<div id="module_<?php echo($module_instance_id); ?>" class="module documents-module <?php echo($module_class); ?>">
	<?php
	if($title && $title_heading_level)
	{
		?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
	}

	if($q)
	{
		if($title_heading_level)
		{
			$heading = substr($title_heading_level, 1) + 1;
		}
		else
		{
			$heading = 2;
		}
		?>
		<div class="row">
			<div class="col-12 col-sm-8">
				<p class="search-summary">Your search for "<?php echo($q); ?>" returned <?php echo(number_format($total, 0)); ?> results.</p>
			</div>
			<div class="col-12 col-sm-4 text-right">
				<form action="" method="get">
					<input type="search" placeholder="<?php echo($search_legend); ?>" aria-label="<?php echo($search_legend); ?>" name="q<?php echo($module_instance_id); ?>" value="<?php echo(html_escape($this->input->get_post("q" . $module_instance_id))); ?>" class="form-control" />
					<button type="submit" class="btn btn-primary" title="<?php echo($search_legend); ?>"><em class="fas fa-fw fa-search" aria-hidden="true"></em><span class="d-none"><?php echo($search_legend); ?></span></button>
				</form>
			</div>
		</div>
		<?php

		if($results > 0)
		{
			?><h<?php echo($heading); ?>>Search Results</h<?php echo($heading); ?>><?php
		}
	}

	$category_name = "";

	if($show_categories)
	{
		?>
		<div class="row">
			<?php
			$cat_cols 	= array();
			$count 		= count($categories);
			$split 		= floor($count/3);
			$offset 	= 0;
			$mod 		= $count % 3;

			for($i=0; $i<3; $i++)
			{
				// If there's an odd number of documents, toss the extras in column 1.
				$cat_cols[$i] = array_slice($categories, $offset, ($mod ? $split+1 : $split));
				$offset += ($mod ? $split+1 : $split);
			}

			foreach($cat_cols as $col)
			{
				?><div class="<?php echo(TWO_COL); ?> col-lg-4"><?php

				foreach($col as $cat)
				{
					$link 			= "/" . Mainframe::page()->url . ($cat->category_id ? "&c=" . $cat->category_id : "") . ($cat->year ? "&year=" . $cat->year : "");
					$link 			= preg_replace('/&/', "?", $link, 1);
					$icon 			= (($category_id && $cat->category_id == $category_id) || ($year && $cat->year == $year) ? "fa-folder-open" : "fa-folder");
					$category_name 	= ($category_id && $cat->category_id == $category_id ? $cat->name : $category_name);
					?>
					<div><a href="<?php echo($link); ?>"><?php echo(($show_icons ? '<em class="fas fa-fw ' . $icon . '" aria-hidden="true"></em> ' : '')); ?><?php echo($cat->name); ?> (<?php echo($cat->total); ?>)</a></div>
					<?php
				}
				?></div><?php
			}
			?>
		</div>
		<?php
	}

	if($category_id && !$show_categories)
	{
		if($title_heading_level)
		{
			$heading = substr($title_heading_level, 1) + 1;
		}
		else
		{
			$heading = 2;
		}
		?><h<?php echo($heading); ?>><?php echo($category_name); ?></h<?php echo($heading); ?>><?php
	}
	?>
	<div class="row">
		<?php
		foreach($documents as $doc)
		{
			$cover_width = 1200;
			$cover_height = 900;

			if($num_columns == 1)
			{
				$class = "col-12";
			}
			else if($num_columns == 2)
			{
				$class = TWO_COL;
			}
			else if($num_columns == 3)
			{
				$class = THREE_COL;
			}
			else if($num_columns == 4)
			{
				$class = TWO_COL . " col-lg-3";
			}
			else 	// failsafe
			{
				$class = "col-12";
			}
			?>
			<div class="<?php echo($class); ?>">
				<article>
					<?php
					if($show_preview && preg_match('/\.pdf?/i', $doc->filename))
					{
						?><div class="document-cover"><a href="/document/<?php echo($doc->url); ?>"><img src="/document/cover/<?php echo($doc->document_id); ?>/<?php echo($cover_width); ?>/<?php echo($cover_height); ?>" /></a></div><?php
					}
					if($show_title)
					{
						?><<?php echo($heading_level); ?> class="document-title"><a href="/document/<?php echo($doc->url); ?>"><?php

						if($show_icons)
						{
							if(preg_match('/\.(jpe?g|png|gif|bmp|ico)/i', $doc->filename))
							{
								$icon = 'fa-image far';
							}
							else if(preg_match('/\.pdf?/i', $doc->filename))
							{
								$icon = 'fa-file-pdf far';
							}
							else if(preg_match('/\.(html|php|js|css)/i', $doc->filename))
							{
								$icon = 'fa-file-code far';
							}
							else if(preg_match('/\.(txt|log|md)/i', $doc->filename))
							{
								$icon = 'fa-file-alt far';
							}
							else if(preg_match('/\.(mp3|wav|ogg)/i', $doc->filename))
							{
								$icon = 'fa-file-audio far';
							}
							else if(preg_match('/\.(mp4|wmv|mov|ogv|webm)/i', $doc->filename))
							{
								$icon = 'fa-file-video far';
							}
							else if(preg_match('/\.(zip|gz|7z|tar|rar)/i', $doc->filename))
							{
								$icon = 'fa-file-archive far';
							}
							else if(preg_match('/\.docx?/i', $doc->filename))
							{
								$icon = 'fa-file-word far';
							}
							else if(preg_match('/\.xlsx?/i', $doc->filename))
							{
								$icon = 'fa-file-excel far';
							}
							else if(preg_match('/\.pptx??/i', $doc->filename))
							{
								$icon = 'fa-file-powerpoint far';
							}
							else
							{
								$icon = 'fa-file far';
							}

							?><em class="fa-fw <?php echo($icon); ?>" aria-hidden="true"></em> <?php
						}

						echo($doc->title);

						?></a></<?php echo($heading_level); ?>><?php
					}

					if($show_category)
					{
						$catlink = "/" . Mainframe::page()->url . "?c=" . $cat->category_id;
						?><p class="document-category"><a href="<?php echo($catlink); ?>"><?php echo($doc->category_name); ?></a></p><?php
					}

					if($show_date)
					{
						?><time datetime="<?php echo(date("Y-m-d H:i:s", strtotime($doc->created))); ?>"><?php echo(date("l, F jS, Y", strtotime($doc->created))); ?></time><?php
					}

					if($show_text)
					{
						//Remove empty paragraphs (whitespace, non-breaking space HTML, and non-breaking space Unicode)
						$description = preg_replace('/(<p>(\s|&nbsp;|\x{00A0})*<\/p>)/', '', $doc->description);
						$strlen1 = strlen($description);

						if($strlen1 > $character_limit && $character_limit > 0)
						{
							$description = truncate($description, $character_limit, array('ending' => "...", 'exact' => false, 'html' => true));
						}

						?><div><?php echo($description); ?></div><?php
					}
					?>
				</article>
			</div>
			<?php
		}
		?>
	</div>
	<?php
	if($next || $prev)
	{
		?>
		<div class="document-list-pagination">
			<?php
			if($prev)
			{
				$link = "/" . Mainframe::page()->url . ($q ? "?q=" . $q . "&p=" . $prev : "?p=" . $prev) . ($category_id ? "&c=" . $category_id : "") . ($year ? "&year=" . $year : "");
				?><a href="<?php echo($link); ?>" class="btn btn-primary" title="Previous <?php echo($per_page); ?> Results"><em class="fas fa-fw fa-chevron-left" aria-hidden="true"></em> Prev <?php echo($per_page); ?></a><?php
			}
			?> <a href="#" onclick="return false" class="btn btn-primary" title="Page <?php echo($page_number); ?> of <?php echo($page_count); ?>">Page <?php echo($page_number); ?> of <?php echo($page_count); ?></a> <?php
			if($next)
			{
				$link = "/" . Mainframe::page()->url . ($q ? "?q=" . $q . "&p=" . $next : "?p=" . $next) . ($category_id ? "&c=" . $category_id : "") . ($year ? "&year=" . $year : "");
				?><a href="<?php echo($link); ?>" class="btn btn-primary" title="Next <?php echo($per_page); ?> Results">Next <?php echo($per_page); ?> <em class="fas fa-fw fa-chevron-right" aria-hidden="true"></em></a><?php
			}
			?>
		</div>
		<?php
	}
	?>
</div>
