<?php
// Define a default style for backwards compatibility.
if(!$style)
{
	$style = "padded";
}

//Knowing our container width, we can determine the largest possible size we're going to need for thumbnails.
$max_width = 0;
$album_max_width = 0;

$max_sm = $breakpoint_md - 1;
$max_md = $breakpoint_lg - 1;
$max_lg = $breakpoint_xl - 1;
$max_xl = 2000;

//Determine the max width for images.
if(floor($max_sm / $per_row_sm) > $max_width)
{
	$max_width = floor($max_sm / $per_row_sm);
}
if(floor($max_md / $per_row_md) > $max_width)
{
	$max_width = floor($max_md / $per_row_md);
}
if(floor($max_lg / $per_row_lg) > $max_width)
{
	$max_width = floor($max_lg / $per_row_lg);
}
if(floor($max_xl / $per_row_xl) > $max_width)
{
	$max_width = floor($max_xl / $per_row_xl);
}

//Determine the max width for albums.
if(floor($max_sm / $album_per_row_sm) > $max_width)
{
	$album_max_width = floor($max_sm / $album_per_row_sm);
}
if(floor($max_md / $album_per_row_md) > $album_max_width)
{
	$album_max_width = floor($max_md / $album_per_row_md);
}
if(floor($max_lg / $album_per_row_lg) > $album_max_width)
{
	$album_max_width = floor($max_lg / $album_per_row_lg);
}
if(floor($max_xl / $album_per_row_xl) > $album_max_width)
{
	$album_max_width = floor($max_xl / $album_per_row_xl);
}

if(strpos($aspect_ratio, ":") !== false)
{
	$exp 	= explode(":", $aspect_ratio);
	$w 		= $exp[0];
	$h 		= $exp[1];

	$max_height 		= ceil($max_width / $w * $h);
    $album_max_height 	= ceil($album_max_width / $w * $h);
}
else
{
    $max_height 		= floor($max_width / 3 * 4);
	$album_max_height 	= floor($album_max_width / 3 * 4);
}

$css_class 			= "col-12 ";

if($per_row_sm == 1) { $css_class .= "col-sm-12 "; }
if($per_row_sm == 2) { $css_class .= "col-sm-6 "; }
if($per_row_sm == 3) { $css_class .= "col-sm-4 "; }
if($per_row_sm == 4) { $css_class .= "col-sm-3 "; }
// if($per_row_sm == 5) { $css_class .= "col-sm-2 "; }
if($per_row_sm == 6) { $css_class .= "col-sm-2 "; }

if($per_row_md == 1) { $css_class .= "col-md-12 "; }
if($per_row_md == 2) { $css_class .= "col-md-6 "; }
if($per_row_md == 3) { $css_class .= "col-md-4 "; }
if($per_row_md == 4) { $css_class .= "col-md-3 "; }
// if($per_row_md == 5) { $css_class .= "col-md-2 "; }
if($per_row_md == 6) { $css_class .= "col-md-2 "; }

if($per_row_lg == 1) { $css_class .= "col-lg-12 "; }
if($per_row_lg == 2) { $css_class .= "col-lg-6 "; }
if($per_row_lg == 3) { $css_class .= "col-lg-4 "; }
if($per_row_lg == 4) { $css_class .= "col-lg-3 "; }
// if($per_row_lg == 5) { $css_class .= "col-lg-2 "; }
if($per_row_lg == 6) { $css_class .= "col-lg-2 "; }

if($per_row_xl == 1) { $css_class .= "col-xl-12 "; }
if($per_row_xl == 2) { $css_class .= "col-xl-6 "; }
if($per_row_xl == 3) { $css_class .= "col-xl-4 "; }
if($per_row_xl == 4) { $css_class .= "col-xl-3 "; }
// if($per_row_xl == 5) { $css_class .= "col-xl-2 "; }
if($per_row_xl == 6) { $css_class .= "col-xl-2 "; }

$album_css_class 	= "col-12 ";

if($album_per_row_sm == 1) { $album_css_class .= "col-sm-12 "; }
if($album_per_row_sm == 2) { $album_css_class .= "col-sm-6 "; }
if($album_per_row_sm == 3) { $album_css_class .= "col-sm-4 "; }
if($album_per_row_sm == 4) { $album_css_class .= "col-sm-3 "; }
// if($album_per_row_sm == 5) { $album_css_class .= "col-sm-2 "; }
if($album_per_row_sm == 6) { $album_css_class .= "col-sm-2 "; }

if($album_per_row_md == 1) { $album_css_class .= "col-md-12 "; }
if($album_per_row_md == 2) { $album_css_class .= "col-md-6 "; }
if($album_per_row_md == 3) { $album_css_class .= "col-md-4 "; }
if($album_per_row_md == 4) { $album_css_class .= "col-md-3 "; }
// if($album_per_row_md == 5) { $album_css_class .= "col-md-2 "; }
if($album_per_row_md == 6) { $album_css_class .= "col-md-2 "; }

if($album_per_row_lg == 1) { $album_css_class .= "col-lg-12 "; }
if($album_per_row_lg == 2) { $album_css_class .= "col-lg-6 "; }
if($album_per_row_lg == 3) { $album_css_class .= "col-lg-4 "; }
if($album_per_row_lg == 4) { $album_css_class .= "col-lg-3 "; }
// if($album_per_row_lg == 5) { $album_css_class .= "col-lg-2 "; }
if($album_per_row_lg == 6) { $album_css_class .= "col-lg-2 "; }

if($album_per_row_xl == 1) { $album_css_class .= "col-xl-12 "; }
if($album_per_row_xl == 2) { $album_css_class .= "col-xl-6 "; }
if($album_per_row_xl == 3) { $album_css_class .= "col-xl-4 "; }
if($album_per_row_xl == 4) { $album_css_class .= "col-xl-3 "; }
// if($album_per_row_xl == 5) { $album_css_class .= "col-xl-2 "; }
if($album_per_row_xl == 6) { $album_css_class .= "col-xl-2 "; }

//sanitize input
$dir = $this->input->get_post("dir"); //filter_input(INPUT_GET, "dir", FILTER_SANITIZE_STRING);
$dir = str_replace("../", "", $dir);

if($dir)
{
	//add sub directory to current path
	$base .= "/" . urldecode($dir) . "/";
}

$directory = ABSOLUTE_PATH . "/" . stripslashes($base);
$directory2 = ABSOLUTE_PATH;

if($files == null)
{
	$files = @scandir($directory);
}

$sorted_images = array();

if(is_array($files))
{
	foreach($files as $file)
	{
		if(($size = @getimagesize("$directory/$file")) !== false)
		{
			$ratio = $size[0] / $size[1];
			$sorted_images[] = array("path" => $file, "ratio" => $ratio, "modified" => filemtime("$directory/$file"));
		}
	}
}

if($ordering == "filename")
{
	// By nature of how the operating system reads the directory, files will be ordered by filename by default.
}
else if($ordering == "filename_desc")
{
	// By nature of how the operating system reads the directory, files will be ordered by filename by default.
	// If we reverse the array, logic says it should be in reverse alphabetical order.
	$sorted_images = array_reverse($sorted_images);
}
else if($ordering == "ratio")
{
	// Use custom comparator to sort by aspect ratio and then filename.
	usort($sorted_images, "ratio_sort");
}
else if($ordering == "date")
{
	// Use custom comparator to sort by date and then filename.
	usort($sorted_images, "date_sort");
}
else if($ordering == "date_desc")
{
	// Use custom comparator to sort by date and then filename.
	// Then reverse the array.
	usort($sorted_images, "date_sort");
	$sorted_images = array_reverse($sorted_images);
}

if(count($files) <= 2)
{
	return;
}

$images 		= "";
$image_count 	= 0;
?>
<div id="module_<?php echo($module_instance_id); ?>" class="module gallery-module gallery-module-<?php echo($style); ?> <?php echo($module_class); ?>">
	<?php
	if($title && $title_heading_level)
	{
		?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
	}

	if($dir)
	{
		?>
		<div class="gallery-header"><?php echo(str_replace("/", " / ", $dir)); ?></div>
		<div class="gallery-back"><a href="javascript:history.go(-1);">Back</a></div>
		<?php

	}

	//first we need to scan for directories only
	?>
	<div class="row">
		<?php
		foreach($files as $file)
		{
			if($file != "." && $file != "..")
			{
				$current_file = "$directory/$file";

				if(is_dir($current_file))
				{
					// Find a thumbnail up to 4 levels deep.
					$subfiles = @scandir($current_file);

					foreach($subfiles as $subfile)
					{
						$thumb_file = "";
						if(!is_dir(ABSOLUTE_PATH . "/" . "$base/$file/$subfile") && @getimagesize(ABSOLUTE_PATH . "/" . "$base/$file/$subfile"))
						{
							$thumb_file = $subfile;
							break;
						}
						else if(ABSOLUTE_PATH . "/" . is_dir("$base/$file/$subfile") && $subfile != "." && $subfile != "..")
						{
							$subfiles2 = @scandir("$base/$file/$subfile");

							foreach($subfiles2 as $subfile2)
							{
								if(!is_dir(ABSOLUTE_PATH . "/" . "$base/$file/$subfile/$subfile2"))
								{
									$thumb_file = "$subfile/$subfile2";
									break;
								}
								else if(ABSOLUTE_PATH . "/" . is_dir("$base/$file/$subfile/$subfile2") && $subfile2 != "." && $subfile2 != "..")
								{
									$subfiles3 = @scandir("$base/$file/$subfile/$subfile2");

									foreach($subfiles3 as $subfile3)
									{
										if(!is_dir(ABSOLUTE_PATH . "/" . "$base/$file/$subfile/$subfile2/$subfile3"))
										{
											$thumb_file = "$subfile/$subfile2/$subfile3";
											break;
										}
										else if(ABSOLUTE_PATH . "/" . is_dir("$base/$file/$subfile/$subfile2/$subfile3") && $subfile3 != "." && $subfile3 != "..")
										{
											$subfiles4 = @scandir("$base/$file/$subfile/$subfile2/$subfile3");

											foreach($subfiles4 as $subfile4)
											{
												if(!is_dir(ABSOLUTE_PATH . "/" . "$base/$file/$subfile/$subfile2/$subfile3/$subfile4"))
												{
													$thumb_file = "$subfile/$subfile2/$subfile3/$subfile4";
													break;
												}
											}

											if($thumb_file)
											{
												break;
											}
										}
									}
								}
							}
						}
					}

					if($thumb_file)
					{
						$module->album_image(($dir ? "$dir/" : "") . $file, "$base/$file/$thumb_file", "$directory2", $album_max_width, $album_max_height, $album_css_class);
					}
				}
			}
		}
		?>
	</div>

	<div class="row <?php echo($style == "compact" ? "no-gutters" : "")?>">
		<?php
		//Now we'll scan for images/videos
		//We already have an array of sorted files.
		foreach($sorted_images as $file)
		{
			$file = $file["path"];

			$module->image("$directory/$file", $directory2, $max_width, $max_height, $css_class);
		}
		?>
	</div>
</div>

<script>
	jQuery(window).on("load", function(){
		jQuery("a.lightbox").colorbox({
			'transition'	: 'elastic',
			'current'		: '{current}/{total}',
			'scalePhotos' 	: true,
			'width'			: '<?php echo($lightbox_width); ?>',
			'height'		: '<?php echo($lightbox_height); ?>',
			'maxWidth' 		: '100%',
			'maxHeight'		: '100%'
		});
	});
</script>
