<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Module Settings</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_title" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_title" id="param_title" ng-model="params.title.value" class="form-control" data-default="" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_title_heading_level" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_title_heading_level", "params.title_heading_level.value", "0", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_module_class" id="param_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>
		</fieldset>
	</div>
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Options</legend>

			<div class="row">
				<label for="param_default_offset_pct" class="<?php echo(LABEL_COL); ?>">Slider Offset %</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="range" name="param_default_offset_pct" id="param_default_offset_pct" ng-model="params.default_offset_pct.value" class="form-control" min="0" max="100" step="1" data-default="50" required /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_orientation" class="<?php echo(LABEL_COL); ?>">Orientation</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_orientation" id="param_orientation" ng-model="params.orientation.value" class="form-control custom-select" data-default="horizontal" required>
						<option value="">Choose a Value</option>
						<option value="horizontal">Horizontal</option>
						<option value="vertical">Vertical</option>
					</select>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_before_label" class="<?php echo(LABEL_COL); ?>">Before Label</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_before_label" id="param_before_label" ng-model="params.before_label.value" class="form-control" data-default="Before" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_after_label" class="<?php echo(LABEL_COL); ?>">After Label</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_after_label" id="param_after_label" ng-model="params.after_label.value" class="form-control" data-default="After" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_no_overlay" class="<?php echo(LABEL_COL); ?>">Disable Before / After Overlay</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_no_overlay", "params.no_overlay.value", 0); ?></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_move_slider_on_hover" class="<?php echo(LABEL_COL); ?>">Move Slider on Hover</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_move_slider_on_hover", "params.move_slider_on_hover.value", 0); ?></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_move_with_handle_only" class="<?php echo(LABEL_COL); ?>">Move Slider on Handle Only</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_move_with_handle_only", "params.move_with_handle_only.value", 1); ?></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_click_to_move" class="<?php echo(LABEL_COL); ?>">Click to Move</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_click_to_move", "params.click_to_move.value", 0); ?></div>
			</div>
		</fieldset>
	</div>
</div>

<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Image 1</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_image1_upload" class="<?php echo(LABEL_COL); ?>">Upload File</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="file" id="param_image1_upload" onchange="FileSelectHandler(this, 1)" /></div>
				<span class="uploading2 d-none"><em class="fas fa-spinner fa-pulse" aria-hidden="true"></em></span>
			</div>

			<input type="hidden" name="param_image1" id="param_image1" ng-model="params.image1.value" />
			<div ng-if="params.image1.value != '' && params.image1.value != null"><img src="" ng-src="{{params.image1.value}}" style="max-width: 100%;" alt="{{params.before_label.value}}" title="{{params.before_label.value}}" /></div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Image 2</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_image2_upload" class="<?php echo(LABEL_COL); ?>">Upload File</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="file" id="param_image2_upload" onchange="FileSelectHandler(this, 2)" /></div>
				<span class="uploading2 d-none"><em class="fas fa-spinner fa-pulse" aria-hidden="true"></em></span>
			</div>

			<input type="hidden" name="param_image2" id="param_image2" ng-model="params.image2.value" />
			<div ng-if="params.image2.value != '' && params.image2.value != null"><img src="" ng-src="{{params.image2.value}}" style="max-width: 100%;" alt="{{params.after_label.value}}" title="{{params.after_label.value}}" /></div>
		</fieldset>
	</div>
</div>

<script>
FileSelectHandler = function(e, image_number)
{
	// fetch FileList object
	var files = e.files;

	// process all File objects
	for (var i = 0, f; f = files[i]; i++)
	{
		ParseFile(f, image_number);
	}
};

ParseFile = function(file, image_number)
{
	var oFReader1 = new FileReader();
	oFReader1.readAsDataURL(file);

	oFReader1.onload = function (oFREvent)
	{
		jQuery(".uploading" + image_number).removeClass("d-none");

		var formData = new FormData();
		formData.append("image", file);

		jQuery.ajax({
			url: "/admin/upload_image",
			type: "POST",
			data: formData,
			processData: false,
			contentType: false,
			success:function(data, textStatus, jqXHR)
			{
				jQuery("#param_image" + image_number).val(data["src"]).change();
				jQuery(".uploading" + image_number).addClass("d-none");
			},
			error: function(jqXHR, textStatus, errorThrown)
			{
				error("Upload Error", jqXHR.responseText, true, null);
				jQuery(".uploading" + image_number).addClass("d-none");
			}
		});
	};
};
</script>