<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Image Information</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_module_class" id="param_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_path_upload" class="<?php echo(LABEL_COL); ?>">Upload Logo</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="file" id="param_path_upload" onchange="FileSelectHandler(this)" /></div>
				<span class="uploading d-none"><em class="fas fa-spinner fa-pulse" aria-hidden="true"></em></span>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_path" class="<?php echo(LABEL_COL); ?>">Logo Path</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_path" id="param_path" ng-model="params.path.value" class="form-control" placeholder="Type a path or upload a file above" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_width" class="<?php echo(LABEL_COL); ?>">Logo Width (px)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_width" id="param_width" ng-model="params.width.value" class="form-control" placeholder="Optional, CSS is preferred" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_text" class="<?php echo(LABEL_COL); ?>">Logo Text</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_text" id="param_text" ng-model="params.text.value" class="form-control" required placeholder="Will be used as alt/title text" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_link" class="<?php echo(LABEL_COL); ?>">Link</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_link" id="param_link" ng-model="params.link.value" class="form-control" data-default="/" placeholder="Location when the logo is clicked" /></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Image Preview</legend>

			<div ng-if="params.path.value != '' && params.path.value != null"><img src="" ng-src="{{params.path.value}}" width="{{params.width.value}}" style="max-width: 100%;" alt="{{params.text.value}}" title="{{params.text.value}}" /></div>
		</fieldset>
	</div>
</div>

<script>
FileSelectHandler = function(e)
{
	// fetch FileList object
	var files = e.files;

	// process all File objects
	for (var i = 0, f; f = files[i]; i++)
	{
		ParseFile(f);
	}
};

ParseFile = function(file)
{
	var oFReader1 = new FileReader();
	oFReader1.readAsDataURL(file);

	oFReader1.onload = function (oFREvent)
    {
    	jQuery(".uploading").removeClass("d-none");

    	var formData = new FormData();
		formData.append("image", file);

		jQuery.ajax({
		    url: "/admin/upload_image",
		    type: "POST",
		    data: formData,
		    processData: false,
		    contentType: false,
		    success:function(data, textStatus, jqXHR)
		    {
		        jQuery("#param_path").val(data["src"]).change();
		        jQuery("#param_width").val(data["width"]).change();
		        jQuery(".uploading").addClass("d-none");
		    },
		    error: function(jqXHR, textStatus, errorThrown)
		    {
		    	error("Upload Error", jqXHR.responseText, true, null);
		    	jQuery(".uploading").addClass("d-none");
		    }
		});
    };
};
</script>
