<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Menu Settings</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_title" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_title" id="param_title" ng-model="params.title.value" class="form-control" data-default="" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_title_heading_level" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_title_heading_level", "params.title_heading_level.value", "0", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_module_class" id="param_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_menu_id" class="<?php echo(LABEL_COL); ?>">Menu</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_menu_id" id="param_menu_id" ng-model="params.menu_id.value" class="form-control custom-select" ng-options="v.value as v.text for (k, v) in menus" required>
						<option value="">Choose a Menu</option>
					</select>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_style" class="<?php echo(LABEL_COL); ?>">Style</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_style", "params.style.value", "nvmenu", ["nvmenu" => "nvMenu <em class='fas fa-arrows-alt-h' title='Horizontal'></em>", "nvmenu-v" => "nvMenu <em class='fas fa-arrows-alt-v' title='Vertical'></em>", "horizontal" => "Basic <em class='fas fa-arrows-alt-h' title='Horizontal'></em>", "vertical" => "Basic <em class='fas fa-arrows-alt-v' title='Vertical'></em>"]); ?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_alignment" class="<?php echo(LABEL_COL); ?>">Alignment</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_alignment", "params.alignment.value", "justify-content-center", ["0" => "Left", "justify-content-center" => "Center", "justify-content-end" => "Right"]); ?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_pill" class="<?php echo(LABEL_COL); ?>">Use Pill Styles</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_pill", "params.pill.value", 0); ?></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>" ng-if="params.responsive.value != 1 && params.style.value != 'vertical'">
				<label for="param_fill" class="<?php echo(LABEL_COL); ?>">Fill Style</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_fill", "params.fill.value", "fill", ["0" => "None", "fill" => "Fill Available Space", "justified" => "Fill Available Space Equally"]); ?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_show_icons" class="<?php echo(LABEL_COL); ?>">Show Icons</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_show_icons" id="param_show_icons" ng-model="params.show_icons.value" class="form-control custom-select" data-default="submenu" required>
						<option value="">Choose an Option</option>
						<option value="menu">Menu bar only</option>
						<option value="submenu" ng-disabled="params.style.value != 'nvmenu' && params.style.value != 'nvmenu-v'">Submenu overlay only</option>
						<option value="both" ng-disabled="params.style.value != 'nvmenu' && params.style.value != 'nvmenu-v'">Menu bar and submenu overlay</option>
					</select>
				</div>
			</div>
		</fieldset>

		<fieldset ng-if="params.style.value != 'nvmenu' && params.style.value != 'nvmenu-v'">
			<legend>Submenu Dropdown</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_hover" class="<?php echo(LABEL_COL); ?>">Hover to Activate?</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_hover", "params.hover.value", 0); ?></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_duplicate_parent_links" class="<?php echo(LABEL_COL); ?>">Duplicate Parent Links</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_duplicate_parent_links", "params.duplicate_parent_links.value", 1); ?></div>
			</div>
		</fieldset>

		<fieldset ng-if="params.style.value == 'nvmenu' || params.style.value == 'nvmenu-v'">
			<legend>Submenu Overlay</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_duplicate_parent_links" class="<?php echo(LABEL_COL); ?>">Duplicate Parent Links</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_duplicate_parent_links", "params.duplicate_parent_links.value", 1); ?></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_search" class="<?php echo(LABEL_COL); ?>">Include Search Box</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_search", "params.search.value", 1); ?></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>" ng-if="params.search.value == 1">
				<label for="param_search_action" class="<?php echo(LABEL_COL); ?>">Search Box Action</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_search_action" id="param_search_action" ng-model="params.search_action.value" class="form-control" data-default="/search" required /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>" ng-if="params.search.value == 1">
				<label for="param_search_legend" class="<?php echo(LABEL_COL); ?>">Search Box Legend</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_search_legend" id="param_search_legend" ng-model="params.search_legend.value" class="form-control" data-default="Search Our Website" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_content_above" class="col-12">Content Above Menu</label>
				<div class="col-12"><textarea ckeditor name="param_content_above" id="param_content_above" ng-model="params.content_above.value" class="form-control"></textarea></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_content_below" class="col-12">Content Below Menu</label>
				<div class="col-12"><textarea ckeditor name="param_content_below" id="param_content_below" ng-model="params.content_below.value" class="form-control"></textarea></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>" ng-if="params.style.value != 'vertical'">
		<fieldset>
			<legend>Responsive Menu Settings</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_responsive" class="<?php echo(LABEL_COL); ?>">Responsive Menu?</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_responsive", "params.responsive.value", 1); ?></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_more_text" class="<?php echo(LABEL_COL); ?>">Text For "More" Item</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_more_text" id="param_more_text" ng-model="params.more_text.value" class="form-control" data-default="<em class=&quot;fa fa-bars&quot;></em> More" ng-required="params.responsive.value == 1" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_menu_text" class="<?php echo(LABEL_COL); ?>">Text For Mobile Menu</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_menu_text" id="param_menu_text" ng-model="params.menu_text.value" class="form-control" data-default="<em class=&quot;fa fa-bars&quot;></em> Menu" ng-required="params.responsive.value == 1" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_threshold" class="<?php echo(LABEL_COL); ?>">Threshold (minimum menu items required for responsiveness)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" min="2" step="1" name="param_threshold" id="param_threshold" ng-model="params.threshold.value" class="form-control" data-default="2" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_container_width_offset" class="<?php echo(LABEL_COL); ?>">Container Width Offset (offset is substracted from container width.)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" min="0" step="1" name="param_container_width_offset" id="param_container_width_offset" ng-model="params.container_width_offset.value" class="form-control" data-default="20" /></div>
			</div>
		</fieldset>
	</div>
</div>
