<div id="module_<?php echo($module_instance_id); ?>" class="module google-map-module <?php echo($module_class); ?>">
	<?php
	if($title && $title_heading_level)
	{
		?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
	}
	?>

	<div id="openstreetmap<?php echo($this->module_instance_id); ?>" style="height: <?php echo($height); ?>px;"></div>

	<script>
		var address     = "<?php echo($address != "" ? str_replace(array("\r", "\n", '"'), array("", "", "'"), nl2br($address)) : null); ?>";
		var latitude    = <?php echo($latitude != "" ? $latitude : "null"); ?>;
		var longitude   = <?php echo($longitude != "" ? $longitude : "null"); ?>;
		var map         = null;
		var url         = "";
		var attribution = "";

		if(latitude != null && longitude != null)
		{
			osmInit(latitude, longitude);
		}
		else
		{
			jQuery.get
		    (
		        "https://api.mapbox.com/geocoding/v5/mapbox.places/" + address + ".json?access_token=<?php echo($access_token); ?>",
		        function(data)
		        {
		        	console.debug(data);
		        	if(data.features.length >= 1)
		        	{
		        		osmInit(data.features[0].center[1], data.features[0].center[0]);
		        	}
		        }
		    );
		}

		function osmInit(latitude, longitude)
		{
			map = L.map('openstreetmap<?php echo($this->module_instance_id); ?>').setView([latitude, longitude], <?php echo($zoom); ?>);
			url = "";
			attribution = 'Map data &copy; <a href="https://www.openstreetmap.org/">OpenStreetMap</a> contributors, <a href="https://creativecommons.org/licenses/by-sa/2.0/">CC-BY-SA</a>, Imagery © ';

			<?php
			if($tileset == "custom")
			{
				$tileset = "";
				?>
				url = "<?php echo($tileserver); ?>";
				attribution += "<?php echo($tileserver_attribution); ?>";
				<?php
			}
			else if($tileset == "wikimedia")
			{
				$tileset = "";
				?>
				url = "https://maps.wikimedia.org/osm-intl/{z}/{x}/{y}" + (window.devicePixelRatio > 1 ? "@" + window.devicePixelRatio + "x" : "") + ".png";
				attribution += '<a href="https://foundation.wikimedia.org/">Wikimedia</a>';
				<?php
			}
			else if($tileset == "osm")
			{
				$tileset = "";
				?>
				url = "https://c.tile.openstreetmap.org/{z}/{x}/{y}.png";
				attribution += '<a href="https://www.openstreetmap.org/">OpenStreetMap</a>';
				<?php
			}
			else
			{
				$tileset = "";
				?>
				url = "https://api.tiles.mapbox.com/v4/{id}/{z}/{x}/{y}" + (window.devicePixelRatio > 1 ? "@" + window.devicePixelRatio + "x" : "") + ".png?access_token={accessToken}";
				attribution += '<a href="https://www.mapbox.com/">Mapbox</a>';
				<?php
			}
			?>

			L.tileLayer(url,
			{
				attribution: attribution,
				<?php
				if($tileset)
				{
					?>id: '<?php echo($tileset); ?>',<?php
				}

				if($access_token)
				{
					?>accessToken: '<?php echo($access_token); ?>'<?php
				}
				?>
			}).addTo(map);

			var marker = L.marker([latitude, longitude]).addTo(map);
			marker.bindPopup("<?php echo($bubble_text); ?>").openPopup();
		}
	</script>
</div>
