<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Module Settings</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_title" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_title" id="param_title" ng-model="params.title.value" class="form-control" data-default="Our Location" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_title_heading_level" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_title_heading_level", "params.title_heading_level.value", "0", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_module_class" id="param_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>
		</fieldset>

		<fieldset>
			<legend>Map Settings</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_address" class="<?php echo(LABEL_COL); ?>">Address</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_address" id="param_address" ng-model="params.address.value" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_height" class="<?php echo(LABEL_COL); ?>">Height</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_height" id="param_height" ng-model="params.height.value" class="form-control" data-default="400" min="0" step="1" required /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_bubble_text" class="<?php echo(LABEL_COL); ?>">Bubble Text</label>
				<div class="<?php echo(FIELD_COL); ?>"><textarea name="param_bubble_text" id="param_bubble_text" ng-model="params.bubble_text.value" class="form-control" required></textarea></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_latitude" class="<?php echo(LABEL_COL); ?>">Latitude</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_latitude" id="param_latitude" ng-model="params.latitude.value" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_longitude" class="<?php echo(LABEL_COL); ?>">Longitude</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_longitude" id="param_longitude" ng-model="params.longitude.value" class="form-control" /></div>
			</div>

			<div class="alert alert-warning" ng-if="params.map_type.value == 'osm' && (params.latitude.value == '' || params.longitude.value == '')">
				Geocoding will be required to determine latitude and longitude. Geocoding requires a Mapbox access token.
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_zoom" class="<?php echo(LABEL_COL); ?>">Default Zoom</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" min="0" max="23" step="1" name="param_zoom" id="param_zoom" ng-model="params.zoom.value" class="form-control" data-default="16" required /></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Map Tiles</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_tileset" class="<?php echo(LABEL_COL); ?>">Tile Set</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select id="param_tileset" name="param_tileset" class="form-control custom-select" ng-model="params.tileset.value" data-default="wikimedia" required>
						<option value="">Select a Tile Set</option>
						<option value="wikimedia">Wikimedia</option>
						<option value="osm">OpenStreetMap</option>
						<option value="mapbox.light">Mapbox Light</option>
						<option value="mapbox.dark">Mapbox Dark</option>
						<option value="mapbox.streets">Mapbox Streets</option>
						<option value="mapbox.outdoors">Mapbox Outdoors</option>
						<option value="mapbox.satellite">Mapbox Satellite</option>
						<option value="custom">Custom Tile Server</option>
					</select>
				</div>
			</div>

			<div ng-if="params.tileset.value.indexOf('mapbox') !== -1">
				<div class="alert alert-info">
					Mapbox tiles require a <a href="https://mapbox.com" target="_blank">free Mapbox account</a> and an access token.
					You can use the access token <b>pk.eyJ1IjoibmVyaXZvbiIsImEiOiJjazIwcmkwbjgxYzE1M2NsMjVicnB2YndzIn0.ud_8lqtdC6xaIFvzNjUXsw</b> but are encouraged to get your own.
				</div>
			</div>

			<div class="alert alert-warning" ng-if="params.access_token.value == 'pk.eyJ1IjoibmVyaXZvbiIsImEiOiJjazIwcmkwbjgxYzE1M2NsMjVicnB2YndzIn0.ud_8lqtdC6xaIFvzNjUXsw'">
				You are using the Nerivon CMS shared access token. You are encouraged to create a <a href="https://mapbox.com" target="_blank">free Mapbox account</a> and use your own access token.
			</div>

			<div ng-if="params.tileset.value == 'custom'">
				<div class="alert alert-info">
					<p>Your tile server URL can contain any of the following placeholders: {x}, {y}, {z}, {accessToken}</p>
					<p>Many providers reference these as ${x}, ${y}, ${z}. Please remove the dollar symbols.
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="param_tileserver" class="<?php echo(LABEL_COL); ?>">Tile Server</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_tileserver" id="param_tileserver" ng-model="params.tileserver.value" data-default="pk.eyJ1IjoibmVyaXZvbiIsImEiOiJjazIwcmkwbjgxYzE1M2NsMjVicnB2YndzIn0.ud_8lqtdC6xaIFvzNjUXsw" class="form-control" required /></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="param_tileserver_attribution" class="<?php echo(LABEL_COL); ?>">Attribution</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_tileserver_attribution" id="param_tileserver_attribution" ng-model="params.tileserver_attribution.value" data-default="" class="form-control" required /></div>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_access_token" class="<?php echo(LABEL_COL); ?>">Access Token</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_access_token" id="param_access_token" ng-model="params.access_token.value" data-default="pk.eyJ1IjoibmVyaXZvbiIsImEiOiJjazIwcmkwbjgxYzE1M2NsMjVicnB2YndzIn0.ud_8lqtdC6xaIFvzNjUXsw" class="form-control" /></div>
			</div>
		</fieldset>
	</div>
</div>
