<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Module Settings</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_title" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_title" id="param_title" ng-model="params.title.value" class="form-control" data-default="Our Services" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_title_heading_level" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_title_heading_level", "params.title_heading_level.value", "", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_module_class" id="param_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Page Settings</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_icon_size" class="<?php echo(LABEL_COL); ?>">Icon Size</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_icon_size", "params.icon_size.value", "2x", ["1x" => "1x", "lg" => "Large", "2x" => "2x", "3x" => "3x", "4x" => "4x", "5x" => "5x"]); ?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_number_of_services" class="<?php echo(LABEL_COL); ?>">Number of Services</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_number_of_services" id="param_number_of_services" ng-model="params.number_of_services.value" class="form-control" min="1" step="1" data-default="1" ng-change="load_datasources($event)" ng-disabled="module_form.$dirty" required /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_column_size" class="<?php echo(LABEL_COL); ?>">Size Of Each Block</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_column_size" id="param_column_size" ng-model="params.column_size.value" class="form-control custom-select" data-default="1" required>
						<option value="">Choose a Size</option>
						<option value="1" ng-value="1">1&frasl;12 (one twelfth)</option>
						<option value="2" ng-value="2">2&frasl;12 (one sixth)</option>
						<option value="3" ng-value="3">3&frasl;12 (one quarter)</option>
						<option value="4" ng-value="4">4&frasl;12 (one third)</option>
						<option value="5" ng-value="5">5&frasl;12 (five twelfths)</option>
						<option value="6" ng-value="6">6&frasl;12 (one half)</option>
						<option value="7" ng-value="7">7&frasl;12 (seven twelfths)</option>
						<option value="8" ng-value="8">8&frasl;12 (two thirds)</option>
						<option value="9" ng-value="9">9&frasl;12 (three quarters)</option>
						<option value="10" ng-value="10">10&frasl;12 (five sixths)</option>
						<option value="11" ng-value="11">11&frasl;12 (eleven twelfths)</option>
						<option value="12" ng-value="12">12&frasl;12 (one column)</option>
					</select>
				</div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(THREE_COL); ?>" ng-repeat="n in getArray(params.number_of_services.value) track by $index">
		<fieldset ng-init="title_index = 'title' + ($index+1); description_index = 'description' + ($index+1); icon_index = 'icon' + ($index+1); url_index = 'url' + ($index+1); button_text_index = 'button_text' + ($index+1);">
			<legend>Service {{$index + 1}}</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_{{icon_index}}" class="<?php echo(LABEL_COL); ?>">Icon</label>

				<div class="<?php echo(FIELD_COL); ?> input-group">
					<div class="input-group-prepend">
						<span class="input-group-text"><em class="fa-fw fa-lg {{params[icon_index].value}}" aria-hidden="true"></em></span>
					</div>
					<select name="param_{{icon_index}}" id="param_{{icon_index}}" ng-model="params[icon_index].value" ng-options="v.value as v.text for (k, v) in icons" class="form-control custom-select">
						<option value="">Choose Icon</option>
					</select>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_{{title_index}}" class="<?php echo(LABEL_COL); ?>">Title</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_{{title_index}}" id="param_{{title_index}}" ng-model="params[title_index].value" class="form-control" required /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_{{description_index}}" class="<?php echo(LABEL_COL); ?>">Description</label>
				<div class="<?php echo(FIELD_COL); ?>"><textarea name="param_{{description_index}}" id="param_{{description_index}}" ng-model="params[description_index].value" class="form-control"></textarea></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_{{url_index}}" class="<?php echo(LABEL_COL); ?>">URL</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_{{url_index}}" id="param_{{url_index}}" ng-model="params[url_index].value" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_{{button_text_index}}" class="<?php echo(LABEL_COL); ?>">Button Text</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_{{button_text_index}}" id="param_{{button_text_index}}" ng-model="params[button_text_index].value" class="form-control" /></div>
			</div>
		</fieldset>
	</div>
</div>
