<script></script>
<noscript><div class="alert alert-danger text-center">You need JavaScript enabled in order to place an order.</div></noscript>

<div class="cart" id="ncms_checkout" v-cloak>
	<div class="alert alert-success text-center" v-for="m in messages" v-html="m"></div>
	<div class="alert alert-danger text-center" v-for="e in errors" v-html="e"></div>

	<div v-show="order_info.cart.length > 0">
		<table width="100%" border="0" class="table table-bordered table-sm">
			<thead><tr><th class="shop_cart_column_name">Product</th><th class="shop_cart_column_quantity">Quantity</th><th class="shop_cart_column_price">Price</th><th class="shop_cart_column_total">Total</th></tr></thead>

			<tbody>
				<tr v-for="item in order_info.cart">
					<td class="shop_cart_column_name">
						<a v-bind:href="'/' + item.url">{{item.title}}</a>

						<ul class="shop_cart_product_options">
							<li v-for="option in item.product_options">{{option}}</li>
						</ul>
					</td>
					<td class="shop_cart_column_quantity">
						<span v-if="edit"><input type="number" name="quantity" v-model="item.quantity" min="0" max="9999" class="form-control quantity" v-on:change="updateCart(item.cart_id, item.quantity)" required /></span>
						<span v-show="!edit">{{item.quantity}}</span>
					</td>
					<td class="shop_cart_column_price">{{itemPrice(item, true)}}</td>
					<td class="shop_cart_column_total">{{itemTotal(item, true)}}</td>
				</tr>

				<tr><td colspan="4">&nbsp;</td></tr>
				<tr id="shop_cart_subtotal_row">
					<th colspan="3" class="text-right">Subtotal:</th>
					<td class="shop_cart_column_total">{{subtotal(true)}}</td>
				</tr>

				<tr id="shop_cart_shipping_row">
					<th colspan="3" class="text-right">Shipping:</th>
					<td class="shop_cart_column_total">---</td>
				</tr>

				<tr class="shop_cart_tax_row" v-for="tax in order_info.tax_info">
					<th colspan="3" class="text-right">{{tax.tax_name}} ({{tax.tax_province}} {{tax.tax_percentage * 100}}%):</th>
					<td class="shop_cart_column_total">{{taxTotal(true)}}</td>
				</tr>

				<tr>
					<th colspan="3" class="text-right">Cart Total:</th>
					<td class="shop_cart_column_total shop_cart_total" id="shop_cart_total"><?php echo((class_exists("Shop") ? Shop::currency()->currency_code : "CAD")); ?> {{total(true)}}</td>
				</tr>
			</tbody>
		</table>

		<div class="alert alert-info text-center">Shipping costs and applicable taxes will be updated at the checkout.</div>

		<p class="text-center">
			<a href="<?php echo($checkout_url); ?>" class="btn btn-primary"><em class="fas fa-shopping-bag" aria-hidden="true"></em> Checkout</a>
		</p>
	</div>
	<div v-show="order_info.cart.length == 0"><div class="alert alert-warning">Your cart is empty.</div></div>
</div>