<noscript><div class="alert alert-danger text-center">You need JavaScript enabled in order to place an order.</div></noscript>

<div class="cart" id="ncms_checkout" v-cloak>
	<div v-show="done && errors.length == 0">
		<h2>Thank You</h2>
		<p>Your order is complete. A receipt has been emailed to {{shipping_info.email}}.</p>
	</div>

	<div class="alert alert-success text-center" v-for="m in messages" v-html="m"></div>
	<div class="alert alert-danger text-center" v-for="e in errors" v-html="e"></div>

	<div class="card mb-3" v-show="!done && order_info.cart.length > 0">
		<div class="card-header"><em class="fas fa-fw fa-shopping-basket"></em> Shopping Cart</div>

		<div class="card-body">
			<table width="100%" border="0" class="table">
				<thead><tr><th class="shop_cart_column_name">Product</th><th class="shop_cart_column_quantity">Quantity</th><th class="shop_cart_column_price">Price</th><th class="shop_cart_column_total">Total</th></tr></thead>

				<tbody>
					<tr v-for="item in order_info.cart">
						<td class="shop_cart_column_name">
							<a v-bind:href="'/' + item.url">{{item.title}}</a>

							<ul class="shop_cart_product_options">
								<li v-for="option in item.product_options">{{option}}</li>
							</ul>
						</td>
						<td class="shop_cart_column_quantity">
							<span v-show="edit"><input type="number" name="quantity" v-model="item.quantity" min="0" max="9999" class="form-control quantity" v-on:change="updateCart(item.cart_id, item.quantity)" required /></span>
							<span v-show="!edit">{{item.quantity}}</span>
						</td>
						<td class="shop_cart_column_price">{{itemPrice(item, true)}}</td>
						<td class="shop_cart_column_total">{{itemTotal(item, true)}}</td>
					</tr>

					<tr id="shop_cart_subtotal_row">
						<th colspan="3" class="text-right">Subtotal:</th>
						<td class="shop_cart_column_total">{{subtotal(true)}}</td>
					</tr>

					<tr id="shop_cart_shipping_row">
						<th colspan="3" class="text-right">Shipping:</th>
						<td class="shop_cart_column_total">{{shippingTotal(true)}}</td>
					</tr>

					<tr class="shop_cart_tax_row" v-for="tax in order_info.tax_info">
						<th colspan="3" class="text-right">{{tax.tax_name}} ({{tax.tax_province}} {{tax.tax_percentage * 100}}%):</th>
						<td class="shop_cart_column_total">{{taxTotal(true)}}</td>
					</tr>

					<tr>
						<th colspan="3" class="text-right">Cart Total:</th>
						<td class="shop_cart_column_total shop_cart_total bold" id="shop_cart_total"><?php echo((class_exists("Shop") ? Shop::currency()->currency_code : "CAD")); ?> {{total(true)}}</td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div v-show="!done && order_info.cart.length == 0"><div class="alert alert-warning">Your cart is empty.</div></div>

	<div v-show="!done && order_info.cart.length > 0">
		<?php
		if(Mainframe::site()->login_page_id && Mainframe::site()->registration_page_id &&
		   (!isset($user->user_id) || $user->user_id <= 0))
		{
			?>
			<div class="card mb-3" v-show="edit">
				<div class="card-header"><em class="fas fa-fw fa-user"></em> Create an Account (Optional)</div>

				<div class="card-body">
					<p>You are currently checking out as a guest.  If you <a href="<?php echo($registration_url); ?>">create an account</a> or <a href="<?php echo($login_url); ?>">login to your existing account</a> you will be able to view order status and maintain an order history.
					<b>Creating an account is entirely optional.</b></p>
				</div>
			</div>
			<?php
		}
		else if(Mainframe::site()->login_page_id && !Mainframe::site()->registration_page_id &&
		   (!isset($user->user_id) || $user->user_id <= 0))
		{
			?>
			<div class="card mb-3" v-show="edit">
				<div class="card-header"><em class="fas fa-fw fa-user"></em> Login (Optional)</div>

				<div class="card-body">
					<p>You are currently checking out as a guest.  If you <a href="<?php echo($login_url); ?>">login to your existing account</a> you will be able to view order status and maintain an order history.
					<b>Logging in is entirely optional.</b></p>
				</div>
			</div>
			<?php
		}
		?>
		<form v-on:submit.prevent="confirmOrder()" id="shop_cart_order">
			<div class="<?php echo(FORM_ROW); ?>">
				<div v-bind:class="{'col-12':edit, 'col-6':!edit}" id="shop_cart_billing">
					<div class="card mb-3">
						<div class="card-header"><em class="fas fa-fw fa-credit-card"></em> Billing Information</div>

						<div class="card-body">
							<fieldset v-show="edit">
								<legend>Method of Payment</legend>

								<div class="my-3">
									<?php
									$qualified = 0;

									foreach($payment_gateways as $gateway)
									{
										$c = $gateway->filename;
										$this->load->model("payment/" . $c);
										$g = new $c();

										if($g->qualifies($gateway_data))
										{
											$qualified++;
											?><button type="button" class="btn btn-light" v-on:click="payment_info.payment_gateway_id = <?php echo($gateway->payment_gateway_id); ?>;updatePaymentService('<?php echo(htmlentities($gateway->gateway_name)); ?>');updatePaymentGateway()"><em class="far fa-fw" v-bind:class="{'fa-check-circle':payment_info.payment_gateway_id == <?php echo($gateway->payment_gateway_id); ?>, 'fa-circle':payment_info.payment_gateway_id != <?php echo($gateway->payment_gateway_id); ?>}"></em> <?php echo($gateway->gateway_name); ?></button> <?php
										}
									}
									?>
									<input type="text" class="toggle_value" tabindex="-1" v-model="payment_info.payment_gateway_id" required />
								</div>

								<?php
								// If only one payment gateway is shown, hide it as a choice.
								/*if($qualified == 1)
								{
									?>
									<script>
									jQuery(".payment_gateway_radio").attr("type", "hidden");
									jQuery(".payment_gateway_label").hide();
									</script>
									<?php
								}
*/
								foreach($payment_gateways as $gateway)
								{
									$c = $gateway->filename;
									$g = new $c();

									if($g->qualifies($gateway_data))
									{
										?>
										<div id="payment_gateway<?php echo($gateway->payment_gateway_id); ?>form" v-show="payment_info.payment_gateway_id == <?php echo($gateway->payment_gateway_id); ?>">
											<?php
											/**
											 * VueJS doesn't allow scripts to be injected as content.
											 * So we're going to change them to <aside> tags, since
											 * those would never be used in a gateway and when they're
											 * injected we append them to the DOM.
											 * This lets developers use regular <script> tags in views.
											 */
											$content = $this->load->view("shop/payment/" . $gateway->filename, array("my_gateway" => $gateway), true);
											$content = str_replace(array("<script>", "<script", "</script>"), array("<aside type='text/javascript'>", "<aside", "</aside>"), $content);
											// devecho(htmlentities($content));
											echo($content);
											?>
										</div>
										<?php
									}
								}
								?>
							</fieldset>

							<div v-show="!edit">
								<div class="<?php echo(FORM_ROW); ?>">
									<div class="<?php echo(LABEL_COL); ?>"><label>Order Total:</label></div>
									<div class="<?php echo(FIELD_COL); ?>">{{total(true)}}</div>
								</div>

								<div class="<?php echo(FORM_ROW); ?>">
									<div class="<?php echo(LABEL_COL); ?>"><label>Payment Type:</label></div>
									<div class="<?php echo(FIELD_COL); ?>">{{payment_info.payment_gateway}}</div>
								</div>

								<?php
								foreach($payment_gateways as $gateway)
								{
									$c = $gateway->filename;
									$g = new $c();

									if($g->qualifies($gateway_data))
									{
										?>
										<div id="payment_gateway<?php echo($gateway->payment_gateway_id); ?>summary" v-show="payment_info.payment_gateway_id == <?php echo($gateway->payment_gateway_id); ?>">
											<?php
											/**
											 * VueJS doesn't allow scripts to be injected as content.
											 * So we're going to change them to <aside> tags, since
											 * those would never be used in a gateway and when they're
											 * injected we append them to the DOM.
											 * This lets developers use regular <script> tags in views.
											 */
											$content = $this->load->view("shop/payment/" . $gateway->filename . "_summary", array("my_gateway" => $gateway), true);
											$content = str_replace(array("<script>", "<script", "</script>"), array("<aside type='text/javascript'>", "<aside", "</aside>"), $content);
											// devecho(htmlentities($content));
											echo($content);
											?>
										</div>
										<?php
									}
								}
								?>

								<div class="<?php echo(FORM_ROW); ?>">
									<div class="col-12 text-center" v-show="!edit">
										<button type="button" class="btn btn-light" v-on:click="editBilling()"><em class="fas fa-pencil-alt" aria-hidden="true"></em> Edit Billing Information</button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div v-bind:class="{'col-12':edit, 'col-6':!edit}" id="shop_cart_shipping">
					<div class="card mb-3">
						<div class="card-header"><em class="fas fa-fw fa-truck"></em> Shipping Information</div>

						<div class="card-body">
							<div class="<?php echo(FORM_ROW); ?>" v-show="edit">
								<div class="col-12 col-lg-6">
									<div class="<?php echo(FORM_ROW); ?>">
										<div class="<?php echo(LABEL_COL); ?>"><label for="shipping_name">Name</label></div>
										<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="shipping_name" id="shipping_name" v-model="shipping_info.name" required class="form-control" /></div>
									</div>

									<div class="<?php echo(FORM_ROW); ?>">
										<div class="<?php echo(LABEL_COL); ?>"><label for="shipping_phone">Phone Number</label></div>
										<div class="<?php echo(FIELD_COL); ?>"><input type="tel" name="shipping_phone" id="shipping_phone" v-model="shipping_info.phone" required class="form-control" /></div>
									</div>

									<div class="<?php echo(FORM_ROW); ?>">
										<div class="<?php echo(LABEL_COL); ?>"><label for="shipping_email">Email Address</label></div>
										<div class="<?php echo(FIELD_COL); ?>"><input type="email" name="shipping_email" id="shipping_email" v-model="shipping_info.email" required class="form-control" /></div>
									</div>

									<div class="<?php echo(FORM_ROW); ?>">
										<div class="<?php echo(LABEL_COL); ?>"><label for="shipping_postalcode">Postal Code</label></div>
										<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="shipping_postalcode" id="shipping_postalcode" v-model="shipping_info.postalcode" v-on:change="postalcodeLookup();" required class="form-control" /></div>
									</div>
								</div>

								<div class="col-12 col-lg-6">
									<div class="<?php echo(FORM_ROW); ?>">
										<div class="<?php echo(LABEL_COL); ?>"><label for="shipping_address">Address</label></div>
										<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="shipping_address" id="shipping_address" v-model="shipping_info.address" required class="form-control" /></div>
									</div>

									<div class="<?php echo(FORM_ROW); ?>">
										<div class="<?php echo(LABEL_COL); ?>"><label for="shipping_city" class="shop-spinner">City</label></div>
										<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="shipping_city" id="shipping_city" v-model="shipping_info.city" onchange="shopUpdateShippingGateway();" required class="form-control" /></div>
									</div>

									<div class="<?php echo(FORM_ROW); ?>">
										<div class="<?php echo(LABEL_COL); ?>"><label for="shipping_province" class="shop-spinner">Province</label></div>

										<div class="<?php echo(FIELD_COL); ?>">
											<?php
											$wgt = new FeralBasicSelectWidget("shipping_province", "ON", "form-control custom-select");
											$wgt->AddOption("", "----- Canada -----");
											$wgt->AddOption("AB", "Alberta");
											$wgt->AddOption("BC", "British Columbia");
											$wgt->AddOption("MB", "Manitoba");
											$wgt->AddOption("NB", "New Brunswick");
											$wgt->AddOption("NL", "Newfoundland and Labrador");
											$wgt->AddOption("NT", "Northwest Territories");
											$wgt->AddOption("NS", "Nova Scotia");
											$wgt->AddOption("NU", "Nunavut");
											$wgt->AddOption("ON", "Ontario");
											$wgt->AddOption("PE", "Prince Edward Island");
											$wgt->AddOption("QC", "Quebec");
											$wgt->AddOption("SK", "Saskatchewan");
											$wgt->AddOption("YT", "Yukon");

											$wgt->AddOption("", "----- United States -----");
											$wgt->AddOption('AL', "Alabama");
											$wgt->AddOption('AK', "Alaska");
											$wgt->AddOption('AZ', "Arizona");
											$wgt->AddOption('AR', "Arkansas");
											$wgt->AddOption('CA', "California");
											$wgt->AddOption('CO', "Colorado");
											$wgt->AddOption('CT', "Connecticut");
											$wgt->AddOption('DE', "Delaware");
											$wgt->AddOption('DC', "District Of Columbia");
											$wgt->AddOption('FL', "Florida");
											$wgt->AddOption('GA', "Georgia");
											$wgt->AddOption('HI', "Hawaii");
											$wgt->AddOption('ID', "Idaho");
											$wgt->AddOption('IL', "Illinois");
											$wgt->AddOption('IN', "Indiana");
											$wgt->AddOption('IA', "Iowa");
											$wgt->AddOption('KS', "Kansas");
											$wgt->AddOption('KY', "Kentucky");
											$wgt->AddOption('LA', "Louisiana");
											$wgt->AddOption('ME', "Maine");
											$wgt->AddOption('MD', "Maryland");
											$wgt->AddOption('MA', "Massachusetts");
											$wgt->AddOption('MI', "Michigan");
											$wgt->AddOption('MN', "Minnesota");
											$wgt->AddOption('MS', "Mississippi");
											$wgt->AddOption('MO', "Missouri");
											$wgt->AddOption('MT', "Montana");
											$wgt->AddOption('NE', "Nebraska");
											$wgt->AddOption('NV', "Nevada");
											$wgt->AddOption('NH', "New Hampshire");
											$wgt->AddOption('NJ', "New Jersey");
											$wgt->AddOption('NM', "New Mexico");
											$wgt->AddOption('NY', "New York");
											$wgt->AddOption('NC', "North Carolina");
											$wgt->AddOption('ND', "North Dakota");
											$wgt->AddOption('OH', "Ohio");
											$wgt->AddOption('OK', "Oklahoma");
											$wgt->AddOption('OR', "Oregon");
											$wgt->AddOption('PA', "Pennsylvania");
											$wgt->AddOption('RI', "Rhode Island");
											$wgt->AddOption('SC', "South Carolina");
											$wgt->AddOption('SD', "South Dakota");
											$wgt->AddOption('TN', "Tennessee");
											$wgt->AddOption('TX', "Texas");
											$wgt->AddOption('UT', "Utah");
											$wgt->AddOption('VT', "Vermont");
											$wgt->AddOption('VA', "Virginia");
											$wgt->AddOption('WA', "Washington");
											$wgt->AddOption('WV', "West Virginia");
											$wgt->AddOption('WI', "Wisconsin");
											$wgt->AddOption('WY', "Wyoming");

											$wgt->SetAttribute("onchange", "if(this.selectedIndex <= 13) { document.getElementById('shipping_country').selectedIndex = 0; } else { document.getElementById('shipping_country').selectedIndex = 1; }");
											$wgt->SetAttribute("v-on:change", "updateShippingGateway()");
											$wgt->SetAttribute("required", "required");
											$wgt->SetAttribute("v-model", "shipping_info.province");
											$wgt->Create();
											?>
										</div>
									</div>

									<div class="<?php echo(FORM_ROW); ?>">
										<div class="<?php echo(LABEL_COL); ?>"><label for="shipping_country" class="shop-spinner">Country</label></div>

										<div class="<?php echo(FIELD_COL); ?>">
											<?php
											$wgt = new FeralBasicSelectWidget("shipping_country", "CA", "form-control custom-select");
											$wgt->AddOption("CA", "Canada");
											$wgt->AddOption("US", "United States");

											$wgt->SetAttribute("v-on:change", "updateShippingGateway();");
											$wgt->SetAttribute("required", "required");
											$wgt->SetAttribute("v-model", "shipping_info.country");
											$wgt->Create();
											?>
										</div>
									</div>
								</div>

								<div class="col-12">
									<fieldset>
										<legend>Shipping Method</legend>

										<div class="my-3">
											<?php
											$qualifies = 0;

											foreach($shipping_gateways as $gateway)
											{
												$c = $gateway->filename;
												$this->load->model("shipping/" . $c);
												$g = new $c();

												if($g->qualifies($gateway_data))
												{
													$qualifies++;
													?><button type="button" class="btn btn-light" v-on:click="shipping_info.shipping_gateway_id = <?php echo($gateway->shipping_gateway_id); ?>;updateShippingService('<?php echo(htmlentities($gateway->gateway_name)); ?>');showShippingGateway()"><em class="far fa-fw" v-bind:class="{'fa-check-circle':shipping_info.shipping_gateway_id == <?php echo($gateway->shipping_gateway_id); ?>, 'fa-circle':shipping_info.shipping_gateway_id != <?php echo($gateway->shipping_gateway_id); ?>}"></em> <?php echo($gateway->gateway_name); ?></button> <?php
												}
											}

											// If only one shipping gateway is shown, hide it as a choice.
											/*if($qualified == 1)
											{
												?>
												<script>
												jQuery(".shipping_gateway_radio").attr("type", "hidden");
												jQuery(".shipping_gateway_label").hide();
												</script>
												<?php
											}*/
											?>
											<input type="text" class="toggle_value" tabindex="-1" v-model="shipping_info.shipping_gateway_id" required />
										</div>

										<div id="shipping_gateway" class="mt-2"></div>
									</fieldset>
								</div>
							</div>

							<div v-show="!edit">
								<div class="<?php echo(FORM_ROW); ?>">
									<div class="<?php echo(LABEL_COL); ?>"><label>Shipping Method:</label></div>
									<div class="<?php echo(FIELD_COL); ?>">{{shipping_info.shipping_gateway}}</div>
								</div>

								<div class="<?php echo(FORM_ROW); ?>">
									<div class="<?php echo(LABEL_COL); ?>"><label>Shipping To:</label></div>
									<div class="<?php echo(FIELD_COL); ?>">{{shipping_info.name}}<br>{{shipping_info.address}}<br>{{shipping_info.city}} {{shipping_info.province}} {{shipping_info.postalcode}}<br>{{shipping_info.country}}</div>
								</div>

								<div class="<?php echo(FORM_ROW); ?>">
									<div class="<?php echo(LABEL_COL); ?>"><label>Phone:</label></div>
									<div class="<?php echo(FIELD_COL); ?>">{{shipping_info.phone}}</div>
								</div>

								<div class="<?php echo(FORM_ROW); ?>">
									<div class="<?php echo(LABEL_COL); ?>"><label>Email:</label></div>
									<div class="<?php echo(FIELD_COL); ?>">{{shipping_info.email}}</div>
								</div>

								<div class="<?php echo(FORM_ROW); ?>">
									<div class="col-12 text-center" v-show="!edit">
										<button type="button" class="btn btn-light" v-on:click="editShipping()"><em class="fas fa-pencil-alt" aria-hidden="true"></em> Edit Shipping Information</button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="card mb-3" v-show="edit">
				<div class="card-header"><em class="fas fa-fw fa-check"></em> Continue</div>

				<div class="card-body">
					<p class="text-center">Your order will be confirmed on the next screen.</p>

					<div class="text-right">
						<button type="submit" class="btn btn-primary" id="shop_continue">Continue <em class="fas fa-fw fa-caret-right" aria-hidden="true"></em></button>
					</div>
				</div>
			</div>
		</form>

		<form v-on:submit.prevent="submitOrder()" v-show="!edit" id="shop_cart_confirm_order">
			<div class="card mb-3">
				<div class="card-header"><em class="fas fa-fw fa-check"></em> Confirm Order</div>

				<div class="card-body">
					<p class="confirm-order">
						<input type="checkbox" id="confirm-order" name="confirm-order" value="0" title="Please check this box to indicate that you have read this paragraph." required />
						<label for="confirm-order" class="d-inline">I agree to pay <?php echo((class_exists("Shop") ? Shop::currency()->currency_code : "CAD")); ?> {{total(true)}} for the above listed item(s). I understand that clicking "Submit Order" below will process my payment immediately and any refunds will be subject to our refund policy.</label>
					</p>
					<div class="text-center"><button type="submit" class="btn btn-primary" id="shop-submit-order"><em class="fas fa-fw fa-thumbs-up" aria-hidden="true"></em> Submit Order</button></div>
				</div>
			</div>
		</form>
	</div>
</div>