<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
<?php
$products 		= unserialize($order->products);
$product_text 	= array();
$product_qty 	= array();
$product_price 	= array();
$count = 0;

foreach($products as $item)
{
	$product_qty[$count]   = $item->quantity;
	$product_price[$count] = $item->price;
	$product_text[$count]  = $item->title;

	if(is_array($item->product_options) && count($item->product_options) > 0)
	{
		$product_text[$count] .= "<ul>";

		foreach($item->product_options as $option)
		{
			$product_text[$count] .= "<li>" . $option . "</li>";
		}

		$product_text[$count] .= "</ul>";
	}
	$count++;
}

$taxes = unserialize($order->taxes);
$tax_text = array();
$count = 0;
$subtotal_plus_shipping = $order->order_subtotal + $order->shipping_total;

foreach($taxes as $tax)
{
	$tax_text[$tax->tax_name] = number_format($subtotal_plus_shipping * $tax->tax_percentage, 2);
	$count++;
}
?>
<div class="container">
	<h2>Purchase Receipt</h2>
	<table width="100%" border="0" class="table table-striped">
		<tbody>
			<tr><td><b>Seller:</b></td><td><?php echo(COMPANY_NAME); ?></td></tr>
			<tr><td><b>Order Date:</b></td><td><?php echo(date("l, F jS, Y \a\\t g:i A T", strtotime($order->order_date))); ?></td></tr>
			<tr><td><b>Order Number:</b></td><td><?php echo(str_pad($order->order_id, 6, "0", STR_PAD_LEFT)); ?></td></tr>
			<tr><td><b>Transaction ID:</b></td><td><?php echo($order->txn_id); ?></td></tr>
			<tr><td><b>Status:</b></td><td><?php echo($order->order_status_name); ?></td></tr>

			<?php
			if($order->ship_date)
			{
				?><tr><td><b>Shipped:</b></td><td><?php echo(date("l, F jS, Y \a\\t g:i A T", strtotime($order->ship_date))); ?></td></tr><?php
			}
			?>
			<tr>
				<td><b>Ship To:</b></td>
				<td>
					<?php echo($order->customer_name); ?>
					<br /><?php echo($order->customer_address); ?>
					<br /><?php echo($order->customer_city); ?>, <?php echo($order->customer_province); ?>&nbsp;&nbsp;<?php echo($order->customer_postalcode); ?>
					<br /><?php echo($order->customer_country); ?>
				</td>
			</tr>
			<tr><td><b>Phone:</b></td><td><?php echo($order->customer_phone); ?></td></tr>
			<tr><td><b>Email:</b></td><td><?php echo($order->customer_email); ?></td></tr>
			<tr><td><b>Payment Method:</b></td><td><?php echo($order->payment_gateway_name); ?></td></tr>
			<tr><td><b>Shipping Method:</b></td><td><?php echo(($order->shipping_gateway_service ? $order->shipping_gateway_service : $order->shipping_gateway_name)); ?></td></tr>
		</tbody>
	</table>
	<p>&nbsp;</p>

	<table width="100%" border="0" class="table table-striped">
		<thead><tr><th>Item</th><th>Quantity</th><th>Price</th><th>Total</th></tr></thead>

		<tbody>
			<?php
			for($i=0; $i<count($product_text); $i++)
			{
				?>
				<tr>
					<td><?php echo($product_text[$i]); ?></td>
					<td><?php echo($product_qty[$i]); ?></td>
					<td>$<?php echo(number_format($product_price[$i], 2)); ?></td>
					<td>$<?php echo(number_format($product_qty[$i] * $product_price[$i], 2)); ?></td>
				</tr>
				<?php
			}
			?>

			<tr><td colspan="3" style="text-align: right;"><b>Subtotal:</b></td><td>$<?php echo(number_format($order->order_subtotal, 2)); ?></td></tr>
			<tr><td colspan="3" style="text-align: right;"><b>Shipping:</b></td><td>$<?php echo(number_format($order->shipping_total, 2)); ?></td></tr>
			<?php
			foreach($tax_text as $tax=>$value)
			{
				?><tr><td colspan="3" style="text-align: right;"><b><?php echo($tax); ?>:</b></td><td>$<?php echo($value); ?></td></tr><?php
			}
			?>
			<tr><td colspan="3" style="text-align: right;"><b>Total:</b></td><td><?php echo($currency->currency_code); ?> $<?php echo(number_format($order->order_total, 2)); ?></td></tr>
		</tbody>
	</table>

	<p><?php echo(nl2br(Mainframe::site()->tax_numbers)); ?></p>
</div>