<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Video Settings</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_title" class="<?php echo(LABEL_COL); ?>">Title (optional)</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_title" id="param_title" ng-model="params.title.value" class="form-control" data-default="" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_title_heading_level" class="<?php echo(LABEL_COL); ?>">Title Heading Level</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php angularMultipleChoice("param_title_heading_level", "params.title_heading_level.value", "0", ["h1" => "H1", "h2" => "H2", "h3" => "H3", "h4" => "H4", "h5" => "H5", "h6" => "H6", "0" => "None"]); ?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_module_class" class="<?php echo(LABEL_COL); ?>">Module Class</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="param_module_class" id="param_module_class" ng-model="params.module_class.value" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_video" class="<?php echo(LABEL_COL); ?>">Video File</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<select name="param_video" id="param_video" ng-model="params.video.value" class="form-control custom-select" ng-options="v.value as v.text for (k, v) in video_files" required>
						<option value="">Choose a Video</option>
					</select>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_max_width" class="<?php echo(LABEL_COL); ?>">Max Width</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_max_width" id="param_max_width" ng-model="params.max_width.value" class="form-control" data-default="400" min="1" step="1" required /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_max_height" class="<?php echo(LABEL_COL); ?>">Max Height</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_max_height" id="param_max_height" ng-model="params.max_height.value" class="form-control" data-default="300" min="1" step="1" required /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_volume" class="<?php echo(LABEL_COL); ?>">Volume</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="param_volume" id="param_volume" ng-model="params.volume.value" class="form-control" data-default="0.5" min="0" max="1" step="0.1" required /></div> {{params.volume.value * 100}}%
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="param_autoplay" class="<?php echo(LABEL_COL); ?>">Autoplay</label>
				<div class="<?php echo(FIELD_COL); ?>"><div class="<?php echo(FIELD_COL); ?>"><?php angularYesNo("param_autoplay", "params.autoplay.value", 0); ?></div></div>
			</div>
		</fieldset>
	</div>
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Instructions</legend>

			<ul>
				<li>Your video must be encoded in multiple formats using the same filename.</li>
				<li>You must have an MP4 copy.</li>
				<li>You must have a WebM copy.</li>
				<li>You can optionally include an OGV copy to support old versions of Firefox.</li>
				<li>You may also include a JPG or PNG with the same name to be used as a preview image.</li>
				<li>Place all copies of the video and the preview image in the videos folder using the same name (except their extensions, of course).
				<li>For example: video.mp4, video.webm, video.ogv, video.jpg</li>
			</ul>
		</fieldset>
	</div>
</div>
