<?php
$configs = explode("\n", $my_gateway->configuration);
$configuration = array();

foreach($configs as $config)
{
	if($config != "")
	{
		$line = explode("=", $config, 2);
		$configuration[$line[0]] = $line[1];
	}
}
?>
<script>
	var stripe_loaded = false;
	var stripe;
	var strip_elements;
	var strip_card;

	if(!stripe_loaded)
	{
		var s = document.createElement("script");
		s.setAttribute("src", "https://js.stripe.com/v3/");
		s.onload = function()
		{
			stripe = Stripe("<?php echo($configuration["public_key"]); ?>");
			strip_elements = stripe.elements();

			strip_card = strip_elements.create('card');
			strip_card.mount('#card-element');

			// When the main form is submitted, submit our Stripe form too.
			var x = function(event)
			{
				// Ignore other events.
				if(event != "confirmOrder")
				{
					return true;
				}

				ncms_checkout.payment_info.stripeToken = "pending";
      			ncms_checkout.$forceUpdate();

      			var errorElement = document.getElementById('card-errors');
				errorElement.textContent = "";
				errorElement.className = "";

				stripe.createToken(strip_card).then(function(result)
				{
    				if (result.error)
    				{
						// Inform the user if there was an error
						errorElement.textContent = result.error.message;
						errorElement.className = "alert alert-danger";
						ncms_checkout.payment_info.stripeToken = null;
      					ncms_checkout.$forceUpdate();
						ncms_checkout.editBilling();
    				}
    				else
    				{
      					// Send the token to your server
      					// console.debug(result.token);
      					ncms_checkout.payment_info.stripeToken = result.token.id;
      					ncms_checkout.$forceUpdate();
					}
  				});

				return true;
			}

			shopAddEventListener(<?php echo($my_gateway->payment_gateway_id); ?>, x);
		}
		document.body.appendChild(s);
		stripe_loaded = true;
	}
</script>

<div class="row">
	<div class="<?php echo(TWO_COL); ?>">
		<div id="card-element"></div>
	</div>
	<div class="<?php echo(TWO_COL); ?>">
		<div id="card-errors" role="alert"></div>
	</div>
</div>
