<h1><?php echo(PRODUCT_NAME); ?> Update</h1>

<div class="row">
	<div class="col-12 col-lg-6">
		<h2>Automatic Update</h2>

		<?php
		if($new_version)
		{
			?>
			<div class="alert alert-info">Version <?php echo($new_version); ?> of <?php echo(PRODUCT_NAME); ?> is available. You have version <?php echo(PRODUCT_VERSION); ?>.</div>
			<div class="alert alert-danger">
				Always do a full account backup (files and database) before updating.
				<hr>
				Always read the changes carefully before updating.
				<?php
				if($manual_action)
				{
					?><hr>Manual actions are required for this update. Only developers should install this update.<?php
				}
				?>
			</div>
			<?php
		}
		else
		{
			?><div class="alert alert-success">You have the latest version of <?php echo(PRODUCT_NAME); ?>, v<?php echo(PRODUCT_VERSION); ?>.</div><?php
		}
		?>
	</div>

	<div class="col-12 col-lg-6">
		<h2>Install Postal Codes</h2>
		<p>Postal codes are used from version 4.7.2 onward for the shop section only.</p>
		<p>There are nearly 1 million records, so they are not installed by default.</p>
		<p><b>Install these only if you actually need them. Installation will take a long time. Do not stop your browser after clicking "Install."</b></p>
		<p class="text-center"><a href="/admin/install_postalcodes" class="btn btn-secondary"><em class="fas fa-fw fa-cloud-download-alt" aria-hidden="true"></em> Install</a></p>
	</div>

	<?php
	if($new_version && $changes)
	{
		?>
		<div class="col-12">
			<h2>Changes From <?php echo($current_version); ?> to <?php echo($new_version); ?></h2>

			<?php echo($changes); ?>

			<p><a href="#" onclick="nerivon_confirm('Before Updating', 'Have you made a full backup and read the changes carefully?', 'warning', true, function(confirmed) { if(confirmed) { window.location = '/update/auto'; }}); return false;" class="btn btn-primary btn-lg"><em class="fas fa-fw fa-sync" aria-hidden="true"></em> Update to <?php echo($new_version); ?></a></p>
		</div>
		<?php
	}
	?>
</div>
