CKEDITOR.plugins.add('nvdocument', {
	init: function(editor)
	{
		editor.addCommand('nvdocument', new CKEDITOR.dialogCommand('nvdocument'));
		editor.modes = {
			wysiwyg: 1,
			source: 0
		};
		editor.canUndo = true;
		editor.ui.addButton('nvdocument', {
			label: 'Insert Document Link',
			command: 'nvdocument',
			icon: this.path + 'nvdocument.png'
		});
		CKEDITOR.dialog.add('nvdocument', this.path + 'dialogs/nvdocument.js');

		if(editor.contextMenu)
		{
		    editor.addMenuGroup('nvDocumentGroup');
		    editor.addMenuItem('nvDocumentSettings',
		    {
		        label: 'Edit Document Link',
		        icon: this.path + 'nvdocument.png',
		        command: 'nvdocument',
		        group: 'nvDocumentGroup'
		    });
		    editor.contextMenu.addListener( function( element )
		    {
		    	if(element.hasClass("fa"))
		        {
		            return { nvDocumentSettings: CKEDITOR.TRISTATE_OFF };
		        }
		    });
		}
	}
});
