CKEDITOR.dialog.add('nvmodule', function(editor)
{
	return {
		title: 'Insert Module',
		resizable: CKEDITOR.DIALOG_RESIZE_NONE,
		minWidth: 400,
        height: 100,
		contents: [
		{
			id: 'tab-info',
			label: 'Info',
			elements: [
			{
				type: 'select',
				id: 'module_text',
				style: 'width: 100%',
				label: 'Select a Module:',
				items: ckEditorModules,
				setup: function( element )
				{
					if(element.getId() != null)
                    {
                    	this.setValue( element.getId().replace("module_", "") );
                    }
                }
			}]
		}],
		onShow: function()
		{
		    // The code that will be executed when a dialog window is loaded.
		    var selection 	= editor.getSelection();
            var element 	= selection.getStartElement();

            if(element != null && element.getName() == 'img')
            {
                element = element.getAscendant({ img:1}, true);
            }
            else
            {
                element = editor.document.createElement('img');
            }

            this.insertMode 	= true;
            this.element 		= element;
            this.setupContent(this.element);
		},
		onOk: function()
		{
			var selection 	= editor.getSelection();
            var element 	= selection.getStartElement();

            // src attribtue doesn't replace properly so we'll remove the element and add a fresh one.
            if(element != null && element.getName() == 'img')
            {
                element = element.getAscendant({ img:1}, true);

                if(element && element.getName() == 'img')
            	{
            		element.remove();
            	}
            }

            // Force the image to be placed in a div, rather than a p (default).
            var style 		= new CKEDITOR.style( { element: 'div' } );
            var img 		= editor.document.createElement( 'img' );
            var module_id 	= this.getValueOf('tab-info', 'module_text');
			img.setAttribute("class", "module_placeholder");
            img.setAttribute("id", "module_" + module_id);
            img.setAttribute("src", "/placeholder?id=" + module_id);
            editor.applyStyle(style);
            this.commitContent(img);

            if(this.insertMode)
            {
               	editor.insertElement(img);
            }
		}
	};
});
