CKEDITOR.dialog.add('nvpage', function(editor)
{
	return {
		title: 'Insert Page Link',
		resizable: CKEDITOR.DIALOG_RESIZE_NONE,
        minWidth: 640,
        height: 300,
        contents:
		[
	        {
	            id: 'tab-page',
	            label: '',
	            title: '',
	            elements:
	            [
	            	{
						type: 'select',
						id: 'nvpage-pageid',
						label: 'Select a Page',
						items: [["Select a Page", ""]],
						style: "width: 100%",
						onChange: function(e)
						{
							option = jQuery("#" + d.getContentElement("tab-page", "nvpage-pageid").domId + " select option:selected");

							d = this.getDialog();
				        	d.setValueOf("tab-page", "nvpage-url", option.val());

				        	// Replace the title, unless there was already selected text.
							if(editor.getSelection().getType() != CKEDITOR.SELECTION_ELEMENT &&
								d.getValueOf("tab-page", "nvpage-text") == "")
							{
								d.setValueOf("tab-page", "nvpage-text", option.text());
								d.getContentElement("tab-page", "nvpage-text").focus();
							}
							if(d.getValueOf("tab-page", "nvpage-title") == "")
							{
								d.setValueOf("tab-page", "nvpage-title", option.text());
								d.getContentElement("tab-page", "nvpage-title").focus();
							}
						},
						setup: function(element)
						{
							d = this.getDialog();
				        	jQuery.post
						    (
						        "/ajax/get_pages_array",
						        {
						        },
						        function(pages)
						        {
						        	for(i=0; i<pages.length; i++)
						        	{
						        		d.getContentElement("tab-page", "nvpage-pageid").add(pages[i].text, "/" + pages[i].url);
						        	}
						        }
						    ).fail(function(data)
						    {
						    	error("No Pages", "Failed to load pages.", true, null);
							});
		                }
					},
					{
						type: 'text',
						id: 'nvpage-text',
						label: 'Link Text',
						setup: function(element)
						{
							if(editor.getSelection().getType() == CKEDITOR.SELECTION_ELEMENT)
							{
								// This is probably HTML, lets just hide the input.
								this.setValue("");
								this.getElement().hide();
							}
							else
							{
								this.getElement().show();
								this.setValue(element.getHtml().replace(/<br>$/ig, ''));
							}
		                }
					},
					{
						type: 'text',
						id: 'nvpage-title',
						label: 'Title Attribute (used as a tooltip for accessibility and SEO)',
						setup: function(element)
						{
							this.setValue((element.getAttribute("title") ? element.getAttribute("title") : ""));
							this.focus();
		                }
					},
					{
						type: 'text',
						id: 'nvpage-url',
						label: 'Link URL (populated automatically after selecting a page)',
						validate: CKEDITOR.dialog.validate.notEmpty("You must select a page."),
						setup: function(element)
						{
							this.setValue((element.getAttribute("href") ? element.getAttribute("href") : ""));
							this.disable();
						}
					}
	            ]
	        }
        ],
        onShow: function()
        {
            var selection 	= editor.getSelection();
            var element 	= selection.getStartElement();

            if(element != null && element.getName() == 'a')
            {
                element = element.getAscendant({ a:1}, true);

                if(element != null && selection != null)
            	{
            		selection.selectElement(element);
            	}
            }
            else
            {
                element = editor.document.createElement('a');
            }

            if(selection != null && selection.getType() != CKEDITOR.SELECTION_ELEMENT)
            {
            	element.setHtml(selection.getSelectedText());
            }

            this.insertMode 	= true;
            this.element 		= element;
            this.setupContent(this.element);
        },
		onOk: function()
		{
			var pageurl 	= this.getValueOf('tab-page', 'nvpage-url');
			var pagetext 	= this.getValueOf('tab-page', 'nvpage-text');
			var pagetitle 	= this.getValueOf('tab-page', 'nvpage-title');
			var selection 	= editor.getSelection();
            var element 	= selection.getStartElement();
            var children 	= "";

            // href attribtue doesn't replace properly so we'll remove the element and add a fresh one.
            if(element != null && element.getName() == 'a')
            {
                parent = element.getAscendant({ a:1}, true);

                if(parent != null && parent.getName() == "a")
            	{
            		children = parent.getHtml().replace(/<br>$/ig, '');
                	parent.remove();
            	}
            	else
            	{
            		children = element.getOuterHtml().replace(/<br>$/ig, '');
            	}
            }
            else if(element != null && element.getName() == 'img')
            {
                children = element.getOuterHtml();
            }
            else
            {
            	children = selection.getSelectedText();
            }

			var link = editor.document.createElement('a');

            if(pagetext)
        	{
        		link.setHtml(pagetext);
        	}
        	else if(children)
        	{
        		link.setHtml(children);
        	}

			link.setAttribute("class", "content-link");
            link.setAttribute("href", pageurl);
            link.setAttribute("title", pagetitle);
            this.commitContent(link);

            if(this.insertMode)
            {
               	editor.insertElement(link);
            }
		}
	};
});
