CKEDITOR.plugins.add('nvpage', {
	init: function(editor)
	{
		editor.addCommand('nvpage', new CKEDITOR.dialogCommand('nvpage'));
		editor.modes = {
			wysiwyg: 1,
			source: 0
		};
		editor.canUndo = true;
		editor.ui.addButton('nvpage', {
			label: 'Insert Page Link',
			command: 'nvpage',
			icon: this.path + 'nvpage.png'
		});
		CKEDITOR.dialog.add('nvpage', this.path + 'dialogs/nvpage.js');

		if(editor.contextMenu)
		{
		    editor.addMenuGroup('nvPageGroup');
		    editor.addMenuItem('nvPageSettings',
		    {
		        label: 'Edit Page Link',
		        icon: this.path + 'nvpage.png',
		        command: 'nvpage',
		        group: 'nvPageGroup'
		    });
		    editor.contextMenu.addListener( function( element )
		    {
		    	if(element.hasClass("fa"))
		        {
		            return { nvPageSettings: CKEDITOR.TRISTATE_OFF };
		        }
		    });
		}
	}
});
