(function()
{
 	var app = angular.module('app');

 	app.controller('ProductController', ["$scope", "$http", function($scope, $http)
	{
		$scope.config = {tag_ids: [], images: [], main_image: 1};
		$scope.uploads = [];

		$scope.setConfig = function(published, promo_expiration, bulk_discount_type, main_image, tag_ids)
		{
			$scope.setPublished(published);
			$scope.config.promo_expiration   = promo_expiration;
			$scope.config.bulk_discount_type = bulk_discount_type;
			$scope.config.main_image 		 = main_image;
			$scope.config.tag_ids            = tag_ids;
		}

		$scope.FileDragHover = function(e)
		{
			try
			{
				e.stopPropagation();
			}
			catch(err){}

			try
			{
				e.preventDefault();
			}
			catch(err){}

			try
			{
				document.getElementById("dropzone").className = (e.type == "dragover" ? "dropzone hover" : "dropzone");
			}
			catch(err)
			{
				document.getElementById("dropzone").className = "dropzone";
			}
		}

		$scope.FileSelectHandler = function(e)
		{
			// cancel event and hover styling
			$scope.FileDragHover(e);

			// fetch FileList object
			var files = e.files || e.dataTransfer.files;

			// process all File objects
			for (var i = 0, f; f = files[i]; i++) {
				$scope.ParseFile(f);
			}
		}

		$scope.ParseFile = function(file)
		{
			var oFReader1 = new FileReader();
        	oFReader1.readAsDataURL(file);

	   		oFReader1.onload = function (oFREvent)
	        {
	        	var newfile = {};
	        	newfile.filename = oFREvent.target.result;
	        	newfile.original_filename = file.name;
	        	$scope.uploads.push(newfile);
	        	// $scope.config.images.push(newfile);
	        	$scope.$apply();
	        };
		}

		$scope.deletePendingImage = function(index)
		{
			nerivon_confirm("Are you sure?", "This image will not be uploaded if you save the product.", "warning", true, function(isConfirm)
			{
				if(isConfirm)
				{
					$scope.uploads.splice(index, 1);
					$scope.$digest();
				}
			})
		}

		$scope.deleteSavedImage = function(index)
		{
			nerivon_confirm("Are you sure?", "This image will be removed if you save the product.", "warning", true, function(isConfirm)
			{
				if(isConfirm)
				{
					jQuery("#field_image" + index).val("");
					jQuery(".trailer-thumbnail" + index).parent().css({"display": "none"});

					if($scope.config.main_image == index)
					{
						$scope.config.main_image = 1;
						$scope.$digest();
					}
				}
			})
		}

		jQuery(document).ready(function()
		{
			var xhr = new XMLHttpRequest();

			if(window.File && window.FileList && window.FileReader && xhr.upload)
			{
				var dropzone = document.getElementById("dropzone");

				dropzone.addEventListener("dragover", $scope.FileDragHover, false);
				dropzone.addEventListener("dragleave", $scope.FileDragHover, false);
				dropzone.addEventListener("drop", $scope.FileSelectHandler, false);
			}
		});
	}]);

	app.filter('toISOString', function()
 	{
	    return function(input)
	    {
	    	if(typeof input == "undefined")
	    	{
	    		return "";
	    	}

	    	try
	    	{
	    		return new Date(input).toISOString().substring(0, 10);
	    	}
	    	catch(e)
	    	{
	    		return input;
	    	}
	    }
	});
})();
