(function ($) {
	var open = false;
	var opt = {};

	var nv_sidebar_open = function(event)
	{
		try{event.preventDefault();}catch(e){}

		$(opt.contentClass).addClass(opt.contentOpenClass.replace(".", ""));
		open = true;
	}

	var nv_sidebar_close = function(event)
	{
		try{event.preventDefault();}catch(e){}

		$(opt.contentClass).removeClass(opt.contentOpenClass.replace(".", ""));
		open = false;
	}

	var nv_sidebar_click = function(event)
	{
		try{event.preventDefault();}catch(e){}

		if(open)
		{
			opt.close(event);
		}
		else
		{
			opt.open(event);
		}
	}

	jQuery.fn.nvSidebar = function(options)
	{
		if(typeof options != "object")
		{
			options = {};
		}

		if(typeof options.triggerClass != "string")
		{
			options.triggerClass = ".nv-sidebar-trigger";
		}

		if(typeof options.contentClass != "string")
		{
			options.contentClass = ".nv-sidebar-content";
		}

		if(typeof options.contentOpenClass != "string")
		{
			options.contentOpenClass = ".nv-sidebar-content-open";
		}

		if(typeof options.open != "function")
		{
			options.open = nv_sidebar_open;
		}

		if(typeof options.close != "function")
		{
			options.close = nv_sidebar_close;
		}

		opt = options;

		jQuery(this).each(function()
		{
			$(opt.triggerClass).unbind("click", nv_sidebar_click).on("click", nv_sidebar_click);
		});
	};
}(jQuery));
