(function ($) {
	var nv_tabs = function(event)
	{
	   	event.preventDefault();

	    $(this).parent().addClass("nv-tab-current");
	    $(this).parent().siblings().removeClass("nv-tab-current");
	    var tab 	= $(this).attr("href");
	    var tabs 	= $(this).parents(".nv-tabs").eq(0);

	    // The reason for doing .children().children() is because we don't want to affect embedded nv-tabs
	    tabs.children(".nv-tab").children(".nv-tab-content").not(tab).css("display", "none");
	    tabs.children(".nv-tab").children(tab).fadeIn(500);
	};

	var nv_tabs_select = function(event)
	{
		event.preventDefault();

		classes = jQuery(this).val().split("|");

		for(i=0; i<classes.length; i++)
		{
			var tab = classes[i];
			var tabs 	= $(tab).parents(".nv-tabs").eq(0);

			// The reason for doing .children().children() is because we don't want to affect embedded nv-tabs
		    tabs.children(".nv-tab").children(".nv-tab-content").not(tab).css("display", "none");
		    tabs.children(".nv-tab").children(tab).fadeIn(500);
		}
	};

	jQuery.fn.nvTabs = function(options)
	{
		if(typeof options != "object" ||
		   (typeof options.active != "number" && typeof options.active != "string") ||
		   (typeof options.active == "number" && options.active < 1) ||
		   (typeof options.active == "string" && options.active == ""))
		{
			options.active = 1;
		}

		jQuery(this).each(function()
		{
			$(this).find(".nv-tabs-nav a.nv-tab-link").unbind("click", nv_tabs).click(nv_tabs);

			if(typeof options.active == "string")
			{
				$(this).find(".nv-tabs-nav a[href='." + options.active + "']").click();
			}
			else
			{
				$(this).find(".nv-tabs-nav li:nth-child(" + options.active + ") > a").click();
			}
		});
	};

	jQuery.fn.nvTabsSelect = function(options)
	{
		if(typeof options != "object" ||
		   (typeof options.active != "number" && typeof options.active != "string") ||
		   (typeof options.active == "number" && options.active < 1) ||
		   (typeof options.active == "string" && options.active == ""))
		{
			options.active = 1;
		}

		jQuery(this).each(function()
		{
			$(this).find(".nv-tabs-nav select").unbind("change", nv_tabs_select).change(nv_tabs_select);
			$(this).find(".nv-tabs-nav select").selectedIndex(options.active - 1).change();
		});
	};
}(jQuery));
