// (function()
// {
	var nvfinder_filetype 		= "";
	var nvfinder_file_count 	= 0;
	var nvfinder_file_total 	= 0;
	var nvfinder_upload_files 	= [];
	var nvfinder_display_files 	= [];
	var nvfinder_cwd 			= "";
	var nvfinder_html 			= "";
	var nvfinder_dircount 		= 0;
	var nvfinder_funcnum 		= 1;
	var upload_progress 		= 0;
	var upload_total 			= 0;
	var document_edit_index 	= false;
	var nvfinder_force_crop 	= false;
	var nvfinder_high_dpi 		= true;
 	var acl_roles				= [];

	function nvfinder_setFileType(filetype)
	{
		nvfinder_filetype = filetype;
	}

	function nvfinder_setFunctionNumber(num)
	{
		nvfinder_funcnum = num;
	}

	function nvfinder_reload_directories()
	{
		jQuery("#nvfinder_loading_spinner").addClass("fa-spin").fadeIn(100);

		jQuery.post
	    (
	        "/finder/directories",
	        {
	            type: nvfinder_filetype
	        },
	        function(data)
	        {
	        	jQuery("#nvfinder-directory-list").html(data);
	        	jQuery("#nvfinder-directory-list li a[data-cwd='/" + nvfinder_cwd + "']").siblings("em").removeClass("fa-folder").addClass("fa-folder-open");
	        }
	    ).fail(function(data)
	    {
			// error("Error Loading Files", data.responseText, true, null);
			jQuery("#nvfinder_loading_spinner").removeClass("fa-spin").fadeOut(100);
		});
	}

	function nvfinder_filter(path, event)
	{
		jQuery("#nvfinder-search").val("");
		jQuery("#nvfinder_loading_spinner").addClass("fa-spin").fadeIn(100);

		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		index = 0;
		nvfinder_display_files = [];

		// If the path is an array of files already, we just want to filter it.
		if(typeof path == "object")
		{
			for(i=0; i<path.length; i++)
        	{
        		if(path[i].type == "directory")
        		{
        			continue;
        		}

				nvfinder_display_files[index] = path[i];
				index++;
        	}

        	nvfinder_show_files();
		}
		// Otherwise, path is a string and we need to query for files.
		else
		{
			try
			{
				id = event.target.id;
			}
			catch(e)
			{
				id = "dir1";
			}

			nvfinder_cwd = path; // jQuery("#" + id).attr("data-cwd");

			jQuery(".fa-folder-open").removeClass("fa-folder-open").addClass("fa-folder");
			// jQuery("#" + id).siblings("em").removeClass("fa-folder").addClass("fa-folder-open");
			jQuery("#nvfinder-directory-list li a[data-cwd='/" + nvfinder_cwd + "']").siblings("em").removeClass("fa-folder").addClass("fa-folder-open");

			jQuery.post
		    (
		        "/finder/filesystem",
		        {
		        	type: nvfinder_filetype,
	            	path: "/" + nvfinder_cwd
	            },
		        function(files)
		        {
		        	for(i=0; i<files.length; i++)
		        	{
		        		if(files[i].type == "directory")
		        		{
		        			continue;
		        		}

						nvfinder_display_files[index] = files[i];
						index++;
		        	}

		        	nvfinder_show_files();
		        }
		    ).fail(function(data)
		    {
				// error("Error Loading Files", data.responseText, true, null);
				jQuery("#nvfinder_loading_spinner").removeClass("fa-spin").fadeOut(100);
			});

			jQuery.post
		    (
		        "/finder/directorySettings",
		        {
		        	path: nvfinder_cwd
	            },
		        function(settings)
		        {
		        	if(typeof settings == "object" && settings.note != null)
	        		{
	        			jQuery("#nvfinder-directory-info").html(settings.note).removeClass("d-none");
	        		}
	        		else
	        		{
	        			jQuery("#nvfinder-directory-info").addClass("d-none").html("");
	        		}

	        		if(typeof settings == "object" && settings.force_crop != null)
	        		{
	        			nvfinder_force_crop = settings.force_crop;
	        		}
	        		else
	        		{
	        			nvfinder_force_crop = false;
	        		}

	        		if(typeof settings == "object" && settings.crop_width != null && settings.crop_height != null)
	        		{
						jQuery("#nvfinder-cropit-maintain-aspect-ratio").val("").prop("disabled", nvfinder_force_crop);
	        			jQuery('#nvfinder-cropit-width').val(settings.crop_width).prop("disabled", nvfinder_force_crop);
						jQuery('#nvfinder-cropit-height').val(settings.crop_height).prop("disabled", nvfinder_force_crop);
						nvfinder_cropit_width();
	        		}
	        		else
	        		{
						jQuery("#nvfinder-cropit-maintain-aspect-ratio").val("4:3").prop("disabled", false);
	        			jQuery('#nvfinder-cropit-width').val(800).prop("disabled", false);
						jQuery('#nvfinder-cropit-height').val(600).prop("disabled", false);
						nvfinder_cropit_width();
	        		}

	        		if(typeof settings == "object" && settings.high_dpi != null)
	        		{
	        			nvfinder_high_dpi = settings.high_dpi;
	        		}
	        		else
	        		{
	        			nvfinder_high_dpi = false;
	        		}
		        }
		    ).fail(function(data)
		    {
				jQuery("#nvfinder-directory-info").addClass("d-none").html("");
			});
		}

		if(nvfinder_cwd.match(/^images/))
		{
			jQuery(".nvfinder-title").html("Media Manager");
			jQuery(".nvfinder-files-title").html("Images");
			jQuery("#nvfinder-upload-button").removeClass("d-none");
			jQuery("#nvfinder-document-button").addClass("d-none");
			jQuery("#nvfinder-mkdir-button").removeClass("d-none");

			if(nvfinder_cwd == "images")
			{
				jQuery("#nvfinder-rename-button").addClass("d-none");
				jQuery("#nvfinder-rmdir-button").addClass("d-none");
			}
			else
			{
				jQuery("#nvfinder-rename-button").removeClass("d-none");
				jQuery("#nvfinder-rmdir-button").removeClass("d-none");
			}
		}
		else if(nvfinder_cwd.match(/^documents/))
		{
			jQuery(".nvfinder-title").html("Document Manager");
			jQuery(".nvfinder-files-title").html("Documents");
			jQuery("#nvfinder-upload-button").addClass("d-none");
			jQuery("#nvfinder-document-button").removeClass("d-none");
			jQuery("#nvfinder-mkdir-button").addClass("d-none");

			if(nvfinder_cwd == "documents")
			{
				jQuery("#nvfinder-rename-button").addClass("d-none");
				jQuery("#nvfinder-rmdir-button").addClass("d-none");
			}
			else
			{
				jQuery("#nvfinder-rename-button").removeClass("d-none");
				jQuery("#nvfinder-rmdir-button").removeClass("d-none");
			}
		}
		else if(nvfinder_cwd.match(/^videos/))
		{
			jQuery(".nvfinder-title").html("Media Manager");
			jQuery(".nvfinder-files-title").html("Videos");
			jQuery("#nvfinder-upload-button").removeClass("d-none");
			jQuery("#nvfinder-document-button").addClass("d-none");
			jQuery("#nvfinder-mkdir-button").removeClass("d-none");

			if(nvfinder_cwd == "videos")
			{
				jQuery("#nvfinder-rename-button").addClass("d-none");
				jQuery("#nvfinder-rmdir-button").addClass("d-none");
			}
			else
			{
				jQuery("#nvfinder-rename-button").removeClass("d-none");
				jQuery("#nvfinder-rmdir-button").removeClass("d-none");
			}
		}
		else
		{
			jQuery(".nvfinder-title").html("File Manager");
			jQuery(".nvfinder-files-title").html("Files");
			jQuery("#nvfinder-upload-button").removeClass("d-none");
			jQuery("#nvfinder-document-button").addClass("d-none");
			jQuery("#nvfinder-mkdir-button").removeClass("d-none");
			jQuery("#nvfinder-rename-button").removeClass("d-none");
			jQuery("#nvfinder-rmdir-button").removeClass("d-none");
		}
	}

	function nvfinder_show_files()
	{
		index = -1;
		var keyword = jQuery("#nvfinder-search").val().toLowerCase();

		if(typeof nvfinder_display_files == "undefined" || nvfinder_display_files.length == 0)
		{
			html = "";
		}
		else
		{
			html = '<div class="row m-0">';

			for(i=0; i<nvfinder_display_files.length; i++)
			{
				index++;

				if(nvfinder_display_files[i].path.toLowerCase().indexOf(keyword) === -1 &&
				   (typeof nvfinder_display_files[i].title == "undefined" ||
				    nvfinder_display_files[i].title.toLowerCase().indexOf(keyword) === -1))
				{
					continue;
				}

				if(nvfinder_display_files[i].type == "file")
				{
					lastslash = nvfinder_display_files[i].path.lastIndexOf("/");
					qmark = nvfinder_display_files[i].path.indexOf("?");

					if(lastslash == -1)
					{
						if(qmark == -1)
						{
							filename = nvfinder_display_files[i].path;
						}
						else
						{
							filename = nvfinder_display_files[i].path.substring(0, qmark);
						}
					}
					else
					{
						if(qmark == -1)
						{
							filename = nvfinder_display_files[i].path.substring(lastslash+1);
						}
						else
						{
							filename = nvfinder_display_files[i].path.substring(lastslash+1, qmark);
						}
					}

					if(filename.match(/\.(jpe?g|png|gif|bmp|ico)/gi) != null)
					{
						content = '<div class="nvfinder-image"><img src="' + nvfinder_display_files[i].thumbnail + '" /></div><div class="nvfinder-filename">' + filename + '</div>';
					}
					else if(filename.match(/\.pdf?/gi) != null)
					{
						content = '<div class="nvfinder-image"><img src="/document/cover/' + nvfinder_display_files[i].document_id + '/200/150" /></div><div class="nvfinder-filename"><em class="far fa-fw fa-file-pdf" aria-hidden="true"></em> ' + filename + '</div>';
					}
					else if(filename.match(/\.(html|php|js|css)/gi) != null)
					{
						content = '<em class="far fa-fw fa-file-code fa-3x" aria-hidden="true"></em><div class="nvfinder-filename">' + filename + '</div>';
					}
					else if(filename.match(/\.(txt|log|md)/gi) != null)
					{
						content = '<em class="far fa-fw fa-file-alt fa-3x" aria-hidden="true"></em><div class="nvfinder-filename">' + filename + '</div>';
					}
					else if(filename.match(/\.(mp3|wav|ogg)/gi) != null)
					{
						content = '<em class="far fa-fw fa-file-audio fa-3x" aria-hidden="true"></em><div class="nvfinder-filename">' + filename + '</div>';
					}
					else if(filename.match(/\.(mp4|wmv|mov|ogv|webm)/gi) != null)
					{
						content = '<em class="far fa-fw fa-file-video fa-3x" aria-hidden="true"></em><div class="nvfinder-filename">' + filename + '</div>';
					}
					else if(filename.match(/\.(zip|gz|7z|tar|rar)/gi) != null)
					{
						content = '<em class="far fa-fw fa-file-archive fa-3x" aria-hidden="true"></em><div class="nvfinder-filename">' + filename + '</div>';
					}
					else if(filename.match(/\.docx?/gi) != null)
					{
						content = '<em class="far fa-fw fa-file-word fa-3x" aria-hidden="true"></em><div class="nvfinder-filename">' + filename + '</div>';
					}
					else if(filename.match(/\.xlsx?/gi) != null)
					{
						content = '<em class="far fa-fw fa-file-excel fa-3x" aria-hidden="true"></em><div class="nvfinder-filename">' + filename + '</div>';
					}
					else if(filename.match(/\.pptx??/gi) != null)
					{
						content = '<em class="far fa-fw fa-file-powerpoint fa-3x" aria-hidden="true"></em><div class="nvfinder-filename">' + filename + '</div>';
					}
					else
					{
						content = '<em class="far fa-fw fa-file fa-3x" aria-hidden="true"></em><div class="nvfinder-filename">' + filename + '</div>';
					}

					if(typeof nvfinder_display_files[i].info == "string")
					{
						content += '<div class="nvfinder-info">' + nvfinder_display_files[i].info + '</div>';
					}

					html += '<div class="col-6 col-md-4 col-lg-3" id="finder-file-' + index + '"><div class="nvfinder-container"><a href="#" onclick="nvfinder_menu(' + index + ', event)" draggable ondragstart="nvfinder_FileMoveStart(' + index + ', event)">';
					html += content;
					html += '</a>';
					html += '</div></div>';
				}
				else if(nvfinder_display_files[i].type == "document")
				{
					html += '<div class="col-6 col-lg-4" id="finder-file-' + index + '"><div class="nvfinder-container"><a href="#" onclick="nvfinder_menu(' + index + ', event)" draggable ondragstart="nvfinder_FileMoveStart(' + index + ', event)">';
					html += '<div class="nvfinder-image"><img src="/document/cover/' + nvfinder_display_files[i].document_id + '/200/150" /></div><div class="nvfinder-filename"><em class="far fa-fw fa-file-pdf" aria-hidden="true"></em> ' + nvfinder_display_files[i].title + '</div>';

					if(typeof nvfinder_display_files[i].info == "string")
					{
						html += '<div class="nvfinder-info">' + nvfinder_display_files[i].info + '</div>';
					}

					html += '</a>';
					html += '</div></div>';
				}
			}
			html += "</div>";
		}

		jQuery("#nvfinder_loading_spinner").removeClass("fa-spin").fadeOut(100);
		jQuery("#nvfinder-files").html(html);
	}

	function nvfinder_menu(index, event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		nvfinder_menu_close();

		var html = '<div class="dropdown-menu" data-reference="parent">';

		if(window.opener)
		{
			// CKEditor mode
			html += '<a href="#" onclick="nvfinder_pickit(' + index + ', event)" class="dropdown-item"><em class="fas fa-fw fa-check" aria-hidden="true"></em> Insert</a>';
		}

		if(nvfinder_display_files[index].path.match(/\.(jpe?g|png|gif|webp)/gi) != null)
		{
			html += '<a href="#" onclick="nvfinder_cropit_dialog(' + index + ', event)" class="dropdown-item"><em class="fas fa-fw fa-crop" aria-hidden="true"></em> Resize</a>';
			html += '<a href="#" onclick="nvfinder_metadata_dialog(' + index + ', event)" class="dropdown-item"><em class="fas fa-fw fa-code" aria-hidden="true"></em> Metadata</a>';
		}
		if(nvfinder_display_files[index].type == "document")
		{
			html += '<a href="#" onclick="nvfinder_edit_document(' + index + ', event)" class="dropdown-item"><em class="far fa-fw fa-edit" aria-hidden="true"></em> Edit</a>';
			html += '<a href="#" onclick="nvfinder_download_document(' + index + ', event)" class="dropdown-item"><em class="fas fa-fw fa-cloud-download-alt" aria-hidden="true"></em> Download</a>';
			html += '<a href="#" onclick="nvfinder_delete_document(' + index + ', event)" class="dropdown-item"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em> Delete</a>';
		}
		else
		{
			html += '<a href="#" onclick="nvfinder_rename_file(' + index + ', event)" class="dropdown-item"><em class="fas fa-fw fa-i-cursor" aria-hidden="true"></em> Rename</a>';
			html += '<a href="#" onclick="nvfinder_duplicate_file(' + index + ', event)" class="dropdown-item"><em class="far fa-fw fa-copy" aria-hidden="true"></em> Duplicate</a>';
			html += '<a href="#" onclick="nvfinder_download_file(' + index + ', event)" class="dropdown-item"><em class="fas fa-fw fa-cloud-download-alt" aria-hidden="true"></em> Download</a>';
			html += '<a href="#" onclick="nvfinder_delete_file(' + index + ', event)" class="dropdown-item"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em> Delete</a>';
		}
		html += '</div>';

		var t = jQuery(event.target);
		var p = t.parents(".nvfinder-container");
		p.append(html);
		var m = p.find(".dropdown-menu");

		width  = event.layerX - 10;
		height = p.outerHeight(true) - event.layerY;

		m.dropdown("toggle");

		setTimeout(function()
		{
			m.css({top: (height * -1) + "px", left: width + "px"});
		}, 1);

		// While the menu is open, clicking anywhere else will close it.
		jQuery(window).off("click").on("click", function()
		{
			nvfinder_menu_close();
		});
	}

	function nvfinder_menu_close()
	{
		jQuery("#nvfinder-menu .dropdown-menu").dropdown("dispose");
		jQuery(".nvfinder-container .dropdown-menu").detach();
		jQuery(window).off("click");
	}

	function nvfinder_pickit(index, event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		if(nvfinder_display_files[index].type == "document")
		{
			path = "/document/" + nvfinder_display_files[index].url + "|" + nvfinder_display_files[index].title;
		}
		else
		{
			qmark = nvfinder_display_files[index].path.indexOf("?");

			if(qmark == -1)
			{
				path = nvfinder_display_files[index].path;
			}
			else
			{
				path = nvfinder_display_files[index].path.substring(0, qmark);
			}
		}

		if(window.opener)
		{
			// CKEditor mode
			window.opener.CKEDITOR.tools.callFunction(nvfinder_funcnum, path);
			window.close();
		}
		else
		{
			// Embedded mode
		}
	}

	function nvfinder_delete_file(index, event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		file = nvfinder_display_files[index];

		nerivon_confirm("Are you sure?", "This file will be DELETED. There is no undo.", "warning", false, function(isConfirm)
		{
			if(isConfirm)
			{
				jQuery.post
			    (
			        "/finder/delete",
			        {
			        	path: file.path
	            	},
			        function(data)
			        {
			        	swal.close();
		        		if(typeof data == "object")
				    	{
				    		nvfinder_filter(data);
				    	}
			        }
			    ).fail(function(data)
			    {
	    			error("Error Deleting File", data.responseText, true, null);
	  			});
			}
		});
	}

	function nvfinder_delete_document(index, event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		file = nvfinder_display_files[index];

		nerivon_confirm("Are you sure?", "This document will be DELETED. There is no undo.", "warning", false, function(isConfirm)
		{
			if(isConfirm)
			{
				jQuery.post
			    (
			        "/admin/document_delete/1",
			        {
			        	document_id: file.document_id
	            	},
			        function(data)
			        {
			        	swal.close();
		        		nvfinder_filter(nvfinder_cwd);
			        }
			    ).fail(function(data)
			    {
	    			error("Error Deleting Document", data.responseText, true, null);
	  			});
			}
		});
	}

	function nvfinder_download_file(index, event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		file = nvfinder_display_files[index];
		window.open("/download" + file.path.replace(/\?t=.*/, ''));
		nvfinder_menu_close();
	}

	function nvfinder_download_document(index, event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		file = nvfinder_display_files[index];
		window.open("/document/" + file.url);
		nvfinder_menu_close();
	}

	function nvfinder_download_directory(event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		window.open("/download/" + nvfinder_cwd);
		nvfinder_menu_close();
	}

	function nvfinder_delete_directory(event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		if(nvfinder_cwd == "" ||
		   nvfinder_cwd == "images" ||
		   nvfinder_cwd == "documents" ||
		   nvfinder_cwd == "videos")
		{
			error("Protected Directory", "You can't delete this directory.", true, null);
			return;
		}

		nerivon_confirm("Are you sure?", "This directory will be DELETED. There is no undo.", "warning", false, function(isConfirm)
		{
			if(isConfirm)
			{
				jQuery.post
			    (
			        "/finder/delete",
			        {
			        	path: "/" + nvfinder_cwd
	            	},
			        function(data)
			        {
			        	swal.close();
			        	nvfinder_cwd = data;
		        		nvfinder_reload_directories();
			        }
			    ).fail(function(data)
			    {
	    			error("Error Deleting File", data.responseText, true, null);
	  			});
			}
		});
	}

	function nvfinder_rename_file(index, event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		file = nvfinder_display_files[index];

		nerivon_input("Rename File", "Type a new filename", false, function(text)
		{
			if(text)
			{
				jQuery.post
			    (
			        "/finder/rename",
			        {
			        	path: file.path,
	            		filename: text
	            	},
			        function(data)
			        {
			        	swal.close();
			        	if(typeof data == "object")
				    	{
				    		nvfinder_filter(data);
				    	}
			        }
			    ).fail(function(data)
			    {
					error("Error Renaming File", data.responseText, true, null);
				});
			}
		});
	}

	function nvfinder_rename_directory(event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		if(nvfinder_cwd == "" ||
		   nvfinder_cwd == "images" ||
		   nvfinder_cwd == "documents" ||
		   nvfinder_cwd == "videos")
		{
			error("Protected Directory", "You can't rename this directory.", true, null);
			return;
		}

		nerivon_input("Rename Directory", "Type a new directory name", false, function(text)
		{
			if(text)
			{
				jQuery.post
			    (
			        "/finder/rename",
			        {
			        	path: "/" + nvfinder_cwd,
	            		filename: text
	            	},
			        function(data)
			        {
			        	swal.close();
			        	nvfinder_cwd = data;
						nvfinder_reload_directories();
						nvfinder_filter(nvfinder_cwd, null);
			        }
			    ).fail(function(data)
			    {
					error("Error Renaming File", data.responseText, true, null);
				});
			}
		});
	}

	function nvfinder_newdir()
	{
		nerivon_input("New Directory", "Type a directory name", false, function(text)
		{
			if(text)
			{
				jQuery.post
			    (
			        "/finder/new_directory",
			        {
			        	cwd: nvfinder_cwd,
	            		filename: text
	            	},
			        function(data)
			        {
			        	swal.close();
			        	nvfinder_reload_directories();
			        }
			    ).fail(function(data)
			    {
					error("Error Creating Directory", data.responseText, true, null);
				});
			}
		});
	}

	function nvfinder_cropit_width()
	{
		aspect 		= jQuery("#nvfinder-cropit-maintain-aspect-ratio").val();
		width 		= jQuery('#nvfinder-cropit-width').val();
		height 		= jQuery('#nvfinder-cropit-height').val();

		if(aspect == "1:1")
		{
			height = width;
		}
		else if(aspect == "4:3")
		{
			height = width / 4 * 3;
		}
		else if(aspect == "3:4")
		{
			height = width / 3 * 4;
		}
		else if(aspect == "16:9")
		{
			height = width / 16 * 9;
		}

		height = Math.round(height);
		jQuery('#nvfinder-cropit-height').val(height);
		jQuery('#image-cropper').cropit('previewSize', { width: width, height: height });
	}

	function nvfinder_cropit_height()
	{
		aspect 		= jQuery("#nvfinder-cropit-maintain-aspect-ratio").val();
		width 		= jQuery('#nvfinder-cropit-width').val();
		height 		= jQuery('#nvfinder-cropit-height').val();

		if(aspect == "1:1")
		{
			width = height;
		}
		else if(aspect == "4:3")
		{
			width = height / 3 * 4;
		}
		else if(aspect == "3:4")
		{
			width = height / 4 * 3;
		}
		else if(aspect == "16:9")
		{
			width = height / 9 * 16;
		}

		width = Math.round(width);
		jQuery('#nvfinder-cropit-width').val(width);
		jQuery('#image-cropper').cropit('previewSize', { width: width, height: height });
	}

	function nvfinder_cropit_upload_dialog(data, index, event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		cropit_index = index;
		cropit_type = "upload";
		file = {path: data};

		jQuery('#image-cropper').cropit('imageSrc', file.path);

		jQuery("#nvfinder-resize-dialog").dialog(
		{
			title: "Resize Image",
			width: jQuery(window).width() * 0.99,
			height: jQuery(window).height() * 0.99,
			modal: true,
			show: { effect: "fade", duration: 800 },
			hide: { effect: "fade", duration: 800 }
		});
	}

	function nvfinder_cropit_dialog(index)
	{
		cropit_index = index;
		cropit_type = "existing";
		file = nvfinder_display_files[index];

		jQuery('#image-cropper').cropit('imageSrc', file.path);

		jQuery("#nvfinder-resize-dialog").dialog(
		{
			title: "Resize Image",
			width: jQuery(window).width() * 0.99,
			height: jQuery(window).height() * 0.99,
			modal: true,
			show: { effect: "fade", duration: 800 },
			hide: { effect: "fade", duration: 800 }
		});
	}

	function nvfinder_cropit_save()
	{
		var data = "";

		if(cropit_type == "upload")
		{
			if(nvfinder_upload_files[cropit_index].name.match(/\.png/gi) != null)
			{
				data = jQuery('#image-cropper').cropit('export',
				{
					type: 'image/png',
					originalSize: false
				});
			}
			else if(nvfinder_upload_files[cropit_index].name.match(/\.jpe?g/gi) != null)
			{
				data = jQuery('#image-cropper').cropit('export',
				{
					type: 'image/jpeg',
					quality: 1,
					originalSize: false
				});
			}
		}
		else if(cropit_type == "existing")
		{
			if(nvfinder_display_files[cropit_index].path.match(/\.png/gi) != null)
			{
				data = jQuery('#image-cropper').cropit('export',
				{
					type: 'image/png',
					originalSize: false
				});
			}
			else if(nvfinder_display_files[cropit_index].path.match(/\.jpe?g/gi) != null)
			{
				data = jQuery('#image-cropper').cropit('export',
				{
					type: 'image/jpeg',
					quality: 1,
					originalSize: false
				});
			}
		}

		if(cropit_type == "upload")
		{
			// Pending upload, just replace the file's path property with new image data.
			nvfinder_upload_files[cropit_index].path = data;
			nvfinder_upload_files[cropit_index].highdpi = nvfinder_high_dpi;
			nvfinder_upload_files[cropit_index].cropped = true;
			nvfinder_show_uploads();

			cropit_index = null;
			cropit_type = null;

			nvfinder_cropit_close();
		}
		else if(cropit_type == "existing")
		{
			// Existing file to be cropped and saved to the server.
			jQuery.post(
				"/finder/crop",
				{
					filename: nvfinder_display_files[cropit_index].path,
					duplicate: (jQuery("#nvfinder-cropit-duplicate").prop("checked") ? 1 : 0),
					highdpi: (nvfinder_display_files[cropit_index].highdpi ? 1 : 0),
					image_data: data
				},
				function(data)
				{
					if(typeof data == "object")
			    	{
			    		nvfinder_filter(data);
			    	}

					cropit_index = null;
					cropit_type = null;

					nvfinder_cropit_close();
				}
			).fail(function(data)
		    {
				error("Error Cropping Image", data.responseText, true, null);
			});
		}
	}

	function nvfinder_cropit_close()
	{
		jQuery("#nvfinder-resize-dialog").dialog("close");
	}

	function nvfinder_remove_upload(index, event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		nvfinder_upload_files.splice(index, 1);

		nvfinder_show_uploads();
	}

	function nvfinder_edit_document(index)
	{
		if(index !== false)
		{
			file = nvfinder_display_files[index];
			document_edit_index = index;

			jQuery("#nvfinder-document-dialog #document_id").val(file.document_id);
			jQuery("#nvfinder-document-dialog #title").val(file.title);
			jQuery("#nvfinder-document-dialog #url").val(file.url);
			jQuery("#nvfinder-document-dialog #url_preview").html(file.url);
			jQuery("#nvfinder-document-dialog #category_id").val((file.category_id ? file.category_id : "0"));
			jQuery("#nvfinder-document-dialog #published").prop("checked", (file.published ? true : false));

			html = '';

			for(i=0; i<file.acl.length; i++)
			{
				html += '<div class="<?php echo(FORM_ROW); ?>">';
				html += '<label for="acl_' + file.acl[i].acl_role_id + 'n" class="col-12 col-md-5 col-lg-4">' + file.acl[i].role + '</label>';
				html += '<div class="col-12 col-md-7 col-lg-8">'
				if(file.acl[i].acl_role_id == 3)
				{
					html += '<input type="radio" name="acl_' + file.acl[i].acl_role_id + '" id="acl_' + file.acl[i].acl_role_id + 'rw" value="rw" checked /> <label for="acl_' + file.acl[i].acl_role_id + 'rw" class="inline">Read / Write</label>';
				}
				else
				{
					html += '<input type="radio" name="acl_' + file.acl[i].acl_role_id + '" id="acl_' + file.acl[i].acl_role_id + 'n" value="" ' + (file.acl[i].read != "1" && file.acl[i].write != "1" ? "checked" : "") + ' /> <label for="acl_' + file.acl[i].acl_role_id + 'n" class="inline">None</label>';
					html += '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" name="acl_' + file.acl[i].acl_role_id + '" id="acl_' + file.acl[i].acl_role_id + 'r" value="r" ' + (file.acl[i].read == "1" && file.acl[i].write != "1" ? "checked" : "") + ' /> <label for="acl_' + file.acl[i].acl_role_id + 'r" class="inline">Read Only</label>';

					if(file.acl[i].acl_role_id > 1)
					{
						html += '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" name="acl_' + file.acl[i].acl_role_id + '" id="acl_' + file.acl[i].acl_role_id + 'rw" value="rw" ' + (file.acl[i].read == "1" && file.acl[i].write == "1" ? "checked" : "") + ' /> <label for="acl_' + file.acl[i].acl_role_id + 'rw" class="inline">Read / Write</label>';
					}
				}

				html += '</div></div>';
			}

			jQuery("#nvfinder-document-dialog #acl").html(html);
		}
		else
		{
			if(acl_roles.length == 0)
			{
				jQuery.ajax(
				{
					url: "/ajax/get_roles_array",
					type: "POST",
					processData: true,
					contentType: "application/x-www-form-urlencoded",
					success: function(data, textStatus, jqXHR)
					{
						acl_roles = data;
						nvfinder_new_document();
			        },
					error: function(jqXHR, textStatus, errorThrown)
					{
						error("Error Getting ACL Roles", jqXHR.responseText, true, null);
					}
				});
			}
			else
			{
				nvfinder_new_document();
			}
		}

		jQuery("#nvfinder-document-dialog").dialog(
		{
			title: "Edit Document",
			width: jQuery(window).width() * 0.99,
			height: jQuery(window).height() * 0.99,
			modal: true,
			show: { effect: "fade", duration: 800 },
			hide: { effect: "fade", duration: 800 }
		});

		setTimeout(function() { initWYSIWYG(); }, 1000);

		var select = document.getElementById("filename");
		select.options = [];
		select.options[0] = new Option("N/A", "0");

		for(i=0; i<nvfinder_display_files.length; i++)
		{
			select.options[(i+1)] = new Option(nvfinder_display_files[i].title, nvfinder_display_files[i].path);
		}

		if(index !== false)
		{
			jQuery("#nvfinder-document-dialog #filename").val(file.path);
		}
	}

	function nvfinder_new_document()
	{
		jQuery("#nvfinder-document-dialog #document_id").val(0);
		jQuery("#nvfinder-document-dialog #title").val("");
		jQuery("#nvfinder-document-dialog #url").val("");
		jQuery("#nvfinder-document-dialog #url_preview").html("");
		jQuery("#nvfinder-document-dialog #category_id").val(0);
		jQuery("#nvfinder-document-dialog #published").prop("checked", true);

		html = '';

		for(i=0; i<acl_roles.length; i++)
		{
			html += '<div class="row">';
			html += '<label for="acl_' + acl_roles[i].acl_role_id + 'n" class="col-12 col-md-5 col-lg-4">' + acl_roles[i].role + '</label>';
			html += '<div class="col-12 col-md-7 col-lg-8">';

			if(acl_roles[i].acl_role_id == 3)
			{
				html += '<input type="radio" name="acl_' + acl_roles[i].acl_role_id + '" id="acl_' + acl_roles[i].acl_role_id + 'rw" value="rw" checked /> <label for="acl_' + acl_roles[i].acl_role_id + 'rw" class="inline">Read / Write</label>';
			}
			else
			{
				html += '<input type="radio" name="acl_' + acl_roles[i].acl_role_id + '" id="acl_' + acl_roles[i].acl_role_id + 'n" value="" /> <label for="acl_' + acl_roles[i].acl_role_id + 'n" class="inline">None</label>';
				html += '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" name="acl_' + acl_roles[i].acl_role_id + '" id="acl_' + acl_roles[i].acl_role_id + 'r" value="r" checked /> <label for="acl_' + acl_roles[i].acl_role_id + 'r" class="inline">Read Only</label>';

				if(acl_roles[i].acl_role_id > 1)
				{
					html += '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="radio" name="acl_' + acl_roles[i].acl_role_id + '" id="acl_' + acl_roles[i].acl_role_id + 'rw" value="rw" /> <label for="acl_' + acl_roles[i].acl_role_id + 'rw" class="inline">Read / Write</label>';
				}
			}

			html += '</div></div>';
		}

		jQuery("#nvfinder-document-dialog #acl").html(html);
	}

	function nvfinder_document_save()
	{
		jQuery("#nvfinder_document_spinner").removeClass("fa-save").addClass("fa-spinner fa-spin");
		jQuery("#nvfinder_document_progress").removeClass("d-none");

		var formData = new FormData();

		try
		{
			formData.append("upload_file", document.getElementById("upload_file").files[0]);
		}
		catch(e){}

		formData.append("document_id", jQuery("#nvfinder-document-dialog #document_id").val());
    	formData.append("site_id", jQuery("#nvfinder-document-dialog #site_id").val());
    	formData.append("title", jQuery("#nvfinder-document-dialog #title").val());
    	formData.append("url", jQuery("#nvfinder-document-dialog #url").val());
    	formData.append("category_id", jQuery("#nvfinder-document-dialog #category_id option:selected").val());
    	formData.append("published", jQuery("#nvfinder-document-dialog #published").val());
    	formData.append("overwrite", jQuery("#nvfinder-document-dialog #overwrite").val());
    	formData.append("filename", jQuery("#nvfinder-document-dialog #filename").val());

    	jQuery("#nvfinder-document-dialog #acl input[type='radio']:checked").each(function()
    	{
    		formData.append(jQuery(this).attr("name"), jQuery(this).val());
    	});

		jQuery.ajax(
		{
			url: "/admin/document_save/1",
			type: "POST",
			data: formData,
			processData: false,
			contentType: false,
			xhr: function()
			{
				// Custom XMLHttpRequest
	            var myXhr = jQuery.ajaxSettings.xhr();

	            if(myXhr.upload)
	            {
	            	myXhr.upload.addEventListener('progress', function(e)
					{
						if(e.lengthComputable)
						{
							jQuery("#nvfinder_document_progress").attr({value:e.loaded, max:e.total});
						}
	                }, false);
	            }
	            return myXhr;
	        },
	        success: function(data, textStatus, jqXHR)
			{
				jQuery("#nvfinder-document-dialog #document_id").val("");
				jQuery("#nvfinder-document-dialog #title").val("");
				jQuery("#nvfinder-document-dialog #url").val("");
				jQuery("#nvfinder-document-dialog #url_preview").html("");
				jQuery("#nvfinder-document-dialog #category_id").val("0");
				jQuery("#nvfinder-document-dialog #acl").html("");
				jQuery("#nvfinder-document-dialog #published").prop("checked", true);
				jQuery("#nvfinder-document-dialog #overwrite").prop("checked", false);
				jQuery("#nvfinder-document-dialog #upload_file").val();
				jQuery("#nvfinder_document_progress").addClass("d-none");

	        	nvfinder_filter(nvfinder_cwd, null);
	        	nvfinder_document_close();
	        },
			error: function(jqXHR, textStatus, errorThrown)
			{
				jQuery("#nvfinder_document_progress").addClass("d-none");
				error("Error Saving Document", jqXHR.responseText, true, null);
			}
		});
	}

	function nvfinder_document_close()
	{
		document_edit_index = false;
		jQuery("#nvfinder-document-dialog #document_id").val("");
		jQuery("#nvfinder-document-dialog #title").val("");
		jQuery("#nvfinder-document-dialog #url").val("");
		jQuery("#nvfinder-document-dialog #url_preview").html("");
		jQuery("#nvfinder-document-dialog #category_id").val("0");
		jQuery("#nvfinder-document-dialog #acl").html("");
		jQuery("#nvfinder-document-dialog #published").prop("checked", true);
		jQuery("#nvfinder-document-dialog #overwrite").prop("checked", false);
		jQuery("#nvfinder-document-dialog #upload_file").val();
		jQuery("#nvfinder-document-dialog").dialog("close");
		jQuery("#nvfinder_document_spinner").removeClass("fa-spinner fa-spin").addClass("fa-save");
	}

	function nvfinder_duplicate_file(index, event)
	{
		try
		{
			event.preventDefault();
		}
		catch(e){}

		try
		{
			event.stopPropagation();
		}
		catch(e)
		{}

		file = nvfinder_display_files[index];

		jQuery.post
	    (
	        "/finder/duplicate",
	        {
	        	path: file.path
	        },
	        function(data)
	        {
	        	if(typeof data == "object")
		    	{
		    		nvfinder_filter(data);
		    	}
	        }
	    ).fail(function(data)
	    {
			error("Error Duplicating File", data.responseText, true, null);
		});
	}

	function nvfinder_upload_dialog()
	{
		jQuery("#nvfinder-upload-dialog").dialog(
		{
			title: "Upload Files",
			width: jQuery(window).width() * 0.99,
			height: jQuery(window).height() * 0.99,
			modal: true,
			show: { effect: "fade", duration: 800 },
			hide: { effect: "fade", duration: 800 }
		});
	}

	function nvfinder_upload_save()
	{
		upload_progress = 0;
		upload_total 	= 0;
		size_known 		= true;

		w 			= jQuery("#nvfinder-cropit-width").val();
		h 			= jQuery("#nvfinder-cropit-height").val();
		all_cropped = true;

		if(nvfinder_force_crop)
		{
			for(i=0; i<nvfinder_upload_files.length; i++)
			{
				all_cropped = all_cropped && nvfinder_upload_files[i].cropped;
			}

			if(!all_cropped)
			{
				error("Cropping Required", "The current directory requires images that are " + w + "x" + h + ". You have at least one image that hasn't been cropped yet.");
				return;
			}
		}

		jQuery("#nvfinder_upload_progress").attr({value:0, max:upload_total});
		jQuery("#nvfinder_upload_progress").removeClass("d-none");

		for(i=0; i<nvfinder_upload_files.length; i++)
		{
			jQuery.ajax(
			{
				url: "/finder/upload",
				type: "POST",
				data:
				{
					file: nvfinder_upload_files[i].path,
					highdpi: (nvfinder_upload_files[i].highdpi ? 1 : 0),
					filename: nvfinder_upload_files[i].name,
					cwd: nvfinder_cwd
				},
				processData: true,
				contentType: "application/x-www-form-urlencoded",
				xhr: function()
				{
					// Custom XMLHttpRequest
		            var myXhr = jQuery.ajaxSettings.xhr();

		            if(myXhr.upload)
		            {
		            	// We need to get the POST size from here rather than the file API because the total POST is slightly larger.
		                myXhr.upload.addEventListener('loadstart', function(e)
						{
							if(e.total > 0)
							{
								upload_total += e.total;
								size_known = true;
								jQuery("#nvfinder_upload_progress").attr({max:upload_total});
							}
							else
							{
								size_known = false;
							}
						}, false);

		                myXhr.upload.addEventListener('progress', function(e)
						{
							if(e.lengthComputable)
							{
								if(!size_known)
								{
									upload_total += e.total;
									size_known = true;
									jQuery("#nvfinder_upload_progress").attr({max:upload_total});
								}

								jQuery("#nvfinder_upload_progress").attr("value", (upload_progress + e.loaded));

								if(e.loaded == e.total)
								{
									upload_progress += e.total;
								}
						    }
		                }, false);
		            }
		            return myXhr;
		        },
				success: function(data, textStatus, jqXHR)
				{
					if(upload_progress >= upload_total)
					{
						jQuery("#nvfinder_upload_progress").addClass("d-none");
					    nvfinder_upload_close();

					    if(typeof data == "object")
				    	{
				    		nvfinder_filter(data);
				    	}
			        }
		        },
				error: function(jqXHR, textStatus, errorThrown)
				{
					jQuery("#nvfinder_upload_progress").addClass("d-none");
					error("Error Uploading File", jqXHR.responseText, true, null);
				}
			});
		}
	}

	function nvfinder_upload_close()
	{
		jQuery("#nvfinder-upload-dialog").dialog("close");
		nvfinder_upload_files = [];
		jQuery("#nvfinder_upload_preview").html("");
	}

	function nvfinder_FileMoveStart(index, e)
	{
		// try
		// {
		// 	e.preventDefault();
		// }
		// catch(e){}

		// try
		// {
		// 	e.stopPropagation();
		// }
		// catch(e)
		// {}


		e.dataTransfer.effectAllowed = 'move';
	    e.dataTransfer.setData('text/plain', index);

	    // Add a custom drag image when we're dragging an image file.
	 //    if(nvfinder_display_files[index].path.match(/\.(jpe?g|png|gif|webp)/gi) != null)
		// {
		// 	img = new Image();
		// 	img.src = nvfinder_display_files[index].path;
		// 	e.dataTransfer.setDragImage(img, 0, 0);
		// }
	}

	function nvfinder_DirDragHover(e)
	{
		try
		{
			e.preventDefault();
		}
		catch(e){}

		// try
		// {
		// 	e.stopPropagation();
		// }
		// catch(e)
		// {}

		e.dataTransfer.dropEffect = 'move';

		jQuery("#" + e.target.id).siblings("em.fa-folder").removeClass("fa-folder").addClass("fa-folder-o-temp").addClass("fa-folder-open");
		jQuery("#" + e.target.id).siblings("em.fa-folder-open").removeClass("fa-folder-open").addClass("fa-folder-open-temp").addClass("fa-folder-open");
	}

	function nvfinder_DirDragUnhover(e)
	{
		try
		{
			e.preventDefault();
		}
		catch(e){}

		// try
		// {
		// 	e.stopPropagation();
		// }
		// catch(e)
		// {}

		jQuery(".nvfinder-directories em.fa-folder-o-temp").removeClass("fa-folder-o-temp").removeClass("fa-folder-open").addClass("fa-folder");
		jQuery(".nvfinder-directories em.fa-folder-open-temp").removeClass("fa-folder-open-temp").removeClass("fa-folder-open").addClass("fa-folder-open");
	}

	function nvfinder_FileMoveHandler(e)
	{
		index 		= Number(e.dataTransfer.getData('text/plain'));
		lastslash 	= nvfinder_display_files[index].path.lastIndexOf("/");
		qmark 		= nvfinder_display_files[index].path.indexOf("?");

		if(lastslash == -1)
		{
			if(qmark == -1)
			{
				filename = nvfinder_display_files[index].path;
			}
			else
			{
				filename = nvfinder_display_files[index].path.substring(0, qmark);
			}

			from = filename;
		}
		else
		{
			if(qmark == -1)
			{
				filename = nvfinder_display_files[index].path.substring(lastslash+1);
				from = nvfinder_display_files[index].path
			}
			else
			{
				filename = nvfinder_display_files[index].path.substring(lastslash+1, qmark);
				from = nvfinder_display_files[index].path.substring(0, qmark);
			}
		}

		to = jQuery("#" + e.target.id).attr("data-cwd") + "/" + filename;

		jQuery.post(
			"/finder/move",
			{
				oldpath: from,
				newpath: to
			},
			function(data)
			{
				if(typeof data == "object")
		    	{
		    		nvfinder_filter(data);
		    	}
			}
		).fail(function(data)
	    {
			error("Error Moving File", data.responseText, true, null);
		});

		nvfinder_DirDragUnhover(e);
		e.dataTransfer.clearData();
	}

	function nvfinder_FileDragHover(e)
	{
		try
		{
			e.preventDefault();
		}
		catch(e){}

		try
		{
			e.stopPropagation();
		}
		catch(e)
		{}

		// Don't do fancy effects on the file input box.
		if(e.target.type == "file")
		{
			return;
		}

		e.target.className = (e.type == "dragover" ? "dropzone hover" : "dropzone");
	}

	function nvfinder_FileSelectHandler(e)
	{
		nvfinder_file_count 	= 0;
		nvfinder_file_total 	= 0;

		// cancel event and hover styling
		nvfinder_FileDragHover(e);

		// jQuery("#nvfinder_upload_preview").html("");
		jQuery("#nvfinder_upload_spinner").addClass("fa-spin").fadeIn(100);

		// fetch FileList object
		var files = e.target.files || e.dataTransfer.files;
		nvfinder_file_total = files.length;

		// process all File objects
		for(var i=0, f; f=files[i]; i++)
		{
			nvfinder_ParseFile(f);
		}
	}

	function nvfinder_ParseFile(file)
	{
		var oFReader1 = new FileReader();
		oFReader1.readAsDataURL(file);

		oFReader1.onload = function(oFREvent)
	    {
	    	file.path = oFREvent.target.result;
	    	file.highdpi = false;
	    	file.cropped = false;
	    	nvfinder_upload_files[nvfinder_file_count] = file;

	    	nvfinder_file_count++;

	    	if(nvfinder_file_count == nvfinder_file_total)
	    	{
	    		jQuery("#nvfinder_upload_spinner").removeClass("fa-spin").fadeOut(100);
	    		jQuery("#newfile").val("");

	    		nvfinder_show_uploads();
	    	}
	    };
	}

	function nvfinder_show_uploads()
	{
		jQuery("#nvfinder_upload_preview").html("");

		for(x=0; x<nvfinder_upload_files.length; x++)
		{
			file = nvfinder_upload_files[x];

			i = document.createElement("div");
			i.setAttribute("class", "center");

			if(file.name.match(/\.(jpe?g|png|gif|webp)/gi) != null)
			{
				i.innerHTML = '<img src="' + file.path + '" /><br>' + file.name + '<br><a href="#" onclick="nvfinder_cropit_upload_dialog(\'' + file.path + '\', ' + x + ', event)"><em class="fas fa-fw fa-crop" aria-hidden="true"></em></a>';
			}
			else if(file.name.match(/\.pdf?/gi) != null)
			{
				i.innerHTML = '<em class="far fa-fw fa-file-pdf fa-3x" aria-hidden="true"></em><br>' + file.name;
			}
			else if(file.name.match(/\.(html|php|js|css)/gi) != null)
			{
				i.innerHTML = '<em class="far fa-fw fa-file-code fa-3x" aria-hidden="true"></em><br>' + file.name;
			}
			else if(file.name.match(/\.(txt|log|md)/gi) != null)
			{
				i.innerHTML = '<em class="far fa-fw fa-file-alt fa-3x" aria-hidden="true"></em><br>' + file.name;
			}
			else if(file.name.match(/\.(mp3|wav|ogg)/gi) != null)
			{
				i.innerHTML = '<audio controls="controls" width="100%"><source src="' + file.path + '" /><em class="far fa-fw fa-file-audio fa-3x" aria-hidden="true"></em></audio><br>' + file.name;
			}
			else if(file.name.match(/\.(mp4|wmv|mov|ogv|webm)/gi) != null)
			{
				i.innerHTML = '<video volume="0.5" controls="controls" width="100%"><source src="' + file.path + '" /><em class="far fa-fw fa-file-video fa-3x" aria-hidden="true"></em></video><br>' + file.name;
			}
			else if(file.name.match(/\.(zip|gz|7z|tar|rar)/gi) != null)
			{
				i.innerHTML = '<em class="far fa-fw fa-file-archive fa-3x" aria-hidden="true"></em><br>' + file.name;
			}
			else if(file.name.match(/\.docx?/gi) != null)
			{
				i.innerHTML = '<em class="far fa-fw fa-file-word fa-3x" aria-hidden="true"></em><br>' + file.name;
			}
			else if(file.name.match(/\.xlsx?/gi) != null)
			{
				i.innerHTML = '<em class="far fa-fw fa-file-excel fa-3x" aria-hidden="true"></em><br>' + file.name;
			}
			else if(file.name.match(/\.pptx??/gi) != null)
			{
				i.innerHTML = '<em class="far fa-fw fa-file-powerpoint fa-3x" aria-hidden="true"></em><br>' + file.name;
			}
			else
			{
				i.innerHTML = '<em class="far fa-fw fa-file fa-3x" aria-hidden="true"></em><br>' + file.name;
			}

			i.innerHTML = i.innerHTML + '<a href="#" onclick="nvfinder_remove_upload(' + x + ', event)"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';

	    	div = document.createElement("div");
	    	div.setAttribute("class", "col-12 col-sm-6 col-md-4 col-lg-3 col-xl-1")

	    	div2 = document.createElement("div");

	    	div.appendChild(div2);
	    	div2.appendChild(i);
	    	document.getElementById("nvfinder_upload_preview").appendChild(div);
	    }
	}

	function nvfinder_metadata_dialog(index)
	{
		cropit_index = index;
		file = nvfinder_display_files[index];

		jQuery.post(
			"/finder/metadata",
			{
				filename: nvfinder_display_files[cropit_index].path
			},
			function(data)
			{
				jQuery("#nvfinder-metadata-alt").val(data.alt);
				jQuery("#nvfinder-metadata-title").val(data.title);
				jQuery("#nvfinder-metadata-description").val(data.description);
			}
		);

		jQuery("#nvfinder-metadata-dialog").dialog(
		{
			title: "Image Metadata",
			maxWidth: jQuery(window).width() * 0.99,
			maxHeight: jQuery(window).height() * 0.99,
			width: 600,
			height: 400,
			modal: true,
			show: { effect: "fade", duration: 800 },
			hide: { effect: "fade", duration: 800 }
		});
	}

	function nvfinder_metadata_save()
	{
		jQuery.post(
			"/finder/metadata_save",
			{
				filename: nvfinder_display_files[cropit_index].path,
				alt: jQuery("#nvfinder-metadata-alt").val(),
				title: jQuery("#nvfinder-metadata-title").val(),
				description: jQuery("#nvfinder-metadata-description").val()
			},
			function(data)
			{
				cropit_index = null;
				cropit_type = null;

				nvfinder_metadata_close();
			}
		).fail(function(data)
	    {
			error("Error Saving Image Metadata", data.responseText, true, null);
		});
	}

	function nvfinder_metadata_close()
	{
		jQuery("#nvfinder-metadata-dialog").dialog("close");
	}
// })();
