<?php
defined('PRODUCT_NAME') or die;
class CalendarModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();
		$this->scripts                    = array("<script async src=\"modules/calendar/fullcalendar.js\"></script>");
		$this->enable_jquery 	          = true;
		$this->enable_jquery_ui           = true;
		$this->cache_config->query_string = true;
	}

	function render()
	{
		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module calendar-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}
			?>
			<script>
				function pad(number, length)
				{
				    var str = '' + number;
				    while (str.length < length) {
				        str = '0' + str;
				    }

				    return str;
				}

				function openDialog_<?php echo $this->module_instance_id?>(event)
				{
					var start 		= jQuery.fullCalendar.formatDate(event.start, "dddd, MMMM dS, yyyy");
					var end 		= jQuery.fullCalendar.formatDate(event.end, "dddd, MMMM dS, yyyy");
					var time_start 	= jQuery.fullCalendar.formatDate(event.start, "h:mm tt");
					var time_end 	= jQuery.fullCalendar.formatDate(event.end, "h:mm tt");

					if(start == end)
					{
						date_string = start;
					}
					else
					{
						date_string = start + " to " + end;
					}

					if(event.allDay == 'true')
					{
						date_string += " (all day)";
					}
					else if(time_start == time_end || time_end == "" || time_end == "undefined")
					{
						date_string += " at " + time_start;
					}
					else
					{
						date_string += " from " + time_start + " to " + time_end;
					}

					jQuery("#calendar_<?php echo $this->module_instance_id?>_event_title").html(event.title);
					jQuery("#calendar_<?php echo $this->module_instance_id?>_event_date").html(date_string);
					jQuery("#calendar_<?php echo $this->module_instance_id?>_event_description").html(event.description);

					jQuery("#calendar-details-dialog_<?php echo $this->module_instance_id?>").dialog(
		            {
						dialogClass: "calendar-details-dialog",
						title: "Event Details",
						width: jQuery(window).width()*0.9,
						height: jQuery(window).height()*0.9,
						modal: true,
						buttons:
						[
						    {
						    	text: "Close",
						    	click: function()
						    	{
						        	jQuery(this).dialog("close");
						        }
						    }
					    ]
					});
				}

				jQuery(window).on("load", function()
				{
					var date = new Date();
					var d = date.getDate();
					var m = date.getMonth();
					var y = date.getFullYear();
					var months = Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");

					jQuery('#calendar_<?php echo $this->module_instance_id?>').fullCalendar({
						editable: false,
						disableDragging: true,
						header: { left: 'prev,next', center: 'title', right:  'prev,next' },
						allDaySlot: true,
						axisFormat:'h:mm tt',
						weekends: true,
						timeFormat: { 'agenda': 'h:mm tt', '': 'h:mm tt' },
						dayClick: function(date, allDay, jsEvent, view)
						{
					    },
					    eventClick: function(calEvent, jsEvent, view)
					    {
						    openDialog_<?php echo $this->module_instance_id?>(calEvent);

					        return;
					    },
					    eventRender: function(event, element)
					    {

					    },
						events: function(start, end, callback)
						{
							var events = [];

					        jQuery.ajax({
					            url: '<?php echo LIVE_SITE?>/ajax/get_events_for_module',
					            dataType: 'xml',
					            data: {
									start: start,
					                end: end
					            },
					            success: function(doc) {
					            	var events = [];
					                jQuery(doc).find('event').each(function()
					                {
					                	events.push({
					                        title: jQuery(this).attr('title'),
					                        description: jQuery(this).attr('description'),
					                        start: jQuery(this).attr('start'),
					                        end: jQuery(this).attr('end'),
					                        allDay: (jQuery(this).attr('allDay') == "true" ? true : false),
					                        editable: false
					                    });
					                });
					                callback(events);
					            }
					        });
					    }
					});
				});
			</script>

			<div id="calendar_<?php echo $this->module_instance_id?>"></div>

			<div id="calendar-details-dialog_<?php echo $this->module_instance_id?>" class="calendar-details-dialog" style="display: none;">
				<div id="calendar_<?php echo $this->module_instance_id?>_event_title" class="calendar-event-title"></div>
				<div id="calendar_<?php echo $this->module_instance_id?>_event_date" class="calendar-event-date"></div>
				<div id="calendar_<?php echo $this->module_instance_id?>_event_description" class="calendar-event-description"></div>
			</div>
		</div>
		<?php
	}
}
