<?php
defined('PRODUCT_NAME') or die;
class ContentSliderModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();
		$this->scripts = array("<script async src=\"modules/content_slider/jquery.bxslider.min.js\"></script>",
								"<script async src=\"modules/content_slider/plugins/jquery.easing.1.3.js\"></script>",
								"<script async src=\"modules/content_slider/plugins/jquery.fitvids.js\"></script>",
								);

		$this->enable_jquery      = true;
		$this->cache_config->user = true;
	}

	function render()
	{
		$this->load->model(array("page", "content_type"));

		$category_id		= $this->setting("category_id");
		$content_type_id	= $this->setting("content_type_id");
		$tag_ids			= $this->setting("tag_ids", null);
		$tag_logic			= $this->setting("tag_logic", "OR");
		$num_articles		= $this->setting("num_articles");
		$ordering 			= $this->setting("ordering");
		$orderby 			= "`created` DESC";

		if($ordering == "newest_created")
		{
			$orderby = "`created` DESC";
		}
		else if($ordering == "oldest_created")
		{
			$orderby = "`created` ASC";
		}
		else if($ordering == "newest_modified")
		{
			$orderby = "`modified` DESC";
		}
		else if($ordering == "oldest_modified")
		{
			$orderby = "`modified` ASC";
		}
		else if($ordering == "alpha")
		{
			$orderby = "`title` ASC";
		}
		else if($ordering == "random")
		{
			$orderby = "RAND()";
		}

		$pages = $this->page->LoadByCategoryContentTypeTagID(Mainframe::site()->site_id, $category_id, $content_type_id, $tag_ids, $tag_logic, $orderby, "", Mainframe::user(), 0);

		if($num_articles > 0)
		{
			$pages = array_splice($pages, 0, $num_articles);
		}

		$final_pages = array();

		foreach($pages as $p)
		{
			$fp = new Page();
			$fp->populate($p);

			$final_pages[] = $fp;
		}

		$data = array("module_instance_id" 			=> $this->module_instance_id,
					  "title" 						=> $this->setting("title"),
					  "title_heading_level" 		=> $this->setting("title_heading_level"),
		              "module_class" 				=> $this->setting("module_class"),
					  "category_id" 				=> $category_id,
					  "content_type_id" 			=> $content_type_id,
					  "num_articles" 				=> $num_articles,
					  "character_limit" 			=> $this->setting("character_limit"),
					  "read_more_text" 				=> $this->setting("read_more_text"),
					  "image_alignment" 			=> $this->setting("image_alignment"),
					  "image_width" 				=> $this->setting("image_width"),
					  "image_height" 				=> $this->setting("image_height"),
					  "show_text" 					=> $this->setting("show_text"),
					  "show_title" 					=> $this->setting("show_title"),
					  "show_date" 					=> $this->setting("show_date"),
					  "link_first_heading" 			=> $this->setting("link_first_heading"),
					  "link_first_image" 			=> $this->setting("link_first_image"),
					  "heading_level" 				=> $this->setting("heading_level"),
					  "always_show_readmore" 		=> $this->setting("always_show_readmore"),
					  "strip_tags" 					=> $this->setting("strip_tags"),
					  "ordering" 					=> $ordering,
					  "config_mode" 				=> $this->setting("mode"),
					  "config_speed" 				=> $this->setting("speed"),
					  "config_slideMargin" 			=> $this->setting("slideMargin"),
					  "config_startSlide" 			=> $this->setting("startSlide"),
					  "config_randomStart" 			=> $this->setting("randomStart"),
					  "config_slideSelector" 		=> $this->setting("slideSelector"),
					  "config_infiniteLoop" 		=> $this->setting("infiniteLoop"),
					  "config_hideControlOnEnd" 	=> $this->setting("hideControlOnEnd"),
					  "config_easing" 				=> $this->setting("easing"),
					  "config_captions" 			=> $this->setting("captions"),
					  "config_ticker" 				=> $this->setting("ticker"),
					  "config_tickerHover" 			=> $this->setting("tickerHover"),
					  "config_adaptiveHeight" 		=> $this->setting("adaptiveHeight"),
					  "config_adaptiveHeightSpeed" 	=> $this->setting("adaptiveHeightSpeed"),
					  "config_video" 				=> $this->setting("video"),
					  "config_responsive" 			=> $this->setting("responsive"),
					  "config_useCSS" 				=> $this->setting("useCSS"),
					  "config_preloadImages" 		=> $this->setting("preloadImages"),
					  "config_touchEnabled" 		=> $this->setting("touchEnabled"),
					  "config_swipeThreshold" 		=> $this->setting("swipeThreshold"),
					  "config_oneToOneTouch" 		=> $this->setting("oneToOneTouch"),
					  "config_preventDefaultSwipeX" => $this->setting("preventDefaultSwipeX"),
					  "config_preventDefaultSwipeY" => $this->setting("preventDefaultSwipeY"),
					  "config_pager" 				=> $this->setting("pager"),
					  "config_pagerType" 			=> $this->setting("pagerType"),
					  "config_pagerShortSeparator" 	=> $this->setting("pagerShortSeparator"),
					  "config_pagerSelector" 		=> $this->setting("pagerSelector"),
					  "config_pagerCustom" 			=> $this->setting("pagerCustom"),
					  "config_buildPager" 			=> $this->setting("buildPager"),
					  "config_controls" 			=> $this->setting("controls"),
					  "config_nextText" 			=> $this->setting("nextText"),
					  "config_prevText" 			=> $this->setting("prevText"),
					  "config_nextSelector" 		=> $this->setting("nextSelector"),
					  "config_prevSelector" 		=> $this->setting("prevSelector"),
					  "config_autoControls" 		=> $this->setting("autoControls"),
					  "config_startText" 			=> $this->setting("startText"),
					  "config_stopText" 			=> $this->setting("stopText"),
					  "config_autoControlsCombine" 	=> $this->setting("autoControlsCombine"),
					  "config_autoControlsSelector" => $this->setting("autoControlsSelector"),
					  "config_auto" 				=> $this->setting("auto"),
					  "config_pause" 				=> $this->setting("pause"),
					  "config_autoStart" 			=> $this->setting("autoStart"),
					  "config_autoDirection" 		=> $this->setting("autoDirection"),
					  "config_autoHover" 			=> $this->setting("autoHover"),
					  "config_autoDelay" 			=> $this->setting("autoDelay"),
					  "config_minSlides" 			=> $this->setting("minSlides"),
					  "config_maxSlides" 			=> $this->setting("maxSlides"),
					  "config_moveSlides" 			=> $this->setting("moveSlides"),
					  "config_slideWidth" 			=> $this->setting("slideWidth"),
					  "config_slideHeight" 			=> $this->setting("slideHeight"),
					  "pages" 						=> $final_pages);

		$this->load->view("modules/content_slider/module", $data);
	}
}
