<?php
defined('PRODUCT_NAME') or die;
class GoogleCalendarModule extends ModuleInstance
{
	public function render()
	{
		$mode          = $this->setting("mode");
		$showTitle     = $this->setting("showTitle");
		$showNav       = $this->setting("showNav");
		$showDate      = $this->setting("showDate");
		$showPrint     = $this->setting("showPrint");
		$showTabs      = $this->setting("showTabs");
		$showCalendars = $this->setting("showCalendars");
		$showTz        = $this->setting("showTz");
		$width         = $this->setting("width");
		$height        = $this->setting("height");
		$wkst          = $this->setting("wkst");
		$color         = $this->setting("color");
		$bgcolor       = $this->setting("bgcolor");
		$src           = $this->setting("src");
		$ctz           = $this->setting("ctz");

		$url = "https://calendar.google.com/calendar/embed";
		$url .= "?mode=" . 				$mode;
		$url .= "&amp;showTitle=" . 	($showTitle ? 1 : 0);
		$url .= "&amp;showNav=" . 		($showNav ? 1 : 0);
		$url .= "&amp;showDate=" . 		($showDate ? 1 : 0);
		$url .= "&amp;showPrint=" . 	($showPrint ? 1 : 0);
		$url .= "&amp;showTabs=" . 		($showTabs ? 1 : 0);
		$url .= "&amp;showCalendars=" . ($showCalendars ? 1 : 0);
		$url .= "&amp;showTz=" . 		($showTz ? 1 : 0);
		$url .= "&amp;height=" . 		$height;
		$url .= "&amp;wkst=" . 			$wkst;
		$url .= "&amp;bgcolor=" . 		urlencode($bgcolor);
		$url .= "&amp;src=" . 			urlencode($src);
		$url .= "&amp;color=" . 		urlencode($color);
		$url .= "&amp;ctz=" . 			urlencode($ctz);

		$data = array("module_instance_id" 	=> $this->module_instance_id,
					  "title" 				=> $this->setting("title"),
					  "title_heading_level"	=> $this->setting("title_heading_level"),
		              "module_class" 		=> $this->setting("module_class"),
		              "url" 				=> $url,
		              "width" 				=> ($width ? $width : "100%"),
		              "height" 				=> $height);

		$this->load->view("modules/gcal/module", $data);
	}
}
