<?php
defined('PRODUCT_NAME') or die;
class ImageDiffModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->scripts = array('<script src="/modules/image_diff/jquery.event.move.js" type="text/javascript"></script>',
							   '<script src="/modules/image_diff/jquery.twentytwenty.js" type="text/javascript"></script>',
							   '<link rel="stylesheet" href="/modules/image_diff/twentytwenty.css" type="text/css" media="screen" />');

		$this->enable_jquery = true;
		$this->cache_config->enabled = false;
	}

	function render($files = null)
	{
		$this->load->view("modules/image_diff/module",
								array("module_instance_id" => $this->module_instance_id,
									  "module_class" => $this->setting("module_class"),
									  "image1" => $this->setting("image1"),
									  "image2" => $this->setting("image2"),
									  "default_offset_pct" => $this->setting("default_offset_pct") / 100,
									  "orientation" => $this->setting("orientation"),
									  "before_label" => $this->setting("before_label"),
									  "after_label" => $this->setting("after_label"),
									  "no_overlay" => $this->setting("no_overlay"),
									  "move_slider_on_hover" => $this->setting("move_slider_on_hover"),
									  "move_with_handle_only" => $this->setting("move_with_handle_only"),
									  "click_to_move" => $this->setting("click_to_move"),
		                  		));
	}
}
