<?php
defined('PRODUCT_NAME') or die;
class LoginModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->cache_config->enabled = false;
	}

	function render()
	{
		$i = 0;
		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$login_redirect			= $this->setting("login_redirect");
		$logout_redirect		= $this->setting("logout_redirect");

		$this->load->model(array("user", "page"));
		$this->load->helper(array("url", "functions", "password"));

		$message = "";

		if($this->input->get_post("task") == "pwreset")
		{
			csrf_verify();
			$email = $this->input->get_post("email");

			$user = new User();
			$user->LoadByEmail($email);

			if(isset($user->user_id) && $user->user_id > 0)
			{
				$new_password = generatePassword(8);
				$user->password = password_hash($new_password, PASSWORD_BCRYPT);
				$user->save();

				$message = "A new password has been emailed to " . html_escape($email);
				send_notification($user, "Password Reset", "<p>Hello $user->fname,</p><p>Somebody (hopefully you) has requested that your password for " . COMPANY_NAME . " be reset.</p><p>Your username is '$user->username' and your new password is: $new_password</p>");
			}
			else
			{
				$message = "No user was found with the email address: " . html_escape($email);
			}
		}

		if(Mainframe::loggedin())
		{
			//already logged in
			if($this->input->get_post("logout") == "1")
			{
				setcookie("user_id", "", 1, $this->config->item("cookie_path"), $this->config->item("cookie_domain"), $this->config->item("cookie_secure"), $this->config->item("cookie_httponly"));

				FeralRedirect(($logout_redirect ? $logout_redirect : "index.php"));
			}

			$user = Mainframe::user();
			?>
			<div id="module_<?php echo($this->module_instance_id); ?>" class="module logout-module <?php echo($module_class); ?>">
				<?php
				if($title && $title_heading_level)
				{
					?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
				}
				?>
				<p>You are currently logged in as <?php echo "$user->fname $user->lname"?>.</p>
				<div class="clear"></div>


				<form name="logout_<?php echo $this->module_instance_id?>" id="logout_<?php echo $this->module_instance_id?>" method="post" action="" class="logout-form">
					<?php
					csrf();
					FeralHidden("logout", "1");
					FeralSubmit("logout-button", "Logout", "btn btn-primary");
					?>
				</form>
			</div>
			<?php
		}
		else
		{
			//not logged in
			if($this->input->post("username"))
			{
				csrf_verify();
				//attempt a login
				$user = $this->user->authenticate($this->input->post("username"), $this->input->post("password"), false);

				if($user !== false)
				{
					$this->load->library("encryption");
					$user->last_login = date("Y-m-d H:i:s");
					$user->save();

					setcookie("user_id", $this->encryption->encrypt($user->user_id), time() + $this->config->item("sess_expiration"), $this->config->item("cookie_path"), $this->config->item("cookie_domain"), $this->config->item("cookie_secure"), $this->config->item("cookie_httponly"));

					$redirect = ($this->input->post("redirect") != "" ? html_escape(urldecode($this->input->post("redirect"))) : ($login_redirect ? $login_redirect : current_url()));

					FeralRedirect($redirect);
				}
				else
				{
					setcookie("user_id", "", 1, $this->config->item("cookie_path"), $this->config->item("cookie_domain"), $this->config->item("cookie_secure"), $this->config->item("cookie_httponly"));

					$message = "Username and/or password incorrect!";
				}
			}
			?>
			<div id="module_<?php echo($this->module_instance_id); ?>" class="module login-module <?php echo($module_class); ?>">
				<?php
				if($title && $title_heading_level)
				{
					?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
				}
				?>
			<div class="row">
				<div class="<?php echo(TWO_COL); ?>">
					<form name="login_<?php echo $this->module_instance_id?>" id="login_<?php echo $this->module_instance_id?>" method="post" action="" class="login-form">
						<?php
						csrf();
						FeralHidden("redirect", ($this->input->get_post("redirect") ? html_escape($this->input->get_post("redirect")) : ($login_redirect ? $login_redirect : current_url())));

						if($message)
						{
							?><p class="alert alert-danger"><?php echo $message?></p><?php
						}
						?>
						<div class="<?php echo(FORM_ROW); ?>">
							<div class="<?php echo(LABEL_COL); ?>"><label for="username">Username:</label></div>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralTextWidget("username", html_escape($this->input->post("username")), "form-control");
								$wgt->SetAttribute("required", "required");
								$wgt->Create();
								?>
							</div>
						</div>
						<div class="<?php echo(FORM_ROW); ?>">
							<div class="<?php echo(LABEL_COL); ?>"><label for="password">Password:</label></div>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralPasswordWidget("password", "", "form-control");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("autocomplete", "off");
								$wgt->Create();
								?>
							</div>
						</div>
						<div class="text-center"><button type="submit" class="btn btn-primary">Login</button></div>

						<?php
						$site = Mainframe::site();

						if($site->registration_page_id)
						{
							$page = new Page();
							$page->Load($site->registration_page_id);

							?><p><strong>No Account Yet? </strong><a href="/<?php echo($page->url) ?>?redirect=<?php echo(html_escape(rawurlencode($this->input->get_post("redirect")))); ?>">Register!</a></p><?php
						}
						?>
					</form>
				</div>

				<div class="<?php echo(TWO_COL); ?>">
					<form name="pwreset_<?php echo $this->module_instance_id?>" id="pwreset_<?php echo $this->module_instance_id?>" method="post" action="" class="pwreset-form">
						<?php
						csrf();
						FeralHidden("task", "pwreset");
						?>

						<h5 style="margin-top: 0;">Forgot Password?</h5>
						<div class="<?php echo(FORM_ROW); ?>">
							<div class="<?php echo(LABEL_COL); ?>"><label>Email address:</label></div>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralTextWidget("email", html_escape($this->input->post("email")), "form-control");
								$wgt->SetAttribute("required", "required");
								$wgt->SetAttribute("type", "email");
								$wgt->Create();
								?>
							</div>
						</div>
						<div class="text-center"><button type="submit" class="btn btn-primary">Reset Password</button></div>
					</form>
				</div>
			</div>
			</div>
			<?php
		}
	}
}
