<?php
defined('PRODUCT_NAME') or die;
class MenuModule extends ModuleInstance
{
	private $active_items = array();

	public function __construct()
	{
		parent::__construct();

		$this->scripts = array(
								// "<script src=\"/modules/menu/priority-navigation.js\"></script>",
								"<script src=\"/modules/menu/nav-priority-util.js\"></script>",
								"<script src=\"/modules/menu/nav-priority-plugin.js\"></script>",
								// "<script src=\"/modules/menu/nav-priority.min.js\"></script>",
								"<link rel=\"stylesheet\" href=\"/modules/menu/nav-priority.min.css\" />");
		$this->enable_jquery 		= true;
		$this->cache_config->user   = true;
	}

	function render()
	{
		$data = array("module_instance_id" 		=> $this->module_instance_id,
					  "title" 					=> $this->setting("title"),
					  "title_heading_level" 	=> $this->setting("title_heading_level"),
		              "module_class" 			=> $this->setting("module_class"),
					  "more_text" 				=> $this->setting("more_text"),
					  "menu_text" 				=> $this->setting("menu_text"),
					  "responsive" 				=> $this->setting("responsive"),
					  "style" 					=> $this->setting("style"),
					  "threshold" 				=> ($this->setting("threshold") ? $this->setting("threshold") : 2),
					  "container_width_offset" 	=> ($this->setting("container_width_offset") ? $this->setting("container_width_offset") : 20),
					  "content_above" 			=> $this->setting("content_above"),
					  "content_below" 			=> $this->setting("content_below"),
					  "search" 					=> $this->setting("search"),
					  "search_action" 			=> $this->setting("search_action"),
					  "search_legend" 			=> $this->setting("search_legend"),
					  "link_overlay_title" 		=> $this->setting("link_overlay_title"),
					  "module" 					=> $this);

		if($data["style"] == "nvmenu" || $data["style"] == "nvmenu-v")
		{
			$this->load->view("modules/menu/nvmenu", $data);
		}
		else
		{
			$this->load->view("modules/menu/menu", $data);
		}
	}

	function menu($parent_id=null, $items=null)
	{
		$this->load->model("menuitem");

		$page                   = Mainframe::page();
		$site                   = Mainframe::site();
		$module_instance_id     = $this->module_instance_id;
		$menu_id                = $this->setting("menu_id");
		$style                  = $this->setting("style");
		$pills                  = ($this->setting("pills") == 1);
		$fill                   = $this->setting("fill");
		$hover                  = ($this->setting("hover") == 1);
		$alignment              = $this->setting("alignment");
		$duplicate_parent_links = $this->setting("duplicate_parent_links");
		$show_icons             = $this->setting("show_icons");
		$link_overlay_title     = $this->setting("link_overlay_title");

		//We can save a double lookup by passing items from the $subitems check below into the recursive function.
		if($items == null)
		{
			$items = $this->menuitem->LoadByMenuID($menu_id, $parent_id, Mainframe::user());
		}

		if(count($items) == 0)
		{
			return;
		}

		if($hover)
		{
			$hover = 'onmouseenter="this.click()"';
		}
		?>
		<ul class="nav <?php echo($alignment); ?> <?php echo($pills ? "nav-pills" : ""); ?> <?php echo($fill ? "nav-" . $fill : ""); ?> <?php echo($style == "nvmenu-v" || $style == "vertical" ? "flex-column" : ""); ?>" id="menu_<?php echo($module_instance_id); ?>">
			<?php
			$total = count($items);
			$count = 0;

			foreach($items as $item)
			{
				if(!$item->published)
				{
					continue;
				}
				$active_parent = false;
				$count ++;

				//check if any children are active
				$subitems = $this->menuitem->LoadByMenuID($menu_id, $item->menu_item_id, Mainframe::user());

				foreach($subitems as $subitem)
				{
					if(!$subitem->published)
					{
						continue;
					}

					if($page->page_id == $subitem->page_id)
					{
						$active_parent = true;
						break;
					}
				}

				$url          = (preg_match('/^http/', strtolower($item->url)) ? '' : '/') . ($item->page_id == $site->default_page_id ? "" : $item->url);
				$class        = "nav-item";
				$has_children = false;

				if($item->url == "index" || $url == "//")
				{
					$url = "/";
				}

				if(count($subitems) > 0 && $item->menu_item_id != $parent_id)
				{
					$class .= " dropdown";// . $item->menu_item_id;
					$has_children = true;
				}

				$toggle = false;

				if($item->menu_item_id != $parent_id && $duplicate_parent_links && count($subitems))
				{
					$toggle = true;
				}

				// The wonky PHP tags here help prevent spaces from being placed between menu items.
				?><li class="<?php echo($class); ?> <?php echo($count == 1 ? "first" : "")?> <?php echo($count == $total ? "last" : "")?> <?php echo($page->page_id == $item->page_id || $active_parent ? "active" : "")?>"><?php
					if(($style == "nvmenu" || $style == "nvmenu-v") && $has_children)
					{
						?><a href="#" onclick="open_nvmenu<?php echo($module_instance_id); ?>(event); return false;" <?php echo ($item->target ? "target=\"$item->target\"" : "")?> <?php echo ($item->title_tag ? "title=\"$item->title_tag\"" : "")?> class="nav-link dropdown-toggle"><?php
					}
					else if($toggle)
					{
						?><a href="<?php echo $url?>" <?php echo($hover); ?> <?php echo ($item->target ? "target=\"$item->target\"" : "")?> <?php echo ($item->title_tag ? "title=\"$item->title_tag\"" : "")?> class="nav-link dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><?php
					}
					else
					{
						?><a href="<?php echo $url?>" <?php echo ($item->target ? "target=\"$item->target\"" : "")?> <?php echo ($item->title_tag ? "title=\"$item->title_tag\"" : "")?> class="nav-link"><?php
					}

					if($item->icon && ($show_icons == "menu" || $show_icons == "both"))
					{
						?><em class="fa-fw <?php echo($item->icon); ?>" aria-hidden="true"></em> <?php
					}
					echo($item->title);
					?></a><?php

					if($style == "nvmenu" || $style == "nvmenu-v")
					{
						?><span class="nvmenu-content-below d-none"><?php echo($item->description); ?></span><?php
					}

					if($item->menu_item_id != $parent_id)
					{
						// Add the current menu item as the first child of the submenu for accessibility reasons.
						if($duplicate_parent_links && count($subitems))
						{
							$subitems = array_merge(array($item), $subitems);
						}

						if($style == "nvmenu" || $style == "nvmenu-v")
						{
							$this->nvsubmenu($parent, $subitems, $module_instance_id, $menu_id, $show_icons, $duplicate_parent_links, $link_overlay_title);
						}
						else
						{
							$this->submenu($subitems);
						}
					}
				?></li><?php
			}
			?>
		</ul>
		<?php
	}

	function submenu($items)
	{
		$this->load->model("menuitem");

		$site = Mainframe::site();

		if(count($items) == 0)
		{
			return;
		}
		?>
		<ul class="dropdown-menu">
			<?php
			$total = count($items);
			$count = 0;

			foreach($items as $item)
			{
				if(!$item->published)
				{
					continue;
				}
				$count ++;

				$url   = (preg_match('/^http/', strtolower($item->url)) ? '' : '/') . ($item->page_id == $site->default_page_id ? "" : $item->url);
				$class = "dropdown-item";

				if($item->url == "index" || $url == "//")
				{
					$url = "/";
				}

				?><li><a href="<?php echo $url?>" <?php echo ($item->target ? "target=\"$item->target\"" : "")?> <?php echo ($item->title_tag ? "title=\"$item->title_tag\"" : "")?> class="dropdown-item"><?php
				if($item->icon)
				{
					?><em class="fa-fw <?php echo($item->icon); ?>" aria-hidden="true"></em> <?php
				}
				echo($item->title);
				?></a></li><?php
			}
			?>
		</ul>
		<?php
	}

	function nvsubmenu($parent, $items, $module_instance_id, $menu_id, $show_icons, $duplicate_parent_links, $link_overlay_title)
	{
		$page = Mainframe::page();
		$CI   = get_instance();
		$CI->load->model("menuitem");

		if(count($items) == 0)
		{
			return;
		}
		?>
		<div class="nvmenu-overlay-data-title d-none">
			<?php
			$url = (preg_match('/^http/', strtolower($parent->url)) ? '' : '/') . $parent->url;

			if($link_overlay_title)
			{
				?><a href="<?php echo $url?>" <?php echo ($parent->target ? "target=\"$parent->target\"" : "")?> <?php echo ($parent->title_tag ? "title=\"$parent->title_tag\"" : "")?> class="nav-link nav-link-heading"><?php
			}

			if($parent->icon && ($show_icons == "submenu" || $show_icons == "both"))
			{
				?><em class="fa-fw <?php echo($parent->icon); ?>" aria-hidden="true"></em> <?php
			}
			echo($parent->title);

			if($link_overlay_title)
			{
				?></a><?php
			}
			?>
		</div>

		<div class="nvmenu-overlay-data-items d-none">
			<ul class="row">
				<?php
				$total = count($items);
				$count = 0;

				foreach($items as $item)
				{
					if(!$item->published)
					{
						continue;
					}
					$count++;

					$url          = $item->url;
					$subitems     = $CI->menuitem->LoadByMenuID($menu_id, $item->menu_item_id, Mainframe::user());
					$class        = "nvmenu-item col-12 col-md-6 col-lg-4 col-xl-3";
					$has_children = false;

					if(count($subitems) > 0 && $item->menu_item_id != $parent->menu_item_id)
					{
						$class .= " nvmenu-has-children";
						$has_children = true;
					}
					?>
					<li class="<?php echo($class); ?> <?php echo($count == 1 ? "first" : "")?> <?php echo($count == $total ? "last" : "")?> <?php echo($page->page_id == $item->page_id ? "active" : "")?>">
						<?php
						if($has_children)
						{
							?><a href="#" onclick="open_nvmenu<?php echo($module_instance_id); ?>(event); return false;" <?php echo ($item->target ? "target=\"$item->target\"" : "")?> <?php echo ($item->title_tag ? "title=\"$item->title_tag\"" : "")?> class="nav-link"><?php
						}
						else
						{
							?><a href="/<?php echo($url); ?>" onclick="close_nvmenu<?php echo($module_instance_id); ?>(event); window.location='<?php echo($url); ?>';" <?php echo ($item->target ? "target=\"$item->target\"" : "")?> <?php echo ($item->title_tag ? "title=\"$item->title_tag\"" : "")?> class="nav-link"><?php
						}

						if($item->icon && ($show_icons == "submenu" || $show_icons == "both"))
						{
							?><em class="fa-fw <?php echo($item->icon); ?>" aria-hidden="true"></em> <?php
						}
						echo($item->title);
						?></a><span class="nvmenu-content-below d-none"><?php echo($item->description); ?></span><?php

						if($item->menu_item_id != $parent->menu_item_id)
						{
							// Add the current menu item as the first child of the submenu for accessibility reasons.
							if($duplicate_parent_links && count($subitems))
							{
								$subitems = array_merge(array($item), $subitems);
							}

							$this->nvsubmenu($item, $subitems, $module_instance_id, $menu_id, $show_icons, $duplicate_parent_links, $link_overlay_title);
						}
						?>
					</li>
					<?php
				}
				?>
			</ul>
		</div>
		<?php
	}
}
