<?php
defined('PRODUCT_NAME') or die;
class OpenStreetMap extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();
		$this->enable_jquery = true;
		$this->scripts = array('<link rel="stylesheet" href="https://unpkg.com/leaflet@1.5.1/dist/leaflet.css" integrity="sha512-xwE/Az9zrjBIphAcBb3F6JVqxf46+CDLwfLMHloNu6KEQCAWi6HcDUbeOfBIptF7tcCzusKFjFw2yuvEpDL9wQ==" crossorigin=""/>',
							   '<script src="https://unpkg.com/leaflet@1.5.1/dist/leaflet.js" integrity="sha512-GffPMF3RvMeYyc1LWMHtK8EbPv0iNZ8/oTtHPx9/cc2ILxQ+u905qIwdpULaqDkyBKgOaB57QTMg7ztg8Jm2Og==" crossorigin=""></script>');
	}

	function render()
	{
		$this->load->view("modules/openstreetmap/module",
	                  array("module_instance_id" 	=> $this->module_instance_id,
					  		"title" 				=> $this->setting("title"),
					  		"title_heading_level" 	=> $this->setting("title_heading_level"),
		              		"module_class" 			=> $this->setting("module_class"),
					  		"zoom" 					=> $this->setting("zoom"),
	                  		"address" 				=> $this->setting("address"),
	                  		"latitude" 				=> $this->setting("latitude"),
	                  		"longitude" 			=> $this->setting("longitude"),
	                  		"bubble_text" 			=> str_replace(array("\r", "\n", '"'), array("", "", "'"), nl2br($this->setting("bubble_text"))),
	                  		"height" 				=> $this->setting("height"),
	                  		"tileset" 				=> $this->setting("tileset"),
	                  		"tileserver" 			=> $this->setting("tileserver"),
	                  		"tileserver_attribution"=> $this->setting("tileserver_attribution"),
	                  		"access_token" 			=> $this->setting("access_token")));
	}
}
