<?php
defined('PRODUCT_NAME') or die;
class RandomImage extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->cache_config->enabled = false;
	}

	function render()
	{
		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$base					= $this->setting("directory");
		$max_width				= $this->setting("max_width");
		$max_height				= $this->setting("max_height");
		$link					= $this->setting("link");

		$directory = ABSOLUTE_PATH . "/" . $this->setting("directory");
		$files = scandir($directory);

		//look for any subdirectories who's name (date range) matches today
		//directories should have names in the format of "from_date to end_date" where each date is parsable by strtotime()

		foreach($files as $file)
		{
			if(is_dir("$base/$file") && $file != "." && $file != "..")
			{
				$seperator = stripos($file, " to ");

				$from 	= date("Y-m-d H:i", strtotime(trim(substr($file, 0, $seperator))));
				$to 	= date("Y-m-d H:i", strtotime(trim(substr($file, $seperator+4))));
				$now 	= date("Y-m-d H:i");

				if($now >= $from && $now <= $to)
				{
					//this directory qualifies for a scheduled banner
					//use this directory instead of the base directory
					$subfiles = scandir("$base/$file");
					//mail("brian@cbsgroup.com", "file test", print_r($subfiles, true));

					if(count($subfiles) > 2)
					{
						$base = "$base/$file";
						$files = $subfiles;

						break;
					}
				}
			}
		}

		if(count($files) <= 2)
		{
			return;
		}

		$broken = true;
		$attempts = 0;

		while($broken && $attempts < 10)
		{
			mt_srand();
			$image_num = mt_rand(2, count($files)-1);
			$image = $files[$image_num];

			//check if this image should be linked
			for($i=0; $i<10; $i++)
			{
				if(strtolower($this->setting("image$i")) == strtolower($image))
				{
					$link = $this->setting("link$i");
				}
			}

			if(preg_match('/\.(jpe?g|png|gif|webp)/i', $image))
			{
				$broken = false;
			}
			else
			{
				//not an image file
				$broken = true;
				$attempts ++;
			}
		}

		if($broken)
		{
			return;
		}

		$thumbnail 	= Mainframe::thumbnail("$base/$image", $max_width, $max_height, false, Mainframe::site()->webp ? IMAGETYPE_WEBP : null);
		$size 		= @getimagesize(ABSOLUTE_PATH . $thumbnail);
		$width 		= $size[0];
		$height 	= $size[1];
		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module random-image-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}

			if($link)
			{
				?><a href="<?php echo $link?>" title="<?php echo $thumbnail?>"><?php
			}
			?>
			<img src="<?php echo $thumbnail?>" width="<?php echo $width?>" height="<?php echo $height?>" />
			<?php
			if($link)
			{
				?></a><?php
			}
			?>
		</div>
		<?php
	}
}
