<?php
defined('PRODUCT_NAME') or die;
//Requires base RSS module
class RSSYouTubeModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->cache_config->enabled = false;
	}

	function render()
	{
		include_once(MODULE_PATH . "/rss/lastrss/lastRSS.php");

		$title 					= $this->setting("title");
		$title_heading_level 	= $this->setting("title_heading_level");
		$module_class 			= $this->setting("module_class");
		$width 					= $this->setting("width");
		$height 				= $this->setting("height");
		$num_articles 			= $this->setting("num_articles");

		if(trim($this->setting("keywords")))
		{
			$keywords = explode(",", $this->setting("keywords"));
		}
		else
		{
			$keywords = array();
		}

		// Create lastRSS object
		$rss = new lastRSS;
		$rss->cache_dir = 'modules/rss/lastrss/cache'; //path to cache directory on your server relative to scrollerbridge.php. Chmod 777!
		$rss->date_format = 'M d, Y g:i:s A'; //date format of RSS item. See PHP date() function for possible input.
		$rss->cache_time = 1800; //Global cache time before fetching RSS feed again, in seconds.

		// Define your list of RSS URLs- "RSS_id"=> "URL to RSS feed"
		$rsslist = array(
						$this->setting("rss1"),
						$this->setting("rss2"),
						$this->setting("rss3"),
						$this->setting("rss4"),
						$this->setting("rss5"),
						$this->setting("rss6"),
						$this->setting("rss7"),
						$this->setting("rss8"),
						$this->setting("rss9"),
						$this->setting("rss10")
						);
		$videos = array();

		?>
		<div id="module_<?php echo($this->module_instance_id); ?>" class="module rss-youtube-module <?php echo($module_class); ?>">
			<?php
			if($title && $title_heading_level)
			{
				?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
			}

			foreach($rsslist as $rssurl)
			{
				if(!$rssurl)
				{
					continue;
				}

				$rs = $rss->get($rssurl);
				if(isset($rs["items"]))
				{
					$rs["items"] = array_slice($rs["items"], 0, 10);	//grab latest 5 videos from each feed

					$videos = array_merge($videos, $rs["items"]);
				}
				else
				{
					$videos = array();
				}
			}
			//shuffle videos so that we don't get them all from the same feed
			shuffle($videos);
			$count = 0;

			foreach($videos as $video)
			{
				if(count($keywords))
				{
					//filter videos by keyword
					//$video["title"]
					//$video["description"]
					$haystack = $video["title"] . " " . $video["description"];

					$match = false;

					//search each keyword against the title and description of this video looking for a match
					foreach($keywords as $keyword)
					{
						if(stripos($haystack, $keyword) !== false)
						{
							$match = true;

							break;
						}
					}

					if(!$match)
					{
						continue;
					}
				}

				$code = $video["link"];
				$code = substr($code, stripos($code, "v=") +2);
				$code = substr($code, 0, stripos($code, "&"));
				//echo("$code<br />");
				?>
				<h4 class="rss-headline"><a href="<?php echo $this->strip_cdata($video["link"])?>" target="_blank"><?php echo $this->strip_cdata($video["title"])?></a></h4>
				<h4 class="rss-date"><?php echo $this->strip_cdata($video["pubDate"])?></span></h4>
				<div class="rss-video"><iframe width="<?php echo $width?>" height="<?php echo $height?>" src="http://www.youtube.com/embed/<?php echo $code?>?hd=1" frameborder="0" allowfullscreen></iframe></div>
				<?php

				$count ++;

				if($count == $num_articles)
				{
					break;
				}
			}
			?>
		</div>
		<?php
	}

	function strip_cdata($string)
	{
	    preg_match_all('/<!\[cdata\[(.*?)\]\]>/is', $string, $matches);
	    return strip_tags(str_replace($matches[0], $matches[1], $string));
	}
}
