<?php
defined('PRODUCT_NAME') or die;
class SearchModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->cache_config->enabled = false;
	}

	function render()
	{
		$this->load->model(array("site", "page", "domain", "document", "category"));

		$q				= filter_var($this->input->get_post("q" . $this->module_instance_id), FILTER_SANITIZE_STRING);
		$page_number	= (int)$this->input->get_post("p");

		if(!$page_number)
		{
			$page_number = 1;
		}

		$category_id	= $this->setting("category_id");
		$tag_ids		= $this->setting("tag_ids", null);
		$tag_logic		= $this->setting("tag_logic", "OR");
		$per_page		= $this->setting("per_page");
		$ordering 		= $this->setting("ordering");
		$site_lock 		= $this->setting("site_lock");
		$orderby 		= "`title` ASC";
		$offset 		= ($page_number-1) * $per_page;
		$next 			= false;
		$prev 			= ($page_number > 1 && $per_page > 0 ? $page_number-1 : false);
		$pages 			= $this->page->LoadByCategoryContentTypeTagID(($site_lock ? Mainframe::site()->site_id : null), $category_id, false, $tag_ids, $tag_logic, $orderby, $q, Mainframe::user(), 0);
		$documents 		= $this->document->loadByCategoryID(($site_lock ? Mainframe::site()->site_id : null), $category_id, $tag_ids, $tag_logic, $orderby, $q, Mainframe::user());

		foreach($pages as &$p)
		{
			$p->type = "page";
		}

		foreach($documents as &$d)
		{
			$d->type = "document";
		}

		$results = array_merge($pages, $documents);
		unset($pages);
		unset($documents);
		usort($results, array("SearchModule", "sortByPoints"));

		$total 		= count($results);
		$page_count = ($per_page > 0 ? ceil($total/$per_page) : 1);
		$next 		= ($page_count > $page_number && $per_page > 0 ? $page_number+1 : false);

		if($per_page > 0)
		{
			if(count($results) > $per_page)
			{
				$results = array_splice($results, $offset, $per_page);
			}
		}

		$final_results = array();

		for($i=0; $i<count($results); $i++)
		{
			if($results[$i]->type == "page")
			{
				$fp = new Page();
			}
			else if($results[$i]->type == "document")
			{
				$fp = new Document();
			}
			$fp->populate($results[$i]);

			$final_results[$i] = $fp;
		}

		$data = array("module_instance_id" 		=> $this->module_instance_id,
					  "title" 					=> $this->setting("title"),
					  "title_heading_level" 	=> $this->setting("title_heading_level"),
		              "heading_level" 			=> $this->setting("heading_level"),
		              "module_class" 			=> $this->setting("module_class"),
					  "q" 						=> $q,
					  "category_id" 			=> $category_id,
					  "show_title" 				=> $this->setting("show_title"),
					  "show_date" 				=> $this->setting("show_date"),
					  "show_category" 			=> $this->setting("show_category"),
					  "show_icons" 				=> $this->setting("show_icons"),
					  "show_text" 				=> $this->setting("show_text"),
					  "character_limit" 		=> $this->setting("character_limit"),
					  "search_legend" 			=> $this->setting("search_legend"),
					  "total" 					=> $total,
					  "per_page" 				=> $per_page,
					  "next" 					=> $next,
					  "prev" 					=> $prev,
					  "page_number"				=> $page_number,
					  "page_count"				=> $page_count,
					  "results" 				=> $final_results);

		$this->load->view("modules/search/module", $data);
	}

	public static function sortByPoints($a, $b)
	{
		if(!isset($a->points))
		{
			$a->points = 0;
		}
	    if(!isset($b->points))
		{
			$b->points = 0;
		}
	    if($a->points == $b->points)
	    {
	        return 0;
	    }
	    return ($a->points > $b->points) ? -1 : 1;
	}
}
