<?php
defined('PRODUCT_NAME') or die;
class ShopModule extends ModuleInstance
{
	public function __construct()
	{
		parent::__construct();

		$this->enable_jquery         = true;
		// $this->enable_jquery_ui      = true;
		$this->cache_config->enabled = false;
		// require_once(APPLICATION_PATH . "/controllers/Shop.php");
	}

	function render()
	{
		/**
		 * This module replaces all shop_* modules via a module setting telling it which part to load.
		 * This lets us customize the whole shop experience by duplicating the module and customizing its views.
		 * The developer can collect whatever data is desired in whatever order is desired.
		 */

		$this->load->model(array("shop/shop_currency"));

		$module              = $this->setting("module");
		$title               = $this->setting("title");
		$title_heading_level = $this->setting("title_heading_level");
		$module_class        = $this->setting("module_class");
		$field_text          = $this->setting("field_text");
		$button_text         = $this->setting("button_text");

		$data = array(	"module_instance_id" 	=> $this->module_instance_id,
						"title" 				=> $this->setting("title"),
						"title_heading_level" 	=> $this->setting("title_heading_level"),
						"module_class" 			=> $this->setting("module_class"),
						"user" 					=> get_user());

		if($module == "cart_summary")
		{
			$this->load->model(array("shop/shop_cart"));

			$cart_page = new Page();
			$cart_page->Load(Mainframe::site()->cart_page_id);

			$checkout_page = new Page();
			$checkout_page->Load(Mainframe::site()->checkout_page_id);

			$cart  = new Shop_cart();
			$items = $cart->GetItemsBySessionID(session_id());

	  		$data["cart_url"]     = $cart_page->url;
	  		$data["checkout_url"] = $checkout_page->url;
		}
		else if($module == "cart")
		{
			$this->load->model(array("shop/shop_cart", "shop/shop_shipping_gateway", "shop/shop_payment_gateway", "shop/shop_tax"));
			$this->load->helper(array("shipping", "payment"));

			$checkout_page = new Page();
			$checkout_page->Load(Mainframe::site()->checkout_page_id);

			$data["checkout_url"]      = $checkout_page->url;
			$data["shipping_gateways"] = $this->shop_shipping_gateway->LoadBySiteID(Mainframe::site()->site_id);
			$data["payment_gateways"]  = $this->shop_payment_gateway->LoadBySiteID(Mainframe::site()->site_id);
		}
		else if($module == "checkout")
		{
			$this->load->model(array("shop/shop_cart", "shop/shop_shipping_gateway", "shop/shop_payment_gateway", "shop/shop_tax"));
			$this->load->helper(array("shipping", "payment"));

			if(Mainframe::site()->registration_page_id)
			{
				$p = new Page();
				$p->Load(Mainframe::site()->registration_page_id);
				$data["registration_url"] = $p->url . "?redirect=" . rawurldecode(current_url());
			}

			if(Mainframe::site()->login_page_id)
			{
				$p = new Page();
				$p->Load(Mainframe::site()->login_page_id);
				$data["login_url"] = $p->url . "?redirect=" . rawurldecode(current_url());
			}

			$data["shipping_gateways"] = $this->shop_shipping_gateway->LoadBySiteID(Mainframe::site()->site_id);
			$data["payment_gateways"]  = $this->shop_payment_gateway->LoadBySiteID(Mainframe::site()->site_id);
			$data["taxes"]             = $this->shop_tax->LoadBySiteIDForProvince(Mainframe::site()->site_id, (isset($shipping_vars["shipping_country"]) ? $shipping_vars["shipping_country"] : "CA"), (isset($shipping_vars["shipping_province"]) ? $shipping_vars["shipping_province"] : "ON"));

		}

		$this->load->view("modules/shop/header", $data);
		$this->load->view("modules/shop/" . $module, $data);
	}
}
