SET FOREIGN_KEY_CHECKS = 0;
DROP TABLE `shop_config`;
DROP TABLE `shop_categories_products`;
DROP TABLE `shop_categories_shopper_groups`;
DROP TABLE `shop_categories`;
DROP TABLE `shop_category_layout`;
DROP TABLE `shop_datasources`;
DROP TABLE `shop_images`;
DROP TABLE `shop_layout_specific_data_values`;
DROP TABLE `shop_layout_specific_data`;
DROP TABLE `shop_prices`;
DROP TABLE `shop_products`;
DROP TABLE `shop_product_layout`;
DROP TABLE `shop_products_related`;
DROP TABLE `shop_product_options`;
DROP TABLE `shop_product_variant`;
DROP TABLE `shop_routes`;
DROP TABLE `shop_shopper_groups`;
DROP TABLE `shop_vehicles_products`;
DROP TABLE `shop_vehicles`;
ALTER TABLE `shop_cart` DROP FOREIGN KEY `fk_shop_cart_product_id`;
ALTER TABLE `shop_cart` DROP FOREIGN KEY `shop_cart_product_variant_id`;
ALTER TABLE `shop_cart` DROP COLUMN IF EXISTS `product_id`;
ALTER TABLE `shop_cart` DROP COLUMN IF EXISTS `product_variant_id`;
ALTER TABLE `shop_cart` ADD IF NOT EXISTS `page_id` INT(11) UNSIGNED NOT NULL AFTER `session_id`;
ALTER TABLE `shop_cart` ADD CONSTRAINT `shop_cart_page_id` FOREIGN KEY (`page_id`) REFERENCES `pages`(`page_id`) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE `users` DROP FOREIGN KEY `fk_users_shopper_group_id`;
ALTER TABLE `users` DROP COLUMN IF EXISTS `shopper_group_id`;
SET FOREIGN_KEY_CHECKS = 1;

ALTER TABLE `sites` ADD IF NOT EXISTS `shop` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0 AFTER `fontawesome`;

ALTER TABLE `sites` DROP COLUMN IF EXISTS `matomo_site_id`;
ALTER TABLE `sites` DROP COLUMN IF EXISTS `matomo_token_auth`;

# Fix grid sizes.
UPDATE `module_settings` SET `value`=1 WHERE `value`="1-1" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=6 WHERE `value`="1-2" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=4 WHERE `value`="1-3" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=8 WHERE `value`="2-3" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=3 WHERE `value`="1-4" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=9 WHERE `value`="3-4" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=2 WHERE `value`="1-5" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=4 WHERE `value`="2-5" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=6 WHERE `value`="3-5" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=8 WHERE `value`="4-5" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=2 WHERE `value`="1-6" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=10 WHERE `value`="5-6" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=1 WHERE `value`="2-24" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=5 WHERE `value`="10-24" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=7 WHERE `value`="14-24" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";
UPDATE `module_settings` SET `value`=11 WHERE `value`="22-24" AND `key`="column_size" OR `key` LIKE "size_sm%" OR `key` LIKE "size_md%" OR `key` LIKE "size_lg%" OR `key` LIKE "size_xl%";

UPDATE `module_settings` AS ms
INNER JOIN `module_instances` AS mi USING(`module_instance_id`)
INNER JOIN `modules` AS m USING(`module_id`)
SET ms.`value`="nvmenu"
WHERE m.file_name="nvmenu" AND `key`="style";

SELECT `module_id` FROM `modules` WHERE `file_name`="nvmenu" INTO @nvmenu_id;
SELECT `module_id` FROM `modules` WHERE `file_name`="menu" INTO @menu_id;
UPDATE `module_instances` SET `module_id`=@menu_id WHERE `module_id`=@nvmenu_id;
DELETE FROM `modules` WHERE `file_name`="nvmenu";

DELETE FROM `modules` WHERE `file_name`="shop_breadcrumb";
DELETE FROM `modules` WHERE `file_name`="shop_cart";
DELETE FROM `modules` WHERE `file_name`="shop_category";
DELETE FROM `modules` WHERE `file_name`="shop_currency";
DELETE FROM `modules` WHERE `file_name`="shop_filter";
DELETE FROM `modules` WHERE `file_name`="shop_menu";
DELETE FROM `modules` WHERE `file_name`="shop_shipping";

ALTER TABLE `shop_cart` DROP FOREIGN KEY `fk_shop_cart_product_id`;
ALTER TABLE `shop_cart` DROP FOREIGN KEY `shop_cart_product_variant_id`;
ALTER TABLE `shop_cart` DROP COLUMN IF EXISTS `product_variant_id`;
ALTER TABLE `shop_cart` CHANGE `product_id` `page_id` INT(11) UNSIGNED NOT NULL;
ALTER TABLE `shop_cart` ADD CONSTRAINT `shop_cart_page_id` FOREIGN KEY (`page_id`) REFERENCES `pages` (`page_id`) ON DELETE CASCADE ON UPDATE CASCADE;
ALTER TABLE `shop_cart` ADD IF NOT EXISTS `price` DECIMAL(10,2) NOT NULL AFTER `page_id`;

INSERT INTO `content_types` SET `content_type`="Shop - Product", `filename`="product", `page_info`=1, `sort`=25;
INSERT INTO `content_types` SET `content_type`="Shop - Cart", `filename`="cart", `page_info`=1, `sort`=26;
INSERT INTO `content_types` SET `content_type`="Shop - Checkout", `filename`="checkout", `page_info`=1, `sort`=27;

UPDATE `shop_payment_gateways` SET `gateway_name`="Credit or Debit Card" WHERE `filename`="stripe";
DELETE FROM `shop_payment_gateways` WHERE `filename`="creditcard";
DELETE FROM `shop_payment_gateways` WHERE `filename`="moneris_hosted";

ALTER TABLE `shop_orders` CHANGE `ship_date` `ship_date` DATETIME;

ALTER TABLE `sites` CHANGE `enable_html5` `enable_vue` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0;
UPDATE `sites` SET `enable_vue`=0;

ALTER TABLE `sites` ADD IF NOT EXISTS `cart_page_id` INT(11) UNSIGNED NULL AFTER `shop`;
ALTER TABLE `sites` ADD IF NOT EXISTS `checkout_page_id` INT(11) UNSIGNED NULL AFTER `cart_page_id`;
ALTER TABLE `sites` ADD IF NOT EXISTS `successful_transaction_link` VARCHAR(255);
ALTER TABLE `sites` ADD IF NOT EXISTS `order_notifications` VARCHAR(255) AFTER `successful_transaction_link`;
ALTER TABLE `sites` ADD IF NOT EXISTS `tax_numbers` VARCHAR(255) AFTER `order_notifications`;
ALTER TABLE `sites` ADD IF NOT EXISTS `currency_id` INT(11) UNSIGNED AFTER `tax_numbers`;
ALTER TABLE `sites` ADD CONSTRAINT `sites_cart_page_id` FOREIGN KEY (`cart_page_id`) REFERENCES `pages` (`page_id`) ON DELETE SET NULL ON UPDATE CASCADE;
ALTER TABLE `sites` ADD CONSTRAINT `sites_checkout_page_id` FOREIGN KEY (`checkout_page_id`) REFERENCES `pages` (`page_id`) ON DELETE SET NULL ON UPDATE CASCADE;
ALTER TABLE `sites` ADD CONSTRAINT `sites_currency_id` FOREIGN KEY (`currency_id`) REFERENCES `shop_currency` (`currency_id`) ON DELETE RESTRICT ON UPDATE CASCADE;

UPDATE `content_values` SET `value`=REPLACE(`value`, '"page-link"', '"content-link"');
UPDATE `module_settings` SET `value`=REPLACE(`value`, '"page-link"', '"content-link"');
INSERT INTO `modules` SET `name`='OpenStreetMap', `file_name`='openstreetmap', `class_name`='OpenStreetMap';
UPDATE `templates` SET `name`="Showcase", `directory`="showcase" WHERE `directory`='kasper';
