# Create contact page and a menu link for it on the main menu.
SELECT `content_type_id` FROM `content_types` WHERE `filename`="contact" INTO @content_type_id;
INSERT INTO `pages` SET `site_id`=1, `category_id`=null, `content_type_id`=@content_type_id, `created`=NOW(), `title`="Contact Us", `title_heading_level`=1, `url`="contact", `description`=null, `content`=null, `rss`=0, `searchable`=1, `allow_url_segments`=0, `allow_url_query`=0, `published`=1;
SELECT MAX(page_id) FROM `pages` INTO @page_id;
INSERT INTO `menu_items` SET `menu_id`=1, `parent_id`=null, `title`="Contact Us", `page_id`=@page_id, `url`="", `target`="", `sort`=10, `published`=1;
SELECT MAX(menu_item_id) FROM `menu_items` INTO @menu_item_id;

# Create a default configuration for the contact form.
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_contact", `value`="Contact Us";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_heading_level_contact", `value`="h2";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="module_class", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="recipients", `value`="{email}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="recaptcha_public_key", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="recaptcha_private_key", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="departments", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="addresses", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_name", `value`="1";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_phone", `value`="1";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_email", `value`="1";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_subject", `value`="1";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_message", `value`="1";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="success_message", `value`="<p>Thank you, your message was sent.</p>";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="error_message", `value`="<p>There was an error sending your message.</p>";

# Contact Info
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_info", `value`="Contact Information";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_heading_level_info", `value`="h2";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="layout", `value`="vertical";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="icon_size_info", `value`="1x";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="phone_numbers_icon", `value`="fa-phone fas";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="phone_numbers", `value`="{phone_numbers}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="hours_icon", `value`="fa-clock far";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="hours", `value`="{hours}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="address_icon", `value`="fa-map-marker-alt fas";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="address_info", `value`="{address}";

# Social Media
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_social", `value`="Follow Us";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_heading_level_social", `value`="h3";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="icon_size_social", `value`="2x";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="facebook", `value`="{facebook}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="twitter", `value`="{twitter}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="gplus", `value`="{gplus}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="flickr", `value`="{flickr}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="pinterest", `value`="{pinterest}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="youtube", `value`="{youtube}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="linkedin", `value`="{linkedin}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="instagram", `value`="{instagram}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="etsy", `value`="{etsy}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="tumblr", `value`="{tumblr}";

# OSM Map
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_map", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_heading_level_map", `value`="0";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="map_type", `value`="osm";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="height", `value`="400";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="address_map", `value`="{map_address}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="latitude", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="longitude", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="bubble_text", `value`="<b>{company}</b><br>{map_address}";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="zoom", `value`="16";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="tileset", `value`="wikimedia";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="access_token", `value`="pk.eyJ1IjoibmVyaXZvbiIsImEiOiJjazIwcmkwbjgxYzE1M2NsMjVicnB2YndzIn0.ud_8lqtdC6xaIFvzNjUXsw";

# ACL
INSERT INTO `acl` SET `acl_role_id`=1, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `page_id`=@page_id, `read`=1, `write`=1;
INSERT INTO `acl` SET `acl_role_id`=1, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `menu_item_id`=@menu_item_id, `read`=1, `write`=1;
