# Create gallery page and a menu link for it on the main menu.
SELECT `content_type_id` FROM `content_types` WHERE `filename`="gallery" INTO @content_type_id;
INSERT INTO `pages` SET `site_id`=1, `category_id`=null, `content_type_id`=@content_type_id, `created`=NOW(), `title`="Gallery", `title_heading_level`=1, `url`="gallery", `description`=null, `content`=null, `rss`=0, `searchable`=1, `allow_url_segments`=0, `allow_url_query`=1, `published`=1;
SELECT MAX(page_id) FROM `pages` INTO @page_id;
INSERT INTO `menu_items` SET `menu_id`=1, `parent_id`=null, `title`="Gallery", `page_id`=@page_id, `url`="", `target`="", `sort`=3, `published`=1;
SELECT MAX(menu_item_id) FROM `menu_items` INTO @menu_item_id;

# Create a default configuration for the gallery.
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_heading_level", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="module_class", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="directory", `value`="images/gallery";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="ordering", `value`="filename";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="aspect_ratio", `value`="4:3";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="style", `value`="padded";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="theme", `value`="theme3";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="lightbox_width", `value`="90%";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="lightbox_height", `value`="90%";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="breakpoint_sm", `value`=568;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="breakpoint_md", `value`=768;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="breakpoint_lg", `value`=1024;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="breakpoint_xl", `value`=1280;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="per_row_sm", `value`=1;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="per_row_md", `value`=2;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="per_row_lg", `value`=3;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="per_row_xl", `value`=4;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="album_per_row_sm", `value`=1;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="album_per_row_md", `value`=2;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="album_per_row_lg", `value`=3;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="album_per_row_xl", `value`=4;

# ACL
INSERT INTO `acl` SET `acl_role_id`=1, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `page_id`=@page_id, `read`=1, `write`=1;
INSERT INTO `acl` SET `acl_role_id`=1, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `menu_item_id`=@menu_item_id, `read`=1, `write`=1;
