# Create login page and a menu link for it on secondary menu.
SELECT `content_type_id` FROM `content_types` WHERE `filename`="login" INTO @content_type_id;
INSERT INTO `pages` SET `site_id`=1, `category_id`=null, `content_type_id`=@content_type_id, `created`=NOW(), `title`="Login", `title_heading_level`=1, `url`="user-login", `description`=null, `content`=null, `rss`=0, `searchable`=1, `allow_url_segments`=1, `allow_url_query`=1, `published`=1;
SELECT MAX(page_id) FROM `pages` INTO @page_id;
INSERT INTO `menu_items` SET `menu_id`=2, `parent_id`=null, `title`="Login", `page_id`=@page_id, `url`="", `target`="", `sort`=2, `published`=1;
SELECT MAX(menu_item_id) FROM `menu_items` INTO @menu_item_id;

# Create a default configuration for the login module.
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_login", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_heading_level_login", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_registration", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_heading_level_registration", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="module_class", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="login", `value`=1;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="register", `value`=0;

# Link up the site to the login page.
UPDATE `sites` SET `login_page_id`=@page_id WHERE `site_id`=1;

# ACL
INSERT INTO `acl` SET `acl_role_id`=1, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `page_id`=@page_id, `read`=1, `write`=1;
INSERT INTO `acl` SET `acl_role_id`=1, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `menu_item_id`=@menu_item_id, `read`=1, `write`=1;
