# Create portfolio page and a menu link for it on the main menu.
SELECT `content_type_id` FROM `content_types` WHERE `filename`="content_list" INTO @content_type_id;
INSERT INTO `pages` SET `site_id`=1, `category_id`=null, `content_type_id`=@content_type_id, `created`=NOW(), `title`="Portfolio", `title_heading_level`=1, `url`="portfolio", `description`=null, `content`=null, `rss`=0, `searchable`=1, `allow_url_segments`=0, `allow_url_query`=1, `published`=1;
SELECT MAX(page_id) FROM `pages` INTO @page_id;
INSERT INTO `menu_items` SET `menu_id`=1, `parent_id`=null, `title`="Portfolio", `page_id`=@page_id, `url`="", `target`="", `sort`=4, `published`=1;
SELECT MAX(menu_item_id) FROM `menu_items` INTO @menu_item_id;

# Create a default configuration for the portfolio.
SELECT `category_id` FROM `categories` WHERE `site_id`=1 AND `name`="Portfolio" INTO @category_id;
#REPLACE INTO `categories` SET `site_id`=1, `name`="Portfolio", `category_id`=@category_id;
SELECT `content_type_id` FROM `content_types` WHERE `content_type`="Portfolio Item" INTO @content_type_id;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_heading_level", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="module_class", `value`="portfolio-module";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="heading_level", `value`="h2";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="category_id", `value`=@category_id;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="content_type_id", `value`=@content_type_id;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="tag_ids", `value`=null;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="num_featured", `value`="0";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="num_articles", `value`="0";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="num_columns", `value`="3";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="num_columns_featured", `value`="1";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="per_page", `value`="10";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="character_limit", `value`="0";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="read_more_text", `value`="Read More <em class=\"fas fa-fw fa-caret-right\" aria-hidden=\"true\"></em>";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="image_alignment", `value`="none";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_image", `value`="1";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="image_width", `value`="400";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="image_height", `value`="300";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_image_featured", `value`="1";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="image_width_featured", `value`="1200";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="image_height_featured", `value`="400";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="crop", `value`="top:left";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="crop_featured", `value`="top:left";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_title", `value`="no";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_date", `value`="0";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_text", `value`="1";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="per_page", `value`="12";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="link_first_heading", `value`="0";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="always_show_readmore", `value`="0";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="strip_tags", `value`="no";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="ordering", `value`="newest_created";

# ACL
INSERT INTO `acl` SET `acl_role_id`=1, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `page_id`=@page_id, `read`=1, `write`=1;
INSERT INTO `acl` SET `acl_role_id`=1, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `menu_item_id`=@menu_item_id, `read`=1, `write`=1;
