<?php defined('PRODUCT_NAME') or die; ?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<base href="<?php echo (isset($_SERVER["HTTPS"]) ? "https://" : "http://");?><?php echo(html_escape($this->input->server("HTTP_HOST")));?>/" />
	<title><?php echo ($page->title && $page->title != "Home" ? $page->title . " | " : "");?><?php echo $site->title?></title>

	<link rel="stylesheet" href="/templates/<?php echo $template->directory?>/css/contrast.css" />
	<link rel="shortcut icon" href="/templates/<?php echo $template->directory?>/images/favicon.ico" />
	<link rel="icon" href="/templates/<?php echo $template->directory?>/images/favicon.ico" />
	<!--CSS-->

	<?php
	if(file_exists(ABSOLUTE_PATH . "/rss.xml"))
	{
		?><link rel="alternate" type="application/rss+xml" title="<?php echo(COMPANY_NAME);?>" href="/rss.xml" /><?php
	}
	?>

	<meta name="description" content="<?php echo ($page->description ? $page->description : "");?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<meta property="og:title" content="<?php echo($page->title); ?>" />
    <meta property="og:type" content="<?php echo($page->og_type); ?>" />
    <meta property="og:url" content="<?php echo(base_url($page->url)); ?>" />
    <meta property="og:image" content="<?php echo($page->og_image); ?>" />
    <meta property="og:description" content="<?php echo($page->description); ?>" />
	<!--JS-->
</head>

<body>
	<header role="banner"><div id="module_position_header"></div></header>

	<nav role="navigation">
		<div id="module_position_menu"></div>
	</nav>

	<div class="row">
		<?php
		if(Mainframe::countModules($page->page_id, "right"))
		{
			$right = true;
			$class = "col-8";
		}
		else
		{
			$right = false;
			$class = "col-12";
		}
		?>
		<div class="<?php echo($class); ?>"><?php Mainframe::content(); ?></div>

		<?php
		if($right)
		{
			?><div class="col-4"><div id="module_position_right"></div></div><?php
		}
		?>
	</div>

	<footer role="contentinfo">
		<div id="module_position_footer"></div>

		<p class="copyright">Copyright &copy; <?php echo date("Y");?>, <?php echo(COMPANY_NAME);?>, All Rights Reserved</p>
	</footer>
	<script src="/js/min/scripts.min.js"></script>
</body>
</html>
