<?php defined('PRODUCT_NAME') or die; ?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<base href="<?php echo (isset($_SERVER["HTTPS"]) ? "https://" : "http://");?><?php echo(html_escape($this->input->server("HTTP_HOST")));?>/" />
	<title><?php echo ($page->title && $page->title != "Home" ? $page->title . " | " : "");?><?php echo $site->title?></title>

	<link rel="stylesheet" href="/templates/<?php echo $template->directory?>/css/contrast.css" />
	<link rel="shortcut icon" href="/templates/<?php echo $template->directory?>/images/favicon.ico" />
	<link rel="icon" href="/templates/<?php echo $template->directory?>/images/favicon.ico" />
	<!--CSS-->

	<?php
	if(file_exists(ABSOLUTE_PATH . "/rss.xml"))
	{
		?><link rel="alternate" type="application/rss+xml" title="<?php echo(COMPANY_NAME);?>" href="/rss.xml" /><?php
	}
	?>

	<meta name="description" content="<?php echo ($page->description ? $page->description : "");?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<meta property="og:title" content="<?php echo($page->title); ?>" />
    <meta property="og:type" content="<?php echo($page->og_type); ?>" />
    <meta property="og:url" content="<?php echo(base_url($page->url)); ?>" />
    <meta property="og:image" content="<?php echo($page->og_image); ?>" />
    <meta property="og:description" content="<?php echo($page->description); ?>" />
	<!--JS-->
</head>

<body>
	<header role="banner" class="container py-3">
		<div class="row">
			<div id="logo" class="col-12 col-md-3 col-lg-2"><div id="module_position_header_logo"></div></div>
			<nav role="navigation" class="col-12 col-md-5 col-lg-7"><div id="module_position_menu"></div></nav>
			<div id="header-right" class="col-12 col-md-4 col-lg-3"><div id="module_position_header_right"></div></div>
		</div>
	</header>

	<?php
	if(Mainframe::countModules($page->page_id, "slideshow"))
	{
		?>
		<div id="slideshow" class="container"><div id="module_position_slideshow"></div></div>
		<?php
	}

	if(Mainframe::countModules($page->page_id, "pagetop"))
	{
		?>
		<div id="pagetop" class="container"><div id="module_position_pagetop"></div></div>
		<?php
	}
	?>

	<div id="content" class="container  py-4">
		<?php Mainframe::content(); ?>
	</div>

	<?php
	if(Mainframe::countModules($page->page_id, "pagebottom"))
	{
		?>
		<div id="pagebottom" class="container-fluid"><div id="module_position_pagebottom"></div></div>
		<?php
	}
	?>

	<footer role="contentinfo">
		<div class="container py-4">
			<div class="row">
				<div id="subfooter" class="col-12">
					<div id="module_position_subfooter"></div>
					<hr />
				</div>
				<div class="col-12 col-lg-6"><div id="module_position_footer_left"></div></div>
				<div class="col-12 col-lg-6"><div class="copyright"><em class="fas fa-fw fa-copyright"></em> Copyright <?php echo date("Y");?>, <?php echo(COMPANY_NAME);?>. All Rights Reserved.</div></div>
			</div>
		</div>
	</footer>
	<script src="/js/min/scripts.min.js"></script>
</body>
</html>
