# Change Log

## Developer Notes

* [Please adhere to these changelog practices](http://keepachangelog.com)
* [Please adhere to Semantic Versioning](http://semver.org)

## 9.11.0 - 2025-12-11

- All outgoing email comes "from" the SMTP username instead of `noreply@{server_name}`.
- Remove legacy servers from email test.

## 9.10.31 - 2025-09-04

- 045: Updated to bxSlider v4.2.17 in each of these modules:
	- bxSlider (`slideshow_bxslider`)
	- Content slider (`content_slider`)
	- Instagram slider (`instagram_slider`)

## 9.10.30 - 2025-06-24

- 045: Fix document automatic URL.

## 9.10.29 - 2025-06-23

- Fix URLs in search module (`search`).

## 9.10.28 - 2025-05-23

- Add contact form response filters.

## 9.10.27 - 2025-05-07

- Some images were not being converted to WebP when Automatic WebP was enabled.

## 9.10.26 - 2025-05-06

- More WebP fixes.

## 9.10.25 - 2025-05-06

- Honour the Automatic WebP setting everywhere that creates thumbnails.

## 9.10.24 - 2025-05-06

- Image thumbnail improvements and WebP fixes.

## 9.10.23 - 2025-05-06

- Add automatic WebP support from v10.
- Deploy v9 data separately for upgrading specifically to the latest version of v9.
- Improve the stability of migrations.

## 9.10.22 - 2019-10-18

### Fixed
- Updated bxSlider module (`slideshow_bxslider`) to bxSlider v4.2.12. Commented a line from the offical source to fix a bug with links in Chrome.

## 9.10.21 - 2019-09-12

### Security
- The Login module (`login`) had an XSS vulnerability.
- `X-XSS-Protection` and `X-Content-Type-Options` response headers were added.

### Fixed
- `server_basename()` would sometimes be empty.
- 019: Deleting images with media manager was not deleting thumbnails.
- `logo-placeholder.png` was accidentally removed in v6.7.0.

### Changed
- Improved high DPI image functions which will allow them to also work on Nginx.
- Simple HTML DOM library updated to v1.9.
- `csrf()` now uses the field name `csrf_token` so that it can be found by the ZAP security scanner.

## 9.10.20 - 2019-06-28

### Fixed
- A minor logic error in the Img controller.

## 9.10.19 - 2019-06-17

### Fixed
- The Content Slider module (`content_slider`) was not ignoring module placeholder images when fetching a preview image.

## 9.10.18 - 2019-06-14

### Fixed
- 016: The Content List content type (`content_list`) had incorrectly configured heading levels.

## 9.10.17 - 2019-06-11

### Fixed
- 016: The Contact content type (`contact`) had incorrectly configured heading levels.

## 9.10.16 - 2019-06-10

### Fixed
- 015: The Content with Left/Right Image content type (`content_image`) was not working due to syntax errors.

## 9.10.15 - 2019-05-29

### Security
- The Content List (`content_list`), Documents (`documents`), and Search (`search`) modules were susceptible to an XSS vulnerability.

## 9.10.15 - 2019-05-29

### Security
- The Content List (`content_list`), Documents (`documents`), and Search (`search`) modules were susceptible to an XSS vulnerability.

## 9.10.14 - 2019-04-26

### Fixed
- The Registration module (`registration`) suffered from two problems:
	+ reCaptcha v2 was not working.
	+ If the "Registered Users" role did not have public login access they would be logged in anyway.
- Fixed a function name in the Crawler controller.

## 9.10.13 - 2019-04-26

### Fixed
- The Account module (`account`) was not saving user information.

## 9.10.12 - 2019-04-26

### Fixed
- The installer was broken since v9.10.3 due to a syntax error in one of the queries.

## 9.10.11 - 2019-03-21

### Fixed
- The button for adding a new role was broken.

## 9.10.10 - 2019-03-21

### Added
- Google Calendar module (`gcal`) for embedding Google Calendars.

## 9.10.9 - 2019-03-14

### Fixed
- 015487: Some controllers, including the admin login controller, which do not inherit from `MY_Controller` were not obeying the `FORCE_SSL` constant.

## 9.10.8 - 2019-03-07

### Changed
- FontAwesome updated to v5.7.2.
- CodeIgniter updated to v3.1.10.
- PHPMailer updated to v5.2.27, the final release of the 5.2 branch. v6.0.0 "is a major update that breaks backwards compatibility."

### Removed
- `/application/third_party/class.html2text.inc` was removed because it was no longer being used.

## 9.10.7 - 2019-02-28

### Changed
- `audio` and `video` tags are always removed from the Content List module (`content_list`) and Content Slider module (`content_slider`) regardless of the "Strip HTML" option.

## 9.10.6 - 2019-02-22

### Changed
- Updated mimetypes config file to support ppsx.

## 9.10.5 - 2019-02-22

### Changed
- The document manager now supports `ods`, `pptx`, and `ppsx` files.

## 9.10.4 - 2019-02-20

### Fixed
- The Joomla importer now disables foreign key checks during import to avoid some issues.
- Typos in the `Document_tag` model.
- The document tag auto complete list was actually listing page tags. They're effectively the same thing but was corrected for clarity.

## 9.10.3 - 2019-02-06

### Fixed
- 015242: The Content List module (`content_list`) was experiencing cache issues and is now configured to include the page URL in the cache key.
- 015239: The Font Awesome icon insert tool was not filtering properly when searching for an icon.
- 015240: New modules would not save under certain conditions.

### Added
- Sitemap priority can now be specified for each page.
- 015206: The Content List module (`content_list`) can be configured to ignore each page's "searchable" flag to find all pages regardless of this setting.

## 9.10.2 - 2019-01-18

### Fixed
- The bxSlider Slideshow (`slideshow_bxslider`), Content Slider (`content_slider`), and Instagram Slider (`instagram_slider`) modules had bxSlider upgraded to v4.2.1d to resolve an issue with infinte looping.

### Added
- Facebook Open Graph tag support for pages.

## 9.10.1 - 2018-12-21

### Fixed
- 015201: The database upgrades for v9.9.0 weren't added to the installation script which caused issues saving the new reCaptcha settings.
- 015201: Some default page settings were not set correctly which caused validation issues when saving new pages.
- 015201: The "Update URL" prompt on various pages was being called twice (one for onchange and one for onblur). With SweetAlert they would replace each other and it went unnoticed. With Bootstrap modals, they stack and give the impression that the dialog is broken.
- 015201: Select lists in module settings and page settings were not correctly saving their values.

## 9.10.0 - 2018-12-04

### Removed / Manual Action
- ngAnimate support in the admin area.
- Sweet Alert has been replaced by Bootstrap. If you were using it directly, you must update your code. If you have a custom template, it probably includes a Sweet Alert CSS file and a Sweet Alert JavaScript file. Remove those references.
- Custom modules should have their settings file converted to Bootstrap. It will still function properly but its layout will be messed up until converted. The module's output should be left as-is.
- If you have a `custom_header_menu.php` defined, its format should be updated to Bootstrap cards + list group action items for consistency with the rest of the admin menu.
- Add `LABEL_COL`, `FIELD_COL`, `TOP_LEFT`, `TOP_RIGHT`, `TWO_COL`, `THREE_COL`, `FOUR_COL`, `LOADING_DATATABLES`, `ADMIN_TABLE` to `application/config/constants.php`.

### Deprecated
- PureCSS will be removed entirely in v10.0.0. All module output and stock templates will be converted to Bootstrap. Custom templates and modules will have to be converted to Bootstrap to use v10.0.0.

### Changed
- PureCSS has been replaced by Bootstrap on all admin pages.
- Many admin input fields have been improved.
- Admin "accordion" blocks have been improved.

## 9.9.2 - 2018-12-04

### Fixed
- The Menu module (`menu`) and NV Menu module (`nvmenu`) have changed URL handling slightly:
	- If the URL override is `/`, it will no longer create a broken link of `//`.
	- If the page is the site's default page, a URL of `/` will be used to avoid duplicate content.
	- If the page's URL is `/index`, a URL of `/` will be used to avoid a redunant 301 redirect when Nerivon CMS pretties up the address bar.

## 9.9.1 - 2018-11-23

### Fixed
- Shop admin section was broken due to incorrect order of function calls.

## 9.9.0 - 2018-11-21

### Removed
- Mathcaptcha is gone. Use reCAPTCHA instead.

### Fixed
- The field for reCAPTCHA Secret Key on the `User Login / Registration` content type was incorrectly linked to the Public key value.

### Added
- Site wide support for reCAPTCHA v3. Configuration settings are per-site.
	- JavaScript functions `botToken()` and `botCheck()`. See comments in `js/scripts.js` for usage information.
	- A captcha helper which contains verification functions for reCAPTCHA v2 and reCAPTCHA v3.

### Changed
- The Contact module (`contact`) and Registration module (`registration`) both support reCAPTCHA v3. If enabled, it will be used. If not enabled, reCAPTCHA v2 keys will continue to work exactly as they did before.
- The Contact module (`contact`) and Booking module (`booking`) can now be used with NO captcha at all.
- The Contact module (`contact`), Booking module (`booking`), and Registration module (`registration`) all use the new captcha helper to verify reCAPTCHA tokens.

## 9.8.16 - 2018-11-14

### Fixed
- The Documents module (`documents`), when using "group by category," now sorts by category name and then document title.
- The shop controller was not loading pages the "new way."
- `Mainframe::ModuleJS()` will no longer return an empty string, which breaks JavaScript.
- Some `User` model functions were not loading the user's ACL.

## 9.8.15 - 2018-11-05

### Fixed
- After updating past v9.8.1, the dashboard would fail to load due to a function that's not yet in memory.
- Images with spaces in their filenames would sometimes not work with the new `Img` controller.
- After accidentally trying to release v9.8.3, GIT got screwed up. This version should fix it.

## 9.8.14 - 2018-10-12

### Security
- CodeIgniter 3.x seems to have changed how they want encryption keys to be set. Keys are now generated as per the documentation. Only new installations will be affected. If you would like to manually apply this change, replace your encryption key in `application/config/config.php` with `$config['encryption_key'] = hex2bin('11111111111111111111111111111111');` and change `11111111111111111111111111111111` to 16 random hex characters. **If you are encrypting anything saved in your database, you will be unable to decrypt it if you change your key.**

## 9.8.13 - 2018-10-09

### Fixed
- The Menu module (`menu`) and NV Menu module (`nvmenu`) were breaking external links.

### Changed
- Latex PDF functions now use pdf.nerivon.ca instead of rouk.org.
- The GET variable `gclid` is now permitted all the time regardless of the "Allow Query String" setting. Google Analytics/AdWords needs it.

## 9.8.12 - 2018-09-07

### Changed
- Dashes in filenames are no longer converted to spaces in alt/title tags.

## 9.8.11 - 2018-08-24

### Fixed
- Some recent improvements to the install process completely screwed up the install process. The old function has been restored.

## 9.8.10 - 2018-08-23

### Fixed
- Apostrophies are now allowed in URLs in order to preserve images that have apostrophies in their filenames. **This change must be applied manually, if you need it.** Add `\'` to the end of `line 61` in `application/config/config.php`.

## 9.8.9 - 2018-08-16

### Fixed
- 014698: The `Img` controller's thumbnail function has been serving original sized images since v9.6.5.

### Changed
- The bulk of `retinaimages.php` has been moved into the `Img` controller since they share a lot of code. `retinaimages.php` remains as an entry point due to conflicts between `mod_rewrite` and CodeIgniter's native URL handling.

## 9.8.8 - 2018-08-14

### Fixed
- A cache key collision would sometimes cause modules to appear on pages that they shouldn't.
- 014661: The Instagram Slider module (`instagram_slider`) was still choaking on apostropies. In actual fact, it was the accessibility filtering that was causing the biggest issue.

## 9.8.7 - 2018-08-14

### Fixed
- 014661: The Instagram Slider module (`instagram_slider`) was choaking on apostropies. It also no longer caches module output since the content is pulled with PHP and not Javascript as was originally overlooked.
- 014659: A change made on May 23, 2018 which claimed to fix admin search actually broke admin search. That change was specific to one customer who was using a highly custom search. This change has been reversed.
- Saving pages, modules, and possibly other things would sometimes bring back a blank editor or other oddities due to caching issues. Several improvements to caching were added.

### Changed
- Updated to AngularJS v1.7.2.

## 9.8.6 - 2018-08-13

### Manual Action
- All custom modules and content types that use checkboxes for settings should switch to the new `angularYesNo()` function. This is not required unless you're using default values for settings, at which point problems will arise with unchecked checkboxes. This change can be made with a simple regex find/replace.

### Fixed
- 014676: All module settings and page settings now use yes/no radios instead of checkboxes because unchecked checkboxes are not sent by the browser and this screws things up.

### Changed
- The directives controller now loads the requested view using the loader instead of reading the file. This allows PHP script to function in a directive and is also more efficient.

## 9.8.5 - 2018-08-08

### Fixed
- 014667: Feral was added back to global inclusion because its convenience functions do not trigger the auto loader, so it doesn't actually work unless you actually create the classes.
- 014669: Same as 014667.
- The Menu module (`menu`) and NV Menu module (`nvmenu`) would sometimes fail to initialize because their scripts were loading `async`.
- Media Manager now recognizes gallery content types the same way it recognizes gallery modules.
- Media Manager now recognizes gallery module subfolders and displays the same note as the parent directory.

### Removed
- The original Slideshow module (`slideshow`).
- The "Image Metadata" feature has been removed. Image specific metadata can be added using Media Manager now.

### Added
- Slippry slideshow module (`slideshow_slippry`). [http://slippry.com](http://slippry.com)
- Image specific metadata can be added using Media Manager.

## 9.8.4 - 2018-08-03

### Fixed
- A couple typos caused a module caching issue.

## 9.8.3 - 2018-08-03

### Fixed
- Saving shop products, categories, etc were not clearing caches when saving.
- All cache checks were modified to prevent occasional false negatives due to PHP loose boolean checks.

### Changed
- Lots more query caching was added.
- All cache TTLs were changed to 1 day because there isn't really any reason not to. Caches are continually invalidated when data changes.

## 9.8.2 - 2018-08-02

### Fixed
- A couple areas of the admin area were not clearing caches when saving. This caused problems with v9.8.1 caching all list queries.

## 9.8.1 - 2018-08-02

### Manual Action
- If you are using any of the global variables mentioned below, you need to replace them with the appropriate `Mainframe` getter function.
- If you are using the PHP version of Recaptcha (`recaptchalib.php`) you need to update to the newer Javascript/cURL code.

### Removed
- All access to the global variables `$site`, `$template`, `$page`, `$page_id`, `$page_name`, and `$module_js` have been removed.
- The PHP Recaptcha library, `recaptchalib.php`, was removed.
- It was possible to override the current template by passing `template_id` to any page. This no longer works after tightening the query string acceptance rules.

### Changed
- The `$module_js` used by the admin area is now cached.
- All admin area lists are now cached.
- PHPMailer, LESS, and Feral were removed from global inclusion and are now automatically included when needed using the autoloader.
- The Mainframe now has an admin-specific `init()` function which skips certain functionality only required on the front end.
- The Mainframe now prevents being reinitialized, which would just be a waste of time.

## 9.8.0 - 2018-08-01

### Manual Action
- Ensure that any custom modules specify any required cache options. Caching is enabled by default and default options are used, but may not be ideal for every module. See below.

### Added
- All modules now utilize output caching. Each module can configure certain cache options or disable caching entirely. Currently this uses file caching since it doesn't require a caching server. Saving just about anything in the admin area will invalidate the entire cache to avoid any changes not being seen immediately. The default cache time is 5 minutes but modules can override this if desired.

### Changed
- The Gallery module (`gallery`) and Nivo Slider module (`slideshow_nivoslider`) now use proper view files.
- Updated to CodeIgniter v3.1.9.

## 9.7.1 - 2018-07-30

### Manual Action
- `.htaccess` has changed. Make sure this file gets updated properly.

### Fixed
- Thumbnails were not being deleted when uploading new photos to a content type.
- The category layout of the Documents module (`documents`) was not formatting the "Uncategorized" section properly.

### Changed
- The `MOD_SENDFILE` constant was removed in favour of automatic detection of `X-SendFile` support. If its available it will be used.

## 9.7.0 - 2018-07-11

### Changed
- nvForm validation library is now included in the admin area. It can be applied to any form by adding the class `nvForm`.
- The password reset process has changed. The user is now emailed a password reset code which must be entered on the form in order to reset their password.
- The login and password reset forms now use nvForm validation and no longer require Feral Form Widgets.
- All admin forms now use nvForm validation.
- The `generatePassword()` function can now be passed a custom alphabet to use for the password. For example, if you wanted to create a numeric PIN.
- All of the custom WYSIWYG insert dialogs have been sized consistently.

## 9.6.5 - 2018-07-06

### Fixed
- The Content List module (`content_list`) and Content Slider module (`content_slider`) were trying to use original images for resizing their own copies but were not modifying the path properly.
- The Content List module (`content_list`) was cropping images even if cropping was disabled.
- Images served by the Image controller (`/img/h/w/crop?src=path`) were not serving high DPI images when required. They now serve images exactly the same way `/retinaimages.php` does, with cache headers and high DPI when required.

## 9.6.4 - 2018-07-04

### Fixed
- A trailing slash was missing from the Matomo tracking code.

## 9.6.3 - 2018-07-04

### Fixed
- 009165: The nvFinder crop tool now suggests 1280x1024 as the crop size for Gallery (`gallery`), Galleria (`galleria`), and BX Slider (`slideshow_bxslider`) modules.

### Changed
- All URLs were audited to ensure they contained a leading slash, for user agents that don't seem to understand the `<base />` tag. Many modules and views were updated.
- All references to "use the page URL if it exists, otherwise `/page#`" have been removed, since page URLs have been required for a long time now.
- Most uses of `current_url()` have been replaced with `Mainframe::page()->url` because a full absolute URL was not required. Shorter links mean less bytes.
- The dashboard now shows a link to Google Analytics if Matomo is not configured but Google Analytics is.

## 9.6.2 - 2018-07-03

### Fixed
- The Gallery module (`gallery`) was cropping full size images instead of showing them in all their glory.

## 9.6.1 - 2018-07-03

### Changed
- Improvements to the new dashboard stats:
	- Now shows 6 months of stats instead of 1.
	- Now includes information about returning visitors.
	- Average time on site is now formatted nicely.
	- There's a pretty line chart again.
	- Formatting of each block has been improved.

## 9.6.0 - 2018-06-29

### Fixed
- The admin area no longer allows duplicate usernames or email addresses to be used. Additionally, database constraints were added to enforce it.

### Added
- Modules can now be installed on the "main page only" in addition to the existing options.
- Matomo analytics on the dashboard. https://matomo.nerivon.com

### Removed
- Internal stats are gone. They were useless.

## 9.5.3 - 2018-06-27

### Added
- The admin area now has a menu option to view the error log when logging errors to a file (`/error_log` or `/application/logs/error_log`). When the error log exists, an icon is added to the top menu bar. This is where all PHP errors and Nerivon CMS error messages go when `ENVIRONMENT` is `development`. There is also an option on that page to nuke the error log.

## 9.5.2 - 2018-06-27

### Fixed
- Some icons were fixed in the Instagram Slider module (`instagram_slider`).
- The Instagram Slider module (`instagram_slider`) now supports multi-photo posts.

## 9.5.1 - 2018-06-25

### Fixed
- It was possible to create more than one page per-site with the same URL. Trying to do so now will append a count to the URL until it becomes unique.
- The pages list was not applying content type or category filters on initial page load.

## 9.5.0 - 2018-06-22

### Fixed
- The updater would sometimes crash trying to free memory from query results.
- The changelog for v9.1.0 now includes a Manual Action.

### Changed
- Errors are no longer eaten by CodeIgniter and should be properly logged to the default location.
- The "development" `ENVIRONMENT` setting no longer displays errors. Errors are always logged instead. Setting the `ENVIRONMENT` to "production" disables logging. This lets you enable logging while troubleshooting without displaying a bunch of junk to visitors.
- Logging is ALWAYS enabled during installation and upgrading.

### Added
- Lots of log messages were added to the "start up" functions, install functions, and update functions. It should be trivial to determine why a site isn't loading now, why its landing page is showing up, or exactly where an install/upgrade failed.

## 9.4.5 - 2018-06-21

### Fixed
- 014432: Duplicating modules was never actually broken, it just appeared so if the LESS file didn't exist. Checks have been added.

## 9.4.4 - 2018-06-21

### Fixed
- 014432: Duplicating a module was referencing an incorrect path when copying files.
- 014434: Saving a page or module with a blank tag IDs setting would create a blank tag filter and break some filters.

### Changed
- FontAwesome updated to v5.0.13.

## 9.4.3 - 2018-06-06

### Fixed
- Fixed a resource hogging issue in the update controller.

## 9.4.2 - 2018-06-06

### Fixed
- 014384: The Menu (`menu`) and NV Menu (`nvmenu`) modules would miscalculate the menu item widths when submenus were in use.
- 014384: The Menu module (`menu`) was throwing a Javascript error. It did not appear to affect functionality.
- The admin pages list was not properly filtering by content type or category.
- The update controller was not completely backwards compatible with `v6.0.0`.

### Changed
- The update controller has been improved for better reliability when queries fail.
- It is now possible to update to a specific version of Nerivon CMS using the URL `/update/##.##.##`.
- SQL patch files are no longer named `update-##.##.##.sql` but rather `##.##.##.sql` like the online patches and other projects.

## 9.4.1 - 2018-06-01

### Fixed
- The Menu (`menu`) and NV Menu (`nvmenu`) modules have been revamped for performance and the "more menu delay bug" has finally been killed.

## 9.4.0 - 2018-06-01

### Manual Action
- This update **will break some pages** if you do not read this. Any pages that have modules on them which require additional URL segments or query strings need to be flagged to allow them to be passed through. If using the corresponding content types, this should be done for you already but you need to verify it. Some modules that require additional URL segments include Events (`events`) and Directory (`directory`). Some modules that require query strings include Login (`login`), Registration (`registration`), Gallery (`gallery`), Content List (`content_list`), Search (`search`), and others.
- Check all areas of all pages to ensure that pages requiring extra URL segments or query strings have been given permission to accept them.

### Changed
- Pages will no longer allow additional URL segments and query strings to be accepted "in case they're needed" by a module on the page. These pages must now be explicitly flagged to "Allow URL Segments" and/or "Allow Query String" on the page edit screen. See **Manual Action** above.
	+ Any pages with additional URL segments attached (ie: `/valid-page/extra/junk`) which have not explicitly been flagged to accept this will now return a 404 error, as it should. Any pages that depend on accepting additional URL segments must be flagged to accept them.
	+ Any pages with a query string attached (ie: `/valid-page?variable=value`) which have not explicitly been flagged to accept this will now create a 301 redirect back to the main page. This helps reduce garbage URLs in Google Search/Analytics.

## 9.3.8 - 2018-05-31

### Changed
- The content pages list now searches deeper within the page data, including custom fields.

## 9.3.7 - 2018-05-24

### Fixed
- The Video module (`video`) was referencing a script from the old `video_html5` directory.

## 9.3.6 - 2018-05-24

### Fixed
- The Accessibility (`accessibility`) and Announcement (`announcement`) modules relied on a Javascript function `setCookie()` that was only available if the main scripts file was included. They now set cookies without relying on this function.

## 9.3.5 - 2018-05-23

### Fixed
- v9.3.4 broke an important function in the Document model.
- Page and document links in the Search module (`search`) were broken.

## 9.3.4 - 2018-05-23

### Fixed
- New modules that had tag lists as a module setting would start with a blank tag entry.

### Added
- Documents can now be tagged.
- A default value can now be provided when requesting a module setting that isn't defined. This is most useful for backwards compatibility with modules which have not yet saved newly added settings.
- The Content List module/content type (`content_list`) and Content Slider (`content_slider`) module now support choosing "AND" logic instead of "OR" logic (the default) when multiple tags are selected.
- The Search module/content type (`search`) and Documents module/content type (`documents`) now support filtering by tags, including the new AND/OR logic selection.

## 9.3.3 - 2018-04-26

### Changed
- The thumbnail function now returns `memory_limit` to its original value when done.
- More optimizations to the thumbnail function.

## 9.3.2 - 2018-04-25

### Fixed
- The new image thumbnail controller would sometimes not process the URL properly.
- The new image thumbnail controller can now be passed zero for the crop value in order to disable cropping.

### Changed
- The thumbnail function has been optimized.

## 9.3.1 - 2018-04-24

### Fixed
- The "link first image" setting of the Content Slider module (`content_slider`) was incorrectly named and therefore not working.
- ngQuickDate calendar icons were broken.

### Added
- Images can now be loaded using `/img/width/height/crop?src=url_encoded_image_path` to generate thumbnails on the fly instead of before the page starts loading.
- The Gallery module (`gallery`), Content List module (`content_list`), and Content Slider module (`content_slider`) now use a "lazy load" display since they take longer to generate a thumbnail now. This isn't a true "lazy load" just a visual one. More stuff will use this going forward and it will likely become a true lazy load.
- A hidden image cleanup function was added to the admin area that does a rather good job (but probably not perfect) of finding unused images and deleting them.
- `Mainframe::page()` now gives access to the current page without using `global $page;`.

### Changed
- The thumbnail function will now crop to the required aspect ratio even if the source image is too small.
- The thumbnail function no longer tries to guess at existing JPG compression and will always compress at 85%. The guessing required too much time.

## 9.3.0 - 2018-04-19

### Manual Action
- Ensure that if you're using `header_custom_menu.php` that it conforms to the new menu format. This should be as easy as removing the accordion classes and the extra div around your fieldset (both of which may have zero impact if left as-is).

### Changed
- The admin area sidebar has been removed in favour of a top slide down menu. The sidebar was causing performance issues.
- The Content List module (`content_list`), Content List content type, and Content Slider module (`content_slider`) now support filtering by multiple tags.

### Removed
- The admin search tool has been temporarily removed. It was found to not be working and needs a layout revamp. It will return in a future version.

## 9.2.4 - 2018-04-19

### Added
- The Content Slider module (`content_slider`) now supports filtering by a tag.

## 9.2.3 - 2018-04-18

### Fixed
- The Search module (`search`) has lots of fixes/changes:
	+ Document links didn't work.
	+ Page links worked, but really shouldn't have.
	+ A new option is available to "site lock" results to the current site.
	+ Individual pages can now be excluded from search results (ie: search pages).
- The Content List module (`content_list`), Content Slider module (`content_slider`), and Documents module (`documents`) were only site locked if a category filter was applied. They are now always site locked.

## 9.2.2 - 2018-04-17

### Fixed
- Lots of prefixes for Font Awesome 5 were added to CSS files.

### Changed
- All references to the `fa` class were replaced with `fas` which is what they essentially fall back to anyway.

## 9.2.1 - 2018-04-11

### Fixed
- 014099: Adding a document through the "insert document" dialog would not let you enter a description.
- Media Manager column widths in a dialog were sometimes messed up.

### Changed
- 014140: All use of CodeIgniter's `form_validation` helper have been removed due to suspected bugs.
- 014147: The Gallery module (`gallery`) will now look 4 levels deep for a thumbnail instead of 2.
- Some icons that are available as "regular" were changed.
- Most trash icons had broken HTML.

## 9.2.0 - 2018-04-06

### Manual Action
- Some Font Awesome icons have changed. They should have been upgraded automatically but you need to verify that none of your selected icons have been broken (ie: Contact Information module (`contact_info`)).
- If you are manually including Font Awesome 4 in your template (which you almost certainly are) you should remove it.

### Fixed
- The "combine CSS" feature was redundantly including some of the non-combined CSS files.
- Resolved some issues when filtering a Content List module (`content_list`) by a tag.
- Fixed a PHP warning in the Content List module (`content_list`) when displaying search results.

### Changed
- Updated to Font Awesome v5.0.9 (free). For the most part this just replaces each icon with its "solid" counterpart.
- Its possible to choose which version of Font Awesome to load (none, free, or pro), however, **each client requires their own license to use pro and they must configure their domain name in their Font Awesome account.**
- Attempting to load Font Awesome Pro without the correct licensing in place will silently return a 403 response and break all icons.
- Although a manually inserted pro icon will display properly in the WYSIWYG editor, the insert icon dialog currently only supports the free icons.

## 9.1.7 - 2018-03-29

### Fixed
- The new loading overlay was modified to fix a performance issue.

### Added
- Content type page fields now support data URI "uploads" for JPG and PNG. They will be processed and then handled the same way regular file uploads are handled.

## 9.1.6 - 2018-03-27

### Fixed
- ngQuickDate support was not including its CSS file.

## 9.1.5 - 2018-03-20

### Removed
- Some old unused files were removed from `/inc`.

### Changed
- Module insertion no longer depends on Simple HTML DOM, so it was removed.

### Added
- A new constant, `MOD_SENDFILE`, if defined and set to true will use X-SendFile headers to send files instead of `readfile()` for better performance.

## 9.1.4 - 2018-03-19

### Fixed
- The new version of Simple HTML DOM was doing lots of HTML "cleanup" that was breaking things.

## 9.1.3 - 2018-03-16

### Changed
- A few more minor performance improvements.

## 9.1.2 - 2018-03-15

### Fixed
- A regular expression in v9.1.1 would break sites that had "Combine CSS Files" enabled.

### Changed
- "HTML5 compatibility" is now off by default for new installations. Most of what that includes is for Internet Explorer 9 and older. It also includes jsWebshim, which primarily makes date inputs work but is end of life and seems to be causing issues with form validation on Safari and all Microsoft browsers.

## 9.1.1 - 2018-03-15

### Added
- Added ngAnimate and ngQuickDate support in the admin area.

### Changed
- More minor performance improvements.

## 9.1.0 - 2018-03-14

### Manual Action
- All local copies of Pure CSS (`pure.css`, `pure-latest.css`, their related grids files, and their related minified files) have been removed and replaced with Pure CSS v1.0.0 from CDN. If you are referencing either of these in your template, you should update to the following to avoid any conflicts:
	+ `<link rel="stylesheet" href="https://unpkg.com/purecss@1.0.0/build/pure-min.css" integrity="sha384-nn4HPE8lTHyVtfCBi5yW9d20FjT8BJwUXyWZT9InLYax14RDjBj46LmSztkmNP9w" crossorigin="anonymous">`
	+ `<link rel="stylesheet" href="https://unpkg.com/purecss@1.0.0/build/grids-responsive-min.css">`

### Fixed
- The Menu module (`menu`) and NV Menu module (`nvmenu`) would sometimes cause scrolling to jump around on mobile devices.
- Stats model constants were not loading properly and therefore throwing PHP notices.

### Added
- A new option to automatically display a loading overlay while front end pages are loading.
- A new option to explicitly set the default page for a site.
- A new option to show modules on all pages except the default page.

### Changed
- Updated to Pure CSS v1.0.0.
- Updated to CodeIgniter v3.1.7.
- Updated to Simple HTML DOM v1.5 Rev 196.
- Various minor performance improvements were made to the initialization functions.

## 9.0.4 - 2018-02-21

### Fixed
- The IP address country check now has a 3 second timeout in case the service goes down or bans our IP.
- 013482: CSS from modules used in content types (ie: gallery) were not properly processing the CSS if the "combine CSS" option was set.
- The image thumbnailer now checks if `exif_read_data()` is available before trying to use it, and also only tries to use it on JPG files.
- Installing a content list for "All Categories" would not set ACL correctly due to a failed query.
- Removed a PHP warning in the admin sidebar.

### Changed
- 013355: Unless the `exact` option is set, the truncate function will extend up to 10% of the character limit before or after the chopping point if it can end a sentence cleanly. *This can and probably will cause periodic issues with closing HTML tags properly.*

## 9.0.3 - 2018-01-30

### Fixed
- Versioning between v9.0.1 and v9.0.2 got messed up. This version should resolve things.

## 9.0.2 - 2018-01-23

### Fixed
- It was possible to download documents that were not published.
- URLs with a file extension or a query string would not work as redirects.

## 9.0.1 - 2018-01-12

### Fixed
- Payment gateway configuration values that contained an equal sign would not work.
- 013725: The "more menu" in the Menu Module (`menu`) would close when scrolling on mobile browsers.
- 013656: When changing environments the menu item would not update until another page load.

### Changed
- Shop orders are now saved regardless of payment status. Before they were only saved if the payment was successful.
- PayPal payment gateway was improved.
- PHPMailer was updated to version 5.2.25.

### Added
- Contact form responses are now stored in the database.

## 9.0.0 - 2017-08-30

### Manual Action
- The shop section has changed dramatically. If you're using the shop, please test the upgrade on a backup copy first.
- Any custom payment gateways must be updated to set the order's `paid` field to `1` upon successful payment.

### Deprecated
- Internet Explorer 8 Pure CSS grids are no longer supported by the default templates. If you require Internet Explorer 8 support, add the conditional Pure CSS grids code to your template and disable the combine CSS feature.

### Fixed
- Many improvements to the checkout process and various shop modules.
- 012843: Product images were deleting properly but the corresponding user interface was messed up.
- The Shop Category module (`shop_category`) has been greatly improved.
- The Shop Category module (`shop_category`) now creates thumbnails when required.
- The product list always showed "no image."
- Saving products had no confirmation message displayed.
- Batch product functions now properly refresh the product list and show a confirmation of success.

### Added
- "Product Variants" allow you to specify variations of a product (sizes, colours, etc). Each variant is product specific and can have a specific price per shopper group.
- Products can be "quick viewed" if the product layout utilizes it.
- Shipping and payment gateways must define a `qualifies()` function that allows each gateway to predetermine if they should be displayed as a choice or not. In most cases, this will be cart-dependent but in some cases you may know ahead of time that a gateway doesn't apply to the situation.
- Orders are now explicitly marked as paid or not paid. Any custom payment gateways must be updated to set the order's `paid` field to `1` upon successful payment.

### Changed
- All product prices are handled in the `shop_prices` table. The upgrade script should take care of this change for you.
- Updated to CodeIgniter v3.1.5.
- The product edit form's tabs were replaced with nvTabs.
- Product images are now automatically cropped to the aspect ratio required by the category or product layout.
- The product list now shows a price range based on product variants and shopper group prices.
- User data now includes a phone number and default shipping address.
- Order summaries have been vastly improved.
- The Account module (`account`) was updated to reflect additional shipping fields.

## 8.9.6 - 2017-08-30

### Manual Action
- Verify that the "primary domain" for each site is set correctly. If you're using multiple sites **all but one of those sites will be set incorrectly**.

### Fixed
- 013105: The Search module (`search`) would sometimes link to the wrong site in a multi-site installation.

### Added
- Sites now have a "primary domain" which gets used when determining the domain to create links with.

## 8.9.5 - 2017-08-25

### Changed
- JPG thumbnails which are requested at the same size as the original image will now return the original image to avoid loss of quality.
- The image optimization function now guesses at the original JPG compression level again. Turns out this was important logic to avoid optimizing JPGs that didn't need optimizing.
- JPG thumbnails are always saved at the same approximate JPG compression as their original file. If the original file was optimized by GD, this should not cause any quality loss.

## 8.9.4 - 2017-08-24

**This update will take a long time if you have lots of stats accumulated.**

### Changed
- The `stats` table has been revamped for more efficiency.
- The "stats by hour" graph has been removed due to performance issues.

## 8.9.3 - 2017-08-24

### Fixed
- The upgrade script for v8.9.0 was incorrectly named. Its content has been pushed forward to v8.9.3 so that it will get run with this update.
- The Account module (`account`) was not updating user information due to an incorrect variable reference.

### Changed
- The internal stats logging should now ignore common bots.

## 8.9.2 - 2017-08-23

### Changed
- A space was added between tags in the minifier because we've sort of come to assume it would be there, and its a lot of work to add proper margins to everything we've ever built.

## 8.9.1 - 2017-08-23

### Fixed
- One of the recent optimizations broke the shop section.

## 8.9.0 - 2017-08-23

### Manual Action
- The new feature to combine all CSS is enabled by default. Verify that nothing is broken after upgrading. If problems arise, disable the feature using the site configuration screen.
- If you have conditional comments for loading PureCSS grid files (which you almost certainly do) you need to drop support for Internet Explorer 8 and simply include the normal grids file. Otherwise you must disable the combine CSS feature.

### Fixed
- If an image was not large enough to create a high DPI copy the thumbnail function would continually generate the thumbnail every time it was requested. The high DPI copy's existence is now ignored.

### Added
- Sites now have an option to automatically combine **all** CSS files found in the generated markup of each page. These files are fetched (local or remote), optimized, and cached.

### Changed
- The multiple non-breaking space removal was re-enabled.
- The image optimization feature no longer cares what JPG quality an image was previously saved at. It will save everything at 85%. Doing so multiple times should have no effect. If loss of quality occurs, save the JPGs at a higher quality before uploading and let the website do the dirty work.
- Several minor optimizations were made.
- The Login module (`login`) and Registration module (`registration`) got visual improvements.

## 8.8.17 - 2017-08-16

### Fixed
- The non-breaking space removal actually breaks things so it has been disabled for now.

## 8.8.16 - 2017-08-16

### Fixed
- A merge conflict disabled stats on the admin dashboard.

## 8.8.15 - 2017-08-16

### Fixed
- Resolved some potential memory leaks in the new image optimization function.

### Changed
- The new image optimization function was modified to use `readdir()` instead of `glob()` or `scandir()` because it would crash on massive directories.
- The new image optimization function now obliterates the `/images/thumbnails` directory before running. Anything using this directory should be recreated automatically.
- The thumbnail function now uses the same "optimized JPG" logic to warrant a reasonably good guess as to which images should be compressed at 85% or left alone at 100%.
- Generated PNG files are no longer interlaced as it seemed to just increase file size.
- Generated PNG files are all generated with the `PNG_NO_FILTER` flag. Not sure what exactly it does aside from making the file sizes on par with Google's suggestions.
- HTML is now minified. Only whitespace between tags is removed, but that covers most of it.
- Multiple non-breaking spaces are now replaced with a single non-breaking space.

## 8.8.14 - 2017-08-16

### Fixed
- The jQuery UI theme was including a non-minified CSS file.

### Added
- A function for optimizing all JPG and PNG images.

### Changed
- All generated PNG images are now saved with maximum compression (lossless).
- Module settings can now specify a `_width` and `_height` for a corresponding image, just like content types.
- Content types and module settings can now specify a `_crop` value to enable or disable cropping on the corresponding image. Use `0` to disable cropping. If omitted, the original aspect ratio is used.

## 8.8.13 - 2017-08-11

### Fixed
- The dashboard stats were incredibly slow when there were several million stats to chew through.

### Added
- The Social module (`social`) and Contact Form module (`contact`) had Tumblr added.

## 8.8.12 - 2017-08-04

### Changed
- The Shippo shipping gateway was improved.
- The Account module (`account`) got a cosmetic change.
- Feral was updated for PHP 7 compatibility.

### Added
- Instagram Slider module (`instagram_slider`). Displays a user's Instagram feed in a bxSlider.

### Removed
- All database caching has been disabled. It caused more problems than it solved.

## 8.8.11 - 2017-06-27

### Fixed
- 012794: The tags input on the page edit screen would sometimes not initialize properly.

### Changed
- 012768: "Invalid Answer" changed to "Invalid Captcha Response" in the Contact module (`contact`) and Booking module (`booking`).

## 8.8.10 - 2017-06-23

### Fixed
- Sometimes the "content below" in the NV Menu module (`nvmenu`) would show a zero.
- Deleting an ACL Role was not working.
- Category links in the Documents module (`documents`) were broken.

## 8.8.9 - 2017-06-19

### Fixed
- 012704: The NV Menu module (`nvmenu`) had its search field renamed back to just `q` for reasons we won't elaborate on.

## 8.8.8 - 2017-06-19

### Fixed
- The Search module (`search`) would fail to match documents if their descriptions were NULL.
- Mainframe counting and loading modules was not accounting for the current user's ACL.
- Some links in the Documents module (`documents`) were potentially broken and also throwing PHP notices.
- 012704: Several modules had conflicting use of a `q` search field causing them all to respond to any search in any module.
- 012659: Crop settings for regular articles in the Content List module (`content_list`) were using crop settings from featured articles.
- 012581: The Documents module (`documents`) was including unpublished documents in the category counts.
- 012658: Duplicate documents, categories, etc were sometimes shown on the module and page edit screens.

### Changed
- The Documents module (`documents`):
	- Can now be sorted by category name.
	- Can now be grouped by category name, similar to grouping alphabetically.
	- Some link issues were fixed.
	
### Added
- Its now possible to include a document selector on a content type admin form.

## 8.8.7 - 2017-05-19

### Fixed
- 010604: URL redirect close button wasn't going anywhere in some situations.
- 010603: Resolved an issue where redirects would not work if the domain was not determined properly. Also improved the `site_id` detection process even when the domain detection fails.

## 8.8.6 - 2017-05-15

### Fixed
- 010591: The Media Manager document upload had some ACL issues when creating new documents.
- 010591: Performing actions on a file in Media Manager when the file list was filtered would act on the wrong file.
- Product URLs in the "related products" section had incorrect URLs.

### Changed
- 010590: The search module (`search`) had the `pure-button-primary` class added to all its buttons.

## 8.8.5 - 2017-05-09

### Fixed
- 010551: The `truncate()` function was updated with a copy from CakePHP 3.4.6 along with several supporting functions. This resolved an issue where text could get truncated inside an HTML anchor tag.

### Added
- 010551: The Content List module (`content_list`) has an option to always disable read more buttons regardless of any other influencing factors.

## 8.8.4 - 2017-05-09

### Fixed
- 010548: Documents List content type was missing the module option for "Show Uncategorized Documents."

## 8.8.3 - 2017-05-05

### Fixed
- 010548: The Documents module (`documents`) was sometimes not linking to categories properly and was sometimes showing all categories as open folders.

## 8.8.2 - 2017-05-03

### Changed
- 010539: The Content List module (`content_list`) no longer forcefully shows a read more button when a URL override is set. Its up to the user to ensure that "Always Show Read More Buttons" is set or "Do Not Link Titles" is not set.

## 8.8.1 - 2017-04-28

### Fixed
- 010516: Hours of Operation module (`hours`) was improperly showing Saturday status on Friday.
- 010509: Media Manager's search was not working.

### Changed
- Updated to CodeIgniter v3.1.4.
- All edit and delete icons in the admin area now have fixed width icons (`fa-fw`) to make them square.

## 8.8.0 - 2017-04-27

### Fixed
- GD would sometimes not properly load JPG images that were slightly corrupt. A `php.ini` flag was set to ignore this.
- Saving a content type with images that had sizes would think there was an image set if only the sizes were present.
- The Registration module (`registration`) had two reCaptcha public key settings, instead of a public and private.
- 010506: 5/12ths was added to several module grid sizes.
- 010505: Duplicating a module was giving an access denied error. Also the module's LESS file was not being duplicated.

### Added
- 010477: Accessibility improvements
	- `aria-label` was added to some modules where appropriate.
	- `aria-hidden` was added to all Font Awesome icons.
	- `hidden` spans were added beside some Font Awesome icons where no text was present (screen reader text).

## 8.7.11 - 2017-04-13

### Fixed
- Changing a page's URL was causing a database error due to a bug in v8.7.9.

## 8.7.10 - 2017-04-10

### Fixed
- Page published state was not working properly when using start publishing and stop publishing dates.

## 8.7.9 - 2017-04-10

### Fixed
- 010393: The "Module Selection" block on the page edit screen was not properly filtered by site ID.
- 010404: Search results were not properly filtered by site ID.
- 010398: Additional checks were added to avoid accidentally creating a cyclical redirect.

## 8.7.8 - 2017-04-03

### Fixed
- Missed a few minor details in v8.7.7.

## 8.7.7 - 2017-04-03

### Fixed
- The Menu module (`menu`) had issues with its "more" menu. The jitter-free loading technique was modified for a smoother load.
- The NV Menu module (`nvmenu`) jitter-free loading technique was modified for a smoother load.

## 8.7.6 - 2017-03-28

### Fixed
- 010316: Saving an existing document was resetting the created date to zeros.

## 8.7.5 - 2017-03-27

### Fixed
- Fixed some PHP warnings on the admin dashboard immediately after installation.
- Forgot to update the table schema installation after v8.7.4.
- 010293: The menu module (`menu`) and NV Menu module (`nvmenu`) "more menus" were sometimes showing up when not actually needed.

### Changed
- The retina images script no longer erroneously sends a `content-disposition: attachment` header.
- Media Manager no longer shows a list of ACL for documents because its too long and screws up the layout.
- 010296: Columns added to the documents list.
- 009782: Double clicking an image or link no longer opens the default image/link dialogs that were replaced with custom dialogs. At a later date, hopefully double clicking images/links will open our custom dialogs.

### Added
- Documents in the Documents module (`documents`) can now be grouped by year or alphabetically, just like the Content List module (`content_list`).
- 010270: Media Manager and the Documents module (`documents`) now support PDF previews when ImageMagick is available.
- 010296: Media Manager now has a search function that will filter down files in the current directory.

## 8.7.4 - 2017-03-13

### Fixed
- 010185: The Accessibility module (`accessibility`) font family control was not working properly.
- 010186: Some subdirectories were not showing up as choices for any module settings which allow choosing a directory.
- Save and Continue on a menu item was not returning to the correct page.

### Changed
- Menu items can now have a description that gets utilized by the NV Menu module (`nvmenu`).
- The NV Menu module (`nvmenu`):
	- Updated to the newer module structure so that view overrides can be used.
	- Displays a menu item's description (if available) in place of the "content below" setting. When no menu item description is available the default "content below" will be used.
	- Can be configured to remove the link on the overlay menu title.

## 8.7.3 - 2017-02-28

### Fixed
- 010144: The Documents module (`documents`) was broken due to `Document->loadDocumentCategories()` that never got properly merged.

### Added
- 010036: The Documents module (`documents`) now has an option to show or not show the list of other categories. When the categories aren't shown, neither is the selected category title.

## 8.7.2 - 2017-02-16

### Fixed
- Minor bug in v8.7.1.

## 8.7.1 - 2017-02-16

### Added
- 010028: CSS and JS inclusion order from modules can now be better controlled for page speed by adding `<!--CSS-->` and `<!--JS-->` in your template where you want each type of file included. CSS should be included after all of your CSS includes and JS should be included before `</head>`. If you do not update existing templates the previous method will be used.

## 8.7.0 - 2017-02-16

### Fixed
- Dashboard charts would be broken immediately after an installation because there was no data yet.

### Added
- 10002: Menu links can be added in bulk for all pages not already on a specific menu.

### Changed
- 009996: The pages drop down list on the menu item screen is now grouped by category.
- 009996: Saving a menu item without a page or URL will set the URL to `#`. Selecting a page when the URL is `#` will remove the URL override when saved.
- The install verification methods have been revamped such that only certain critical issues will cause a failed installation. Other checks that don't add up will be displayed as warnings but the installation will succeed.

## 8.6.14 - 2017-02-16

### Fixed
- More style fixes for the Accessibility module (`accessibility`).

### Changed
- 010015: The Content List module (`content_list`) now supports a "plain" paragraph heading level.
- The Documents module (`documents`) now has the ability to group by categories.
- The Content List module (`content_list`) can now be grouped by document year.

## 8.6.13 - 2017-02-14

### Fixed
- The `FORCE_SSL` redirect now uses a 301 response instead of the CodeIgniter default of 307.
- Minor style fix to the new Accessibility module (`accessibility`) translate link.
- Saving a portfolio content type without providing an image would erase the existing image.
- The broken link crawler has been improved slightly.

## 8.6.12 - 2017-02-13

### Fixed
- Fixed a JavaScript error with the recent changes to the Accessibility module (`accessibility`).

### Added
- New module: Hours of Operation (`hours`). Shows a time-specific analysis of a company's open/closed status. ie: "Open until 5:00 today."

### Changed
- Minor modifications to the default product layout schema tags.

## 8.6.11 - 2017-02-10

### Changed
- The Accessibility module (`accessibility`) has changed:
	- Much simpler choices of fonts, colours, and text sizes.
	- Google Translate is now a plain link that opens in a new tab.
	- Now uses a single JSON encoded cookie instead of several cookies.

## 8.6.10 - 2017-02-09

### Added
- The Documents module (`documents`) now has options for number of columns and pagination.

## 8.6.9 - 2017-02-08

### Fixed
- The Menu module (`menu`) and NV Menu (`nvmenu`) were not showing the "more" menu on page load when there were too many menu items.
- The menu overlay for NV Menu (`nvmenu`) was given a default colour for sites which are using the "none" theme.

## 8.6.8 - 2017-02-02

### Changed
- Modules which contained LESS functions that were dependent on having a colour theme were changed such that those specific rules are now conditional. This is because the `none` colour theme uses `inherit` for the colours, which fails when used in a function that expects a colour.
- `common.less` `.column` padding changed from left to right because that's how it should have been.

## 8.6.7 - 2017-02-02

### Fixed
- The update controller was not applying ACL to documents that it created during downloads-to-documents conversion.
- The documents list was not showing uncategorized documents.
- Forgot to update `install-tables.sql` after v8.6.4.
- 009863: Shop order statuses in the admin area were not updating.
- 009782: Saving a "content with image left/right aligned" page without providing an image would erase the existing image.
- 009782: When editing a page, sometimes the WYSIWYG editor would attempt to be loaded twice.
- High DPI image script was causing an XMLHttpRequest warning due to being called synchronously.
- Removed 4 lines of SQL from the v8.0.0 update that were causing errors.

## 8.6.6 - 2017-01-26

### Changed
- Shop orders now use the order ID as the order number.

## 8.6.5 - 2017-01-20

### Fixed
- Found a few places where cURL was not being closed after use.
- Found a few places which were still using `file_get_contents` on URLs instead of cURL.
- Search module (`search`) was half-baked after recent changes that were not fully applied.
- Found an unclosed `<div>` at the end of the admin footer.
- Shop shipping rates were pulling cached data after updating your cart.

## 8.6.4 - 2017-01-16

### Security
- Updated to PHP Mailer 5.2.22 to resolve an important vulnerability.

### Changed
- `LIVE_SITE` and `ABSOLUTE_PATH` now use more reliable methods of being determined. `ABSOLUTE_PATH` no longer depends on PHP `$_SERVER` variables, which allows functions to be run on the command line without path errors.
- Page content was changed from `TEXT` to `LONGTEXT` to avoid ever having a max length issue ever again.
- 009709: Blockquote style updated because Lea said so.
- 009752: Enough clients were asking that documents open inline instead of forcefully downloading so this has been added as a per-document option, with the default being inline.
- The generic search module (`search`) now includes shop products.

### Fixed
- Running on the command line was not working properly using CodeIgniter's `index.php controller function params` syntax, which broke cron jobs.
- Fixed an ACL issue when saving documents.
- 009710: Unchecked checkboxes on content types were not saving as zero.
- 009711: Empty tags will no longer be added erroneously and duplicate tags will no longer be allowed.
- 009745: The registration module was not completely configuring new users due to an error. It was also not sending new users an email confirmation.

## 8.6.3 - 2016-12-22

### Fixed
- Front-end login was not working for certain users.

### Changed
- Ajax functions for `simple()` and `complex()` are now `protected` instead of `private` so that the class can be useful when inherrited.

## 8.6.2 - 2016-12-20

### Fixed
- jQuery's `swap()` function was manually defined in `admin.js` for compatibility with `js-webshim`. It seems that some versions of jQuery break or omit this function.

## 8.6.1 - 2016-12-20

### Added
- Pages can now be set to automatically publish on a given date.

## 8.6.0 - 2016-12-20

### Deprecated
- Internet Explorer 8 is no longer supported by jQuery. Stuff might still work, but there are no guarantees. If legacy support is important, do not upgrade.

### Changed
- jQuery has been updated to v2.2.4.
- jQuery UI has been updated to v1.12.1.
- `js-webshim` was updated to v1.16.0 to resolve an issue with `datetime-local`.

### Added
- Pages can now be automatically unpublished on a given date.
- It is now possible to disable loading `common.less` in a site's configuration.

## 8.5.14 - 2016-12-19

### Fixed
- Small change in `.htaccess` that may have caused rewrites to not work with some server configurations.
- The `/temp` directory was removed from `robots.txt` because it was blocking Google from retrieving the compiled LESS CSS and causing sites to fail mobile friendly tests.

### Changed
- The Menu module (`menu`) and NV Menu module (`nvmenu`) were modified so that their menu is hidden until the page finishes loading. This prevents jittery loading caused by the menus initially appearing vertically until rendered. A better solution to this will be considered in a future version.

### Added
- A "none" colour theme was added for upgraded sites that require minimal theme capabilities.
- The Content List module (`content_list`) now supports an alternate view which groups pages by first letter.

## 8.5.13 - 2016-12-09

### Fixed
- 009550: Several modules and a few other views were incorrectly including `.php` in the load function. This seemingly still worked but broke the layout overrides.
- 009553: There were issues trying to reset a password from the admin login screen.

### Changed
- 009551: `pure-button-primary` was added to pagination buttons in the Content List module (`content_list`).

## 8.5.12 - 2016-11-25

### Added
- Similar to the customer header menu view, it is now possible to add custom stuff (likely scripts) to the footer using a custom footer view.

### Changed
- All copies of `spit_json()` now support numeric checking to make AngularJS like numbers.

## 8.5.11 - 2016-11-23

### Fixed
- 009501: Modules and document admin lists would show duplicates depending on ACL.
- Improvements to the Joomla importer, which was not working very well.

## 8.5.10 - 2016-11-22

### Fixed
- 009487: Non-administrator users will now default (and be locked on) Read/Write access for pages, menu items, and documents they create.
- 009489: Product edit and shop category screens were not waiting until async scripts were loaded to initialize CKEditor.

## 8.5.9 - 2016-11-21

### Fixed
- The fix for 009477 in v8.5.7 was actually not entirely merged.

## 8.5.8 - 2016-11-21

### Changed
- `jQuery(document).ready(function);` has universally been replaced with `jQuery(window).on("load", function);` for better compatibility with async script loading introduced in v8.5.7.

## 8.5.7 - 2016-11-21

### Fixed
- 009479: Pages would show up more than once in the admin area if the ACL table was imperfect.
- 009477: Content list modules (`content_list`) with "keep formatting" enabled were not using the desired image size.
- 009441: A 100ms delay was added to jQuery Sortable on menu item reorganizing with hopes of preventing unwanted drag events from starting.

### Changed
- Lots of scripts are now loaded async. There may be some situations where this breaks things, primarily if a script isn't wrapped in `document.ready`.
- There were a few places where scripts were being started outside of a `document.ready` block.

## 8.5.6 - 2016-11-18

### Fixed
- The Gallery module (`gallery`) was having issues with `urlencode()` on nginx. `rawurlencode()` works properly, since it doesn't break RFC.
- 009468: Sitemap generator would add `/search` to the sitemap, which was blocked by `robots.txt`.

### Changed
- Since page URLs have been required for some time, it is no longer possible to access a page via the URL `/page#`.
- More optimizations to `.htaccess`.
	+ When redirecting from www to non-www over HTTPS, there would have been two redirects before. Now it will go straight to `https://non-www-domain.tld`.
	+ Some rule changes for file/directory access were changed for sanity and probably better performance.
	+ A rule that was never possible to reach was removed.
	+ The hacky rule that made Nerivon CMS work with CodeIgniter wasn't actually needed and no loads the controller function natively as the last rule in the routes file.
- Grunt dependancies were changed to "latest" versions.
- The retina images script was cleaned up and modified slightly, removing commented debug blocks and conditional checks that weren't necessary.
- All instances of `urlencode()` were replaced with `rawurlencode()` except in system and third party files.
- Instead of unsetting ETag headers, they're now used.

## 8.5.5 - 2016-11-16

### Fixed
- Redirects were not loading properly and therefore not redirecting properly.
- Added a constraint to `tag_page` that was originally forgotten.

## 8.5.4 - 2016-11-11

### Fixed
- 009435: Search modules (`search`, `documents`, `content_list`) were showing an incorrect number of search results.

### Added
- Interac e-Transfer payment gateway is now the default enabled payment gateway.

### Changed
- PayPal payment gateway was not passing shipping or taxes properly. The process was also modified so that a Pay Now button is displayed on the order summary screen since the previous method was unreliable in some browsers.
- The build script is more fault tollerant and will also attempt to use `scp` if FTP fails. For `scp`, you'll want to give Polar your public key to avoid entering your password half a dozen times.

## 8.5.3 - 2016-11-10

### Fixed
- Brian broke the `slideshow` and `pagetop` module positions in the Kasper template.
- Kasper's menu alignment no longer affects NV Menu module's (`nvmenu`) overlay.

## 8.5.2 - 2016-11-10

### Manual Action
- Move any custom routes to `/application/config/routes_custom.php`.

### Changed
- `retinaimages.php` now uses `$_SESSION` instead of `$_COOKIE` which resolves an issue where the initial page load would show low resolution images due to the way cookies work.
- Some `.htaccess` rules were optimized.
- Custom routes are now placed in `/application/config/routes_custom.php` so that you don't have to keep replacing them after updates to the main routes file.

## 8.5.1 - 2016-11-03

### Changed
- Updated to CodeIgniter v3.1.2.

## 8.5.0 - 2016-11-02

### Added
- Content types can now specify a different view for being displayed in a content list by creating a view with the suffix `_preview` (ie: `/application/views/content/content_list_preview.php`). If this view doesn't exist, the main view will be used.
- The thumbnail function now checks if the input file exists so that it won't throw half a dozen errors when it doesn't.
- Content list module (`content_list`) now supports filtering by a page tag.
- Content list module (`content_list`) is now also a content type ("Content List").
- Documents module (`documents`) is now also a content type ("Documents List").
- Contact module (`contact`), Contact Info module (`contact_info`), Google Map module (`googlemap`), and Social module (`social`) is now also combined into a content type ("Contact Page").
- Gallery module (`gallery`) is now also a content type ("Photo Gallery").
- Login module (`login`) and Registration module (`registration`) are now also combined into a content type ("User Login / Registration Page").
- Services module (`services`) is now also a content type ("Services").
- Team module (`team`) is now also a content type ("Our Team").
- Directory module (`directory`) is now also a content type ("Business Directory").
- Events module (`events`) is now also a content type ("Event Listings").
- Account module (`account`) is now also a content type ("User Account Portal").
- Calendar module (`calendar`) is now also a content type ("Event Calendar").
- Booking module (`booking`) is now also a content type ("Online Booking").
- The Search module (`search`) is now also a content type ("Search Results").

### Changed
- Preconfigured pages now use their appropriate new content type when appropriate.
- The Social module (`social`) now shows social network icon previews in the admin area.
- The Search module (`search`) now supports pagination.
- The Google Maps module (`googlemap`) now uses a non-restricted shared API key by default. It is unlikely that we'll ever hit the 25,000/day limit, however, good practice is to get the big boys their own key to use.

## 8.4.1 - 2016-10-28

### Fixed
- 009312: Shop products were duplicated in the admin list when multiple categories were selected.

### Added
- You can now install a content list preconfigured page.

## 8.4.0 - 2016-10-28

### Removed
- The Purolator shipping gateway that was never used and probably didn't work was removed in favour of Shippo.

### Fixed
- 009313: When a user didn't have read access to a module the site would send them to the login screen. If the module was on all pages it would cause a redirect loop. The site will now silently hide modules in this situation.
- The preconfigured page for "Shop Section" wasn't configuring ACL properly.
- The "install postal codes" function was updated to work with `allow_url_fopen` disabled.

### Added
- Stripe payment gateway. This is the easiest to use, most secure, and most user-friendly payment gateway we support. Fees are identical to PayPal. Payments are automatically deposited into accounts 7 days after being received. Realtime processing with no IPN insanity.
- Flat rate shipping gateway. Very simple, one rate fits all.
- Shippo shipping gateway. [https://shippo.com](https://shippo.com)
- It is now possible to view, enable/disable, and configure payment/shipping gateways using the admin area.

### Changed
- Shop default styles for the checkout were added.
- Default widths were added for form inputs.
- Installing the shop section will now disable the shop page's heading by default since most shop pages already have headings defined.
- It is now possible for generic shipping gateways to set a field value for `shipping_gateway_service` to override the name of the shipping gateway displayed to the user based on the choice. ie: Shippo sets this to "Canada Post Regular Parcel" or whatever the user selected. This same value gets saved and displalyed to the user as the shipping method.

## 8.3.1 - 2016-10-26

### Fixed
- Fixed PHP notices here and there.
- 009309: Account module (`account`) `order` view was missing.
- 009308: "Do not crop" was an invalid selection in the Content List module (`content_list`).
- 009310: Disabled payment gateways were showing up as choices.
- 009311: Source view of CKEditor was not wrapping text.

### Added
- PayPal hosted payment page payment gateway. No IPN support.

### Changed
- Some default shop views were improved.

## 8.3.0 - 2016-10-25

### Manual Action
- Delete `/images/portfolio` after verifying that portfolio items have been converted properly.

### Deprecated
- The following modules are deprecated and will be removed in a future version:
	+ Portfolio (`portfolio`)
	+ Latest portfolio (`portfolio_latest`)

### Removed
- Access to the old portfolio admin pages have been removed.
- Portfolio items are now created using a content type. The old portfolio items have been converted and will be removed in a future version.

### Fixed
- "Number of columns" content type settings default values were not loading properly.
- The update controller should now be backwards compatible with any resonably recent version of Nerivon CMS.
- 009292: The Content List module (`content_list`) would not display extracted images if text preview was disabled.
- The Content List module (`content_list`) will now crop images to the requested size.
- A few files that were still using the `pure-g-r` CSS class were updated to `pure-g`.
- 009261: When converting a page to "content with image" sometimes the image will fail to copy. Additional error handling has been added but PHP's handling of special characters using `copy()` is poor. Because of this, some pages will simply not be able to be converted automatically.
- Fixed an issue where upgrading to v8.1.0 or newer would cause a PHP error on the subsequent page load (only once).
- The Menu module (`menu`) was showing a drop down arrow on the "More" menu.

### Added
- Content pages can now be tagged. Tags are currently only used for portfolio items.
- You can now change the `ENVIRONMENT` constant from the admin menu. A warning message is displayed while the `ENVIRONMENT` is `development`.
- The Content List module (`content_list`) now supports pagination.
- The thumbnailing function now allows a cropping position to be sent along with the aspect ratio. The Content List module (`content_list`) supports this functionality.
- Added Etsy to the social media icons module (`social`).
- Changing the URL or category field for a page will prompt the user to update the page's URL.

### Changed
- Font Awesome was updated to v4.7.0.
- The default favicon was updated to our new N.
- The Content List module (`content_list`) had its responsive column break points adjusted for smoother scaling.

## 8.2.3 - 2016-10-17

### Fixed
- 009217: All email functionality where `get_mailer()` was used (which should be everywhere) was not sending proper authentication data.
- 009216: Login module (`login`) used `url` field types which forced a full URL which was not desired.
- Contact form module (`contact`) had 2 module setting for the "success redirect."
- 009211: A bunch of PHP warnings and notices were resolved.
- 009177: Slideshow module (`slideshow`), Nivo Slider module (`slideshow_nivoslider`), BX Slider module (`slideshow_bxslider`), and Random Image module (`random_image`) all had their image-to-link mapping off by 1, causing the first image not to have a link.

## 8.2.2 - 2016-10-13

### Fixed
- `noreply@` email addresses were not working on dev sites because of the subdomain.

## 8.2.1 - 2016-10-13

### Fixed
- 009196: Nivo Slider module (`slideshow_nivoslider`) wasn't applying Colorbox themes.
- 009195: BX Slider module (`slideshow_bxslider`) was displaying a 404 on `colorbox.css` in some situations.
- 009192: Gallery module (`gallery`) was not respecting date sorting and had no options for reverse order. You can now sort by filename ascending/descending, date ascending/descending, or aspect ratio.
- 009189: Many admin screens were defaulting to 1 instead of the active site when creating a new entity.

### Added
- 009197: The site form now has a button for testing the mail settings entered. Additionally, if those settings don't work it will try a bunch of configurations that should work.
 
### Changed
- PHPMailer was updated to version 5.2.16.
- The shop cart module (`shop_cart`) was upgraded to the new module format so that its views can be overridden.
- Cross site request forgery tokens were removed from search modules because they're ugly in the URL, which is otherwise copy and sharable.

## 8.2.0 - 2016-09-30

### Fixed
- Encryption library was not loaded in some functions where it was being used.
- [[0001070]](https://bugnet.nerivon.com/view.php?id=0001070): More shop route issues were resolved.
- [[0001072]](https://bugnet.nerivon.com/view.php?id=0001072): Public users could not download public documents.
- [[0001071]](https://bugnet.nerivon.com/view.php?id=0001071): Nivo Slider (`slideshow_nivoslider`) and BX Slider (`slideshow_bxslider`) had `onclick` issues.
- [[0001077]](https://bugnet.nerivon.com/view.php?id=0001077): Modules were showing up multiple times in the module insert dialog.
- [[0001078]](https://bugnet.nerivon.com/view.php?id=0001078): Menu items were showing up multiple times in the menu modules.
- Documents were eventually going to show up multiple times too.
- [[0001076]](https://bugnet.nerivon.com/view.php?id=0001076): Adding a link using our custom CKEditor plugins would not work when adding a link to an image.

### Added
- Roles can now be bulk assigned to all existing pages, documents, modules, or menu items when saved.
- All admin pages have save and continue buttons.

### Changed
- Shop admin pages have finally been updated to use the "messages" view instead of an intermediate "continue screen" with status messages.

## 8.1.0 - 2016-09-29

### Manual Action
- [[0001066]](https://bugnet.nerivon.com/view.php?id=0001066): All forms should include a CSRF token. Put `<?php csrf(); ?>` inside each form. In your controller functions, add `csrf_verify();`. **All modules which accept user input should do this.**
- All eligible external files should have SRI hashes added. [https://www.srihash.org](https://www.srihash.org)
- `.htaccess` was updated. Make sure this file gets updated.

### Security
- [[0001066]](https://bugnet.nerivon.com/view.php?id=0001066): Cross Site Request Forgery tokens were added to all forms. Currently only certain ones are verified where it will not break functionality.
- Some XSS vulnerabilities were fixed.
- All eligible external files have had SRI hashes added. [https://www.srihash.org](https://www.srihash.org)
- Password fields now have `autocomplete="off"` and no longer attempt to fill in the previously entered password attempt.
- Cookies are now flagged as secure if the `FORCE_SSL` constant is set.
- Cookies are now flagged as HTTP only by default (inaccessible to JavaScript).
- `session_start()` now flags its cookie as secure if the user is accessing the site over HTTPS.
- `session_start()` now flags its cookie as HTTP only.
- Clickjacking has been prevented.

### Fixed
- Could not change the active site in the admin area.
- Some sections were not filtering by the active site ID.
- Fixed a bug that would sometimes cause an admin user's session to end.
- Installing a search page would not properly include the Company Name in the title.
- [[0001061]](https://bugnet.nerivon.com/view.php?id=0001061): Cropping an existing image with Media Manager will now obey directory-specific High DPI settings.

### Added
- Basic stats logging of page views, document downloads, contact form submissions, shop category views, and shop product views.
- Dashboard graph for stats by day and stats by hour.

### Changed
- The "site picker" is now at the top of the sidebar.
- The site name was added to all page titles when more than one site is available and the page content is site-specific.
- The sidebar icons are all slightly larger.

## 8.0.4 - 2016-09-27

### Fixed
- [[0001061]](https://bugnet.nerivon.com/view.php?id=0001061): Improved the stability of the Media Manager upload dialog in some browsers.
- [[0001065]](https://bugnet.nerivon.com/view.php?id=0001065): The Menu module (`menu`) was made invisible due to a mix up with the NV Menu module (`nvmenu`).
- [[0001064]](https://bugnet.nerivon.com/view.php?id=0001064): Fixed image linking in the following modules:
	- Random Image (`random_image`)
	- NivoSlider (`slideshow_nivoslider`)
	- BX Slider (`slideshow_bxslider`)
	- Slideshow (`slideshow`)
- Shop routes were not generating properly.
- Improved the reliability of the automatic redirect system such that it should help avoid reciprocal redirects.
- In some page lists, pages were showing up more than once.

### Changed
- All scripts and CSS files for the admin area have a version tag applied to prevent caching between versions.

## 8.0.3 - 2016-09-26

### Fixed
- [[0001057]](https://bugnet.nerivon.com/view.php?id=0001057): Users could not create new menu items due to an ACL issue.
- [[0001061]](https://bugnet.nerivon.com/view.php?id=0001061): Media Manager no longer forces cropping images when it should have been disabled.
- User role assignments were not being saved.
- Some shop image thumbnails were not regenerating after clearing the thumbnail cache.
- The Menu module (`menu`) and NV Menu module (`nvmenu`) had their priority menu scripts revamped for better performance and reliability.
- The NivoSlider module (`slideshow_nivoslider`) was not loading themes properly.

### Changed
- Sweet Alert confirm buttons are now the same as `@blue1` from the admin area styles.
- [[0001060]](https://bugnet.nerivon.com/view.php?id=0001060): Kasper template: header changed to `1-4` and `3-4`.
- [[0001059]](https://bugnet.nerivon.com/view.php?id=0001059): Kasper template: bold changed to font weight 700.
- [[0001061]](https://bugnet.nerivon.com/view.php?id=0001061): Media Manager no longer defaults to creating high DPI images for module controlled directories because those modules all create their own thumbnails.
- The dashboard buttons now flow fluidly instead of being specifically split into columns.

### Added
- [[0001058]](https://bugnet.nerivon.com/view.php?id=0001058): Added Instagram to the social media icons module (`social`).
- Several quick links have been added to the sidebar menu.

## 8.0.2 - 2016-09-21

### Fixed
- The Menu module (`menu`) was still conflicting with the NV Menu module (`nvmenu`).
- The NV Menu module (`nvmenu`) was wrapping the "more" menu link under certain conditions.

## 8.0.1 - 2016-09-21

### Removed
- The shop config option for `add_shop_name_to_title` was removed because it doesn't really help SEO.
- The shop config option for `shop_name` was removed because its no longer used.

### Fixed
- All templates had padding added because a view was changed inadvertantly.
- Menu item URLs were still not loading properly.
- Shop category and product pages had a double `<h1>`.
- The High DPI image script was intercepting requests from Media Manager to download images.

### Changed
- The NV Menu module (`nvmenu`) search box/button had minor style changes.
- All shop related buttons have been changed to `.pure-button-secondary`.

## 8.0.0 - 2016-09-21

### Manual Action
- [[0001033]](https://bugnet.nerivon.com/view.php?id=0001033): Any references to the tables `action`, `role`, `role_action`, or `user_role` need to be updated to `acl_action`, `acl_role`, `acl_role_action`, and `acl_user_role`.
- [[0001033]](https://bugnet.nerivon.com/view.php?id=0001033): Any references to the models `Action`, `Role`, `Role_action`, or `User_role` need to be updated to `Acl_action`, `Acl_role`, `Acl_role_action`, and `Acl_user_role`. Their primary keys have all been prepended with `acl_` too.
- [[0001033]](https://bugnet.nerivon.com/view.php?id=0001033): Any references to user fields `admin`, `restricted_admin`, or `media_admin` must be replaced with ACL checks for `ACTION_ADMIN_LOGIN` or `ACTION_MEDIA`. `restricted_admin` has no replacement.
- If you were using the AddThis Widget, you aren't any more.
- If you were using checkbox or radio switches, you must replace them with regular checkboxes and radio inputs.
- The directory, events, shop, and appointments actions are disabled by default to save menu bar space in the admin area. If you need them you must assign them to the administrators role.
- If you have anything in `/application/views/common/header_custom_menu.php` it must be changed to a vertical menu to work in the new sidebar.

### Deprecated
- The admin area no longer supports HTML5 non-compliant browsers. This means that Internet Explorer 9 and older no longer work properly.

### Removed
- [[0001033]](https://bugnet.nerivon.com/view.php?id=0001033): User flag for `restricted_admin` was removed.
- The AddThis Widget was removed because nobody uses it. Its functionality can be replaced by a module if desired.
- Checkbox switches and radio switches were removed and replaced with regular checkboxes and radio inputs.
- TableDND (Table Drag & Drop) was removed because it is no longer needed.
- The Gallery Submission module (`gallery_submission`) was removed because it has never been used.

### Fixed
- The admin area search was broken since removing testmonials in v7.3.0.
- Shop product/category routes were no longer generating properly.
- The shop product edit screen had errors related to quotes in the layout specific options.
- The CKEditor image plugin would sometimes fail to identify the selected image.
- All edit screens that have a site ID input now hide it when there is only one site available. This was the intended UI but was never properly implemented.
- Documents could not be delete from the main documents list - only from Media Manager.
- Directory companies with certain URLs would load the wrong company due to an odd issue.
- The Menu module (`menu`) was conflicting with the NV Menu module (`nvmenu`).
- Fixed an issue with the new custom loader when loading an array of models.
- Windows users will no longer get `C:\fakepath\` in their uploaded file names.
- As a result of adding unit testing, several models and modules had minor issues fixed.
- Fixed some incorrect module settings during automatic installation of the Testimonials page.

### Added
- [[0001033]](https://bugnet.nerivon.com/view.php?id=0001033): Roles and actions have been revamped an implemented across the entire admin.
- [[0001033]](https://bugnet.nerivon.com/view.php?id=0001033): Per-item ACL for:
	- Pages
	- Modules
	- Documents
	- Menu links
- [[0001033]](https://bugnet.nerivon.com/view.php?id=0001033): Several preconfigured roles exist for common user groups.
- The admin area search now searches documents.
- Unit testing was added at `/admin/qatest`.
- The update controller will now attempt to automatically update itself before starting an update.

### Changed
- [[0001033]](https://bugnet.nerivon.com/view.php?id=0001033): User flags for `admin` and `media_admin` have been replaced by ACL checks.
- Form styles have been simplified.
- Page edit screen has been reorganized with accordion effects.
- Module edit screen has been reorganized with accordion effects.
- Document edit screen has been reorganized with accordion effects.
- Install screen has been reorganized with accordion effects.
- Menu edit screen was revamped with a better drag & drop ordering system.
- The directory, events, shop, and appointments actions are disabled by default to save menu bar space in the admin area. If you need them you must assign them to the administrators role.
- The menu bar was removed and replaced with a slide out sidebar menu.
- The SEO admin screen will now detect when Google Analytics is installed manually in the active template rather than using the site configuration option, since legacy or custom snippets will be configured this way.
- `.pure-button` and `.pure-button-primary` (mainly save and cancel buttons) got some minor style improvements.
- Cancel buttons now use an X icon instead of thumbs down for a more professional appearance.

## 7.4.0 - 2016-09-19

### Manual Action
- Any menu items using FontAwesome icons that were saved after v7.3.0 need to be resaved for their icons to work.

### Fixed
- FontAwesome icons in the menu module were not displaying properly.
- A couple of queries were broken since converting to bound queries.
- [[0001045]](https://bugnet.nerivon.com/view.php?id=0001045): All of the custom CKEditor plugins were improved, mostly to fix issues with Internet Explorer.

### Added
- [[0001033]](https://bugnet.nerivon.com/view.php?id=0001033): Views can now be overridden by placing a view in `/application/views/overrides/{original path to view}`.
- [[0001033]](https://bugnet.nerivon.com/view.php?id=0001033): Models can now be overridden by placing a model in `/application/models/overrides/{original path to model}`.
- [[0001033]](https://bugnet.nerivon.com/view.php?id=0001033): JavaScript files can now be overridden by placing a script in `/js/overrides/{original path to script}`.

### Changed
- `scripts.js` has been broken out into 3 files:
	+ `scripts.js` now contains only generic functions.
	+ `admin.js` now contains all of the admin and shop admin functions.
	+ `shop.js` now contains all of the front-end shop functions and is automatically included by the shop controller.

## 7.3.2 - 2016-09-09

### Fixed
- FontAwesome icons in CKEditor were broken after being updated to v4.6.3.
- Image thumbnails in Media Manager would not refresh themselves when cropping existing images.

### Added
- [[0001039]](https://bugnet.nerivon.com/view.php?id=0001039): CKEditor now has a plugin for inserting a page link.
- CKEditor now has a custom plugin for inserting a link.
- [[0001040]](https://bugnet.nerivon.com/view.php?id=0001040): CKEditor now has a custom plugin for inserting images and figures.
- Search module (`search`). This module searches pages and documents and displays mixed results ordered by rank.
- Documents module (`documents`). This module displays all documents, with optional search.
- Preconfigured page option for documents.

### Changed
- CKEditor custom plugin icons were redone for better quality and consistency.
- CKEditor's `cbsmodule` plugin has finally been renamed to `nvmodule`.
- Installing a "search page" now uses the search module (`search`) instead of the content list module (`content_list`).
- The Content List module (`content_list`), Search module (`search`), and Documents module (`documents`) now take their `q` parameter from `$_POST` OR `$_GET`. These modules and the NVMenu module (`nvmenu`) now use `GET` forms for a better user experience (no repost warnings, sharing the URL, etc).

### Removed
- CKEditor's base "link" plugin was removed as it was replaced by several simplified plugins.
- CKEditor's base "image" plugin was removed as it was replaced by our own.

## 7.3.1 - 2016-09-08

### Fixed
- Fixed an issue with an update query in v7.1.0.
- Menu items were not displaying their URLs properly.
- Downloading documents or files from Media Manager would crash if the files were too large.

## 7.3.0 - 2016-09-06

### Manual Action
- The Update controller was updated. You should manually update it before updating.
- `/application/config/routes.php` was updated. Restore any custom routes.
- `.htaccess` was updated. Make sure this file gets updated.

### Removed
- The following modules were removed because their functionality has been replaced by the content list module (`content_list`):
	+ `blog`
	+ `blog_archive`
	+ `blog_latest`
	+ `blog_search`
	+ `testimonials`
- The mobile menu module (`menu_mobile`) was removed because the other menu modules are responsive.

### Fixed
- Potentially fixed some issues with the testimonials snippet module installation (using `content_list`).
- Invalid page URLs would not return a 404 if the site had a page with the URL `home`. `home` will no longer be used as a fallback for `index`.
- Saving a document would always cause its URL to increment by 1 because it thought the URL was already in use.

### Security
- A few places were accessing `$_POST` and `$_GET` directly instead of filtering through CodeIgniter's `Input` class.
- Using PHP `$_SERVER` variables now filter through CodeIgniter's `Input` class for added protection against header forgery.
- [[0001028]](https://bugnet.nerivon.com/view.php?id=0001028): Most queries have been replaced with CodeIgniter data-bound queries for added security.
- All templates and modules now check for the `PRODUCT_NAME` constant to prevent direct access to these files.
- Directory listings are now explicitly disabled.
- `X-Powered-By` header is now removed from all requests.
- Various recommendations by Google Skipfish were implemented.

### Changed
- The Mainframe helper now handles the `active_site_id` cookie for easier retrieval.
- Updated to Font Awesome 4.6.3.
- Font Awesome editor plugin now supports Font Awesome 4.6.3.

### Added
- The updater now displays the change log between current version and newest version. Additional warnings are displayed when manual actions are required and a confirmation dialog was added before starting the update.
- [[0001023]](https://bugnet.nerivon.com/view.php?id=0001023): Certain document actions are now logged.
- [[0001026]](https://bugnet.nerivon.com/view.php?id=0001026): Files and directories can now be downloaded with Media Manager.

## 7.2.2 - 2016-09-02

### Fixed
- Fixed an incorrect LESS variable name in the Team module (`team`).
- All modules with read more buttons have had their classes standardized to `pure-button pure-button-primary pure-button-readmore`.

### Added
- The random image module (`random_image`) is now supported by Media Manager.
- The Google Map module (`googlemap`) now supports using an API key, since this is now required.
- The Team module (`team`) now supports putting a custom link on each person's name/photo, for linking to a bio.
- All areas that allow selecting a FontAwesome icon size now support `fa-lg` which is between `fa-1x` and `fa-2x`.

### Changed
- Kasper's logo and menu are now `pure-u-1-3` and `pure-u-2-3` respectively because `pure-u-1-5` was not enough space for the logo.
- Kasper's `h1` and `h3` are now uppercase and bold.

## 7.2.1 - 2016-09-01

### Fixed
- Fixed a few more issues with the installer's verification logic.

## 7.2.0 - 2016-08-31

### Manual Action
- Any references to `seo_name` in custom modules or shop views **must be changed** to `url`.
- The Update controller was updated. You should manually update it before updating.
 
### Fixed
- Fixed more JavaScript errors when saving documents.
- Validation on the document edit screen was not functioning.
- It was not possible to edit the first document in media manager.
- Updated `https://html5shim.googlecode.com/svn/trunk/html5.js` (HTML5 compatibility for IE < 9) to a new version because that URL died.
- Linted `/css/styles.less` for potentially better CSS.

### Added
- All pages that have a URL field now have a URL preview.

### Changed
- Updated SweetAlert.
- SweetAlert messages that are long enough to wrap will no longer remain centered.
- SweetAlert now allow HTML and some alerts have been modified as a result.
- SweetAlert no longer use the native graphics. They now use FontAwesome icons.
- Cleaned up some alerts that weren't using SweetAlert.
- Removed some more old cruft.
- jQuery was updated to v1.12.4.
- jQuery UI was updated to v1.11.4.
- Menu item reordering was finally converted to jQuery AJAX requests instead of Dojo.
- The title bar of jQuery dialogs was restyled.
- `SEO Name` is now known as `URL` and its internal field name `seo_name` is now known as `url`.
- Added database indexes on `url` fields.

### Removed
- Dojo was removed because its not used anywhere anymore.
- Tabber was removed because its not used anywhere anymore.
- Image Crop Tool and its associated module (`image_crop`) were removed because its functionality has been replaced by Media Manager.

## 7.1.0 - 2016-08-30

### Manual Action
- Make sure that anything in `/downloads` was properly converted to a document and that all links on the website have been updated. **If you have custom modules or shop views which reference files in the downloads directory they will need to be updated accordingly.** Redirects were created but should not be relied upon. Once this is verified, delete the entire contents of `/downloads`.
- The Update controller was updated. You should manually update it before updating.

### Fixed
- The PDF tools no longer verify SSL certificate validity when connecting to rouk.org because the certificate expired. We trust rouk.org, so as long as SSL exists, we're happy.
- Editing a document and not providing a new file would fail.

### Changed
- The gallery module (`gallery`) and Galleria module (`galleria`) now resize the full-size images to a maximum of 1280x1024.
- Using "Quick Upload" for a file link in CKEditor will now automatically create a document and return its link.
- Any files in `/downloads` were converted to documents and their links throughout the site were updated. Redirects were also created in case any links were missed. The `/downloads` directory is now retired in favour of documents.
- Media Manager:
	- Displays file information below the filename (image dimensions, modified dates, file sizes, etc).
	- Displays previews for icon files as well as which sizes it contains (favicons generated by Nerivon CMS contain 4 sizes).
	- Is contextually aware of what directory is being used. Directories have notes attached to them for clarity and directories which are controlled by a module will force cropping of images to the required size. Supported modules are: Gallery (`gallery`), Galleria (`galleria`), Slideshow (`slideshow`), BX Slider (`slideshow_bxslider`), and Nivo Slider (`slideshow_nivoslider`).
	- Automatically updates module settings if a directory which is controlled by a module gets renamed.
	- Prevents deleting a file if references are found on the website.
	- Prevents renaming a directory if references are found on the website.
	- Silently updates references to a file if it is renamed or moved.

## 7.0.0 - 2016-08-26

### Manual Action
- Add `define("DOCUMENT_PATH", ABSOLUTE_PATH . "/documents");` to `/application/config/constants.php` after `MODULE_PATH`.
- `/application/config/routes.php` was updated. Restore any custom routes.

### Fixed
- Module placeholder images are now inserted inside `<div>` elements instead of `<p>` elements for proper structure once the modules are loaded.
- Module placeholder images now properly update their `src` attribute when being edited and replaced with a different module.
- [[0001022]](https://bugnet.nerivon.com/view.php?id=0001022): Page titles that contained quotation marks would appear blank when editing.
- [[0001020]](https://bugnet.nerivon.com/view.php?id=0001020): Admin user will now be part of the default shopper group automatically.
-  [[0001021]](https://bugnet.nerivon.com/view.php?id=0001021): The shop products list was changed back to `server side false` in order to restore the category filter functionality. This causes the bulk tools to not update the list. Choose your poison.
-  The installer was reporting errors when the installation actually worked fine because the verification logic was out of date.
-  Cleaned up a bunch of old or sloppy CSS in the admin area.

### Added
- Document management (DocMan replacement).
- Media Manager supports document management.
- CKEditor supports inserting document links.
- The Joomla importer now supports DocMan.

### Changed
- Media manager's action buttons are now context sensitive based on the current directory.
- [[0001018]](https://bugnet.nerivon.com/view.php?id=0001018): Content list images will now use the page's title as the `alt` and `title` attributes.
- The NivoSlider module (`slideshow_nivoslider`) and BX Slider module (`slideshow_bxslider`) no longer require a lightbox width and height.
- Updated to CodeIgniter 3.1.0.

## 6.8.4 - 2016-08-12

### Changed
- The Joomla importer was improved.

## 6.8.3 - 2016-08-11

### Manual Action
- `/application/config/routes.php` was updated. Restore any custom routes.

### Added
- Joomla importer, available at `/joomla-import`. Follow the instructions at that page.

### Fixed
- Fixed a PHP warning in the NV Menu module (`nvmenu`).

## 6.8.2 - 2016-08-11

### Added
- Added a shop config option for specifying a custom checkout view. Any fields named `custom_*` will be included in the order summary as custom data.

### Changed
- Changed how the content list module (`content_list`) determines if the text had been truncated or not.

## 6.8.1 - 2016-08-10

### Fixed
- The Google Map module (`googlemap`), directory module (`directory`), and directory Google Map module (`directory_googlemap`) now include JavaScript over HTTPS.

## 6.8.0 - 2016-08-09

### Fixed
- [[0001000]](https://bugnet.nerivon.com/view.php?id=0001000): A site-specific CSS rule ended up in the gallery module's CSS which caused the titles to be hidden.
- [[0000999]](https://bugnet.nerivon.com/view.php?id=0000999): The admin country restriction still relied on `allow_url_fopen`.

### Changed
- The menu module (`menu`) now has an option to duplicate or not duplicate parent menu items in their drop down lists.
- The NV Menu module (`nvmenu`) now has the following options:
	- Duplicate or not duplicate parent menu items in their drop down lists.
	- Text to put above the menu items.
	- Text to put below the menu items.
	- Whether to show a search box.
	- Whether to show icons on the main menu, submenu overlay, or both.
- The NV Menu module (`nvmenu`) now uses priority menu.
- The NV Menu module (`nvmenu`) is now the default main menu.
- The content list module (`content_list`) now supports search queries and is now an installable page. Posting any form with a `q` field will automatically display search results.
- The content list module (`content_list`) now strips out module placeholder images before extracting the first image.

## 6.7.9 - 2016-08-05

### Changed
- Some disabled functions were removed from `php.ini` because they were breaking the update process.

## 6.7.8 - 2016-08-05

### Manual Action
- Remove meta tag "keywords" from any custom templates. This field no longer exists as it is no longer relevant to search engines.
- The Update controller was updated. You should manually update it before updating.

### Fixed
- [[0000988]](https://bugnet.nerivon.com/view.php?id=0000988): Page list and product list filters are now persistent.
- [[0000989]](https://bugnet.nerivon.com/view.php?id=0000989): Batch product functions were not reloading the list afterwards, giving the impression that they weren't working.

### Changed
- [[0000991]](https://bugnet.nerivon.com/view.php?id=0000991): Categories or products with a specific page title will use that page title for the image/link alt/title tags.

### Removed
- [[0000990]](https://bugnet.nerivon.com/view.php?id=0000990): Meta keywords have been removed from everywhere as they are no longer relevant to search engines.

## 6.7.7 - 2016-08-03

### Manual Action
- The Update controller was updated. You should manually update it before updating.

### Changed
- The update controller now uses cURL instead of `file_get_contents()` to get the latest version in order to work with `allow_url_fopen` disabled.

## 6.7.6 - 2016-08-02

### Added
- [[0000977]](https://bugnet.nerivon.com/view.php?id=0000977): Cropping an image with media manager now includes an option to retain the original image.

### Changed
- The media manager is now heavily optimized.
- The media manager got some more cosmetic changes.
- `php.ini` now blocks more potentially dangerous functions that we never use.

## 6.7.5 - 2016-07-29

### Fixed
- Fixed a few issues with the media manager (typos, dialog sizes, etc).

## 6.7.4 - 2016-07-28

### Added
- It is now possible to add a "URL override" to content items in order to go "somewhere else" when clicking a read more link. This is useful, for example, when showcasing a product and you'd like to go to the product page rather than the article.

## 6.7.3 - 2016-07-28

### Fixed
- Deleting a module would delete the wrong module (since v6.6.0).

### Added
- Modules can now be set as "always on" so that they will default to being enabled for new pages.

### Changed
- The 404's list will now indicate whether a redirect has been created to resolve the 404.
- Creating a URL redirect from the 404's page will now bring you back to the 404's page.

## 6.7.2 - 2016-07-27

### Fixed
- The media manager no longer loads up the directories and files unless the page actually loads a media manager.

### Added
- Shop categories and shop products can now explicitly set a page title.

## 6.7.1 - 2016-07-26

### Fixed
- Forgot to include the new database schema/data.
- The media manager now longer offers to resize non-image files.
- The `FORCE_SSL` function was not working properly.

### Added
- You can now explicitly set the title tag for menu items, which are honoured by the menu module (`menu`) and NV Menu Module (`nvmenu`).
- The media manager now allows drag and drop file moving.

### Changed
- The media manager now ignores `images/portfolio` since this is a special directory.
- The media manager now ignores jQuery UI image files.
- The media manager now strips quotes and apostrophes from new directory names.
- The NV Menu Module (`nvmenu`) got some cosmetic changes.
- The media manager got some cosmetic changes.

## 6.7.0 - 2016-07-26

### Fixed
- Image Crop Tool was not working properly.

### Added
- Added a link to purge unused shop images, functionality which was recently added but didn't get a link.
- Menu items can now have Font Awesome icons.
- New module: Nerivon Menu (`nvmenu`) displays submenus with a responsive tablet-like UI.
- Our own custom media manager completely replaces CKFinder for the media manager page as well as image/link integration with CKEditor.
- `AddItemByProductID()` was added to the `Shop_cart` model.

### Changed
- The menu module (`menu`) now displays Font Awesome icons when selected.
- The Cropit JavaScript library was updated from v0.1.9 to v0.5.1.

### Removed
- CKEditor's "Insert Flash" functions have been neutered.

## 6.6.3 - 2016-07-13

### Fixed
- Delete buttons on some pages were not working after v6.6.0.

## 6.6.2 - 2016-07-12

### Changed
- If the LESS compiler sees that any of the LESS files its compiling are newer than the temporary CSS file its going to generate it will regenerate. This all but eliminates the need to manually dump the CSS cache.

## 6.6.1 - 2016-07-11

### Fixed
- Fixed a couple issues in the new DataTables library that were causing PHP notices (which causes data to fail when error reporting is enabled).

## 6.6.0 - 2016-07-11

### Manual Action
- The Update controller was updated. You should manually update it before updating.

### Security
- Security of the AJAX controller functions has been audited and greatly improved. All sites which can easily do so should be update to this version as soon as possible.

### Removed
- Access to the old testimonials admin pages have been removed. Testimonials have been a content type since v6.0.0. The testimonials module (`testimonials`) remains for backwards compatibility but will be removed in a future version.

### Deprecated
- The old methods for getting DataTables data (`get_data()`) will eventually removed. All DataTables should be upgraded to the newer methods (`DataTables::simple()` and `DataTables::complex()`).

### Added
- Newer methods for loading DataTables are now available (`DataTables::simple()` and `DataTables::complex()`). Examples of this can be found on any core data list.
- It is now possible to sort content pages by content type and/or category.
- Application cache and CSS cache are now emptied after installing an update.

### Changed
- All core DataTables have been upgraded to the newer methods (`DataTables::simple()` and `DataTables::complex()`).
- Shop products list now uses a proper DataTables custom search filter rather than simply populating the search query.

## 6.5.5 - 2016-07-08

### Fixed
- Content list module's (`content_list`) "keep formatting" option for featured/non featured articles was backwards.
- Shop route model wasn't escaping query values.

## 6.5.4 - 2016-07-06

### Fixed
- High DPI thumbnails would fail to crop if the image was not large enough for a high DPI copy to be created. In such a case, a high DPI copy will only be created if cropping is disabled.
- Unpublished pages were appearing in the sitemap.

## 6.5.3 - 2016-07-06

### Fixed
- Fixed a typo on the new SEO page.
- Fixed an issue with redirecting after generating a sitemap or crawling links.

### Added
- Added a shop menu link to rebuild the `shop_routes` table. This is sometimes necessary if the built in mechanisms fail to keep it in sync with the shop categories and products.

### Changed
- The sitemap generator now relies on the `sites` and `shop_routes` tables to generate itself. Most of the time, this should provide flawless results in far less time than crawling the site.
- The sitemap generator and link checker now require that an admin user be logged in or that they are running from the command line (cron job). This will prevent public access to triggering these functions.

## 6.5.2 - 2016-07-06

### Fixed
- The shop parent category list has been cleaned up.
- The sitemap generator now ignores `mailto` and `tel` URLs.
- The sitemap generator now ignores anchors in URLs.
- The sitemap generator is slightly more error tolerant.
- Fixed an issue with shop category path string not saving properly.

### Added
- The main menu now contains a link to an SEO page with links to various SEO related pages.

### Changed
- Crawler issues are no longer reported in the main menu. They are now on the new SEO page.
- Several SEO related menu items were removed. They are now on the new SEO page.

## 6.5.1 - 2016-07-05

### Added
- Changing a shop category or shop product will now automatically create 301 redirects when necessary.

## 6.5.0 - 2016-06-30

### Added
- When saving content types with images the images are not cropped to the size requested upon every save so that its very easy to resize images after the fact. Original images are kept for further processing by the content list module (`content_list`).
- When creating a page using a content type with an image the system will display the most commonly used image size for the selected category. This should help users use consistent image sizes.
- When saving a blank page content type where only one image is present in the content the system will suggest converting to a "content with image" content type. The system will also provide a link to have the page automatically converted.

### Changed
- When creating thumbnails, retina copies will be deleted before proceeding so that they can be regenerated (unless both copies already exist).

## 6.4.1 - 2016-06-29

### Added
- Contact form module (`contact`) now supports a redirect URL for bouncing users to a thank you page upon successful submission.

### Changed
- Content list module (`content_list`) now crops images to the exact size required and no longer supports the "banner view port" style imagery.
- Content list module (`content_list`) settings were carefully reconsidered and some were removed or renamed.
- Content list module (`content_list`) now allows for multiple columns of featured articles in addition to multiple columns of regular articles.

## 6.4.0 - 2016-06-27

### Manual Action
- The Update controller was updated. You should manually update it before updating.

### Fixed
- [[0000913]](https://bugnet.nerivon.com/view.php?id=0000913): Unpublished pages should no longer show up in content lists.
- Some default settings for the BX Slider module (`slideshow_bxslider`) were invalid or not optimal.
- Some default settings for the Nivo Slider module (`slideshow_nivoslider`) were invalid or not optimal.
- Contact info module (`contact_info`) no longer shows empty rows when information is not entered.

### Changed
- [[0000853]](https://bugnet.nerivon.com/view.php?id=0000853): The page table's `added` field was renamed to `created` for clarity and a `modified` field was also added.
- Image alignment settings in the content list module (`content_list`) were renamed to "Crop Settings" and the values were modified to uniform `background-position` values. Better descriptions and more crop values were added.
- [[0000904]](https://bugnet.nerivon.com/view.php?id=0000904): Content type images now save their original images for use by the content list module (`content_list`).
- [[0000904]](https://bugnet.nerivon.com/view.php?id=0000904): Content list module (`content_list`) now grabs the original image when available and creates a more suitable image size from it.
- [[0000904]](https://bugnet.nerivon.com/view.php?id=0000904): Content list module (`content_list`) now allows sorting by date created and date modified in addition to previous sort options.
- BX Slider module (`slideshow_bxslider`) and Nivo Slider module (`slideshow_nivoslider`) both support a dynamic number of slide specific image links (20 max).
- BX Slider module (`slideshow_bxslider`) and Nivo Slider module (`slideshow_nivoslider`) now allow you to specify a blank default link in order to remove the link behaviour entirely. This will now be the default behavior.
- Nivo Slider module (`slideshow_nivoslider`) now allows you to "disable" the captions without hacking CSS yourself.

### Added
- [[0000853]](https://bugnet.nerivon.com/view.php?id=0000853): Created/modified dates were added to the pages list.
- New module: Content Slider (`content_slider`) displays content with similar options from the content list module (`content_list`) in a BX Slider. Content sliders can even be placed inside other content sliders (Sliderception™).
- BX Slider module (`slideshow_bxslider`) and Nivo Slider module (`slideshow_nivoslider`) both have a specific option for using or not using a Lightbox.
- BX Slider module (`slideshow_bxslider`) now includes Lightbox and supports the same Lightbox themes that Nivo Slider (`slideshow_nivoslider`) does.

## 6.3.7 - 2016-06-10

### Fixed
- Modules would sometimes not load in the proper order.
- BX Slider module (`slideshow_bxslider`) was not saving the `startSlide` setting with the correct name.
- Query syntax error in `Shop_product` model.

### Added
- A function was added to purge unused shop images in order to reduce query time and reduce disk space usage.

### Changed
- Shop menu module (`shop_menu`) was improved.
- Minor tweaks to Nivo slider (`slideshow_nivoslider`) and BX Slider (`slideshow_bxslider`).

## 6.3.6 - 2016-05-27

### Fixed
- The new "template LESS" feature was full of path errors.

## 6.3.5 - 2016-05-26

### Manual Action
- The Update controller was updated. You should manually update it before updating.

### Fixed
- Fixed a typo during the upgrade to 6.0.0 that caused content modules to fail upgrading properly.

## 6.3.4 - 2016-05-25

### Changed
- Renamed the `FourOhFour` model to `Four_oh_four` to resolve naming issues.

## 6.3.3 - 2016-05-25

### Manual Action
- The Update controller was updated. You should manually update it before updating.

### Fixed
- Resolved an issue with the update process which wasn't flusing MySQLi multi queries, causing the update to fail.

## 6.3.2 - 2016-05-25

### Manual Action
- The Update controller was updated. You should manually update it before updating.

### Fixed
- [[0000841]](https://bugnet.nerivon.com/view.php?id=0000841): CKFinder may have had an intermittent authentication issue.
- [[0000842]](https://bugnet.nerivon.com/view.php?id=0000842): The "Remove HTML" option for the content list module (`content_list`) will no longer remove the preview image.
- All modules now check for `$title` and `$title_heading_level` before displaying a module title.
- Some old `module_params` were present in the directory module (`directory`), presumably from a merge error.
- BX Slider module (`slideshow_bxslider`) was trying to use a module title that it wasn't supposed to have.

### Added
- Templates which include a LESS file by the same name as the template will now be automatically included for LESS compilation. This file can override anything except the "site specific LESS" code, if present.

### Changed
- Mail settings can now be specified per-site and default to using `localhost` for SMTP rather than `emmie.nerivon.com`.
- `common.less` was cleaned up and had all its variables moved to the theme files where they belong. Module-specific styles were also moved to the module's `less` files where they belong.

## 6.3.1 - 2016-05-13

### Changed
- Added a missing constraint in `module_settings`.
- Ironed out some inconsistencies in the table collations.

## 6.3.0 - 2016-05-12

### Manual Action
- `/application/config/routes.php` was updated. Restore any custom routes.
- The Update controller was updated. You should manually update it before updating.

### Fixed
- Lots of update queries were fixed or improved for a more solid upgrade path.

### Added
- 404 errors are now logged and can be viewed in the admin area. Redirects can easily be added if desired.

### Changed
- Invalid pages no longer all send a 301 redirect to the main page. Instead the 404 is logged and a proper 404 is sent to the requestor. The result is that dead links aren't automatically "cleaned up" by sending a 301 but it gives us more control over where to redirect dead links to.

## 6.2.1 - 2016-04-25

### Fixed
- SEO name for events is no longer a required field because it was messing up child events. Also if an SEO name is entered for a child event it will be wiped out when saved.

## 6.2.0 - 2016-04-20

### Fixed
- Added CSS for reCAPTCHA to align itself properly on contact forms.
- `index.html` GIT placeholders are now removed from `/images/gallery` and `/images/slideshow` after installation so that they won't interfere with modules.

### Changed
- When creating a new page, any modules which are enabled on all other pages will automatically be enabled on the new page.
- PHP value for `max_input_vars` was increased to 100,000 so that it never becomes an issue ever again.
- "Checkbox switches" were removed from the content edit screen to save space.
- The list of pages on the module edit screen was placed in a scrolling div so that if a site has more than about 25 pages it won't stretch the page. The most practical use here is "all" or "none" anyway.

### Added
- It is now possible for content types to place the "page info" fields at the top, at the bottom, or not at all.

## 6.1.1 - 2016-04-14

### Fixed
- Minor issue with user authentication function.
- Disabled the use of `mail()`, `eval()`, `system()`, and `exec()` for security reasons.

## 6.1.0 - 2016-04-13

### Added
- [[0000670]](https://bugnet.nerivon.com/view.php?id=0000670): URL redirects can now be added in the admin area without editing `.htaccess`.
- URL redirects are automatically created if a page, portfolio item, or testimonial item has its SEO name changed.

### Fixed
- [[0000669]](https://bugnet.nerivon.com/view.php?id=0000669): Application cache is now obliterated continually while using the admin area to ensure that its clean after making changes.
- [[0000646]](https://bugnet.nerivon.com/view.php?id=0000646): Inserting Font Awesome icons would sometimes allow text to be typed inside the Font Awesome element.

### Changed
- Updated to Font Awesome 4.6.0.
- Font Awesome editor plugin now supports Font Awesome 4.6.0 and includes `aria-hidden="true"` by default.

## 6.0.0 - 2016-03-31

### Manual Action
- See first point in **deprecated** section.
- Replace any instances of the following modules with the new content list module (`content_list`): Blog (`blog`), Blog - Archives (`blog_archive`), Blog - Latest (`blog_latest`), Blog - Search (`blog_search`), and Testimonials (`testimonials`).
- The Update controller was updated. You should manually update it before updating.

### Deprecated
- Templates **must change** their `echo` of `$page->content` to `Mainframe::content()` without an `echo`. ie: `<?php echo($page->content); ?>` becomes `<?php Mainframe::content(); ?>`. Templates which are not converted will continue to use the old page content for compatibility, however, **that content will no longer be updated**. Old page content has been automatically converted to use the content types, however, the template needs this small tweak in order to utilize it.
- The days are numbered for the following modules: Blog (`blog`), Blog - Archives (`blog_archive`), Blog - Latest (`blog_latest`), Blog - Search (`blog_search`), and Testimonials (`testimonials`).
- Testimonials are now created using a content type. The old testimonials have been converted and will be removed in a future version.

### Added
- The concept of content types was borrowed from Drupal. Content types define common layouts for page content. All new and existing pages will default to `Blank Page` which simulates previous behaviour of simply dumping page content to the screen.
- Content list module (`content_list`) is essentially a clone of the blog module (`blog`) that works with the new content types. This is a generic module that can display pages from any category and/or content type using each individual pages's content type for rendering.
- Created empty image directories for `content`, `gallery`, and `slideshow`.
- Several basic content types are preloaded.
- Added `Title heading level` to pages which allows the system to automatically insert the page title as a heading.
- All modules now have a `module class` setting which allows you to add an additional class to the module's container.
- It is now possible to add redirects to a domain name without editing `.htaccess`.

### Fixed
- Fixed a path issue in the random image module (`random_image`).
- Fixed an issue with the testimonials module (`testimonials`) showing a "view all" link when it shouldn't have.
- Portfolio items now use random image names so that they don't overwrite older images with the same filenames.
- Resolved yet another issue when saving zeros, nulls, and empty strings.
- Fixed some bugs in the blog module (`blog`) despite its pending demise.
- Fixed some bugs with the "check/uncheck all" function.
- Fixed some issues where the login form would not properly return a status message for a failed login attempt.
- The `user_id` cookie that keeps a user logged in was not freshing itself as the user used the system.
- Fixed an issue where the admin menu was cut off on pages where the menu was longer than the content.

### Changed
- Social media icons module (`social`) now supports YouTube and LinkedIn.
- Portfolio items no longer require you to upload `@2x` copies of the images. You can now upload any images and the original source file will be used as the high DPI with a half-sized standard image created automatically.
- [[0000634]](https://bugnet.nerivon.com/view.php?id=0000634): Product name and version was removed from the login screen and page title in order to avoid advertising it to hackers.
- [[0000634]](https://bugnet.nerivon.com/view.php?id=0000634): Login form is now prettier.
- [[0000634]](https://bugnet.nerivon.com/view.php?id=0000634): It is no longer possible to login to the admin area from an IP address outside of Canada or United States.
- [[0000638]](https://bugnet.nerivon.com/view.php?id=0000638): The encryption key in `/application/config/config.php` is now randomly generated during installation.
- [[0000638]](https://bugnet.nerivon.com/view.php?id=0000638): The `user_id` cookie is now encrypted by CodeIgniter so that a hacker can't create a cookie to gain access to the website without the encryption key.
- [[0000614]](https://bugnet.nerivon.com/view.php?id=0000614): The custom content module (`html`) now supports specific breakpoints for each screen size.
- The `ENVIRONMENT` constant now defaults to `production` and must be changed to `development` if you need to see errors.

### Removed
- Removed some unused user cookies when logging in.
- All existing "cake builder" code was removed from the main branch.

## 5.5.9 - 2016-03-10

### Fixed
- Forgot to add some SQL stuff in 5.5.8.

### Changed
- `common.less` updated.
- Services module (`services`) had some text alignment changed.

## 5.5.8 - 2016-03-10

### Fixed
- Fixed an issue with the footer menu having a fixed height.
- Services module (`services`) now preserves line breaks.

### Added
- The Facebook JavaScript SDK can now be included automatically in site configuration.
- Facebook Page Feed module (`facebook_feed`).

## 5.5.7 - 2016-03-08

### Fixed
- A couple of hard coded fonts were removed from the Kasper template.
- Follow up fixes to [0000620].

## 5.5.6 - 2016-03-08

### Fixed
- This version added a single equal sign that was very important to the core model.

## 5.5.5 - 2016-03-08

### Fixed
- Fixed an issue in the contact module (`contact`) which caused Recaptcha not to display.
- Fixed an issue where duplicate redundant checks were present in the contact module (`contact`), presumably due to a merge issue at some point.
- [[0000620]](https://bugnet.nerivon.com/view.php?id=0000620): Child menu items now appear properly on the menu edit screen.
- [[0000619]](https://bugnet.nerivon.com/view.php?id=0000619): Sort values on new menu items were higher than the maximum allowed. Fixing [0000620] resolved this.
- [[0000622]](https://bugnet.nerivon.com/view.php?id=0000622): New testimonials would not save when set to "Full Testimonial."

## 5.5.4 - 2016-03-08

### Fixed
- Contact info module (`contact_info`) had paragraph tags added to resolve style issues with colour themes.

### Added
- `analogous` colour theme.
- Gallery module (`gallery`) now allows the selection of `padded` or `compact` display styles for simple changing of how its laid out.

### Removed
- `complimentary` colour theme never made it off the ground.

## 5.5.3 - 2016-03-08

### Changed
- Font package LESS is now included before colour theme LESS in case there's an `@import` for font faces.
- Testimonial module (`testimonial`) was modified slightly.
- The LESS compiler was replaced with a new one that is still maintained. It is an official port of `less.js`.
- `common.less` had several syntax errors fixed.

## 5.5.2 - 2016-03-08

### Fixed
- Fixed a small issue in the new cache cleaning function that would generate a bunch of PHP warnings.

## 5.5.1 - 2016-03-08

### Fixed
- Lots of pathing issues were fixed in the video module (`video`). **Existing instances of this module may need to have their video file re-selected and saved.**
- Inclusion of `common.less` has been restricted to sites with a colour theme selected. This will prevent upgraded sites from breaking.
- Fixed an issue where high DPI images would not be loaded on the initial page load because of cookie related issues.

### Added
- Its now possible to add some LESS code to a site in order to apply small style tweaks to built in templates.
- The CSS and application caches can be manually cleaned (Home -> Clean Cache);

### Changed
- Testimonials module (`testimonials`) now only shows the client name when viewing full testimonials.
- Testimonials module (`testimonials`) now uses `blockquote` tags for snippet view and also removes HTML from snippet view.
- Default address icon in the contact info module (`contact_info`) was changed from `calendar` to `map-marker`.
- Contact info module (`contact_info`) now lets you choose a horizontal or vertical layout.
- Colour theme and font package are now required since not having a colour theme will break `common.less`.
- `common.less`, colour themes, and font packages have been improved.
- Nerivon CMS can no longer be re-installed without first setting the `INSTALLED` constant back to `false`;
- Services module (`services`) now lets you add a URL and button text to each service block.

## 5.5.0 - 2016-03-04

### Manual Action
- `/application/config/routes.php` was updated. Restore any custom routes.

### Fixed
- NivoSlider module (`slideshow_nivoslider`) and the gallery module (`gallery`) both use Colorbox themes and could conflict if both are used on the same page with different themes. This can still happen, but lightboxes in Nivoslider are almost never used so the CSS file is no longer included unless necessary.
- NivoSlider module (`slideshow_nivoslider`) now uses only the pretty-formatted image filename for its title (without the full path).
- The install SQL scripts have been optimized to use variables for all the repetitive subqueries.
- Menu module (`menu`) now supports "title" and "title heading level" module settings.
- Contact module (`contact`) was not being installed properly with the new `show_x` module settings.

### Added
- Each site can now have 5 colour overrides. These colour overrides will replace the LESS variables for `@color1`, `@color2`, `@color3`, `@color4`, and `@color5` in the selected theme.
- On the site edit screen, a logo can be uploaded and its colours will be analyzed and displayed for the user to easily copy the colour codes to the colour override boxes.
- Added the Kasper template.
- A note was added to the available modules screen indicating that custom modules can be created for an extra cost.
- The installer now allows a user to provide their logo and up to 3 colour overrides using the same interface as the edit site form. In addition to this, providing a logo will automatically resize and insert it into the logo module. Lastly, the logo will be converted into a multi-size favicon.
- The site edit form now has a field for creating a multi-size favicon from an image.

### Changed
- Kasper is now the default template.
- The `ncms` module position is now `content` for clarity.
- `Top Menu` is now known as `Secondary Menu` for clarity.
- Templates can each have their own install scripts now and the only modules being installed in the `content` position are during installation of the "Cake Builder" (`default`) template.

## 5.4.0 - 2016-02-26

### Fixed
- Fixed an issue with sorting in the shop product feed.

### Added
- It is now possible to force SSL connections using the `FORCE_SSL` constant rather than modifying `.htaccess`.
- [[0000607]](https://bugnet.nerivon.com/view.php?id=0000607): It is now possible to select "raw" output in the menu module (`menu`) which changes all the `pure-*` CSS classes to `ncms-*`.
- It is now possible to override the site's template by adding a valid `template_id` to the URL. ie: `https://nerivon.com/portfolio?template_id=2`

### Manual Action
- Add `define("FORCE_SSL", false);` to `/application/config/constants.php` after the `INSTALLED` constant because the constants file is ignored during automatic updates.

## 5.3.3 - 2016-02-23

### Added
- [[0000601]](https://bugnet.nerivon.com/view.php?id=0000601): Pages can now be unpublished which disables all public access.

### Fixed
- [[0000603]](https://bugnet.nerivon.com/view.php?id=0000603): Start and end times on the event edit screen were initially disabled when they shouldn't have been.
- [[0000600]](https://bugnet.nerivon.com/view.php?id=0000600): Lots of little issues with the installer were fixed that would cause errors which ultimately causes the constants and database configuration files to refuse changes.
- A JavaScript error relating to CKEditor was fixed on the page edit screen when page content is controlled by content modules.

### Changed
- Module placeholder images now allow you to right click and edit them. They also use a more proper method of insertion.
- Prerequisite CKEditor modules for using widgets were added. The module placeholder images might be replaced by a widget some day.
- You can now edit an existing Font Awesome icon. Currently you must double click it to have it selected and it doesn't actually show a selection around it, but it is selected. Clicking the Font Awesome icon will edit it.

## 5.3.2 - 2016-02-09

### Fixed
- Small typo in the new `ckeditor-basic` directive which caused it not to initialize.

## 5.3.1 - 2016-02-09

### Fixed
- Reply to was not being set in `send_notification()`.
- Removed "useless horizontal scrollbar" bug in Firefox.
- All WYSIWYG editors for module settings are now AngularJS directives for proper goodness and to fix bug #588 where AngularJS models were not being updated properly.

## 5.3.0 - 2016-02-08

### Manual Action
- The Update controller was updated. You should manually update it before updating.

### Changed
- The contact module (`contact`) now supports having custom fields as well as removing the core fields. This allows for customization that should meet the requirements of most simple contact forms without creating a custom module.
- The "required field" asterisks on the contact module (`contact`) are now after the colon to make Lea happy.

### Fixed
- Fixed a JS error on the login screen and anywhere else that the main menu isn't shown.

## 5.2.0 - 2016-02-04

### Manual Action
- The Update controller was updated. You should manually update it before updating.

### Added
- Added a page for installing "Preconfigured Pages" using the same install scripts that the installer uses. This allows quick configuration of new pages with modules and menu links ready to go.
- Added a menu link for the recently released updater.

### Changed
- `build.py` was added to the exclusions list in the updater.

## 5.1.1 - 2016-02-04

### Manual Action
- The Update controller was updated. You should manually update it before updating.

### Changed
- The updater should now (in theory) support updating from Nerivon CMS 3.0.0 or newer. Updating from Web Builder should also be possible by uploading the current version of Nerivon CMS, changing the version constant back to what the old version was, and then running the updater to update the database.

## 5.1.0 - 2016-02-03

### Added
- Added an auto-update feature, currently "hidden" at `/update` until further tested. This update script can be retrofitted onto any site running 5.0.0 or newer by coping `/application/controllers/Update.php` and `/application/views/update/dashboard.php` to the old site.

## 5.0.7 - 2016-02-01

### Added
- A "popup" announcement module (`announcement`) was added for showing a delayed "popup" when the site is loaded. Please don't use it.

## 5.0.6 - 2016-01-28

### Fixed
- Fixed some issues with the module instance class not behaving nicely, causing issues when saving modules and pages.

## 5.0.5 - 2016-01-26

### Fixed
- Fixed a width calculation bug in the menu module (`menu`).

## 5.0.4 - 2016-01-22

### Fixed
- Fixed yet another issue with the new cookies.

## 5.0.3 - 2016-01-22

### Fixed
- Fixed another minor issue related to the modified login process in v5.0.2.

## 5.0.2 - 2016-01-22

### Changed
- All session cookies for handling login and active_site_id have been converted to standard cookies that utilize the CodeIgniter session expiration and cookie settings. Session variables in Internet Explorer do not appear to last until the user closes their browser.
- User login cookie creation has been moved to the Login controller instead of the User model.

## 5.0.1 - 2016-01-22

### Fixed
- Removed old version of Pure CSS from the default template as it conflicts with the new version in some cases.
- The responsive features in the menu module (`menu`) were not working properly.

## 5.0.0 - 2016-01-13

### Added
- Logo module (`logo`) for displaying a single image with alt text and a link.
- Social media icons module (`social`) for displaying social media icons using Font Awesome vectors.
- Team module (`team`) for displaying mugshots in fancy circles.
- Services module (`services`) for displaying a grid of services.
- Header module (`header1`) as the first official multi-module layer.
- New function (`/admin/upload_image`) allowing AJAX requests to upload a single image.
- A warning message appears above every page while the landing page is enabled. It also provides a quick link to activate the site.
- The installer now allows for creating the following additional common pages: portfolio, testimonials, business directory, and shop.
- You can now view the change log in the admin area.

### Fixed
- Menu items can be reordered using drag and drop again.
- Fixed some incorrect icons on "add new" buttons.
- Fixed an issue where the landing page would show up immediately after installation in the back end.
- Fixed some inconsistent charset issues with the MySQL tables.
- Default tab values in the shop product admin have been corrected.
- Fixed some PHP notices in the shop default layouts.

### Changed
- Implemented the structural fundamentals for "layer" type modules and properly structured module views. This includes:
	+ Modules can include other modules.
	+ Conversion of "module params" into "module settings."
	+ Revamped module settings user interface.
	+ Proper views for module output and settings.
	+ Inclusion of core styling, colour and font themes, and module overriding of styles.
- Blog module (`blog`) now also sets the first heading level using the module parameter when not linked.
- Gallery module (`gallery`) has better alt tags now.
- All outgoing email now uses a common `get_mailer()` function that returns a properly configured PHPMailer based on `get_email_config()`.
- Video (HTML5) module (`video_html5`) now replaces the original video module (`video`).
- Accessibility module (`accessibility`) is updated for new structure.
- Contact module (`contact`) is updated for new structure.
- HTML module (`html`) is updated for new structure.
- Google Map module (`googlemap`) is updated for new structure.
- Image Crop module (`image_crop`) is updated for new structure.
- All Feral widgets that set the `required` attribute now set its value to `required` instead of `1`, as per the HTML5 specification.
- Several modules renamed for better clarity. Only their names, not their directories.
- All modules now use PHP5 constructors.
- Unofficial bug fix to Fancybox in the gallery module when trying to detect IE6.
- Gallery module (`gallery`) now uses a Colorbox lightbox with 5 themes, no longer supports videos, and has a setting for auto-cropping images to a consistent aspect ratio.
- Menu module (`menu`) has been revamped into a "priority menu" with an automatic simple and effective mobile menu. The module also automatically injects duplicate parent menu items when there are drop down lists for better usability across tablets and mobile devices.
- Admin menu now utilizes a "priority" menu the same as the menu module (`menu`). It does not, however, include a mobile menu since its reasonably infeasible to use Nerivon CMS on a smartphone.
- Restructured the installation and update mechanisms for better reliability and less effort.
- All PHP short tags were removed.
- All modules have had their closing PHP tags removed and indentation fixed.
- The template `default_nogrid` was renamed to `default_custom` as a base template for creating custom templates.
- Database changes are no longer stored in the changelog. They now reside only in `/sql/update-{version}.sql` where they should be.
- The function `get_user_logged_in()` has finally been replaced with the simpler `get_user()`. `get_user_logged_in()` remains for backwards compatibility with custom modules, however, all core modules have been upgraded.
- The "Get Started" option on the installer has been removed and is now installed by default.
- The installation process has been stabilized to handle bad situations better.
- All database initialization during the installation process has been moved into `/sql/install-{something}.sql` and is no longer created using database models.
- Admin area and landing page fonts changed to Lato and Rajdhani until our final re-branding is complete.
- All database models have had their now-redundant field definitions removed. These have loaded automatically for a while now.
- Removed the use of CodeIgniter's `set_value()` form function because it was HTML encoding values. In the early days of CodeIgniter I thought it was necessary.
- All database tables now have proper constraints and consistent naming conventions.
- All admin pages now use Pure Grids for the title/buttons instead of floats.
- Updated to Font Awesome 4.5.0.
- `/ajax/get_icons` can now be used as a datasource on module settings in order to show a list of all Font Awesome icons as of 4.5.0.  See the contact info module (`contact_info`) module for an example of this.
- All modules, with the exception of a select few, now have `title` and `title_heading_level` module settings. This is now a new standard for modules.
- Postal code installer for the shop was changed and no longer takes all day to install the postal codes.
- All database tables have been refactored to use table-specific ID fields instead of the ambiguous `id` field.

### Security
- The default username is now "admin" with a random number between 1 and 9 appended to the end of it.
- The default password is now 10 characters instead of 8.

### Removed
- TCPDF is not actually used anywhere anymore. All new reports should use LaTeX functions.
- Countdown module (`countdown`).
- Music module (`music`).
- News ticker module (`ticker`).
- Non-HTML5 video module (`video`).
- Payment calculator module (`payment_calculator`).
- Quote module (`quote`).
- Old menu module (`menu_old`).
- Random video module (`random_video`).
- Order form module (`order`).
- Complete obliteration of the useless and redundant `inputbox` class.
- The template `default_grid` was removed as a failed attempt at glory.
- The following tables were removed as failed attempts at glory: `module_dependancy`, `template_cake`, `template_cell`, `template_layers`, `template_layers_modules`, `template_row`, `template_options`.
- Facebook Application ID and Application Secret have been removed since they haven't been used in years.
- Facebook ID has been removed from the user accounts because it hasn't been used in years.
- Birth day has been removed from the user accounts because it hasn't been used since the initial version of Web Builder.

### Deprecated
- Internet Explorer 8 and older are no longer officially supported in the admin area due to AngularJS requirements. Anything that continues to work in Internet Explorer 8 is a fluke.
- All custom modules **must** be converted to adhere to the new module settings structure. The old module params have been **REMOVED.**
- Any custom modules which were using TCPDF **must** be updated. TCPDF has been **REMOVED**.
- Any client templates that rely on the `inputbox` class **must** update their CSS to style the inputs generically.
- Any admin areas utilizing the "custom menu" secondary menu **must** convert it to a Pure CSS menu. The old initialization code has been **REMOVED**.
- Any custom modules which were using `get_user_logged_in()` should be changed to `get_user()`. `get_user_logged_in()` will be removed eventually.
- Any custom modules which were using generic `id` fields from core database tables **must** be updated.

### Manual Upgrade Action Required
- Move `/application/views/shop/category_module.php` to `/application/views/modules/shop_category/module.php`
- Move `/application/views/shop/account_dashboard.php` to `/application/views/modules/account/module.php`
- Move `/application/views/shop/account_info.php` to `/application/views/modules/account/info.php`
- Move `/application/views/shop/account_orders.php` to `/application/views/modules/account/orders.php`

## 4.8.2 - 2015-12-16
### Changed
- FileManager was replaced with CKFinder for the Media Manager.

### Fixed
- Futher refinements to the core database model to improve handling of zeros and nulls.
- Module settings in bxSlider module are now working properly.
- Menu links without a page selected will now save properly.
- Sites without a theme or font package selected will still include module LESS and common LESS.
- Duplicate module feature now duplicates the views folder as well.

## 4.8.1.13 - 2015-12-15
### Fixed
- Unofficial bug fix to Fancybox in the gallery module when trying to detect IE6.

### Added
- Added front end directory export to the directory module.
- WYSIWYG editor now understands Font Awesome tags on `span`, `em`, and `i` tags. Those tags can be empty without being stripped and do not require a non-breaking space anymore.
- WYSIWYG editor now supports inserting Font Awesome icons via a toolbar icon (blue star).

### Fixed
- The "Insert Module" dialog is now properly sorted.

### Changed
- "Insert Module" icon updated (blue cubes).
- "Insert Module" dialog has been polished a bit.
- Gallery module has better alt tags now.
- Reconfigured WYSIWYG toolbar buttons.
- The "module placeholder" image has been improved.
- All system emails now come from `contactform@[domian name]` for better delivery.

## 4.8.1.12 - 2015-12-15
### Fixed
- Menu item drag and drop wasn't working properly.

## 4.8.1.11 - 2015-12-15
### Fixed
- Shop category "feed" no longer has duplicate products.

## 4.8.1.10 - 2015-12-14

### Manual Action
- `/application/config/routes.php` was updated. Restore any custom routes.

### Fixed
- The route `shop/search` had been accidentally removed.
- CSS for the new shop product image sort became incorrect at some point.

## 4.8.1.9 - 2015-12-14

### Fixed
- `send_notification()` was using SSL instead of TLS and not working.
- Shop category "feed" now obeys the specified category sort order including subcategories. This means the sort value is effective "per page" rather than "per category." Not ideal, but it solves the problem without a rewrite.

## 4.8.1.8 - 2015-12-11

### Fixed
- Shop category "feed" now obeys the specified category sort order.

## 4.8.1.7 - 2015-12-10

### Changes
- Updated to FileManager 10.41.
- More tweaks to Media Manager (FileManager) configuration.
- Changed FileManager to use the JavaScript upload engine instead of PHP.

## 4.8.1.6 - 2015-12-10

### Fixed
- Media Manager configuration was modified to prevent thumbnail directories from crashing it.
- Path error in the footer.

## 4.8.1.5 - 2015-12-10

### Manual Action
- `/application/config/routes.php` was updated. Restore any custom routes.

### Added
- Shop category layouts can now be displayed in a "feed" where all categories and products will be loaded.
- The number of products per page can now be overridden in a category layout. If specified, the shop's configuration value will be ignored and the category layout's value will be used.

### Fixed
- Shop category path builder is now far more efficient and shouldn't stall anymore.
- A few little bugs here and there related to the shop section and PHP notices.
- A few files were referencing other files or the PDF library using the wrong case and therefore failing.

### Changed
- Shop product images can now be manually sorted.

## 4.8.1.4 - 2015-09-29

### Fixed
- Fixed a few issues in the contact module, since it was accidentally pre-released prior to v5.
- Fixed a PHP notice in menu_mobile module.

### Added
- Added options for stripping HTML and how to align the preview images.

### Removed
- Removed some pre-release files from v5 that were breaking the contact module settings.

## 4.8.1.3 - 2015-09-28

### Fixed
- Fixed a bunch of installer bugs.

## 4.8.1.2 - 2015-09-28

### Changed
- Core model now manually caches queries when it can and does its own dirty checking before saving. This results in a huge performance boost.

### Changed
- Directory module now sorts properly and allows for sorting by company or contact.
- Directory module is now generic to avoid forking.

### Added
- Added Schema.org structured product data to default product page.

## 4.8.1.1 - 2015-09-04

### Manual Action
- `/application/config/routes.php` was updated. Restore any custom routes.

### Fixed
- Another couple fixes for pre-installation.

## 4.8.1 - 2015-09-04

### Manual Action
- `/application/config/routes.php` was updated. Restore any custom routes.

### Added
- Added imagemin to Grunt tasks.

### Changed
- Compressed images.
- Removed some old unused images.
- Updated to CodeIgniter 3.0.1
- Core model improvements.
- No more use of CodeIgniter's session BS. Only using PHP sessions now.

### Fixed
- Gallery module now includes minified Pure CSS file and no longer breaks Pure CSS as a result.
- Changed database library to avoid autoloading if Nerivon CMS is not installed yet.
- Bug when changing a user's password.
- Problem with RSS generator.
- Improper "Error Saving User" message when saving a user successfully.
- Unchecked checkboxes not saving (ie: unpublished).
- Media manager works again due to ditching CodeIgniter's sessions.
- CKFinder works again due to ditching CodeIgniter's sessions.

## 4.8.0 - 2015-05-14

### Added
- New function `distance()` calculates the distance between two latitudes/longitudes.
- Shop products can now be deleted in batch.
- New maintenance function to clean up hung queries and optimize the database.
- Now uses NPM and Grunt for developer sanity.
- Karma configuration added for upcoming unit tests.
- Added a directives controller which allows AngularJS directives to be loaded via /directives/filename
- Added a cool loading directive.

### Changed
- changelog.txt changed to CHANGELOG.md and now adheres to standard change log practices as well as Semantic Versioning.
- Old menu module is being archived as `menu_old` in case any sites are too difficult to update to the new module.
- Added Redirect URL field to contact module.
- Installation and update SQL are now stored in individual files for better clarity.
- Removed constraint for product options to prevent deleting a product.
- Major optimization to product model.
- Major refactoring of JavaScript and CSS minified filenames for consistency.
- Updated to CodeIgniter 3.0.0

## Fixed
- Shop geocoder was not working properly in all situations.
- Speed improvements from Jensen Trailers in the slideshow modules and shop queries.
- Optimized shop product list in admin area.

## 4.7.2 - 2015-04-16
- Official build of 4.7.2.

## 4.7.2 RC
### Added
- Added a "Shipping N/A" flag to indicate that a product should not be included in shipping charges (ie: for services).
- Added Purolator as a default shipping gateway, ported from Jensen Trailers.
- Added Moneris Hosted Payment Page as a default payment gateway, ported from Opus Glow.
- Added viewport meta tag to default templates.
- Added an option to sort by filename only or aspect ratio then filename.
- Added `restricted admin` for use by front-end components.

### Removed
- CodeMirror CKEditor plugin because it screws up drag and drop in the code window and that annoys Lea.

### Deprecated
- NEW MENU MODULE REQUIRES CSS MODIFICATIONS.

### Fixed
- Fixed a loading bug in the Google Maps module.
- Re-added AddThis features which got lost in the shuffle somewhere along the line.

### Changed
- Changed menu module to utilize Pure CSS menus now that they don't rely on YUI.
- Replaced admin menu with a proper Pure CSS menu.
- Restructured much of the base controller functionality into MY_Controller.
- Updated events registration module.
- Updated media manager to the latest version of FileManager.
- All relevant product queries should now respect any shopper group price overrides.
- Product and category routes will now update "down the branch" for related categories and products.
- Postal code lookups are now done locally since the previous service disappeared.
- Modified credit card payment gateway to use the new gateway "configuration" field.
- Improvements to the blog module.
- Updated robots.txt to be less restrictive.

## 4.7.1
- Fixes for 4.7 after merging with Jensen Trailers and realizing that there were lots of issues and areas for optimization.
- Improvements to search speed and functionality.
- Updated to Pure CSS 0.6.0
- Changed menu module to utilize Pure CSS menus now that they don't rely on YUI.
- Restructured much of the base controller functionality into MY_Controller.

## 4.7
- Significant structural updates to the shop.
- Created shop "routes" to define category and product URLs. These routes provide vast improvements on previously bulky and slow operations.

## 4.6
- Removed email marketing features.
- Separated JS and CSS files such that they're not including other script files during preprocessing. While better for performance, this causes a multi-user nightmare. Now only basic LESS and minifying are used.
- Fixed a bug where data tables would overflow in Chrome.
- Updated to CI 2.2.1
- Updated registration module.
- Fixed a bug in NivoSlider and bxSlider causing a broken link instead of a lightbox popup.
- Improvements to the crawler.
- Added default favicons for the default templates.

## 4.5.6
- Fixed a bug causing sitemap.xml to be blocked by .htaccess

## 4.5.5
- Added RSS features.
- Added Tag library, though it is not used yet.
- Added autoloading properties in the core MY_Model, though no database models are using it yet.

## 4.5.4
- Minor bug in the content preprocessor applying camel case to image alt tags.
- Added a cleaned up central thumbnail system and applied it to the gallery/slideshow modules.
- Gallery module will now sort images by aspect ratio and push tall images to the end.
- Fixed a bug when logging in with an incorrect password.
- Fixed typos during installation.
- Added subdirectory support to slideshow modules.
- Fixed a bug in the blog search module.
- Links in search field fixed to match new URL structures.
- List view improvements.
- Template options became a reality.

## 4.5.3
- Added shopper groups and shopper group specific prices.

## 4.5.2
- Removed HostGator "fix" for PHP 5.3. It breaks when used on other servers and no longer works on HostGator.
- Revamped lots of forms to use Pure CSS instead of tables.
- Fixed a bunch of installer issues.
- Revamped the admin login form.
- Added password reset to the admin login form.
- Added the ability to hide the footer display (but keep the scripts & stuff).
- Added missing blog search module from DRHBA.
- Updated blog module from DRHBA.
- Changed "sort priority" in the shop to a straight up number field because it was apparently really confusing to clients.
- Because of above, the sort order also changed slightly.

## 4.5.1
- Added the ability to duplicate a module for customization. ie: duplicate a contact module in order to customize it.
- Added missing directory modules from Bowmanville BIA.
- Some UI fixes.

## 4.5
- Registration module enhancements.
- Users can now be set as inactive.
- Shop overhaul / more shop features. NOT ENTIRELY COMPLETE.
- Added a database update mechanism. Go to /update and follow the instructions.
- Redirection added to admin login.
- Added `booking_appointments` table to the upgrade script.
- Remodeled the header.
- Added global site search to the menu bar.
- Updated to DataTables 1.10.3.
- Added fancy switch toggles for checkbox and radio buttons.
- Added missing event modules that were never merged.
- Added Image Crop Tool for cropping slideshow banners to the correct size.
- Added a "dummy module" called image_crop which simply lets us define image sizes and directories for the Image Crop Tool.
- Contact form now uses the system wide email server settings.
- Removed the "click to continue" pages.
- Fixed delete confirmation dialogs.
- Lists now have clickable titles so that the edit button isn't forcefully required.
- Links are now in the form of: /admin/xxx/##
- Shop section will receive the same love while developing Jill Jensen's site.
- Added sitemap.xml generator. Add a daily cron job for: php /home/user/public_html/index.php crawler sitemap >/dev/null 2>&1
- Added broken image/link checker. Add a daily cron job for: php /home/user/public_html/index.php crawler linkcheck >/dev/null 2>&1
- Added template options.
- Added default grid based template system ala-"cake builder" mockups.
- Removed some unnecessary clutter.
- Updated CKEditor to 4.4.5
- Updated CKFinder to 2.4.2

### Manual Upgrade Action Required
- Move all shop database models into /application/models/shop

## 4.2.4
- Added AddThis.com social sharing options. Use the full script URL, without the script tag.
- Added slideshow_bxslider module.
- Various bug fixes.
- Added Google Analytics tracking to the sites table for automatic insertion of the tracking code when present.
- Gallery module is now responsive and overhauled.

## 4.2.3 - August 28, 2014
- Cleaned up and optimized several key areas for even better speed.

## 4.2.2 - August 27, 2014
- Added a proper landing page mechanism.

## 4.2.1 - August 19, 2014
- Updated to CodeIgniter 2.2.0
- Lots of installer bug fixes.

## 4.2 - August 14, 2014
- Rolled in lots of bug fixes and changes from Jensen and Holsag.
- Lots of bugs fixed.
- Lots of optimizations added.
- Roles and actions are now included, although not used. They're added so that they're easily available to custom functionality.
- The main controller is now extensible so that new controllers can be created without duplicating the core functionality.
- Made sure that all tables are InnoDB and that all ID fields are int(11) unsigned.
- There were inconsistencies preventing the creation of constraints.
- This paves the path to setting up proper constraints on all the core tables some day.

## 4.1.1 - June 18, 2014
- Various bug fixes.
- Added out of stock notice on shop products.

## 4.1 - June 13, 2014
- Directory and events modules updated.

## 4.0.0 - June 3, 2014
- Shop section added.

## 3.2.1 - May 9, 2014
- Fixed bugs in Booking module and created event calendar module.

## 3.2 - April 24, 2014
- Major fixes to the email marketing system to work as a standalone app.

## 3.1.1
- MAJOR flaw in the password hashing algorithms has been fixed.
- Regenerate password hashes using: password_hash($password, PASSWORD_BCRYPT);

## 3.1
Lots of changes - see GIT repository.

## 3.0.1 - December 30, 2013

## 3.0.0 - December 4, 2013
- Rewritten in CodeIgniter

## 2.2.1 - November 1, 2013
- Added robots.txt to prevent crawling most directories.
- Added a new function in the cron job to empty old files from the temp directories.
- Added .htaccess "no index" files to the temp directories.

## 2.2 - October 18, 2013
- Reintroduced the DOD entertainment, info, menu, and daily special modules for the simplicity of maintaining a single copy of Web Builder.

## 2.1.3.1 - October 17, 2013
- Bug fix in monthly specials module.
- New option in monthly specials module.

## 2.1.3 - October 9, 2013
- Updated everything to consistently require jQuery 1.8.3 due to compatibility issues.
- Cleaned up traces of PrettyPhoto and replaced it with FancyBox in the NivoSlider module.

## 2.1.2 - October 9, 2013
- Updated a few modules to all include jQuery 1.9.1 via HTTPS for consistency to avoid conflicts.
- Added a character limit to the blog module.

## 2.1.1 - Sept 23, 2013
- Disabled error reporting.
- Replaced lightbox with fancybox in gallery module.

## 2.1 - June 13, 2013
- Added HTML5 features to admin area.
- Cleaned up old useless libraries.
- Updated CKEditor and CKFinder.
- Added CodeMirror syntax highlighting to CKEditor.

## 2.0.4 - June 5, 2013
- Optimized images
- Fixed a bug causing user with ID 1 to log as "opening" test emails.
- Removed references to inc/classes.php and inc/footer.php as those were always just empty files that have since been removed.
- Changed old string comparisons to regular expressions and added Google Font URLs to the list of ignores for now.

## 2.0.3 - May 31, 2013
- Added Pure CSS to admin area.
- Added Pure CSS to default template.

## 2.0.2 - May 16, 2013
- Facebook sharing button updated.

## 2.0.1 - April 22, 2013
- Obituary changes.

## 2.0 - January 9, 2013
- Forked from CBS Group.

## 1.8.5.1 - December 5, 2012
- Fixed a potential bug in the cron job file.

## 1.8.5 - November 7, 2012
- Added a base mobile template and mobile menu module.

## 1.8.4.3 - October 24, 2012
- Added a Nivo Slider module.

## 1.8.4.2 - October 11, 2012
- Fixed the module placeholder image.

## 1.8.4.1 - September 27, 2012
- Transparency bug fix in createThumbnail()
- Added a cache override on the image optimizer.

## 1.8.4 - September 13, 2012
- Added an automatic image optimizer/cacher.

## 1.8.3.6 - August 30, 2012
- Fixed e-mail marketing so that checkBounces() is now a cron job to avoid slowing down the UI.

### Manual Action:
+ Add cron job: curl -s -o /dev/null "http://www.example.com/admin/cron.php"

## 1.8.3.5 - July 30, 2012
- Minor CRM tweaks

## 1.8.3.4 - July 6, 2012
- Updated gallery modules to allow multiple levels of directories to be selected.

## 1.8.3.3 - July 4, 2012
- Security release.

## 1.8.3.2 - June 21, 2012
- Added a letter filter to the client page in the CRM.

## 1.8.3.1 - 2012-04-09
- Bug fix for payment method not saving properly in CRM on quotes page.
- Default template changed so that paths need not be updated each time.
- Updated isDev() IP address.

## 1.8.3 - 2012-03-23
- Added Bubbleriffic gallery module.

## 1.8.2 - 2012-03-20
- Truck scheduler added to CRM.
- JSCal2 added to admin section for date/time selection.

## 1.8.1.5 - 2012-03-19
- Bug fixes in gallery and music player modules.
- Added PrettyPhoto option for gallery module.

## 1.8.1.4 - 2012-03-15
- Bug fix in slideshow module (delay was being ignored).

## 1.8.1.3 - 2012-02-17
- Bug fixes in HTML5 Video module.

## 1.8.1.2 - 2012-02-15
- Client letters added to CRM.

## 1.8.1.1 - 2012-02-08
- Bug fix in e-mail marketing check bounces function.

## 1.8.1 - 2012-01-25
- Edits to the CRM.

## 1.8 - 2012-01-13
- Added an SQL patch script.
- Added content categories and related modules for proper blogging.
- Added the ability to share content items on Facebook.

## 1.7.3 - 2012-01-11
- Added a gallery submission module.
- Bug fix in multi-level galleries.
- Added service address to CRM.
- Added payments to CRM.

## 1.7.2 - 2012-01-03
- Added obituaries to the menu dynamically if the file exists.

## 1.7.1 - 2011-12-15
- Better error handling in HTML 5 video module.
- Bug fixes in the CRM.

## 1.7 - 2011-12-08
- Added CRM area.

## 1.6.6 - 2011-11-17
- Added drag & drop sorting to menu items and modules.
- Added monthly specials module.

## 1.6.5.1 - 2011-10-31
- Improved registration module to allow selecting a specific mailing list.

## 1.6.5 - 2011-10-25
- Added video_html5 module for HTML5 video.
- Added version string to the product name in the header for easy version checks.
- Bug fix in menu module causing the menu to be auto expanded and not working.

## 1.6.4 - 2011-09-19
- Fixed a potential bug with the bounce checker.
- Added some SEO enhancements to prevent duplicate content and increase page speed.
- Added proper caching in the gallery module.
- Added automatic minify of CSS and JS files.

## 1.6.3 - 2011-09-14
- Added an RSS feed module.
- Added an RSS YouTube module.

## 1.6.2 - 2011-08-30
- Updated the Fadeshow script to resolve issues with IE9

## 1.6.1 - 2011-08-15
- Fixed an issue where Facebook errors would display if Facebook was down.
- Added mailing list subscription module.
- Added company to merge tags.
- Fixed mailing list bugs after initial launch.

## 1.6 - 2011-08-10
- Added CBS Mailing Software.
- Bug fix in DOD Info module.
- Bug fix in gallery module where album images were distorted due to caching gallery images.
- Added Galleria module.

## 1.5.4 - 2011-04-25
- Tweaked help file.
- Added randomize option to slideshow module.
- Added version to Google Map request to fix a bug in IE7.
- Added support for "All Week" specials to the DOD Specials module.
- Fixed a bug in the registration module parameters.

## 1.5.3 - 2011-03-10
- Added some options to the video module.
- Added random video module.

## 1.5.2 - 2011-02-10
- Fixed a bug on the module page which displayed incorrect template positions when multiple sites are used.
- JQuery 1.4.4 added.
- DOD Menu and navigation menu modules updated to require JQuery 1.4.4
- Minor changes to menu style.
- Fixed list segment bugs for e-mail marketing.

## 1.5.1 - 2011-02-02
- Gallery module now uses global thumbnail function.
- Fixed bugs with installer.
- Fixed JavaScript errors for CKEditor.
- Fixed contact module to include phone number in e-mail.

## 1.5 - 2011-01-31
- Added support for newest DOD Menus.
- Changed menu module to use global JQuery file.

## 1.4.1 - 2011-01-19
- Added an offset for sending e-greetings.
- Improved Facebook publishing feature set.

## 1.4 - 2011-01-18
- Added filter on users page.
- Added option to e-mail marketing page to show user details.
- Various tweaks.
- Fixed issues with Facebook for multiple sites.
- Removed Facebook configuration from inc/configuration.php

## 1.3 - 2011-01-13
- Added Facebook Connect to the registration, login, and admin areas.
- Moved database configuration values from admin/inc/classes.php to inc/configuration.php
- inc/configuration.php is now the only file that can not be overwritten during an upgrade

## 1.2 - 2010-10-21
- Added live chat to header.
- Updated CKFinder to 2.0.1.
- Added a dynamic "menu style" site setting to be set by a template to indicate its main menu's orientation.
- Added an "auto" value for menu style that will dynamically determine menu orientation depending on the template used.

## 1.1 - 2010-10-08
- Added published state to menu items (add published field to database, int, default 1).
- Added list of available modules on the content editing screen to simplify enabling modules for a page, especially new pages.
- Added the ability to auto-install Web Builder using install.values.php or by sending a POST to install.php with the required values.

## 1.0.x	Various edits made to modules, bug fixes, etc.

## 1.0		Initial release
