<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Matomo extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();

		// Force SSL if the constant is set but the HTTPS server variable is not set or set but false.
		if(defined("FORCE_SSL") && FORCE_SSL && preg_match('/^http:/', current_url()) && !is_cli())
		{
			if(defined("LOGGING")) { error_log(PRODUCT_NAME . ": Redirecting to HTTPS."); }
			redirect(str_replace("http://", "https://", current_url()), 'auto', 301);
		}
	}

	public function report()
	{
		$function          = $this->input->post("function");
		$matomo_site_id    = $this->input->post("matomo_site_id");
		$matomo_token_auth = $this->input->post("matomo_token_auth");

		if($function && $matomo_site_id && $matomo_token_auth)
		{
			$url = "https://matomo.nerivon.com";
			$url .= "?module=API&method=$function";
			$url .= "&idSite=$matomo_site_id&period=range&date=" . date("Y-m-d", strtotime("-6 months")) . "," . date("Y-m-d");
			$url .= "&format=JSON&filter_limit=20";
			$url .= "&token_auth=$matomo_token_auth";

			$content = file_get_contents($url);

			if(!$content)
			{
				http_response_code(409);
				die();
			}

			http_response_code(200);
			echo($content);
		}
		else
		{
			http_response_code(409);
		}
	}

	public function chart()
	{
		$function          = $this->input->post("function");
		$matomo_site_id    = $this->input->post("matomo_site_id");
		$matomo_token_auth = $this->input->post("matomo_token_auth");

		if($function && $matomo_site_id && $matomo_token_auth)
		{
			$url = "https://matomo.nerivon.com";
			$url .= "?module=API&method=$function";
			$url .= "&idSite=$matomo_site_id&period=month&date=" . date("Y-m-d", strtotime("-6 months")) . "," . date("Y-m-d", strtotime("last day of last month"));
			$url .= "&format=JSON&filter_limit=20";
			$url .= "&token_auth=$matomo_token_auth";

			$content = file_get_contents($url);

			if(!$content)
			{
				http_response_code(409);
				die();
			}

			http_response_code(200);
			echo($content);
		}
		else
		{
			http_response_code(409);
		}
	}
}
