<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * This controller manages the e-commerce addon.  Its main functionality is a close clone to the main website controller.
 * This allows us to have a "shop" URL and maintain the ability to include modules in product or category descriptions.
 * While this could be done with a module, like everything else, he vast functionality required for the shop warrants its own rig.
 * The URL structure for shop pages will be:
 * /shop.html
 * /shop/category.html
 * /shop/category/category.html (etc)
 * /shop/category/product.html
 */
class Shop extends MY_Controller
{
	protected static $all_products;
	protected static $products;
	protected static $categories;
	protected static $product;
	protected static $category;
	protected static $is_product;
	protected static $is_category;
	protected static $currency;
	protected static $currencies;

	public function __construct()
	{
		parent::__construct();
		$this->scripts[] = '<script src="/js/min/shop.min.js"></script>';
	}

	public static function get_unfiltered_products()
	{
		return self::$all_products;
	}
	public static function get_products()
	{
		return self::$products;
	}
	public static function get_product()
	{
		return self::$product;
	}
	public static function get_categories()
	{
		return self::$categories;
	}
	public static function get_category()
	{
		return self::$category;
	}
	public static function is_product()
	{
		return self::$is_product;
	}
	public static function is_category()
	{
		return self::$is_category;
	}
	public static function currency()
	{
		// $CI =& get_instance();

		// if(self::$currency != "")
		// {
		// 	return self::$currency;
		// }
		// else if($CI->input->get_post("currency") != "")
		// {
		// 	self::$currency = $CI->input->get_post("currency");
		// 	$_SESSION["currency"] = $CI->input->get_post("currency");
		// }
		// else if(isset($_SESSION["currency"]) && $_SESSION["currency"] != "")
		// {
		// 	self::$currency = $_SESSION["currency"];
		// }
		// else
		// {
		// 	self::$currency = "CAD";
		// 	$_SESSION["currency"] = "CAD";
		// }

		self::$currency = "CAD";
		$_SESSION["currency"] = "CAD";

		return self::$currency;
	}

	public static function currency_id()
	{
		$CI =& get_instance();

		$CI->load->model("shop/shop_currency");
		$c = new Shop_Currency();
		$c->LoadByCode(self::currency());

		return $c->currency_id;
	}

	public static function currency_exchange()
	{
		$CI =& get_instance();

		$CI->load->model("shop/shop_currency");
		$c = new Shop_Currency();
		$c->LoadByCode(self::currency());

		return $c->exchange_rate;
	}

	public static function get_currencies()
	{
		if(isset(self::$currencies))
		{
			return self::$currencies;
		}

		$CI =& get_instance();

		$CI->load->model("shop/shop_currency");

		$currencies = $CI->shop_currency->LoadAll();

		foreach($currencies as $c)
		{
			self::$currencies[$c->currency_code] = $c;
		}

		return self::$currencies;
	}

	public static function convert_currency($value, $from, $to)
	{
		$CI =& get_instance();
		$CI->load->model("shop/shop_currency");

		$cfrom = new Shop_Currency();
		$cfrom->LoadByCode($from);

		$cto = new Shop_Currency();
		$cto->LoadByCode($to);

		if($cfrom->exchange_rate > $cto->exchange_rate)
		{
			$diff = $cfrom->exchange_rate - $cto->exchange_rate + 1;
			return $value * $diff;
		}
		else if($cfrom->exchange_rate < $cto->exchange_rate)
		{
			$diff = $cto->exchange_rate - $cfrom->exchange_rate + 1;
			return $value * $diff;
		}
		else if($cfrom->exchange_rate == $cto->exchange_rate)
		{
			return $value;
		}

		//absolute failsafe - all conditions are already covered above
		return $value;
	}

	// public function cctest()
	// {
	// 	$this->load->helper("payment");
	// 	$this->load->model("payment/creditcard");

	// 	$this->creditcard->init();
	// 	$this->creditcard->process();

	// }
	// public function boxes()
	// {
	// 	$this->load->helper("shipping");

	// 	mt_srand();

	// 	echo("Items: ");
	// 	for($i=0; $i<5; $i++)
	// 	{
	// 		$item = new ShippingItem(mt_rand(2, 15), mt_rand(2, 15), mt_rand(2, 15), 2,2);
	// 		$items[] = $item;

	// 		echo($item->getLength() . "x" . $item->getWidth() . "x" . $item->getHeight() . ", ");
	// 	}

	// 	$boxes = array(array(30, 15, 15, 5),
	// 	               array(30, 20, 20, 8),
	// 	               array(30, 30, 30, 12));

	// 	$gateway = new NerivonShippingCalculator();
	// 	$gateway->addItems($items);

	// 	echo("<br />Box Options: ");
	// 	foreach($boxes as $box)
	// 	{
	// 		$gateway->addBoxSize($box[0], $box[1], $box[2], $box[3]);
	// 		echo($box[0] . "x" . $box[1] . "x" . $box[2] . " ($" . $box[3] . "), ");
	// 	}
	// 	$best_box = $gateway->calculate();

	// 	foreach($best_box as $box)
	// 	{
	// 		$box->debug();
	// 	}
	// }

	/**
	 * Take a postal code and look up city/country info.
	 */
	public function geocode($postalcode=null, $return=false)
	{
		if($postalcode == null)
		{
			$postalcode = $this->input->get_post("postalcode");
		}

		$postalcode = str_replace(array(" ", "-"), "", $postalcode);

		$this->load->model("shop/shop_postalcode");

		$pc = new Shop_Postalcode();
		$pc->LoadByCode($postalcode);

		if(isset($pc->postalcode_id) && $pc->postalcode_id > 0)
		{
			if($return)
			{
				return $pc;
			}
			else
			{
				$this->spit_json($pc);
			}
		}

		return null;
	}

	public function shipping_estimate()
	{
		$postalcode = strtoupper(str_replace(array(" ", "-"), "", $this->input->get_post("postalcode")));
		$postalcode = $this->geocode($postalcode, true);

		if(isset($postalcode->postalcode_id) && $postalcode->postalcode_id > 0)
		{
			// Use the "primary" shipping gateway for an estimate.
			$shipping_gateway_id = 1;

			$shipping_vars = array();
			$shipping_vars["shipping_postalcode"] 	= $postalcode->postalcode;
			$shipping_vars["shipping_address"] 		= "100 Main Street East";
			$shipping_vars["shipping_city"] 		= $postalcode->city;
			$shipping_vars["shipping_province"] 	= $postalcode->province;
			$shipping_vars["shipping_country"] 		= $postalcode->country;

			$this->load->helper("shipping");
			$this->load->model(array("shop/shop_cart", "shop/shop_shipping_gateway"));

			$gateway = new Shop_Shipping_Gateway();
			$gateway->load($shipping_gateway_id);

			$cart = new Shop_Cart();
			$cart_items = $cart->GetItemsBySessionID(session_id());

			if(count($cart_items) == 0)
			{
				?><h3 class="center error">Your Cart Is Empty</h3><?php
				return false;
			}

			$gateway_data = array();
			$gateway_data["cart_items"] 	= $cart_items;
			$gateway_data["my_gateway"] 	= $gateway;
			$gateway_data["payment_vars"] 	= array();
			$gateway_data["shipping_vars"] 	= $shipping_vars;
			$gateway_data["order_vars"] 	= array();

			$this->load->model("shipping/" . $gateway->filename);
			$gfn 	= $gateway->filename;
			$rates 	= $this->$gfn->get_rates($gateway_data);

			$gateway_data["rates"] = $rates;
			?>
			<div class="shipping_gateway" id="shipping_gateway<?php echo($gateway->shipping_gateway_id); ?>form">
				<h3><?php echo($gateway->gateway_name); ?></h3>
				<?php $this->load->view("shop/shipping/" . $gateway->filename, $gateway_data); ?>
			</div>
			<?php
		}
		else
		{
			?><h3 class="center error">Postal Code Not Found</h3><?php
			return false;
		}

		return "FAILED";
	}

	private function force_ssl()
	{
		if(empty($_SERVER['HTTPS']))
		{
			$this->load->helper("url");

			$CI =& get_instance();
    		$CI->config->config['base_url'] = str_replace('http://', 'https://', $CI->config->config['base_url']);
    		redirect($CI->uri->uri_string());
			exit;
		}
	}

	/**
	 * Main shop function for showing categories or products.
	 */
	public function index()
	{
		$site     = Mainframe::site();
		$template = Mainframe::template();
		$page     = Mainframe::page();

		parent::start();

		$this->load->model(array("template", "page", "module", "moduleinstance", "shop/shop_category", "shop/shop_product", "shop/shop_product_layout", "shop/shop_category_layout", "shop/shop_product_variant", "shop/shop_config", "shop/shop_image", "shop/shop_cart", "shop/shop_shipping_gateway", "shop/shop_payment_gateway", "shop/shop_tax", "shop/shop_product_option", "shop/shop_product_related", "shop/shop_order", "shop/shop_datasource", "shop/shop_category_shopper_group", "shop/shop_route"));

		$shop_config = $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);
		$page = Mainframe::loadPage($site->site_id, $shop_config["page_id"]);

		$cart_url 		= LIVE_SITE . "/" . $page->url . "/cart";
		$checkout_url 	= LIVE_SITE . "/" . $page->url . "/checkout";

		self::$is_product 	= false;
		self::$is_category 	= false;

		$user = get_user();
		$data["user"] = $user;

		$route = new Shop_Route();
		$route->LoadBySiteID(Mainframe::site()->site_id, uri_string());

		$url_parts = uri_string();
		$url_parts = explode("/", $url_parts);
		$all_original_url_parts_including_shop = $url_parts;

		//the first element is "shop" so we can shift it off and ignore it
		$url_parts = $all_original_url_parts_including_shop;
		$original_url_parts = $all_original_url_parts_including_shop;
		array_shift($url_parts);
		array_shift($original_url_parts);

		if(is_array($url_parts) && count($url_parts) > 0)
		{
			if($route->product_id != null)
			{
				$product = new Shop_Product();
				$product->LoadWithImages($route->product_id);

				$category = new Shop_Category();
				$category->LoadWithImages($product->main_category_id);
			}
			else if($route->category_id != null)
			{
				$category = new Shop_Category();
				$category->LoadWithImages($route->category_id);
			}
			else
			{
				$this->http404();
				exit();
			}

			$view = false;

			if(isset($product->product_id) && $product->product_id > 0)
			{
				self::$is_product = true;

				$prices = $this->shop_product->LoadAllPrices($product->product_id);

				$layout = new Shop_Product_Layout();
				$layout->Load($product->product_layout_id);

				$layout_specific_options 	= $layout->get_layout_options_for_product_display($product->product_id);
				$product_options 			= $this->shop_product_option->LoadByProductOrCategoryID($product->product_id, $product->main_category_id, true);
				$related_products 			= $this->shop_product_related->LoadByProductID($product->product_id);
				$product_variants 			= $this->shop_product_variant->LoadByProductID($product->product_id);

				if($this->input->post("send-to-friend") == "1")
				{
					$subject = $this->input->post("send-to-friend-sender-name") . " Shared a " . ucwords($this->input->post("send-to-friend-type")) . " With You";
					$recipient = $this->input->post("send-to-friend-recipient-email");
					$url = LIVE_SITE . "/" . $product->url;

					$message = "<p>" . $this->input->post("send-to-friend-sender-name") . " (" . $this->input->post("send-to-friend-sender-email") . ") shared a " . strtolower($this->input->post("send-to-friend-type")) . " with you.</p>";
					$message .= "<p><b>\"$product->product_name\"</b>&nbsp;&nbsp;&nbsp;&nbsp;";
					$message .= "<a href='" . $url . "' target='_blank'>" . $url . "</a></p>";
					$message .= "<p>This product may be of interest to you and " . $this->input->post("send-to-friend-sender-name") . " would like to invite you to browse pictures and specifications. If you are interested in purchasing this product please feel free do to so at the link above or contact us in store at 1-866-479-1744.</p>";

					send_notification($this->input->post("send-to-friend-recipient-email"), $subject, $message);
				}

				$page->url		= $product->url;
				$page->title		= ($product->page_title ? $product->page_title : $product->product_name);
				$page->description	= ($product->meta_description ? $product->meta_description : $page->description);

				if(isset($layout->product_layout_id) && $layout->product_layout_id > 0)
				{
					$view = $layout->view_filename;

					if(!file_exists(APPLICATION_PATH . "/views/shop/" . $view . ".php"))
					{
						$view = false;
					}
				}

				if(!$view)
				{
					$view = "product_default";
				}
			}
			else if(isset($category->category_id) && $category->category_id > 0)
			{
				self::$is_category = true;

				//Check if this user is allowed to view this category
				if($this->shop_category_shopper_group->validate_user($category, $user) == false)
				{
					//Not authorized
					if($category->not_authorized_page_id > 0)
					{
						$p = new Page();
						$p->load($category->not_authorized_page_id);

						header("Location: " . LIVE_SITE . "/" . $p->url . "?redirect=/" . $category->url, TRUE, 401);
						exit();
					}
					else
					{
						header("Location: " . LIVE_SITE, TRUE, 401);
						die("Not authorized.");
					}
				}

				$layout = new Shop_Category_Layout();
				$layout->Load($category->category_layout_id);

				$page->url		= $category->url;
				$page->title		= ($category->page_title ? $category->page_title : $category->category_name);
				$page->description	= ($category->meta_description ? $category->meta_description : $page->description);

				if(isset($layout->category_layout_id) && $layout->category_layout_id > 0)
				{
					$view = $layout->view_filename;

					if(!file_exists(APPLICATION_PATH . "/views/shop/" . $view . ".php"))
					{
						$view = false;
					}
				}

				if(!$view)
				{
					$view = "category_default";
				}
			}
			else
			{
				$this->http404();
				exit();
			}
		}
		else
		{
			self::$is_category = true;

			$category = new Shop_Category();
			$category->category_id = 0;
			$category->category_name = COMPANY_NAME;

			$layout = new Shop_Category_Layout();
			$layout->Load((isset($shop_config["category_layout_id"]) ? $shop_config["category_layout_id"] : 1));
			$view = $shop_config["index_view_filename"];

			if(!file_exists(APPLICATION_PATH . "/views/shop/" . $view . ".php"))
			{
				$view = "index_default";
			}
		}

		if($layout instanceof Shop_Category_Layout && isset($layout->show_all_products) && $layout->show_all_products)
		{
			$products 		= $this->shop_product->LoadFeedByCategoryID((isset($category->category_id) && $category->category_id > 0 ? $category->category_id : 0), (isset($user->shopper_group_id) ? $user->shopper_group_id : 1));
		}
		else
		{
			$products 		= $this->shop_product->LoadByCategoryID((isset($category->category_id) && $category->category_id > 0 ? $category->category_id : 0), (isset($user->shopper_group_id) ? $user->shopper_group_id : 1));
		}
		$categories 		= $this->shop_category->LoadByParentID((isset($category->category_id) && $category->category_id > 0 ? $category->category_id : 0), (isset($user->shopper_group_id) ? $user->shopper_group_id : 1));
		Shop::$all_products = $products;

		Shop::$categories 	= (isset($categories) ? $categories : array());
		Shop::$category 	= (isset($category->category_id) ? $category : null);
		Shop::$product 		= (isset($product->product_id) ? $product : null);

		//pagination stuff
		if(isset($products) && is_array($products))
		{
			$pagination_total			= count($products);
			$pagination_perpage 		= (isset($layout->products_per_page) ? $layout->products_per_page : $shop_config["products_per_page"]);
			$pagination_current_page 	= ($this->input->get_post("page") ? $this->input->get_post("page") : 1);
			$pagination_offset 			= $pagination_perpage * ($pagination_current_page-1);
			$pagination_pages 			= ceil($pagination_total / $pagination_perpage);

			$products = array_slice($products, $pagination_offset, $pagination_perpage);
		}
		Shop::$products = (isset($products) ? $products : array());

		/**
		 * BEGIN IMAGE OPTIMIZATIONS
		 */

		//gather up all category images and ensure they are resized as defined in the category layout
		$shop_category_images = array();

		if(isset($category->category_id) && $category->category_id > 0)
		{
			if(strlen($category->image_filename) > 0)
			{
				$shop_category_images[] = $category->image_filename;
			}
		}

		if(is_array($categories))
		{
			foreach($categories as $cat)
			{
				if(strlen($cat->image_filename) > 0)
				{
					$shop_category_images[] = $cat->image_filename;
				}
			}
		}

		//gather up all product images and ensure they are resized as defined in the product layout
		$shop_product_images = array();
		$shop_product_extra_images = array();
		$shop_product_related_images = array();

		if(self::$is_product) //isset($product->product_id) && $product->product_id > 0)
		{
			//$layout is a PRODUCT layout
			//if product is set, we know that $layout is a product_layout and we can optimize its full_image and all additional images

			if(strlen($product->image_filename) > 0)
			{
				$shop_product_images[] = $product->image_filename;
			}

			process_thumbnails($shop_product_images, $layout->product_image_width, $layout->product_image_height);

			$images = $this->shop_image->LoadByProductID($product->product_id);

			foreach($images as $img)
			{
				if(strlen($img->filename) > 0)
				{
					$shop_product_extra_images[] = $img->filename;
				}
			}

			foreach($related_products as $related_product)
			{
				$shop_product_related_images[] = $related_product->image_filename;
			}

			process_thumbnails(array_merge($shop_product_extra_images, $shop_product_related_images), $layout->extra_image_width, $layout->extra_image_height);
		}
		else if(self::$is_category || self::is_search()) //count($categories) || (count($products) > 0 && isset($layout->category_image_width)))
		{
			//$layout is a CATEGORY layout
			//only process the category images if we're not viewing a product
			process_thumbnails($shop_category_images, $layout->category_image_width, $layout->category_image_height);

			// if(strlen($product->image_filename) > 0)
			// {
			// 	$shop_product_images[] = $product->image_filename;
			// }

			foreach($products as $prod)
			{
				if(strlen($prod->image_filename) > 0)
				{
					$shop_product_images[] = $prod->image_filename;
				}
			}

			process_thumbnails($shop_product_images, $layout->product_image_width, $layout->product_image_height);
		}

		/**
		 * END IMAGE OPTIMIZATIONS
		 */

		$shop_data = array();
		$shop_data["shop_config"]	= $shop_config;
		//$shop_data["shop_controller"] = $this;
		$shop_data["site"]			= $site;
		$shop_data["template"]		= $template;
		$shop_data["page"]			= $page;
		$shop_data["user"]			= $user;
		$shop_data["url_parts"]		= (isset($all_original_url_parts_including_shop) ? $all_original_url_parts_including_shop : null);
		$shop_data["category"]		= (isset($category->category_id) ? $category : null);
		$shop_data["categories"]	= (isset($categories) ? $categories : array());
		$shop_data["product"]		= (isset($product->product_id) ? $product : null);
		$shop_data["products"]		= (isset($products) ? $products : array());
		$shop_data["layout"]		= (isset($layout) ? $layout : null);
		$shop_data["layout_specific_options"]	= (isset($layout_specific_options) ? $layout_specific_options : array());
		$shop_data["product_extra_images"]		= (isset($shop_product_extra_images) ? $shop_product_extra_images : array());
		$shop_data["pagination_total"] 			= (isset($pagination_total) ? $pagination_total : null);
		$shop_data["pagination_perpage"] 		= (isset($pagination_perpage) ? $pagination_perpage : null);
		$shop_data["pagination_pages"] 			= (isset($pagination_pages) ? $pagination_pages : null);
		$shop_data["pagination_current_page"] 	= (isset($pagination_current_page) ? $pagination_current_page : null);
		$shop_data["pagination_offset"] 		= (isset($pagination_offset) ? $pagination_offset : null);
		$shop_data["cart_url"]					= $cart_url;
		$shop_data["checkout_url"]				= $checkout_url;
		$shop_data["product_options"]			= (isset($product_options) ? $product_options : array());
		$shop_data["payment_gateway_messages"]	= (isset($payment_gateway_messages) ? $payment_gateway_messages : array());
		$shop_data["payment_gateway_success"]	= (isset($txn_id) && $txn_id !== false);
		$shop_data["related_products"]			= (isset($related_products) ? $related_products : array());
		$shop_data["product_variants"]			= (isset($product_variants) ? $product_variants : array());
		$shop_data["prices"]					= (isset($prices) ? $prices : array());

		// Only Jensen Trailers uses this, but this allows them to update safely.
		if(self::$is_product && file_exists(APPLICATION_PATH . "/models/shop/Shop_product_size.php"))
		{
			$this->load->model("shop/shop_product_size");
			$sizes 				= $this->shop_product_size->load_by_product_id($product->product_id);
			$shop_data["sizes"] = $sizes;
		}

		$this->load->view("shop/" . $view, $shop_data);
		parent::end();
	}

	public function search()
	{
		$site     = Mainframe::site();
		$template = Mainframe::template();
		$page     = Mainframe::page();

		parent::start();

		$this->load->model(array("template", "page", "module", "moduleinstance", "shop/shop_category", "shop/shop_product", "shop/shop_product_layout", "shop/shop_category_layout", "shop/shop_config", "shop/shop_image", "shop/shop_cart", "shop/shop_shipping_gateway", "shop/shop_payment_gateway", "shop/shop_tax", "shop/shop_product_option", "shop/shop_product_related", "shop/shop_order", "shop/shop_datasource", "shop/shop_category_shopper_group"));

		$shop_config = $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);
		$page = Mainframe::loadPage($site->site_id, $shop_config["page_id"]);

		$cart_url = LIVE_SITE . "/" . $page->url . "/cart";
		$checkout_url = LIVE_SITE . "/" . $page->url . "/checkout";

		self::$is_product = false;
		self::$is_category = false;

		$user = get_user();
		$data["user"] = $user;

		$url_parts = uri_string();
		$url_parts = explode("/", $url_parts);
		$all_original_url_parts_including_shop = $url_parts;

		//the first element is "shop" so we can shift it off and ignore it
		$url_parts = $all_original_url_parts_including_shop;
		$original_url_parts = $all_original_url_parts_including_shop;
		array_shift($url_parts);
		array_shift($original_url_parts);

		$category_id_filter = $this->input->get_post("shop_filter_category_id");
		$layout 			= new Shop_Category_Layout();

		if($category_id_filter > 0 && strpos($category_id_filter, "|") === false)
		{
			$category = new Shop_Category();
			$category->LoadWithImages($category_id_filter);
			$layout->Load($category->category_layout_id);

			$view = $layout->view_filename;

			if(!file_exists(APPLICATION_PATH . "/views/shop/" . $view . ".php"))
			{
				$view = false;
			}

			if(!$view)
			{
				$view = $shop_config["search_view_filename"];

				if(!file_exists(APPLICATION_PATH . "/views/shop/" . $view . ".php"))
				{
					$view = "search_default";
				}
			}
		}
		else
		{
			$layout->Load((isset($shop_config["category_layout_id"]) ? $shop_config["category_layout_id"] : 1));
			$view = $shop_config["search_view_filename"];

			if(!file_exists(APPLICATION_PATH . "/views/shop/" . $view . ".php"))
			{
				$view = "search_default";
			}
		}

		$categories = array();
		$all_products = $this->shop_product->LoadByQuery(false);

		Shop::$all_products = $all_products;
		$products = $this->shop_product->LoadByQuery(true);

		Shop::$categories 	= (isset($categories) ? $categories : array());
		Shop::$category 	= (isset($category->category_id) ? $category : null);
		Shop::$product 		= (isset($product->product_id) ? $product : null);

		//pagination stuff
		if(isset($products) && is_array($products))
		{
			$pagination_total			= count($products);
			$pagination_perpage 		= $shop_config["products_per_page"];
			$pagination_current_page 	= ($this->input->get_post("page") ? $this->input->get_post("page") : 1);
			$pagination_offset 			= $pagination_perpage * ($pagination_current_page-1);
			$pagination_pages 			= ceil($pagination_total / $pagination_perpage);

			$products = array_slice($products, $pagination_offset, $pagination_perpage);
		}
		Shop::$products = (isset($products) ? $products : array());

		/**
		 * BEGIN IMAGE OPTIMIZATIONS
		 */

		//gather up all product images and ensure they are resized as defined in the product layout
		$shop_product_images = array();
		$shop_product_extra_images = array();
		$shop_product_related_images = array();

		foreach($products as $prod)
		{
			if(strlen($prod->image_filename) > 0)
			{
				$shop_product_images[] = $prod->image_filename;
			}
		}

		process_thumbnails($shop_product_images, $layout->product_image_width, $layout->product_image_height);

		/**
		 * END IMAGE OPTIMIZATIONS
		 */

		$shop_data = array();
		$shop_data["shop_config"]	= $shop_config;
		//$shop_data["shop_controller"] = $this;
		$shop_data["site"]			= $site;
		$shop_data["template"]		= $template;
		$shop_data["page"]			= $page;
		$shop_data["user"]			= $user;
		$shop_data["url_parts"]		= (isset($all_original_url_parts_including_shop) ? $all_original_url_parts_including_shop : null);
		$shop_data["category"]		= (isset($category->category_id) ? $category : null);
		$shop_data["categories"]	= (isset($categories) ? $categories : array());
		$shop_data["product"]		= (isset($product->product_id) ? $product : null);
		$shop_data["products"]		= (isset($products) ? $products : array());
		$shop_data["layout"]		= (isset($layout) ? $layout : null);
		$shop_data["layout_specific_options"]	= (isset($layout_specific_options) ? $layout_specific_options : array());
		$shop_data["product_extra_images"]		= (isset($shop_product_extra_images) ? $shop_product_extra_images : array());
		$shop_data["pagination_total"] 			= (isset($pagination_total) ? $pagination_total : null);
		$shop_data["pagination_perpage"] 		= (isset($pagination_perpage) ? $pagination_perpage : null);
		$shop_data["pagination_pages"] 			= (isset($pagination_pages) ? $pagination_pages : null);
		$shop_data["pagination_current_page"] 	= (isset($pagination_current_page) ? $pagination_current_page : null);
		$shop_data["pagination_offset"] 		= (isset($pagination_offset) ? $pagination_offset : null);
		$shop_data["cart_url"]					= $cart_url;
		$shop_data["checkout_url"]				= $checkout_url;
		$shop_data["product_options"]			= (isset($product_options) ? $product_options : array());
		$shop_data["payment_gateway_messages"]	= (isset($payment_gateway_messages) ? $payment_gateway_messages : array());
		$shop_data["payment_gateway_success"]	= (isset($txn_id) && $txn_id !== false);
		$shop_data["related_products"]			= (isset($related_products) ? $related_products : array());
		$shop_data["prices"]					= (isset($prices) ? $prices : array());

		$this->load->view("shop/" . $view, $shop_data);
		parent::end();
	}

	public function cart()
	{
		$site     = Mainframe::site();
		$template = Mainframe::template();
		$page     = Mainframe::page();

		parent::start();

		$this->load->model(array("template", "page", "module", "moduleinstance", "shop/shop_category", "shop/shop_product", "shop/shop_product_layout", "shop/shop_category_layout", "shop/shop_config", "shop/shop_image", "shop/shop_cart", "shop/shop_shipping_gateway", "shop/shop_payment_gateway", "shop/shop_tax", "shop/shop_product_option", "shop/shop_product_related", "shop/shop_order", "shop/shop_datasource", "shop/shop_category_shopper_group"));

		$shop_config = $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);
		$page = Mainframe::loadPage($site->site_id, $shop_config["page_id"]);

		$cart_url 		= LIVE_SITE . "/" . $page->url . "/cart";
		$checkout_url 	= LIVE_SITE . "/" . $page->url . "/checkout";

		self::$is_product 	= false;
		self::$is_category 	= false;

		$cart_items = $this->shop_cart->GetItemsBySessionID(session_id());

		$user = get_user();
		$data["user"] = $user;

		$view 				= "cart_" . $shop_config["cart_view_filename"];
		$task				= $this->input->post("task");
		$product_id 		= $this->input->post("product_id");
		$product_variant_id = $this->input->post("product_variant_id");
		$cart_id 			= $this->input->post("cart_id");
		$quantity 			= $this->input->post("quantity");

		$payment_vars = (isset($_SESSION["payment_vars"]) ? unserialize($_SESSION["payment_vars"]) : array());
		$shipping_vars = (isset($_SESSION["shipping_vars"]) ? unserialize($_SESSION["shipping_vars"]) : array());
		$order_vars = (isset($_SESSION["order_vars"]) ? unserialize($_SESSION["order_vars"]) : array());

		switch($task)
		{
			case "add":
			{
				$added = false;
				$product_options = array();
				$option_prices = 0;

				foreach($this->input->post() as $key=>$value)
				{
					if(substr($key, 0, 7) == "option_")
					{
						$option_id = str_replace("option_", "", $key);

						if($this->input->post("option_$option_id") != "")
						{
							$o = new Shop_Product_Option();
							$o->Load($option_id);
							$o->option_value = $this->input->post("option_$option_id");

							$product_options[] = $o;
						}
					}
				}

				//add the product to the cart
				//check our existing cart to see if this product already exists
				foreach($cart_items as $item)
				{
					//product ID and product options must match, otherwise we add a new item
					if($item->product_id == $product_id &&
					   $item->product_variant_id == $product_variant_id &&
					   $item->product_options == serialize($product_options))
					{
						//if it does, update the quantity
						$cart_item = new Shop_Cart();
						$cart_item->load($item->cart_id);
						$cart_item->quantity += $quantity;
						$cart_item->save();

						$added = true;
						break;
					}
				}
				if(!$added)
				{
					$cart_item 						= new Shop_Cart();
					$cart_item->session_id 			= session_id();
					$cart_item->product_id 			= $product_id;
					$cart_item->product_variant_id 	= $product_variant_id;
					$cart_item->quantity 			= $quantity;
					$cart_item->product_options 	= serialize($product_options);
					$cart_item->save();
				}

				$product_temp = new Shop_Product();
				$product_temp->Load($product_id);

				$category_temp = new Shop_Category();
				$category_temp->Load($product_temp->main_category_id);

				$related_products = $this->shop_product_related->LoadByProductID($product_id);

				//load the product's main category layout simply for grabbing image dimensions.
				$layout = new Shop_Category_Layout();
				$layout->Load($category_temp->category_layout_id);

				$added = false;

				//check for related products that were added to the cart
				foreach($this->input->post() as $key=>$value)
				{
					if(substr($key, 0, 17) == "shop_add_to_cart_")
					{
						$related_product_id = str_replace("shop_add_to_cart_", "", $key);

						if($this->input->post("shop_add_to_cart_$related_product_id") == "1")
						{
							//check our existing cart to see if this product already exists
							foreach($cart_items as $item)
							{
								if($item->product_id == $related_product_id)
								{
									//if it does, update the quantity
									$cart_item = new Shop_Cart();
									$cart_item->load($item->cart_id);
									$cart_item->quantity += 1;
									$cart_item->save();

									$added = true;
									break;
								}
							}

							if(!$added)
							{
								$cart_item 						= new Shop_Cart();
								$cart_item->session_id 			= session_id();
								$cart_item->product_id 			= $related_product_id;
								// TODO: fix this
								// $cart_item->product_variant_id 	= $product_variant_id;
								$cart_item->quantity 			= 1;
								$cart_item->product_options 	= serialize(array());	//additional products don't have options
								$cart_item->save();
							}
						}
					}
				}

				break;
			}
			case "update":
			{
				$cart_item = new Shop_Cart();
				$cart_item->load($cart_id);

				if($quantity == 0 || $this->input->post("remove") == "1")
				{
					$cart_item->delete();
				}
				else
				{
					$cart_item->quantity = $quantity;
					$cart_item->save();
				}

				break;
			}
		}

		//reload cart items in case they've changed
		$cart_items = $this->shop_cart->GetItemsBySessionID(session_id());
		$taxes = $this->shop_tax->LoadBySiteIDForProvince(Mainframe::site()->site_id, (isset($order_vars["order_country"]) ? $order_vars["order_country"] : "CA"), (isset($order_vars["order_province"]) ? $order_vars["order_province"] : "ON"));

		$shop_data = array();
		$shop_data["shop_config"]	= $shop_config;
		//$shop_data["shop_controller"] = $this;
		$shop_data["site"]			= $site;
		$shop_data["template"]		= $template;
		$shop_data["page"]			= $page;
		$shop_data["user"]			= $user;
		$shop_data["url_parts"]		= (isset($all_original_url_parts_including_shop) ? $all_original_url_parts_including_shop : null);
		$shop_data["category"]		= (isset($category->category_id) ? $category : null);
		$shop_data["categories"]	= (isset($categories) ? $categories : array());
		$shop_data["product"]		= (isset($product->product_id) ? $product : null);
		$shop_data["products"]		= (isset($products) ? $products : array());
		$shop_data["layout"]		= (isset($layout) ? $layout : null);
		$shop_data["layout_specific_options"]	= (isset($layout_specific_options) ? $layout_specific_options : array());
		$shop_data["product_extra_images"]		= (isset($shop_product_extra_images) ? $shop_product_extra_images : array());
		$shop_data["pagination_total"] 			= (isset($pagination_total) ? $pagination_total : null);
		$shop_data["pagination_perpage"] 		= (isset($pagination_perpage) ? $pagination_perpage : null);
		$shop_data["pagination_pages"] 			= (isset($pagination_pages) ? $pagination_pages : null);
		$shop_data["pagination_current_page"] 	= (isset($pagination_current_page) ? $pagination_current_page : null);
		$shop_data["pagination_offset"] 		= (isset($pagination_offset) ? $pagination_offset : null);
		$shop_data["cart"]						= (isset($cart) ? $cart : null);
		$shop_data["cart_items"]				= (isset($cart_items) ? $cart_items : array());
		$shop_data["cart_url"]					= $cart_url;
		$shop_data["checkout_url"]				= $checkout_url;
		$shop_data["payment_gateways"]			= (isset($payment_gateways) ? $payment_gateways : null);
		$shop_data["shipping_gateways"]			= (isset($shipping_gateways) ? $shipping_gateways : null);
		$shop_data["taxes"]						= (isset($taxes) ? $taxes : array());
		$shop_data["payment_gateway"]			= (isset($payment_gateway) ? $payment_gateway : null);
		$shop_data["shipping_gateway"]			= (isset($shipping_gateway) ? $shipping_gateway : null);
		$shop_data["task"]						= (isset($task) ? $task : null);
		$shop_data["payment_vars"]				= (isset($payment_vars) ? $payment_vars : array());
		$shop_data["shipping_vars"]				= (isset($shipping_vars) ? $shipping_vars : array());
		$shop_data["order_vars"]				= (isset($order_vars) ? $order_vars : array());
		$shop_data["checkout_errors"]			= (isset($checkout_errors) ? $checkout_errors : array());
		$shop_data["checkout_messages"]			= (isset($checkout_messages) ? $checkout_messages : array());
		$shop_data["product_options"]			= (isset($product_options) ? $product_options : array());
		$shop_data["payment_gateway_messages"]	= (isset($payment_gateway_messages) ? $payment_gateway_messages : array());
		$shop_data["payment_gateway_success"]	= (isset($txn_id) && $txn_id !== false);
		$shop_data["related_products"]			= (isset($related_products) ? $related_products : array());
		$shop_data["prices"]					= (isset($prices) ? $prices : array());

		$this->load->view("shop/" . $view, $shop_data);
		parent::end();
	}

	public function checkout($task=NULL)
	{
		$site     = Mainframe::site();
		$template = Mainframe::template();
		$page     = Mainframe::page();

		parent::start();

		$this->load->model(array("template", "page", "module", "moduleinstance", "shop/shop_category", "shop/shop_product", "shop/shop_product_layout", "shop/shop_category_layout", "shop/shop_config", "shop/shop_image", "shop/shop_cart", "shop/shop_shipping_gateway", "shop/shop_payment_gateway", "shop/shop_tax", "shop/shop_product_option", "shop/shop_product_related", "shop/shop_order", "shop/shop_datasource", "shop/shop_category_shopper_group"));
		$this->load->helper(array("shipping", "payment"));

		$shop_config = $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);
		$page = Mainframe::loadPage($site->site_id, $shop_config["page_id"]);

		$cart_url = LIVE_SITE . "/" . $page->url . "/cart";
		$checkout_url = LIVE_SITE . "/" . $page->url . "/checkout";

		self::$is_product = false;
		self::$is_category = false;

		$cart = new Shop_Cart();
		$cart_items = $cart->GetItemsBySessionID(session_id());

		$user = get_user();
		$data["user"] = $user;

		$view = "checkout_" . $shop_config["checkout_view_filename"];

		if(!file_exists(APPLICATION_PATH . "/views/shop/" . $view . ".php"))
		{
			$view = "checkout_default";
		}

		$task				= ($task != NULL ? $task : $this->input->post("task"));
		$product_id 		= $this->input->post("product_id");
		$product_variant_id = $this->input->post("product_variant_id");
		$cart_id 			= $this->input->post("cart_id");
		$quantity 			= $this->input->post("quantity");
		$shipping_gateways 	= $this->shop_shipping_gateway->LoadBySiteID(Mainframe::site()->site_id);
		$payment_gateways 	= $this->shop_payment_gateway->LoadBySiteID(Mainframe::site()->site_id);
		$payment_gateway 	= new Shop_Payment_Gateway();
		$shipping_gateway 	= new Shop_Shipping_Gateway();

		$payment_vars 	= array();
		$shipping_vars 	= array();
		$order_vars 	= array();
		$custom_vars 	= array();

		$post_vars = $this->input->post();

		if($task == "update")
		{
			$cart_item = new Shop_Cart();
			$cart_item->load($cart_id);

			if($quantity == 0 || $this->input->post("remove") == "1")
			{
				$cart_item->delete();
			}
			else
			{
				$cart_item->quantity = $quantity;
				$cart_item->save();
			}

			$cart_items = $this->shop_cart->GetItemsBySessionID(session_id());
		}

		if($post_vars !== false)
		{
			foreach($post_vars as $key=>$value)
			{
				if(substr_compare($key, "payment_", 0, 8, true) == 0)
				{
					if($key == "payment_cc_num")
					{
						$value = str_replace(array(" ", "-", "/"), "", $value);		//remove spaces/dashes from CC number
					}
					else if($key == "payment_cc_exp_month")
					{
						$value = str_pad($value, 2, "0", STR_PAD_LEFT);				//ensure that month is 2 digits
					}
					$payment_vars[$key] = $value;
				}
				else if(substr_compare($key, "shipping_", 0, 9, true) == 0)
				{
					$shipping_vars[$key] = $value;
				}
				else if(substr_compare($key, "order_", 0, 6, true) == 0)
				{
					$order_vars[$key] = $value;
				}
				else if(substr_compare($key, "custom_", 0, 7, true) == 0)
				{
					$custom_vars[$key] = $value;
				}
			}
		}

		//merge existing payment vars with session payment vars.  both could potentially be empty.
		$payment_vars = array_merge(
                                     (isset($_SESSION["payment_vars"]) ? unserialize($_SESSION["payment_vars"]) : array()),
                                     (isset($payment_vars) ? $payment_vars : array())
                                     );
		//merge existing shipping vars with session shipping vars.  both could potentially be empty.
		$shipping_vars = array_merge(
                                      (isset($_SESSION["shipping_vars"]) ? unserialize($_SESSION["shipping_vars"]) : array()),
                                      (isset($shipping_vars) ? $shipping_vars : array())
                                      );
		//merge existing custom vars with session custom vars.  both could potentially be empty.
		$custom_vars = array_merge(
                                      (isset($_SESSION["custom_vars"]) ? unserialize($_SESSION["custom_vars"]) : array()),
                                      (isset($custom_vars) ? $custom_vars : array())
                                      );
		//$order_vars = array_unique(array_merge($order_vars, (isset($_SESSION["order_vars"]) ? unserialize($_SESSION["order_vars"]) : array())));

		// if(count($payment_vars) > 0 || count($shipping_vars) > 0 || count($order_vars) > 0)
		// {
		if(isset($payment_gateway))
		{
			$payment_vars["payment_gateway"] = $payment_gateway;
		}
		$payment_vars["shipping_total"]		= ($this->input->post("shop_cart_shipping_unformatted") ? $this->input->post("shop_cart_shipping_unformatted") : (isset($payment_vars["shipping_total"]) ? $payment_vars["shipping_total"] : 0));
		$payment_vars["tax_total"] 			= ($this->input->post("shop_cart_tax_unformatted") ? $this->input->post("shop_cart_tax_unformatted") : (isset($payment_vars["tax_total"]) ? $payment_vars["tax_total"] : 0));
		$payment_vars["order_subtotal"] 	= ($this->input->post("shop_cart_total_unformatted") ? $this->input->post("shop_cart_total_unformatted") : (isset($payment_vars["order_subtotal"]) ? $payment_vars["order_subtotal"] : 0));
		$payment_vars["order_total"] 		= $payment_vars["order_subtotal"] + $payment_vars["tax_total"] + $payment_vars["shipping_total"];

		if(isset($shipping_gateway))
		{
			$shipping_vars["shipping_gateway"] = $shipping_gateway;
		}

		$_SESSION["payment_vars"] = serialize($payment_vars);
		$_SESSION["shipping_vars"] = serialize($shipping_vars);
		$_SESSION["custom_vars"] = serialize($custom_vars);

		$payment_gateway->load(isset($payment_vars["payment_gateway_id"]) ? $payment_vars["payment_gateway_id"] : $this->input->get_post("payment_gateway_id"));
		$shipping_gateway->load(isset($shipping_vars["shipping_gateway_id"]) ? $shipping_vars["shipping_gateway_id"] : $this->input->get_post("shipping_gateway_id"));

		$taxes = $this->shop_tax->LoadBySiteIDForProvince(Mainframe::site()->site_id, (isset($shipping_vars["shipping_country"]) ? $shipping_vars["shipping_country"] : "CA"), (isset($shipping_vars["shipping_province"]) ? $shipping_vars["shipping_province"] : "ON"));

		if($task == "process")
		{
			$checkout_errors = array();
			$checkout_messages = array();
			$processing_errors = array();

			//verify taxes, shipping, etc from what the form submitted to what we just calculated to ensure no forgeries have occurred.
			$expected_subtotal 	= 0;
			$received_subtotal 	= $payment_vars["order_subtotal"];	//$this->input->post("shop_cart_total_unformatted");
			$expected_tax 		= 0;
			$received_tax 		= $payment_vars["tax_total"];		//$this->input->post("shop_cart_tax_unformatted");
			$expected_shipping 	= $payment_vars["shipping_total"];	//$this->input->post("shop_cart_shipping_unformatted");
			$received_shipping 	= $payment_vars["shipping_total"];	//$this->input->post("shop_cart_shipping_unformatted");
			$expected_total 	= 0;
			$received_total 	= $received_subtotal + $received_tax + $received_shipping;

			foreach($cart_items as $item)
			{
				$expected_subtotal += ($item->quantity * $item->price);
				$options = unserialize($item->product_options);

				foreach($options as $option)
				{
					$extra = 0;

					switch($option->option_type)
					{
						case "radio":
						case "select":
						{
							$option_values = explode("\n", $option->option_values);

							foreach($option_values as $option_value)
							{
								$values = explode("|", $option_value);

								if(count($values) < 2)
								{
									continue;
								}
								$extra = number_format($item->quantity * ($values[2] ? $values[2] : 0), 2);
							}

							break;
						}
						default:
						{
							$extra = ($item->quantity * $option->price_change);
						}
					}

					if($item->deposit_price > 0)
					{
						$extra = 0;
					}

					$expected_subtotal += $extra;
				}
			}

			if(count($taxes) > 0)
			{
				$cart_total_before_taxes = $expected_subtotal + $expected_shipping;

				foreach($taxes as $tax)
				{
					$tax_amount = $tax->tax_percentage * $cart_total_before_taxes;
					$expected_tax += $tax_amount;
					//$expected_total += $tax_amount;
				}
			}

			$expected_total 	= $expected_subtotal + $expected_shipping + $expected_tax;
			$expected_subtotal 	= number_format($expected_subtotal, 2);
			$expected_tax 		= number_format($expected_tax, 		2);
			$expected_shipping 	= number_format($expected_shipping, 2);
			$expected_total 	= number_format($expected_total, 	2);
			$received_subtotal 	= number_format($received_subtotal, 2);
			$received_tax 		= number_format($received_tax, 		2);
			$received_shipping 	= number_format($received_shipping, 2);
			$received_total 	= number_format($received_total, 	2);

			//we're going to allow a difference of 5 cents to account for potential rounding errors between JavaScript and PHP
			//any difference in values greater than this margin will be flagged and alerted.
			$margin_of_error = 0.05;

			//If our re-calculated total doesn't match the expected total, return to the checkout screen.
			if($expected_total != $received_total)
			{
				$diff = $expected_total - $received_total;

				if($diff < 0)
				{
					$diff *= -1;
				}

				if($diff >= $margin_of_error)
				{
					$checkout_errors[] = "Order total from the previous page doesn't match what it should be.  Please confirm the following information and try again.";
					$task = "confirm";
				}
			}

			if($expected_tax != $received_tax)
			{
				$diff = $expected_tax - $received_tax;

				if($diff < 0)
				{
					$diff *= -1;
				}

				if($diff >= $margin_of_error)
				{
					$checkout_errors[] = "Tax from the previous page doesn't match what it should be.  Please confirm the following information and try again.";
					$task = "confirm";
				}
			}
			if($expected_shipping != $received_shipping)
			{
				$diff = $expected_shipping - $received_shipping;

				if($diff < 0)
				{
					$diff *= -1;
				}

				if($diff >= $margin_of_error)
				{
					$checkout_errors[] = "Shipping from the previous page doesn't match what it should be.  Please confirm the following information and try again.";
					$task = "confirm";
				}
			}

			//if anything above failed, stop processing here
			//if task still equals "process" we're good to continue
			if($task == "process")
			{
				$user 						= get_user();
				$user->phone 				= $shipping_vars["shipping_phone"];
				$user->shipping_address 	= $shipping_vars["shipping_address"];
				$user->shipping_city 		= $shipping_vars["shipping_city"];
				$user->shipping_postalcode 	= $shipping_vars["shipping_postalcode"];
				$user->shipping_province 	= $shipping_vars["shipping_province"];
				$user->shipping_country 	= $shipping_vars["shipping_country"];
				$user->save();

				mt_srand();

				//create order object - it won't be saved unless payment is approved.
				$order = new Shop_Order();
				$order->site_id 					= Mainframe::site()->site_id;
				$order->order_date 					= date("Y-m-d H:i:s");
				$order->ship_date 					= "0000-00-00 00:00:00";
				$order->order_status_id 			= 1;
				$order->customer_postalcode 		= str_replace(array(" ", "-"), "", $this->input->post("shipping_postalcode"));
				$order->payment_gateway_id 			= $payment_vars["payment_gateway_id"];
				$order->shipping_gateway_id 		= $shipping_vars["shipping_gateway_id"];
				$order->shipping_gateway_service 	= (isset($shipping_vars["shipping_gateway_service"]) ? $shipping_vars["shipping_gateway_service"] : null);
				$order->currency_id 				= self::currency_id();
				$order->customer_name 				= $shipping_vars["shipping_name"];
				$order->customer_phone 				= $shipping_vars["shipping_phone"];
				$order->customer_email 				= $shipping_vars["shipping_email"];
				$order->customer_address 			= $shipping_vars["shipping_address"];
				$order->customer_city 				= $shipping_vars["shipping_city"];
				$order->customer_province 			= $shipping_vars["shipping_province"];
				$order->customer_postalcode 		= $shipping_vars["shipping_postalcode"];
				$order->customer_country 			= $shipping_vars["shipping_country"];
				$order->products 					= serialize($cart_items);
				$order->taxes 						= serialize($taxes);
				$order->shipping_total 				= $payment_vars["shipping_total"];
				$order->tax_total 					= $payment_vars["tax_total"];
				$order->order_subtotal 				= $payment_vars["order_subtotal"];
				$order->order_total 				= $payment_vars["order_subtotal"] + $payment_vars["shipping_total"] + $payment_vars["tax_total"];
				$order->custom_fields 				= serialize($custom_vars);
				$order->tracking_number1			= "";
				$order->tracking_number2			= "";
				$order->tracking_number3			= "";

				//logging in to place an order is optional
				if(isset($user->user_id) && $user->user_id > 0)
				{
					$order->user_id = $user->user_id;
				}
				else
				{
					$order->user_id = 0;
				}

				//add order to system
				if($order->save())
				{
					//process payment
					$payment_gateway_messages = array();

					$this->load->helper("payment");
					$this->load->model("payment/" . $payment_gateway->filename);

					$this->{$payment_gateway->filename}->init();
					$txn_id = $this->{$payment_gateway->filename}->process($order, $payment_vars, $payment_gateway_messages);

					if($txn_id !== false)
					{
						$order->txn_id = $txn_id;

						// update the order
						if($order->save())
						{
							//reload the order with full details
							$order->LoadWithDetails($order->order_id);

							//loop through each data source that was used for products on this order and run their process_order() function
							$datasource_ids = array();

							//get all data sources from our cart
							foreach($cart_items as $cart_item)
							{
								if($cart_item->datasource_id > 0)
								{
									$datasource_ids[] = $cart_item->datasource_id;
								}
							}
							//make the list unique
							$datasource_ids = array_unique($datasource_ids);
							require_once(APPLICATION_PATH . "/controllers/Shop_importer.php");

							foreach($datasource_ids as $datasource_id)
							{
								$datasource = new Shop_Datasource();
								$datasource->load($datasource_id);
								$class_name = ucwords($datasource->controller_filename);

								require_once(APPLICATION_PATH . "/controllers/" . $class_name . ".php");

								$datasource = new $class_name();
								$checkout_messages = array();
								$errors = array();
								$checkout_messages[] = $datasource->process_order($order, $errors);

								if(count($errors) > 0)
								{
									$processing_errors = array_merge($processing_errors, $errors);
								}
							}
							//remove duplicate errors
							$processing_errors = array_unique($processing_errors);

							ob_start();
							$this->load->view("shop/emails/order", array("order" => $order));
							$message = ob_get_clean();

							send_notification($order->customer_email, "Order Confirmation", $message);

							//send order confirmation to vendor with any processing errors added to the message
					    	if(count($processing_errors) > 0)
					    	{
					    		$message .= "<p>The following errors have occurred during processing:</p><ul>";

					    		foreach($processing_errors as $error)
					    		{
					    			$message .= "<li>$error</li>";
					    		}

					    		$message .= "</ul>";
					    	}

					    	$admins = explode(",", $shop_config["order_notifications"]);
					    	send_notification($admins, "Order Received", $message);
					    }
					    else
					    {
					    	$checkout_errors[] = "Your payment appears to be complete, but we could not save your order information. Please leave this screen up for reference and contact us to confirm your order.";
							$task = "confirm";
					    }

						//clear session data which contains payment info
						unset($_SESSION["payment_vars"]);
						//clear cart for this session ID
						$this->shop_cart->EmptyBySessionID(session_id());
					}
				}

				//still no errors, go to processing screen
				if($task == "process")
				{
					$view  = "checkout_process";
				}
			}
		}

		$shop_data = array();
		$shop_data["shop_config"]	= $shop_config;
		//$shop_data["shop_controller"] = $this;
		$shop_data["site"]			= $site;
		$shop_data["template"]		= $template;
		$shop_data["page"]			= $page;
		$shop_data["user"]			= $user;
		$shop_data["cart"]						= (isset($cart) ? $cart : null);
		$shop_data["cart_items"]				= (isset($cart_items) ? $cart_items : array());
		$shop_data["cart_url"]					= $cart_url;
		$shop_data["checkout_url"]				= $checkout_url;
		$shop_data["payment_gateways"]			= (isset($payment_gateways) ? $payment_gateways : null);
		$shop_data["shipping_gateways"]			= (isset($shipping_gateways) ? $shipping_gateways : null);
		$shop_data["taxes"]						= (isset($taxes) ? $taxes : array());
		$shop_data["payment_gateway"]			= (isset($payment_gateway) ? $payment_gateway : null);
		$shop_data["shipping_gateway"]			= (isset($shipping_gateway) ? $shipping_gateway : null);
		$shop_data["task"]						= (isset($task) ? $task : null);
		$shop_data["payment_vars"]				= (isset($payment_vars) ? $payment_vars : array());
		$shop_data["shipping_vars"]				= (isset($shipping_vars) ? $shipping_vars : array());
		$shop_data["custom_vars"]				= (isset($custom_vars) ? $custom_vars : array());
		$shop_data["order_vars"]				= (isset($order_vars) ? $order_vars : array());
		$shop_data["checkout_errors"]			= (isset($checkout_errors) ? $checkout_errors : array());
		$shop_data["checkout_messages"]			= (isset($checkout_messages) ? $checkout_messages : array());
		$shop_data["product_options"]			= (isset($product_options) ? $product_options : array());
		$shop_data["payment_gateway_messages"]	= (isset($payment_gateway_messages) ? $payment_gateway_messages : array());
		$shop_data["payment_gateway_success"]	= (isset($txn_id) && $txn_id !== false);
		$shop_data["order"]						= (isset($order) ? $order : null);

		$this->load->view("shop/" . $view, $shop_data);
		parent::end();
	}

	public static function is_search()
	{
		$CI =& get_instance();

		if(self::$is_product)
		{
			return false;
		}

		if($CI->input->get_post("shop_q") != "")
		{
			return true;
		}

		$getvars = $CI->input->get(NULL, TRUE);
		$postvars = $CI->input->post(NULL, TRUE);
		$postvars = array_merge(is_array($postvars) ? $postvars : array(), is_array($getvars) ? $getvars : array());

		foreach($postvars as $key=>$value)
		{
			if(stripos($key, "shop_filter") !== false || stripos($key, "shop_part") !== false)
			{
				return true;
			}
		}

		return false;
	}

	/**
	 * This function will load up any existing data sources, instantiate them, and run their import() method.
	 */
	public function import()
	{
		set_time_limit(86000);
		gc_enable();
		//ini_set("zlib.output_compression", "Off");
		ini_set("memory_limit", "512M");
		ini_set("output_buffering", "0");
		ini_set("implicit_flush", "1");

		$this->output->enable_profiler(false);
		$this->db->save_queries = false;

		if($this->input->get("golong") == "1")
		{
			devecho("Ignoring user abort...");
			ini_set("ignore_user_abort", "1");
		}

		ini_set("track_errors", "1");
		ob_implicit_flush(true);

		while (@ob_end_flush())
		{
			//Void
		}

		$this->load->helper("mainframe");
		$this->load->model("shop/shop_datasource");

		Mainframe::init();

		//get current exchange rates before importing
		$this->update_exchange_rates();

		devecho("Optimizing database...");
		$this->load->dbutil();
		$this->dbutil->optimize_database();

		//load our main importer class
		require_once(APPLICATION_PATH . "/controllers/Shop_importer.php");
		$datasources = $this->shop_datasource->LoadBySiteID(Mainframe::site()->site_id);

		$defrag_tables = array("shop/shop_products", "shop/shop_categories", "shop/shop_images", "shop/shop_categories_products", "shop/shop_layout_specific_data", "shop/shop_layout_specific_data_values", "shop/shop_products_related");

		foreach($defrag_tables as $table)
		{
			//this will "defrag" an InnoDB table, essentially cleaning it up and resetting the auto-increment value to fill in gaps.
			$this->db->query("ALTER TABLE `$table` ENGINE=INNODB");
		}

		$this->avoid_foreach_copy[] =& $datasources;	//this will apparently prevent foreach from working on a 2nd copy of our array

		$datasource_id = $this->input->get_post("datasource_id");

		foreach($datasources as $datasource)
		{
			$classname = ucwords($datasource->controller_filename);

			//if a specific datasource was requested, ignore all others.
			if($datasource_id > 0 && $datasource->datasource_id != $datasource_id)
			{
				continue;
			}
			//load our controller
			require_once(APPLICATION_PATH . "/controllers/" . $classname . ".php");

			//instantiate and run the import method
			$class = new $classname();
			$class->model = $datasource;	//because this isn't a model, we must set this value after instantiation
			$class->import();
			unset($class);
			unset($classname);
			unset($datasource);
		}

		//disable any categories that are empty

		//remove any product images that for whatever reason don't exist

		$this->load->view("shop/import");
	}

	// public function importdev()
	// {
	// 	$this->load->helper("Mainframe");
	// 	$this->load->model(array("shop/shop_product", "shop/shop_image"));

	// 	Mainframe::init();

	// 	$img = new Shop_Image();
	// 	$img->loadbyfilename('t801002l.png');
	// 	if($img->save())
	// 	{
	// 		die("SAVED");
	// 	}
	// 	else
	// 	{
	// 		die("NOT SAVED");
	// 	}
	// 	die();
	// 	$product = new Shop_Product();
	// 	$product->LoadByDatasourceProductID(Mainframe::site()->site_id, "RTTLLED311-1");
	// 	$product->product_id = 45442;
	// 	$product->site_id = 1;
	// 	$product->main_category_id = 346;
	// 	$product->product_layout_id = 1;
	// 	$product->datasource_id = 1;
	// 	$product->datasource_product_id = "RTTLLED311-1";
	// 	$product->datasource_hash = "BRIANISAWESOME";
	// 	$product->product_name = "12V SINGLE LED DOME LIGHT";
	// 	$product->url = "12v-single-led-dome-light";
	// 	$product->meta_description = "12V SINGLE LED DOME LIGHT, PLAFONNIER SIMPLE DEL 12V";
	// 	$product->product_short_description = "12V SINGLE LED DOME LIGHT";
	// 	$product->product_description = "12V SINGLE LED DOME LIGHT";
	// 	$product->cost = 22.33;
	// 	$product->price = 27.91;
	// 	$product->price_lock = 0;
	// 	$product->deposit_price = 0;
	// 	$product->shipping_length = 0.00;
	// 	$product->shipping_width = 0.00;
	// 	$product->shipping_height = 0.00;
	// 	$product->shipping_weight = 0.00;
	// 	$product->published = 1;
	// 	$product->last_modified = "2014-04-08 11:16:19";
	// 	$product->last_datasource_update = "2014-04-08 11:16:19";
	// 	$product->product_image_id = null;

	// 	if($product->save())
	// 	{
	// 		die("SAVED");
	// 	}
	// 	else
	// 	{
	// 		die("NOT SAVED");
	// 	}
	// }

	public function get_taxes()
	{
		$country = $this->input->get_post("country");
		$province = $this->input->get_post("province");

		$this->load->helper("mainframe");
		$this->load->model("shop/shop_tax");
		Mainframe::init();

		$taxes = $this->shop_tax->LoadBySiteIDForProvince(Mainframe::site()->site_id, $country, $province);

		header('Content-type: application/json');
		echo json_encode( $taxes );
	}

	public function get_shipping_rates()
	{
		$shipping_gateway_id 	= $this->input->get_post("shipping_gateway_id");
		$payment_vars 			= (isset($_SESSION["payment_vars"]) 	? unserialize($_SESSION["payment_vars"]) 	: array());
		$shipping_vars 			= (isset($_SESSION["shipping_vars"]) 	? unserialize($_SESSION["shipping_vars"]) 	: array());
		$order_vars 			= (isset($_SESSION["order_vars"]) 		? unserialize($_SESSION["order_vars"]) 		: array());

		$this->load->helper(array("mainframe", "shipping"));
		$this->load->model(array("shop/shop_cart", "shop/shop_shipping_gateway"));

		$gateway = new Shop_Shipping_Gateway();
		$gateway->load($shipping_gateway_id);

		$cart = new Shop_Cart();
		$cart_items = $cart->GetItemsBySessionID(session_id());

		$gateway_data = array();
		$gateway_data["cart_items"] 	= $cart_items;
		$gateway_data["my_gateway"] 	= $gateway;
		$gateway_data["payment_vars"] 	= $payment_vars;
		$gateway_data["shipping_vars"] 	= $shipping_vars;
		$gateway_data["order_vars"] 	= $order_vars;

		$this->load->model("shipping/" . $gateway->filename);
		$gfn = $gateway->filename;
		$rates = $this->$gfn->get_rates($gateway_data);

		$gateway_data["rates"] = $rates;
		?>
		<div class="shipping_gateway" id="shipping_gateway<?php echo($gateway->shipping_gateway_id); ?>form">
			<?php $this->load->view("shop/shipping/" . $gateway->filename, $gateway_data); ?>
		</div>
		<?php
	}

	public function update_exchange_rates()
	{
		$this->load->helper("mainframe");
		$this->load->model("shop/shop_currency");
		Mainframe::init();

		$currencies = $this->shop_currency->get();

		$url = "http://openexchangerates.org/api/latest.json?app_id=f05be6ad81164e9e8ffe777bd2aca8f0";

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		$rates = curl_exec($ch);
		curl_close($ch);

		$rates = json_decode($rates);
		$rates = $rates->rates;

		if(!is_object($rates))
		{
			//something has gone wrong, probably a server outage
			return;
		}

		$base = "";
		$base_value = 0;
		$base_diff = 0;

		//find our base currency, probably CAD
		foreach($currencies as $currency)
		{
			if($currency->exchange_rate == 1)
			{
				$base = $currency->currency_code;
				$base_value = 1/$rates->$base;
				$base_diff = 1-$base_diff;
			}
		}

		//because the base currency returned by OpenExchangeRates is always USD its easiest to convert OUR base currency to USD, then convert to each currency based on the new value, which represents OUR base currency as a percent of all others.
		foreach($currencies as $currency)
		{
			//NEVER update our base currency. If base currency gets messed up, all values eventually turn to zero and prices reflect zero.
			if($currency->exchange_rate == 1)
			{
				continue;
			}

			$currency_code = $currency->currency_code;
			$exchange_rate = $rates->$currency_code * $base_value;

			$c = new Shop_Currency();
			$c->LoadByCode($currency->currency_code);
			$c->exchange_rate = $exchange_rate;
			$c->save();
		}
	}

	public function get_cart()
	{
		$this->load->helper("mainframe");
		$this->load->model("shop/shop_cart");
		Mainframe::init();

		$cart_items = $this->shop_cart->GetItemsBySessionID(session_id());

		header('Content-type: application/json');
		echo json_encode($cart_items);
	}

	/**
	 * This function will run any cron jobs that a datasource may have.
	 * @return [type] [description]
	 */
	public function cron()
	{
		$this->load->helper("mainframe");
		$this->load->model("shop/shop_datasource");

		Mainframe::init();

		$datasources = $this->shop_datasource->LoadBySiteID(Mainframe::site()->site_id);

		require_once(APPLICATION_PATH . "/controllers/Shop_importer.php");

		foreach($datasources as $ds)
		{
			$classname = ucwords($ds->controller_filename);

			require_once(APPLICATION_PATH . "/controllers/" . $classname . ".php");
			$gateway = new $classname();
			$gateway->cron();
		}

		//send_notification("brian@nerivon.com", "Shop cron job has run", "The shop cron job seems to be working properly");
	}

	public static function get_price_range_index($price, $products=null, &$min_price=0, &$max_price=0, &$min_ranges=0, &$max_ranges=0)
	{
		if($products == null)
		{
			$products = self::get_unfiltered_products();
		}

		$min_price = 100000000;
		$max_price = 0;

		foreach($products as $product)
		{
			if($product->price < $min_price)
			{
				$min_price = floor($product->price);
			}
			if($product->price > $max_price)
			{
				$max_price = ceil($product->price);
			}
		}

		$price_ranges = array();
		$price_gap = ceil($max_price - $min_price);
		$price_groups = floor($price_gap * 0.10);	//10% of our price gap gives us a good number of ranges.

		if($price_groups < 1)
		{
			$price_groups = 1;
		}
		else if($price_groups > 8)
		{
			$price_groups = 8;
		}

		// Split up the price gap X times evenly.
		$even_split = (int)($price_gap / $price_groups);

		for($i=0; $i < $price_groups; $i++)
			$price_ranges[$i] = $even_split;

		// Divide up the remainder by adding one to each, progressively.
		for($i=0; $i<$price_gap % $price_groups; $i++)
		    $price_ranges[$i] += 1;

		// Reverse the values so that the last range's high end doesn't look odd when the split is uneven.
		$price_ranges = array_reverse($price_ranges);

		$min_ranges = array();
		$max_ranges = array();

		//Our first range is manually set in order to feed the for loop below.
		$min_ranges[0] 					= floor($min_price);
		$max_ranges[0] 					= $min_ranges[0] + $price_ranges[0] - 1;

		//Now we can repeatedly reference the previous range up to $price_groups number of ranges.
		for($i=1; $i<$price_groups; $i++)
		{
			$min_ranges[$i] = $min_ranges[$i-1] + $price_ranges[$i];
			$max_ranges[$i] = $min_ranges[$i] + $price_ranges[$i] - 1;
		}

		// Ensure that our highest range ends with our max price.
		$max_ranges[$price_groups-1] = $max_price;

		for($i=0; $i<$price_groups; $i++)
		{
			if($price >= $min_ranges[$i] && $price <= $max_ranges[$i])
			{
				return $i;
			}
		}

		return false;
	}

	public function product_quick_view($product_id)
	{
		$site = Mainframe::site();
		$this->load->model(array("shop/shop_config", "shop/shop_product", "shop/shop_product_related", "shop/shop_product_layout", "shop/shop_product_option", "shop/shop_product_variant", "shop/shop_category_layout"));

		$shop_config = $this->shop_config->LoadAssocBySiteID(Mainframe::site()->site_id);
		$page = Mainframe::loadPage($site->site_id, $shop_config["page_id"]);

		$cart_url = LIVE_SITE . "/" . $page->url . "/cart";
		$checkout_url = LIVE_SITE . "/" . $page->url . "/checkout";

		$product = new Shop_product();
		$product->loadWithImages($product_id);

		$layout = new Shop_product_layout();
		$layout->load($product->product_layout_id);

		$view = $layout->view_filename;

		if(!file_exists(APPLICATION_PATH . "/views/shop/" . $view . ".php"))
		{
			$view = "product_default";
		}

		$layout_specific_options 				= $layout->get_layout_options_for_product_display($product->product_id);
		$product_options 						= $this->shop_product_option->LoadByProductOrCategoryID($product->product_id, $product->main_category_id, true);
		$related_products 						= $this->shop_product_related->LoadByProductID($product->product_id);
		$product_variants 						= $this->shop_product_variant->LoadByProductID($product->product_id);
		$page->url								= $product->url;
		$page->title							= ($product->page_title ? $product->page_title : $product->product_name);
		$page->description						= ($product->meta_description ? $product->meta_description : $page->description);

		$shop_data = array();
		$shop_data["shop_config"]				= $shop_config;
		$shop_data["page"]						= $page;
		$shop_data["user"]						= get_user();
		$shop_data["product"]					= (isset($product->product_id) ? $product : null);
		$shop_data["layout"]					= (isset($layout) ? $layout : null);
		$shop_data["layout_specific_options"]	= (isset($layout_specific_options) ? $layout_specific_options : array());
		$shop_data["product_extra_images"]		= (isset($shop_product_extra_images) ? $shop_product_extra_images : array());
		$shop_data["cart_url"]					= $cart_url;
		$shop_data["checkout_url"]				= $checkout_url;
		$shop_data["related_products"]			= $related_products;
		$shop_data["product_options"]			= (isset($product_options) ? $product_options : array());
		$shop_data["product_variants"]			= (isset($product_variants) ? $product_variants : array());

		$this->load->view("shop/" . $view, $shop_data);
	}

	public function add_to_cart()
	{
		$product_id 		= $this->input->post("product_id");
		$product_variant_id = $this->input->post("product_variant_id");
		$quantity 			= $this->input->post("quantity");

		$this->load->model(array("shop/shop_product", "shop/shop_cart", "shop/shop_product_option", "shop/shop_product_variant"));

		$added 				= false;
		$product_options 	= array();
		// $option_prices 		= 0;
		// $options_text 		= "";

		// foreach($this->input->post() as $key=>$value)
		// {
		// 	if(substr($key, 0, 7) == "option_")
		// 	{
		// 		$option_id = str_replace("option_", "", $key);

		// 		if($this->input->post("option_$option_id") != "")
		// 		{
		// 			$o = new Shop_Product_Option();
		// 			$o->Load($option_id);
		// 			$o->option_value = $this->input->post("option_$option_id");

		// 			$product_options[] = $o;
		// 			$options_text .= ($options_text ? ", " : "") . $o->option_value;
		// 		}
		// 	}
		// }

		$cart_items = $this->shop_cart->GetItemsBySessionID(session_id());

		//add the product to the cart
		//check our existing cart to see if this product already exists
		foreach($cart_items as $item)
		{
			//product ID and product options must match, otherwise we add a new item
			if($item->product_id == $product_id &&
			   $item->product_variant_id == $product_variant_id &&
			   $item->product_options == serialize($product_options))
			{
				//if it does, update the quantity
				$cart_item = new Shop_Cart();
				$cart_item->load($item->cart_id);
				$cart_item->quantity += $quantity;
				$cart_item->save();

				$added = true;
				break;
			}
		}
		if(!$added)
		{
			$cart_item 						= new Shop_Cart();
			$cart_item->session_id 			= session_id();
			$cart_item->product_id 			= $product_id;
			$cart_item->product_variant_id 	= $product_variant_id;
			$cart_item->quantity 			= $quantity;
			$cart_item->product_options 	= serialize($product_options);
			$cart_item->save();
		}

        $product = new Shop_product();
        $product->load($product_id);

        $variant = new Shop_product_variant();
        $variant->load($product_variant_id);

        echo('<em class="fas fa-fw fa-check" aria-hidden="true"></em> Added To Cart: ' . $quantity . ' x ' . $product->product_name . ($product_variant_id ? ' (' . $variant->variant . ')' : ""));
	}
}
