<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * This abstract controller is the base for all product importing controllers.
 */
abstract class Shop_Importer extends CI_Controller
{
	const Failed = 0;
	const Refused = -1;
    const Success = 1;
    public $model = null;	//because this isn't a model, our calling function must set this value after instantiation

    /**
     * This function will import products from the data source.
     * @return boolean True if successful, false otherwise.
     */
	public abstract function import();

	/**
	 * This function gives a data source an opportunity to do post-order processing, such as submitting the order to the supplier automatically.
	 * @param  Shop_Order $order The entire order to be processed. Note that its up to the subclass to ignore items which are not for their specific gateway!
	 * @param array $errors Array of errors that have occurred during processing.  Leave empty to indicate no errors.
	 * @return String Message with any desired information about the order that was submitted, such as tracking numbers or delivery dates.
	 */
	public abstract function process_order($order, &$errors=array());

	/**
	 * This function allows for a data source to perform actions via a cron job.  For example, checking for uploaded files by a supplier.
	 * @return void
	 */
	public abstract function cron();

	protected function flush_buffers()
	{
		@ob_flush();
		@flush();
	}

	public function create_url($string)
	{
		$url = strip_tags($string);								//remove HTML
		$url = preg_replace('/[^0-9A-Za-z\-_]/', '-', $url);	//remove non URL characters
		$url = preg_replace('/\-+/', '-', $url);				//remove multiple dashes
		$url = preg_replace('/^\-/', '', $url);				//remove leading dashes
		$url = preg_replace('/\-$/', '', $url);				//remove trailing dashes
		$url = strtolower($url);								//change to lower case

		return $url;
	}

	protected function post($url, $data, $optional_headers = null)
	{
		$params = array('http' => array(
		          'method' => 'POST',
		          'content' => $data
		        ));
		if ($optional_headers !== null)
		{
			$params['http']['header'] = $optional_headers;
		}
		$ctx = stream_context_create($params);
		$fp = @fopen($url, 'rb', false, $ctx);
		if (!$fp)
		{
			throw new Exception("Problem with $url, $php_errormsg");
		}
		$response = @stream_get_contents($fp);
		if ($response === false)
		{
			throw new Exception("Problem reading data from $url, $php_errormsg");
		}
		fclose($fp);

		return $response;
	}
}
