<?php
class MY_Loader extends CI_Loader
{
	public function view($view, $vars = array(), $return = FALSE)
	{
		if(file_exists(APPLICATION_PATH . "/views/overrides/" . $view . ".php"))
		{
			if(defined("LOGGING")) { error_log(PRODUCT_NAME . ": View `" . $view . "` has an override."); }
			$view = "overrides/" . $view;
		}
		return parent::view($view, $vars, $return);
	}

	public function model($model, $name = '', $db_conn = FALSE)
	{
		if(!is_array($model))
		{
			$model = array($model);
		}

		foreach($model as $m)
		{
			if(file_exists(APPLICATION_PATH . "/models/overrides/" . $m . ".php"))
			{
				if(defined("LOGGING")) { error_log(PRODUCT_NAME . ": Model `" . $m . "` has an override."); }
				$m = "overrides/" . $m;
			}
			parent::model($m, $name, $db_conn);
		}
	}
}
