<?php
/**
 * When tracking information is added to an order, this function can be called to notify the customer.
 * @param  int $order_id Order ID of the order which had tracking information added.
 * @return void
 */
function tracking_info_added($order_id)
{
	$CI =& get_instance();

	$CI->load->model(array("shop/shop_order", "shop/shop_shipping_gateway"));
	$CI->load->helper("shipping");

	$order = new Shop_Order();
	$order->LoadWithDetails($order_id);

	$gateway = new Shop_Shipping_Gateway();
	$gateway->load($order->shipping_gateway_id);

	$CI->load->model("shipping/$gateway->filename");
	$model = $gateway->filename;

	$gateway_name = $CI->$model->name();

	$tracking_numbers = array();
	$tracking_urls = array();

	if($order->tracking_number1)
	{
		$tracking_numbers[] = $order->tracking_number1;
		$tracking_urls[] = $CI->$model->tracking_url($order->tracking_number1);
	}
	if($order->tracking_number2)
	{
		$tracking_numbers[] = $order->tracking_number2;
		$tracking_urls[] = $CI->$model->tracking_url($order->tracking_number2);
	}
	if($order->tracking_number3)
	{
		$tracking_numbers[] = $order->tracking_number3;
		$tracking_urls[] = $CI->$model->tracking_url($order->tracking_number3);
	}

	$msg_data = array("customer_name" => $order->customer_name,
	                  "gateway_name" => $gateway_name,
	                  "tracking_numbers" => $order->tracking_numbers,
	                  "tracking_urls" => $tracking_urls);

	ob_start();
	$CI->load->view("shop/emails/tracking", $msg_data);
	$message = ob_get_clean();

	send_notification($order->customer_email, "Your Order Has Been Updated", $message);
}
?>
