<?php
class Acl_role_action extends MY_Model
{
	const DB_TABLE = 'acl_role_action';
    const DB_TABLE_PK = 'acl_role_action_id';

    public function add_link($acl_role_id, $acl_action_id)
    {
	    $result = $this->db->query("SELECT `acl_role_action_id`
	                               FROM acl_role_action
	                               WHERE acl_role_id=? AND acl_action_id=?", array($acl_role_id, $acl_action_id));

	    if($result->num_rows() > 0)
	    {
		    //a link already exists
		    return true;
	    }
	    else
	    {
	    	$this->db->query("INSERT INTO `acl_role_action` SET `acl_role_id`=?, `acl_action_id`=?",
	    	                 array($acl_role_id, $acl_action_id));

		    return ($this->db->affected_rows() > 0);
	    }

	    return false;
    }

    public function delete_link($acl_role_id, $acl_action_id)
    {
    	$this->db->query("DELETE FROM `acl_role_action` WHERE `acl_role_id`=? AND `acl_action_id`=?",
	    	                 array($acl_role_id, $acl_action_id));

		return ($this->db->affected_rows() > 0);
    }
}
