<?php
class Acl_user_role extends MY_Model
{
	const DB_TABLE = 'acl_user_role';
    const DB_TABLE_PK = 'acl_user_role_id';

    public function add_link($user_id, $acl_role_id)
    {
	    $result = $this->db->query("SELECT `acl_user_role_id`
	                               FROM `acl_user_role`
	                               WHERE `acl_role_id`=? AND `user_id`=?",
	                               array($acl_role_id, $user_id));

	    if($result->num_rows() > 0)
	    {
		    //a link already exists
		    return true;
	    }
	    else
	    {
	    	$this->db->query("INSERT INTO `acl_user_role` SET `acl_role_id`=?, `user_id`=?",
	    	                 array($acl_role_id, $user_id));

		    return ($this->db->affected_rows() > 0);
	    }

	    return false;
    }

    public function delete_link($user_id, $acl_role_id)
    {
    	$this->db->query("DELETE FROM `acl_user_role` WHERE `acl_role_id`=? AND `user_id`=?",
    	                 array($acl_role_id, $user_id));

		return ($this->db->affected_rows() > 0);
    }
}
