<?php
class Category extends MY_Model
{
	const DB_TABLE = 'categories';
    const DB_TABLE_PK = 'category_id';

    function LoadBySiteID($id)
	{
		$query = $this->db->query("SELECT * FROM categories AS c WHERE site_id=? ORDER BY `name`", array($id));

		return $query->result();
	}

	function get($limit=0, $offset=0)
	{
		return $this->LoadBySiteID(Mainframe::active_site_id());
	}

    function loadDocumentCategories($site_id)
    {
    	$q = $this->db->query("SELECT c.*, COUNT(*) AS total
    	                      FROM categories AS c
    	                      INNER JOIN document AS d USING(category_id)
    	                      WHERE d.`published`='1' AND c.site_id=?
    	                      GROUP BY c.category_id
    	                      ORDER BY c.`name`",
    	                      array($site_id));
    	return $q->result();
    }
}
