<?php
class Content_value extends MY_Model
{
	const DB_TABLE = 'content_values';
    const DB_TABLE_PK = 'content_value_id';

    function LoadByPageKey($page_id, $key)
	{
		$query = $this->db->query("SELECT *
		                          FROM `content_values`
		                          WHERE `page_id`=? AND `key`=?",
		                          array($page_id, $key));

		return $this->populate($query->row());
	}

    function LoadByPageID($page_id)
	{
		$key = "content_values:" . $page_id;

		if(($query = $this->cache->get($key)) === false)
	  	{
	  		$query = $this->db->query("SELECT *
		  	                          FROM `content_values`
		  	                          WHERE `page_id`=?",
		  	                          array($page_id));
	  		$query = $query->result();
	  		$this->cache->save($key, $query, 86400);
	  	}

	  	return $query;
	}

    public function delete_all($page_id)
    {
    	$this->db->query("DELETE FROM `content_values` WHERE `page_id`=?",
    	                 array($page_id));
    }

    public function delete_all_others($page_id, $ids)
    {
    	$this->db->query("DELETE FROM `content_values` WHERE `page_id`=? AND `content_value_id` NOT IN ($ids)",
    	                 array($page_id));
    }
}
